<?php 
	use App\Models\User; 
	use App\Models\Option; 
?>


<?php $__env->startSection('styles'); ?>
	<?php echo HTML::style('backend/assets/css/jquery-ui.css'); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('maincontent'); ?>
	<!-- BEGIN CONTENT-->
	<div id="content" ng-app="corporateMembersFilter" ng-controller="corporateMembersController">
		<section class="style-default-bright">
			<div class="section-header ">
				<ol class="breadcrumb">
					<li class="active">Home</li>
					<li>Corporate Members</li>
				</ol>
			</div>

			<div id="exclUploadDiv">
		      	<div class="card">
		        	<div class="card-body">
		          		<div class="row">
		            		<?php echo Form::open(["id"=>"corporateMembersSearchForm"]); ?>

		            			<div class="col-lg-3">
		              				<?php echo Form::text("dateFrom","",["class"=>"form-control","id"=>"dateFrom","placeholder"=>"From Date","ng-model"=>"params.dateFrom"]); ?>

					              	<?php if($errors->has("dateFrom")): ?>
										<span id="dateFrom-error" class="help-block"><?php echo $errors->first("dateFrom"); ?></span>
									<?php endif; ?>
		            			</div>

		            			<div class="col-lg-3">
		              				<?php echo Form::text("dateTo","",["class"=>"form-control","id"=>"dateTo","placeholder"=>"To Date","ng-model"=>"params.dateTo"]); ?>

					              	<?php if($errors->has("dateTo")): ?>
										<span id="dateTo-error" class="help-block"><?php echo $errors->first("dateTo"); ?></span>
									<?php endif; ?>
		            			</div>

		            			<div class="col-lg-3">
		              				<?php echo Form::text("membershipID","",["class"=>"form-control","id"=>"membershipID","placeholder"=>"Membership ID","ng-model"=>"params.membershipID"]); ?>

					              	<?php if($errors->has("membershipID")): ?>
										<span id="membershipID-error" class="help-block"><?php echo $errors->first("membershipID"); ?></span>
									<?php endif; ?>
		            			</div>

		            			<div class="clearfix"></div>	
		            			<br>
		            			
					            <div class="col-lg-2">
					                <input type="submit" class="btn ink-reaction pull-left btn-primary" ng-click="searchCorporateMembers($event)">
					            </div>
		            		<?php echo Form::close(); ?>

		          		</div>
		        	</div>
		      	</div>
		  	</div>

		  	<div class="clearfix"></div>

  			<?php if(Session::has('success')): ?> <?php echo HTML::display_success('success'); ?> <?php endif; ?>

  			<div class="preLoadingDiv" style='display:none'>
		        <div class="spinner">
				  <div class="bounce1"></div>
				  <div class="bounce2"></div>
				  <div class="bounce3"></div>
				</div>
		        <p class="text-center">Processing.... Please wait...</p>
		    </div>

			<section id="corporateMembersTable" style="display:none">

				<div class="section-header">
					<div class="row">
						<div class="col-lg-6">
							<h2 class="text-primary">Corporate Members</h2>
						</div>
					</div>
				</div>

				<div class="section-body">
					<div class="row">
						<div class="col-lg-12">
							<div class="table-responsive">
								<div style="float: left;"><b>Shows</b> &nbsp;&nbsp;
									<select ng-model="recordLimit"  ng-init="recordLimit=10" ng-options="item for item in recordArray">
									</select>
								</div>

								<div style="float: right;"><b>Search</b> &nbsp;&nbsp;<input type="text" ng-model="filterSearch"></div>

								<table id="myTable" class="table table-striped table-hover">
									<thead>
										<tr>
											<th ng-click="sort('sno')">#</th>
											<th ng-click="sort('unique_id')">Membership ID</th>
											<th ng-click="sort('org_name')">Organisation</th>
											<th ng-click="sort('con_person')">Contact Person</th>
											<th ng-click="sort('total_mem')">Nominees</th>
											<th ng-click="sort('mobile')">Contact</th>
											<th ng-click="sort('email')">Email ID</th>
											<th ng-click="sort('status')">Status</th>
											<th ng-click="sort('sno')">Action</th>
										</tr>
									</thead>

									<tbody>
										<tr dir-paginate="rec in records |orderBy:sortKey:reverse | filter: filterSearch|itemsPerPage:recordLimit">
											<td>{{ rec.sno }}</td>
											<td>{{ rec.unique_id }}</td>
											<td>{{ rec.org_name|uppercase }}</td>
											<td>{{ rec.con_person|uppercase }}</td>
											<td>{{ rec.total_mem }}</td>
											<td>{{ rec.mobile }}</td>
											<td>{{ rec.email }}</td>
											<td><button type="button" class="btn ink-reaction btn-xs btn-{{rec.status=='active'?'success':'danger'}} corporateStatus" data-id="{{rec.id}}">{{rec.status=='active'?'Active':'Inactive'}}</button></td>
											<td><a href="<?php echo URL::to('admin/members/corporate/modify/get'); ?>/{{ rec.id }}"><i class="fa fa-edit"></i></a></td>
										</tr>
									</tbody>
								</table>

								<dir-pagination-controls
							       max-size="10"
							       direction-links="true"
							       boundary-links="true" >
							    </dir-pagination-controls>
							</div><!--end .table-responsive -->
						</div><!--end .col -->
					</div><!--end .row -->
					<!-- END DATATABLE 1 -->
				</div><!--end .section-body -->
			</section>
		</section>
	</div><!--end #content-->
	<!-- END CONTENT -->
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
	<?php echo HTML::script('backend/js/angular.min.js'); ?>

  	<?php echo HTML::script('backend/js/dirPagination.js'); ?>

  	<?php echo HTML::script('backend/assets/js/jquery-ui.js'); ?>

  	<?php echo HTML::script('backend/js/angular-select2.min.js'); ?>

  	<?php echo HTML::script('backend/js/bala.js'); ?>

	<script>
		$(document).ready(function(){
	    	$("#dateFrom").datepicker({
		      	changeMonth: false,
		      	dateFormat:'yy-mm-dd',
		      	numberOfMonths: 1,
		      	onClose: function( selectedDate ){
		        	$("#dateTo").datepicker( "option", "minDate", selectedDate );
		      	}
		    });

		    $( "#dateTo" ).datepicker({
		      	dateFormat:'yy-mm-dd',
		      	changeMonth: false,
		      	numberOfMonths: 1,
		      	onClose: function( selectedDate ){
		        	$( "#dateFrom" ).datepicker( "option", "maxDate", selectedDate );
		      	}
		    });
		});

		var app = angular.module('corporateMembersFilter', ['angularUtils.directives.dirPagination']);
		app.controller('corporateMembersController', function($timeout, $scope, $http){
			
			// $timeout(function(){
			// 	$scope.searchCorporateMembers();
			// },500);

			$scope.params = {};
	        $scope.params.dateFrom = '';
	        $scope.params.dateTo = '';
	        $scope.params.membershipID = '';
	      
			$scope.searchCorporateMembers = function(event) {
				event.preventDefault();
				angular.element(document.querySelector('.preLoadingDiv')).show();
				angular.element(document.querySelector('#corporateMembersTable')).hide();
				angular.element(document.querySelector('#displayError')).hide();
				$scope.records = [];
				$scope.recordArray = [10, 25, 50, 100];
				$http({
		          	method  : 'POST',
		          	url     : '/admin/members/corporate/post',
		          	data    : $scope.params,
		        }).success(function(data){
		         	console.log(data);
		         	$scope.originaldata = data;
					$scope.datalength = $scope.originaldata.length;

					if($scope.datalength > 0){
						for(var i = 0; i < $scope.originaldata.length; i++){
							$scope.originaldata[i].sno = i + 1;
							$scope.records.push($scope.originaldata[i]);
						}
						angular.element(document.querySelector('.preLoadingDiv')).hide();
						angular.element(document.querySelector('#corporateMembersTable')).show();
					}else{
						angular.element(document.querySelector('.preLoadingDiv')).hide();
						angular.element(document.querySelector('#corporateMembersTable')).hide();
		         		swal("No Records!", "No Records Found", "info");
		         		return false;
					}
				});
			}

			$scope.clickCorporateMemberDelete = function(rec, index){
		        swal({
		            title: "Are you sure?",
		            text: "Do you really want to delete this member's details?",
		            type: "warning",
		            showCancelButton: true,
		            confirmButtonColor: "#EE2C47",
		            confirmButtonText: "Yes",
		            cancelButtonText: "No",
		            closeOnConfirm: false,
		            closeOnCancel: false
	        	},
		        function(isConfirm){
	            	if(!isConfirm){
	              		swal("Cancelled", "This member's details are not being deleted:)", "error");
	              		return false;
	            	}

	            	$(".processLoadingDiv").show();
		            $http.post('/admin/members/applied/delete/post', {id: rec.id}).then(function(response){
		              	console.log(response.data);
		              	if(response.data.status == 'success'){
		                	$scope.records.splice(index, 1);
		                	swal('Success!!!', 'Selected member has been deleted successfully!!!', 'success');
		              	}else{
		                	swal('Error', 'Error processing your request. Please contact system administrator', 'error');
		              	}
		              	$(".processLoadingDiv").hide();
		              	return false;
		            }, function(e){
		              	console.log(e);
		              	swal('Error', 'Error processing your request. Please contact system administrator', 'error');
		              	$(".processLoadingDiv").hide();
		              	return false;
		            });
	            });/* end of confirm function */
				return false;
	      	}

			$scope.sort = function(keyname){
		        $scope.sortKey = keyname;   //set the sortKey to the param passed
		        $scope.reverse = !$scope.reverse; //if true make it false and vice versa
		    }
		});

		app.filter('capitalize', function() {
		    return function(input) {
		      return (!!input) ? input.charAt(0).toUpperCase() + input.substr(1).toLowerCase() : '';
		    }
		});

		app.filter('secondsToDateTime', function() {
		    return function(seconds) {
		        var d = new Date(0,0,0,0,0,0,0);
		        d.setSeconds(seconds);
		        return d;
		    };
		});
	</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make("backend/master", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/adclubmadras/public_html/resources/views/backend/members/corporateMembers.blade.php ENDPATH**/ ?>