<?php

	use App\Models\EventCategories;

?>



<?php $__env->startSection('styles'); ?>

	<?php echo HTML::style('backend/assets/css/jquery-ui.css'); ?>


<?php $__env->stopSection(); ?>

<?php $__env->startSection('maincontent'); ?>

	<!-- BEGIN CONTENT-->

	<div id="content">

		<section>

			<div class="section-header ">

				<ol class="breadcrumb">

					<li class="active">Home</li>

					<li class="active">Events</li>

					<li class="active">Add New Event</li>

				</ol>

			</div>



			<div class="section-body">

				<!-- BEGIN VERTICAL FORM -->

				<?php echo Form::open(["url"=>"admin/events/add/post", "class"=>"form", "files"=>true]); ?>


					<div class="row">

						<div class="col-lg-12">

							<h1 class="text-primary">Add New Event</h1>

						</div><!--end .col -->



						<?php

							$time = [];

							$seconds = 60;

							while($seconds <= 86400){

								$time[$seconds] = gmdate("H:i", $seconds);

								$seconds += 60;

							}

						?>



						<div class="col-md-9">

							<div class="card">

								<div class="card-head style-primary">

									<header>Create Event</header>

								</div>



								<?php if(Session::has('success')): ?> <?php echo HTML::display_success('success'); ?> <?php endif; ?>

								<?php if(Session::has('error')): ?> <?php echo HTML::display_error('error'); ?> <?php endif; ?>



								<div class="card-body">

									<div class="form-group <?php if($errors->has('eventTitle')): ?>has-error <?php endif; ?>">

										<?php echo Form::text("eventTitle","",["class"=>"form-control"]); ?>


											<?php if($errors->has("eventTitle")): ?>

												<span id="eventTitle-error" class="help-block"><?php echo $errors->first("eventTitle"); ?></span>

											<?php endif; ?>

										<?php echo HTML::decode(Form::label("eventTitle","Title <span class='text-danger'>*</span>")); ?>


									</div>



									<div class="form-group <?php if($errors->has('eventDate')): ?>has-error <?php endif; ?>">

										<?php echo Form::text("eventDate","",["class"=>"form-control", 'id'=>'eventDate']); ?>


											<?php if($errors->has("eventDate")): ?>

												<span id="eventDate-error" class="help-block"><?php echo $errors->first("eventDate"); ?></span>

											<?php endif; ?>

										<?php echo HTML::decode(Form::label("eventDate","Date <span class='text-danger'>*</span>")); ?>


									</div>



									<div class="form-group <?php if($errors->has('eventStartTime')): ?>has-error <?php endif; ?>">

										<?php echo Form::select("eventStartTime",$time,"",["class"=>"form-control","placeholder"=>"Start Time"]); ?>


											<?php if($errors->has("eventStartTime")): ?>

												<span id="eventStartTime-error" class="help-block"><?php echo $errors->first("eventStartTime"); ?></span>

											<?php endif; ?>

										<?php echo HTML::decode(Form::label("eventStartTime","Start Time <span class='text-danger'>*</span>")); ?>


									</div>



									<div class="form-group">

										<?php echo Form::select("eventEndTime",$time,"",["class"=>"form-control","placeholder"=>"End Time"]); ?>


										<?php echo HTML::decode(Form::label("eventEndTime","End Time")); ?>


									</div>



									<div class="form-group <?php if($errors->has('reportingTime')): ?>has-error <?php endif; ?>">

										<?php echo Form::select("reportingTime",$time,"",["class"=>"form-control","placeholder"=>"Time"]); ?>


											<?php if($errors->has("reportingTime")): ?>

												<span id="reportingTime-error" class="help-block"><?php echo $errors->first("reportingTime"); ?></span>

											<?php endif; ?>

										<?php echo HTML::decode(Form::label("reportingTime","Reporting Time <span class='text-danger'></span>")); ?>


									</div>



									<div class="form-group <?php if($errors->has('eventPoster')): ?>has-error <?php endif; ?>">

										<?php echo Form::file("eventPoster",["class"=>"form-control"]); ?>


											<?php if($errors->has("eventPoster")): ?>

												<span id="eventPoster-error" class="help-block"><?php echo $errors->first("eventPoster"); ?></span>

											<?php endif; ?>

										<?php echo HTML::decode(Form::label("eventPoster","Event Poster <span class='text-danger'>*</span>")); ?>


									</div>



									<div class="form-group <?php if($errors->has('entryType')): ?>has-error <?php endif; ?>">

										<?php echo Form::select("entryType",['general'=> 'General', 'free' => 'Free', 'paid' => 'Paid'], "",["class"=>"form-control","placeholder"=>"Select", 'id' => 'entryType']); ?>


											<?php if($errors->has("entryType")): ?>

												<span id="entryType-error" class="help-block"><?php echo $errors->first("entryType"); ?></span>

											<?php endif; ?>

										<?php echo HTML::decode(Form::label("entryType","Entry Fee Type <span class='text-danger'></span>")); ?>


									</div>



									



									<div id="badmintonandtennisModule" class="sportEventModule" style="display: none;">

										<div class="form-group <?php if($errors->has('typeOfTeam')): ?>has-error <?php endif; ?>">

											<?php echo Form::select("typeOfTeam",['single'=> 'Singles Only','double' => 'Dobles Only', 'both' => 'Both Singles and Doubles'], '',["class"=>"form-control", 'id' => 'typeOfTeam']); ?>


												<?php if($errors->has("typeOfTeam")): ?>

													<span id="typeOfTeam-error" class="help-block"><?php echo $errors->first("typeOfTeam"); ?></span>

												<?php endif; ?>

											<?php echo HTML::decode(Form::label("typeOfTeam","Allow type of team <span class='text-danger'></span>")); ?>


										</div>



										<div class="row">

											<div class="col-md-6 <?php if($errors->has('maxSinglesCount')): ?>has-error <?php endif; ?>">

												<?php echo HTML::decode(Form::label("maxSinglesCount","Maximum singles allowed<span class='text-danger'></span>")); ?>


												<?php echo Form::number("maxSinglesCount", '',["class"=>"form-control",'id'=>'maxSinglesCount']); ?>


												<em>Maximum player allowed per register</em>

												<?php if($errors->has("maxSinglesCount")): ?>

													<span id="maxSinglesCount-error" class="help-block"><?php echo $errors->first("maxSinglesCount"); ?></span>

												<?php endif; ?>

											</div>



											<div class="col-md-6 <?php if($errors->has('maxDoublesCount')): ?>has-error <?php endif; ?>">

												<?php echo HTML::decode(Form::label("maxDoublesCount","Maximum doubles allowed<span class='text-danger'></span>")); ?>


												<?php echo Form::number("maxDoublesCount", '',["class"=>"form-control",'id'=>'maxDoublesCount']); ?>


												<em>Maximum team allowed per register</em>

												<?php if($errors->has("maxDoublesCount")): ?>

													<span id="maxDoublesCount-error" class="help-block"><?php echo $errors->first("maxDoublesCount"); ?></span>

												<?php endif; ?>

											</div>



											<div class="col-md-6 <?php if($errors->has('singlesMemberFee')): ?>has-error <?php endif; ?>">

												<?php echo HTML::decode(Form::label("singlesMemberFee","Singes Fee (Member) / per head<span class='text-danger'></span>")); ?>


												<?php echo Form::text("singlesMemberFee", '',["class"=>"form-control",'id'=>'singlesMemberFee']); ?>


												<?php if($errors->has("singlesMemberFee")): ?>

													<span id="singlesMemberFee-error" class="help-block"><?php echo $errors->first("singlesMemberFee"); ?></span>

												<?php endif; ?>

											</div>



											<div class="col-md-6 <?php if($errors->has('singlesNonMemberFee')): ?>has-error <?php endif; ?>">

												<?php echo HTML::decode(Form::label("singlesNonMemberFee","Singles Fee (Non Member)  / per head<span class='text-danger'></span>")); ?>


												<?php echo Form::text("singlesNonMemberFee", '',["class"=>"form-control",'id'=>'singlesNonMemberFee']); ?>


												<?php if($errors->has("singlesNonMemberFee")): ?>

													<span id="singlesNonMemberFee-error" class="help-block"><?php echo $errors->first("singlesNonMemberFee"); ?></span>

												<?php endif; ?>

											</div>



											<div class="col-md-6 <?php if($errors->has('doublesMemberFee')): ?>has-error <?php endif; ?>">

												<?php echo HTML::decode(Form::label("doublesMemberFee","Doubles Fee (Member)  / per team<span class='text-danger'></span>")); ?>


												<?php echo Form::text("doublesMemberFee", '',["class"=>"form-control",'id'=>'doublesMemberFee']); ?>


												<?php if($errors->has("doublesMemberFee")): ?>

													<span id="doublesMemberFee-error" class="help-block"><?php echo $errors->first("doublesMemberFee"); ?></span>

												<?php endif; ?>

											</div>



											<div class="col-md-6 <?php if($errors->has('doublesNonMemberFee')): ?>has-error <?php endif; ?>">

												<?php echo HTML::decode(Form::label("doublesNonMemberFee","Doubles Fee (Non Member)   / per team<span class='text-danger'></span>")); ?>


												<?php echo Form::text("doublesNonMemberFee", '',["class"=>"form-control",'id'=>'doublesNonMemberFee']); ?>


												<?php if($errors->has("doublesNonMemberFee")): ?>

													<span id="doublesNonMemberFee-error" class="help-block"><?php echo $errors->first("doublesNonMemberFee"); ?></span>

												<?php endif; ?>

											</div>



										</div>



									</div>



									<div id="cricketModule" class="sportEventModule"  style="display: none;">

										<div class="form-group <?php if($errors->has('maximumPlayer')): ?>has-error <?php endif; ?>">

											<?php echo HTML::decode(Form::label("maximumPlayer","Maximum Player / per team<span class='text-danger'></span>")); ?>


											<?php echo Form::number("maximumPlayer", '',["class"=>"form-control",'id'=>'maximumPlayer']); ?>


											<em>Maximum player</em>

											<?php if($errors->has("maximumPlayer")): ?>

												<span id="maximumPlayer-error" class="help-block"><?php echo $errors->first("maximumPlayer"); ?></span>

											<?php endif; ?>

										</div>

									</div>



									<div id="paidEntryFee" style="display: none;">

										<div class="form-group <?php if($errors->has('memberFee')): ?>has-error <?php endif; ?>">

											<?php echo HTML::decode(Form::label("memberFee","Member Fee <span class='text-danger'></span>")); ?>


											<?php echo Form::text("memberFee", '',["class"=>"form-control",'id'=>'memberFee']); ?>


											<em>Enter fee without GST</em>

											<?php if($errors->has("memberFee")): ?>

												<span id="memberFee-error" class="help-block"><?php echo $errors->first("memberFee"); ?></span>

											<?php endif; ?>

										</div>



										<div class="form-group <?php if($errors->has('nonMemberFee')): ?>has-error <?php endif; ?>">

											<?php echo HTML::decode(Form::label("nonMemberFee","Non-member Fee <span class='text-danger'></span>")); ?>


											<?php echo Form::text("nonMemberFee", '',["class"=>"form-control",'id'=>'nonMemberFee']); ?>


											<em>Enter fee without GST</em>

											<?php if($errors->has("nonMemberFee")): ?>

												<span id="nonMemberFee-error" class="help-block"><?php echo $errors->first("nonMemberFee"); ?></span>

											<?php endif; ?>

										</div>



										<div class="form-group <?php if($errors->has('memberFeeText')): ?>has-error <?php endif; ?>">

											<?php echo HTML::decode(Form::label("memberFeeText","Entry Fee Text <span class='text-danger'></span>")); ?>


											<?php echo Form::textarea("memberFeeText", '',["class"=>"form-control","rows"=>2, "cols"=>2,'id'=>'memberFeeText']); ?>


											<?php if($errors->has("memberFeeText")): ?>

												<span id="memberFeeText-error" class="help-block"><?php echo $errors->first("memberFeeText"); ?></span>

											<?php endif; ?>

										</div>

									</div>



									



									<div class="form-group <?php if($errors->has('partnerEvent')): ?>has-error <?php endif; ?>">

										<?php echo HTML::decode(Form::label("partnerEvent","Partner Event")); ?>


										<?php echo Form::radio("partnerEvent", 'yes', false, ['class' => 'partner_event']); ?>&nbsp;Yes&nbsp;

										<?php echo Form::radio("partnerEvent", 'no', true, ['class' => 'partner_event']); ?>&nbsp;No&nbsp;

									</div>



									<div class="form-group partnerNameDiv <?php if($errors->has('partnerName')): ?>has-error <?php endif; ?>" style="display: none;">

										<?php echo HTML::decode(Form::label("partnerName","Partner Name <span class='text-danger'></span>")); ?>


										<?php echo Form::text("partnerName", '',["class"=>"form-control"]); ?>


										<?php if($errors->has("partnerName")): ?>

											<span id="partnerName-error" class="help-block"><?php echo $errors->first("partnerName"); ?></span>

										<?php endif; ?>

									</div>



									<div class="form-group <?php if($errors->has('streaming_link')): ?>has-error <?php endif; ?>">

										<?php echo HTML::decode(Form::label("streaming_link","Streaming Link <span class='text-danger'></span>")); ?>


										<?php echo Form::text("streaming_link",'',["class"=>"form-control"]); ?>


										<?php if($errors->has("streaming_link")): ?>

											<span id="streaming_link-error" class="help-block"><?php echo $errors->first("streaming_link"); ?></span>

										<?php endif; ?>

									</div>



									<div class="form-group <?php if($errors->has('eventVenue')): ?>has-error <?php endif; ?>">

										<?php echo HTML::decode(Form::label("eventVenue","Venue <span class='text-danger'></span>")); ?>


										<?php echo Form::textarea("eventVenue","",["class"=>"form-control","rows"=>3, "cols"=>2]); ?>


										<?php if($errors->has("eventVenue")): ?>

											<span id="eventVenue-error" class="help-block"><?php echo $errors->first("eventVenue"); ?></span>

										<?php endif; ?>

									</div>

									<div class="form-group <?php if($errors->has('eventInformation')): ?>has-error <?php endif; ?>">

										<?php echo HTML::decode(Form::label("eventInformation","Event Information <span class='text-danger'></span>")); ?>


										<?php echo Form::textarea("eventInformation","",["class"=>"form-control"]); ?>


										<?php if($errors->has("eventInformation")): ?>

											<span id="eventInformation-error" class="help-block"><?php echo $errors->first("eventInformation"); ?></span>

										<?php endif; ?>

									</div>



									<div class="form-group <?php if($errors->has('eventDescription')): ?>has-error <?php endif; ?>">

										<?php echo HTML::decode(Form::label("eventDescription","Terms & Conditions <span class='text-danger'></span>")); ?>


										<?php echo Form::textarea("eventDescription","",["class"=>"form-control"]); ?>


										<?php if($errors->has("eventDescription")): ?>

											<span id="eventDescription-error" class="help-block"><?php echo $errors->first("eventDescription"); ?></span>

										<?php endif; ?>

									</div>

								</div><!--end .card-body -->

							</div><!--end .card -->

						</div><!--end .col -->



						<div class="col-md-3">

							<div class="card">

								<div class="card-head style-primary">

									<header>Manage</header>

								</div><!--end .card-head -->



								<div class="publishActions">

									<div class="card-actionbar">

										<div class="card-actionbar-row">

											<?php echo HTML::link("admin/events/get", "Manage Events", ["class"=>"btn ink-reaction btn-block btn-primary"]); ?>


										</div>

									</div>

								</div>

							</div><!--end .card -->

							

							<div class="card">

								<div class="card-head style-primary">

									<header>Gallery</header>

								</div><!--end .card-head -->



								<div class="publishActions">

									<div class="card-actionbar">

										<div class="card-actionbar-row">

											<?php echo Form::select("gallery",$gallery,"",["class"=>"form-control","placeholder"=>"Select Gallery"]); ?>


										</div>

									</div>

								</div>

							</div><!--end .card -->



							<div class="card">

								<div class="card-head style-primary">

									<header>Categories</header>

								</div><!--end .card-head -->



								<div class="card-body small-padding height-8 productCategories">

									<ul data-sortable="true" class="list">

										<?php 

											$categories = EventCategories::where('status', 'active')->get(); 

										?>

										

										<?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

											<li class="tile">

												<div class="radio radio-styled">

													<label>

														<input type="radio" name="eventCategory" value="<?php echo $category->id; ?>" class="eventCategories">

														<span><?php echo $category->categoryName; ?></span>

													</label>

												</div>

											</li>

										<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!-- 1-->



										<?php if($errors->has("eventCategory")): ?>

											<span id="eventCategory-error" class="help-block"><?php echo $errors->first("eventCategory"); ?></span>

										<?php endif; ?>		

									</ul>

								</div>

							</div><!--end .card -->



							<div class="card">

								<div class="card-head style-primary">

									<header>Publish</header>

								</div><!--end .card-head -->



								<div class="publishActions">

									<div class="card-actionbar">

										<div class="card-actionbar-row">

											<!-- <button class="btn ink-reaction btn-primary">Preview</button> -->

											<button type="submit" id="publishEvent" class="btn ink-reaction btn-primary-dark">Publish Event</button>

										</div>

									</div>

								</div>

							</div><!--end .card -->

						</div>

					</div><!--end .row -->

				<?php echo Form::close(); ?>


				<!-- END VERTICAL FORM -->

			</div>

		</section>

	</div><!--end #content-->

	<!-- END CONTENT -->

<?php $__env->stopSection(); ?>



<?php $__env->startSection("script"); ?>

	<?php echo HTML::script('backend/assets/js/jquery-ui.js'); ?>


	<?php echo HTML::script('backend/ckeditor/ckeditor.js'); ?>


	<script type="text/javascript">

	    $(document).ready(function(){

	      	CKEDITOR.replace('eventDescription');
	      	CKEDITOR.replace('eventInformation');

	      	$("select").select2();

	    });



	    $("#eventDate").datepicker({

	      	changeMonth: false,

	      	dateFormat:'yy-mm-dd',

	      	numberOfMonths: 1

	    });



	    $(document).on("click", "#publishEvent", function(){

			if(!$("input[name='eventCategory']").is(':checked')){

                swal("Please Select", "Please select event category", "info");

                return false;

            }

            var e_type = $('#entryType').val();

			var m_type = $('#sportEvent').val();



            if(e_type == ''){

            	swal("Please Select", "Entry fee type required", "info");

            	return false;

			}

			if(m_type == ''){

				swal("Please Select", "Is sport required", "info");

            	return false;

			}

			if(m_type == 'badminton' || m_type == 'tennis'){

				if(e_type == 'paid'){

					if($('#maxSinglesCount').val() == '' || !$.isNumeric($('#maxSinglesCount').val())) {

						swal("Please Select", "Maximum singles allowed required", "info");

            			return false;

					}

					if($('#maxDoublesCount').val() == '' || !$.isNumeric($('#maxDoublesCount').val())) {

						swal("Please Select", "Maximum doubles team allowed required", "info");

            			return false;

					}

					if($('#singlesMemberFee').val() == '' || !$.isNumeric($('#singlesMemberFee').val())) {

						swal("Please Select", "Singles member fee required", "info");

            			return false;

					}

					if($('#singlesNonMemberFee').val() == '' || !$.isNumeric($('#singlesNonMemberFee').val())) {

						swal("Please Select", "Singles non-member fee required", "info");

            			return false;

					}

					if($('#doublesMemberFee').val() == '' || !$.isNumeric($('#doublesMemberFee').val())) {

						swal("Please Select", "Doubles member fee required", "info");

            			return false;

					}

					if($('#doublesNonMemberFee').val() == '' || !$.isNumeric($('#doublesNonMemberFee').val())) {

						swal("Please Select", "Doubles non-member fee required", "info");

            			return false;

					}

				}

			}else if(m_type == 'cricket'){

				if(e_type == 'paid'){

					if($('#memberFee').val() == '' || !$.isNumeric($('#memberFee').val())) {

						swal("Please Select", "Member fee required", "info");

            			return false;

					}

					if($('#nonMemberFee').val() == '' || !$.isNumeric($('#nonMemberFee').val())) {

						swal("Please Select", "Non-member fee required", "info");

            			return false;

					}

				}

			}else if(m_type == 'no'){

				if(e_type == 'paid'){

					if($('#memberFee').val() == '' || !$.isNumeric($('#memberFee').val())) {

						swal("Please Select", "Member fee required", "info");

            			return false;

					}

					if($('#nonMemberFee').val() == '' || !$.isNumeric($('#nonMemberFee').val())) {

						swal("Please Select", "Non-member fee required", "info");

            			return false;

					}

				}

			}

		});



		// function sportEventModule() {

		// 	var e_type = $('#entryType').val();

		// 	$('#paidEntryFee').hide();

		// 	$('.sportEventModule').hide();

		// 	var m_type = $('#sportEvent').val();

		// 	if(m_type == 'badminton' || m_type == 'tennis'){

		// 		$('#badmintonandtennisModule').show();

		// 	}else if(m_type == 'cricket'){

		// 		$('#cricketModule').show();	

		// 		if(e_type == 'paid'){

		// 			$('#paidEntryFee').show();

		// 		}

		// 	}else if(m_type == 'no'){

		// 		if(e_type == 'paid'){

		// 			$('#paidEntryFee').show();	

		// 		}

		// 	}

		// }



		$(document).on('change', '#entryType', function(){

			// sportEventModule();
			var e_type = $('#entryType').val();
			if(e_type == 'paid'){
				$('#paidEntryFee').show();	
			}else{
				$('#paidEntryFee').hide();
			}

			return false;

		});



		// $(document).on('change', '#sportEvent', function(){

		// 	sportEventModule();

		// 	return false;

		// });



		// sportEventModule();

		partnerevent();



		$(document).on('click', '.partner_event', function(){

			partnerevent();

		});



		function partnerevent(){

			var partner_event = $("input[name='partnerEvent']:checked").val();

			if(partner_event == 'yes'){

				$('.partnerNameDiv').show();

			}else{

				$('.partnerNameDiv').hide();

			}

		}

	</script>

<?php $__env->stopSection(); ?>
<?php echo $__env->make("backend/master", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/adclubmadras/public_html/resources/views/backend/events/addEvent.blade.php ENDPATH**/ ?>