<?php 
	use App\Models\User; 
	use App\Models\Option; 
	use App\Models\Usergroup; 

	$updatePermission = Usergroup::getupdatepermission(Auth::User()->userGroup, 11);
	$deletePermission = Usergroup::getdeletepermission(Auth::User()->userGroup, 11);
	$addPermission = Usergroup::getupdatepermission(Auth::User()->userGroup, 11);
?>

<?php $__env->startSection('styles'); ?>
<?php echo HTML::style('backend/assets/css/theme-default/libs/DataTables/jquery.dataTables.css'); ?>

<?php echo HTML::style('backend/assets/css/theme-default/libs/DataTables/extensions/dataTables.colVis.css'); ?>

<?php echo HTML::style('backend/assets/css/theme-default/libs/DataTables/extensions/dataTables.tableTools.css'); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('maincontent'); ?>
	<!-- BEGIN CONTENT-->
	<div id="content">
		<section class="style-default-bright">
			<div class="section-header ">
				<ol class="breadcrumb">
					<li class="active">Home</li>
					<li class="active">Admin Members</li>
				</ol>
			</div>
			<div class="section-header">
				<div class="row">
					<div class="col-lg-6">
						<h2 class="text-primary">List of Admin Members</h2>
					</div>
					<?php if($addPermission == true || Auth::User()->userGroup == 1): ?>
						<div class="col-lg-6">
							<?php echo HTML::link("admin/users/add","Add New Admin Member",["class"=>"btn ink-reaction pull-right btn-primary"]); ?>

						</div>
					<?php endif; ?>
				</div>
			</div>



			<div class="section-body">
				<div class="row">
					<div class="col-lg-12">
						<div class="table-responsive">
							<table id="myTable" class="table table-striped table-hover">
								<thead>
									<tr>
										<th>#</th>
										<th>Name</th>
										<th>Email</th>
										<th>Created On</th>
										<th>Last Login</th>
										<th>IP Address</th>
										<th class="sort-numeric">Status</th>
										<?php if(($updatePermission == true || $deletePermission == true || Auth::User()->userGroup == 1)): ?>
											<th class="sort-alpha">Actions</th>
										<?php endif; ?>
									</tr>
								</thead>
								<tbody>
									<?php $i = 1; ?>
									<?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
										<tr class="gradeX">
											<td><?php echo $i; ?></td>
											<td><?php echo $user->firstName.$user->lastName; ?></td>
											<td><?php echo $user->email; ?></td>
											<td><?php echo date(Option::fetchDateFormat()." ".Option::fetchTimeFormat(),strtotime($user->created_at)); ?></td>
											<td><?php echo $user->lastLogin != "" ? date(Option::fetchDateFormat()." ".Option::fetchTimeFormat(),strtotime($user->lastLogin)) : ""; ?> </td>
											<td><?php echo $user->ipAddress; ?></td>
											<?php
												$user->status=="active"?$class="success":$class="danger";
											?>
											<td><button type="button" class="btn ink-reaction btn-xs btn-<?php echo $class; ?> userStatus" data-id="<?php echo $user->id; ?>"><?php echo ucfirst($user->status); ?></button></td>
											<td>
												<?php if($updatePermission == true || Auth::User()->userGroup == 1): ?>
													<a href="<?php echo URL::to('admin/users/modify/'.$user->id); ?>">
														<button type="button" class="btn btn-icon-toggle" data-toggle="tooltip" data-placement="top" data-original-title="Edit row"><i class="fa fa-pencil"></i></button>
													</a>
												<?php endif; ?>

												<?php if($deletePermission == true || Auth::User()->userGroup == 1): ?>
													<button type="button" class="btn btn-icon-toggle userDelete" data-toggle="tooltip" data-placement="top" data-original-title="Delete row" data-id="<?php echo $user->id; ?>"><i class="fa fa-trash-o"></i></button>
												<?php endif; ?>
											</td>
										</tr>
									<?php $i++; ?>
									<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
								</tbody>
							</table>
						</div><!--end .table-responsive -->
					</div><!--end .col -->
				</div><!--end .row -->
				<!-- END DATATABLE 1 -->

			</div><!--end .section-body -->
		</section>
	</div><!--end #content-->
	<!-- END CONTENT -->
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
	<?php echo HTML::script('backend/assets/js/libs/DataTables/jquery.dataTables.min.js'); ?>

	<?php echo HTML::script('backend/assets/js/libs/DataTables/extensions/ColVis/js/dataTables.colVis.min.js'); ?>

	<?php echo HTML::script('backend/assets/js/libs/DataTables/extensions/TableTools/js/dataTables.tableTools.min.js'); ?>

	<?php echo HTML::script('backend/assets/js/core/demo/DemoTableDynamic.js'); ?>

	<?php echo HTML::script('backend/js/bala.js'); ?>

	<script type="text/javascript">
	$(document).ready(function(){
    	$('#myTable').DataTable();
	});
	</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make("backend/master", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/adclubmadras/public_html/resources/views/backend/users/users.blade.php ENDPATH**/ ?>