<?php 
	use App\Models\User; 
	use App\Models\Taxes; 
?>

<?php $__env->startSection('styles'); ?>
	<?php echo HTML::style('backend/assets/css/jquery-ui.css'); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('maincontent'); ?>
	<!-- BEGIN CONTENT-->
	<div id="content">
		<section>
			<div class="section-header ">
				<ol class="breadcrumb">
					<li class="active">Home</li>
					<li class="active">News</li>
					<li class="active">Modify News</li>
				</ol>
			</div>
			<div class="section-body">
				<!-- BEGIN VERTICAL FORM -->
				<div class="row">
					<div class="col-lg-12">
						<h1 class="text-primary">Modify News</h1>
					</div><!--end .col -->
					<div class="col-lg-3 col-md-4">
						
						<div class="section-header">
							<?php echo HTML::link("admin/news/get","Manage Posts",["class"=>"btn ink-reaction btn-block btn-primary"]); ?>

						</div>
					</div><!--end .col -->
					<div class="col-md-9">
						<?php echo Form::open(["url"=>"admin/news/modify/post/".$news->id,"class"=>"form","files"=>true]); ?>

							<div class="card">
								<div class="card-head style-primary">
									<header>Modify Post</header>
								</div>
								<?php if(Session::has('success')): ?> <?php echo HTML::display_success('success'); ?> <?php endif; ?>
								<div class="card-body">
									<div class="form-group <?php if($errors->has('postTitle')): ?>has-error <?php endif; ?>">
										<?php echo Form::text("postTitle",$news->newsTitle,["class"=>"form-control"]); ?>

											<?php if($errors->has("postTitle")): ?>
												<span id="postTitle-error" class="help-block"><?php echo $errors->first("postTitle"); ?></span>
											<?php endif; ?>
										<?php echo HTML::decode(Form::label("postTitle","Title <span class='text-danger'>*</span>")); ?>

									</div>

									<div class="form-group <?php if($errors->has('newsDate')): ?>has-error <?php endif; ?>">
										<?php echo Form::text("newsDate", $news->newsDate,["class"=>"form-control", 'id'=>'newsDate']); ?>

											<?php if($errors->has("newsDate")): ?>
												<span id="newsDate-error" class="help-block"><?php echo $errors->first("newsDate"); ?></span>
											<?php endif; ?>
										<?php echo HTML::decode(Form::label("newsDate","Date <span class='text-danger'>*</span>")); ?>

									</div>
										
									<div class="form-group <?php if($errors->has('postDescription')): ?>has-error <?php endif; ?>">
										
										<?php echo Form::textarea("postDescription",$news->newsContent,["class"=>"form-control"]); ?>

										<?php if($errors->has("postDescription")): ?>
											<span id="postDescription-error" class="help-block"><?php echo $errors->first("postDescription"); ?></span>
										<?php endif; ?>
										<?php echo HTML::decode(Form::label("postDescription","Short Description <span class='text-danger'>*</span>")); ?>

									</div>

									<div class="form-group <?php if($errors->has('postCategories')): ?>has-error <?php endif; ?>">
										<?php echo Form::select("postCategories[]",$categories,explode(",", $news->newsCategories),["class"=>"form-control","id"=>"postCategories","multiple"]); ?>

										<?php if($errors->has("postCategories")): ?>
											<span id="postCategories-error" class="help-block"><?php echo $errors->first("postCategories"); ?></span>
										<?php endif; ?>
										<?php echo HTML::decode(Form::label("postCategories","Category<span class='text-danger'>*</span>")); ?>

									</div>

									<div class="form-group <?php if($errors->has('postAuthor')): ?>has-error <?php endif; ?>">
										<?php echo Form::select("postAuthor",$authors,$news->newsAuthorID,["class"=>"form-control","id"=>"postAuthor","placeholder"=>"Select Author"]); ?>

										<?php if($errors->has("postAuthor")): ?>
											<span id="postAuthor-error" class="help-block"><?php echo $errors->first("postAuthor"); ?></span>
										<?php endif; ?>
										<?php echo HTML::decode(Form::label("postAuthor","Author<span class='text-danger'>*</span>")); ?>

									</div>

									<div class="form-group <?php if($errors->has('postSettings')): ?>has-error <?php endif; ?>">
										<div class="checkbox checkbox-styled">
											<label>
												<?php echo Form::checkbox("postSettings","yes",$news->newsSettings == "yes",["class"=>""]); ?>

												<span>Display this news in home page</span>
											</label>
										</div>
									</div>

									<div class="form-group <?php if($errors->has('newsLink')): ?>has-error <?php endif; ?>">
										<?php echo Form::text("newsLink", $news->news_link,["class"=>"form-control"]); ?>

											<?php if($errors->has("newsLink")): ?>
												<span id="newsLink-error" class="help-block"><?php echo $errors->first("newsLink"); ?></span>
											<?php endif; ?>
										<?php echo HTML::decode(Form::label("newsLink","News Link <span class='text-danger'>*</span>")); ?>

									</div>

									
								</div><!--end .card-body -->

								<div class="card-actionbar">
									<div class="card-actionbar-row">
										<button type="submit" class="btn ink-reaction btn-primary-dark">Modify News</button>
									</div>
								</div>

							</div><!--end .card -->
						<?php echo Form::close(); ?>

					</div><!--end .col -->
				</div><!--end .row -->
				<!-- END VERTICAL FORM -->
			</div>
		</section>
	</div><!--end #content-->
	<!-- END CONTENT -->
<?php $__env->stopSection(); ?>

<?php $__env->startSection("script"); ?>
	<?php echo HTML::script('backend/assets/js/jquery-ui.js'); ?>

	<?php echo HTML::script('backend/js/bala.js'); ?>

	<?php echo HTML::script('backend/ckeditor/ckeditor.js'); ?>

	<script type="text/javascript">
	    $(document).ready(function() 
	    {
	    	$("#newsDate").datepicker({
		      	changeMonth: false,
		      	dateFormat:'yy-mm-dd',
		      	numberOfMonths: 1
		    });
	      //CKEDITOR.replace('postDescription');
	    });
	</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make("backend/master", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/adclubmadras/public_html/resources/views/backend/news/editNews.blade.php ENDPATH**/ ?>