<?php
    use App\Models\Members;
?>

<?php $__env->startSection('content'); ?>
    <div ng-app="AdclubMadras" ng-controller="membershipController">
        <div class="hero-area">
            <div ng-show="loaded">
                <div class="overlay"></div>
                <div class="modal-loader bg-color1">
                    <div class="spinner">
                        <div class="bounce1"></div>
                        <div class="bounce2"></div>
                        <div class="bounce3"></div>
                        <p class="text-center">Processing.... Please wait...</p>
                    </div>
                </div>
            </div>

            <div class="page-header bg-color1 text-center">
                <div class="container">
                    <h1>Profile</h1>
                    <ol class="breadcrumb">
                        <li><a href="<?php echo URL::to(''); ?>">Home</a></li>
                        <li>Profile</li>
                    </ol>
                </div>
            </div>
        </div>

        <div id="main-container">
            <div class="content padding-b40">
                <div class="container">
                    <div class="row">
                        <div class="col-md-2 col-sm-12 parallax">
                            <?php echo $__env->make('frontend/profile-sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </div>

                        <div class="col-md-10">
                            <?php
                                $members = Members::where("createdBy", Auth::User()->id)->where("paymentStatus", "=", "Success")->get();
                            ?>

                            <?php $__currentLoopData = $members; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $member): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="row">
                                    <div class="col-md-5">
                                        <div class="icon-box ibox-center ibox-plain">
                                            <div class="ibox-icon margin-0">
                                                <img src="<?php echo URL::asset('frontend/images/icons/member.png'); ?>">
                                            </div>

                                            <h3>Membership ID:<br><b><?php echo $member->unique_id; ?></b></h3>
                                            <p>Member Since: <?php echo date("M d Y", strtotime($member->date_registered)); ?><br>
                                            Next Renewal On: <?php echo date("M d Y", strtotime($member->expiryDate)); ?></p>

                                            <div class="spacer-20"></div>
                                            <?php
                                                $uniqueID = Crypt::encrypt($member->unique_id);
                                                $currentDate = date('Y-m-d');
                                                $renewalDate = date('Y-m-d', strtotime('+7 day', strtotime($currentDate)));
                                            ?>
                                            <?php if($member->expiryDate <= $renewalDate): ?>
                                                <div class="clearfix">
                                                    <button type="submit" id="submit" ng-click="checkRenewalClick('<?php echo $uniqueID; ?>')" name="submit" class="btn btn-primary btn-lg">Renewal</button>
                                                </div>
                                            <?php endif; ?>
                                        </div>
                                    </div>

                                    <div class="col-md-7">
                                        <h4 class="widgettitle">Category of Membership: <?php echo ucfirst($member->mem_category); ?></h4>
                                        <div class="team-grid-item format-standard">
                                            <div class="grid-item-inner <?php if($member->mem_category == 'corporate'): ?> height-4 <?php endif; ?>">
                                                <h4 class="ng-binding"><?php echo ucwords($member->org_name); ?></h4>
                                                <p class="ng-binding"> <?php echo ucwords($member->address); ?></p>
                                                <p class="ng-binding"><i class="fa fa-phone"></i> <?php echo $member->phone; ?> <?php echo $member->mobile; ?>

                                                    <br>
                                                    <i class="fa fa-envelope"></i> <a href="mailto:<?php echo $member->email; ?>" class="ng-binding"><?php echo $member->email; ?></a><br>
                                                </p>
                                                
                                                <?php if($member->mem_category == 'corporate'): ?>
                                                    <?php
                                                        $nominees = json_decode($member->members);
                                                    ?>
                                                    <hr class="sm">

                                                    <b>Member(s) Nominated:</b>
                                                    <ul class="carets">
                                                        <?php $__currentLoopData = $nominees; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $nominee): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <li><?php echo ucwords($nominee->name); ?></li>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </ul>
                                                <?php endif; ?>

                                                <div class="spacer-20"></div>

                                                <div class="contact_details" style="padding-bottom:15px">
                                                    <b>Social Profile(s):</b>
                                                    <ul class="social-icons">
                                                        <?php if($member->facebook != ""): ?>
                                                            <li><a href="<?php echo $member->facebook; ?>" target="_blank"><i class="fa fa-facebook"></i></a></li>
                                                        <?php endif; ?>
                                                        
                                                        <?php if($member->twitter != ""): ?>
                                                            <li><a href="<?php echo $member->twitter; ?>" target="_blank"><i class="fa fa-twitter"></i></a></li>
                                                        <?php endif; ?>

                                                        <?php if($member->linkedin != ""): ?>
                                                            <li><a href="<?php echo $member->linkedin; ?>" target="_blank"><i class="fa fa-linkedin"></i></a></li>
                                                        <?php endif; ?>
                                                    </ul>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="spacer-20"></div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
  <?php echo HTML::script('backend/js/angular.min.js'); ?>

  <script>
    var app = angular.module('AdclubMadras', []);
    
    app.controller('membershipController', function($timeout, $scope, $http, $window){
        $scope.loaded = false;

        $scope.checkRenewalClick = function(uniqueID){
            $scope.loaded = true;
            $http.post('/profile/membership-details/check/renewal', {'uniqueID':uniqueID}).then(function(response){
                console.log(response);
                if(response.data.status == "time"){
                    swal("Info", response.data.msg, "warning");
                    $scope.loaded = false;
                    return false;
                }

                if(response.data.status == "renewal"){
                    $window.location.href = response.data.url;
                    $scope.loaded = false;
                    return false;
                }
            },  
            function(e){
                console.log(e);
                swal('Error', 'Error processing your request. Please contact system administrator', 'error');
                $scope.loaded = false;
                return false;
            });
        }
    });/* end of membership controller */
  </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('frontend/master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/adclubmadras/public_html/resources/views/frontend/membership-details.blade.php ENDPATH**/ ?>