<?php 
	use App\Models\User; 
	use App\Models\Option; 
	use App\Models\Generalsetting; 
?>

<?php $__env->startSection('maincontent'); ?>
	<!-- BEGIN CONTENT-->
	<div id="content">
		<section>
			<div class="section-header ">
				<ol class="breadcrumb">
					<li class="active"><i class="md md-home"></i>Home</li>
					<li class="active">Settings</li>
					<li class="active">Mail</li>
				</ol>
			</div>

			<div class="section-body">
				<!-- BEGIN VERTICAL FORM -->
				<div class="row">
					<div class="col-lg-12">
						<h1 class="text-primary">Mail Settings</h1>
					</div><!--end .col -->

					<div class="col-md-12">
						<div class="card">
							<div class="card-head style-primary">
								<header>Mail Settings</header>
							</div>

							<?php if(Session::has('success')): ?> <?php echo HTML::display_success('success'); ?> <?php endif; ?>

							<div class="card-body">
								<?php echo Form::open(["url"=>"admin/settings/general","class"=>"form"]); ?>

									<div class="form-group <?php if($errors->has('senderEmail')): ?>has-error <?php endif; ?>">
										<?php echo Form::text("senderEmail",Option::getvalue("senderEmail"),["class"=>"form-control"]); ?>

											<?php if($errors->has("senderEmail")): ?>
												<span id="senderEmail-error" class="help-block"><?php echo $errors->first("senderEmail"); ?></span>
											<?php endif; ?>
										<?php echo HTML::decode(Form::label("senderEmail","Sender Email<span class='text-danger'>*</span>")); ?>

									</div>

									<div class="form-group <?php if($errors->has('senderName')): ?>has-error <?php endif; ?>">
										<?php echo Form::text("senderName",Option::getvalue("senderName"),["class"=>"form-control"]); ?>

											<?php if($errors->has("senderName")): ?>
												<span id="senderName-error" class="help-block"><?php echo $errors->first("senderName"); ?></span>
											<?php endif; ?>
										<?php echo HTML::decode(Form::label("senderName","Sender Name<span class='text-danger'>*</span>")); ?>

									</div>

									<div class="form-group <?php if($errors->has('smtpHost')): ?>has-error <?php endif; ?>">
										<?php echo Form::text("smtpHost",Option::getvalue("smtpHost"),["class"=>"form-control"]); ?>

											<?php if($errors->has("smtpHost")): ?>
												<span id="smtpHost-error" class="help-block"><?php echo $errors->first("smtpHost"); ?></span>
											<?php endif; ?>
										<?php echo HTML::decode(Form::label("smtpHost","SMTP Host<span class='text-danger'>*</span>")); ?>

									</div>

									<div class="form-group <?php if($errors->has('smtpPort')): ?>has-error <?php endif; ?>">
										<?php echo Form::text("smtpPort",Option::getvalue("smtpPort"),["class"=>"form-control"]); ?>

											<?php if($errors->has("smtpPort")): ?>
												<span id="smtpPort-error" class="help-block"><?php echo $errors->first("smtpPort"); ?></span>
											<?php endif; ?>
										<?php echo HTML::decode(Form::label("smtpPort","SMTP Port<span class='text-danger'>*</span>")); ?>

									</div>

									<div class="form-group <?php if($errors->has('smtpEmail')): ?>has-error <?php endif; ?>">
										<?php echo Form::text("smtpEmail",Option::getvalue("smtpEmail"),["class"=>"form-control"]); ?>

											<?php if($errors->has("smtpEmail")): ?>
												<span id="smtpEmail-error" class="help-block"><?php echo $errors->first("smtpEmail"); ?></span>
											<?php endif; ?>
										<?php echo HTML::decode(Form::label("smtpEmail","SMTP Email<span class='text-danger'>*</span>")); ?>

									</div>

									<div class="form-group <?php if($errors->has('smtpPassword')): ?>has-error <?php endif; ?>">
										<?php echo Form::text("smtpPassword",Option::getvalue("smtpPassword"),["class"=>"form-control"]); ?>

											<?php if($errors->has("smtpPassword")): ?>
												<span id="smtpPassword-error" class="help-block"><?php echo $errors->first("smtpPassword"); ?></span>
											<?php endif; ?>
										<?php echo HTML::decode(Form::label("smtpPassword","SMTP Password<span class='text-danger'>*</span>")); ?>

									</div>

									<div class="card-actionbar">
										<div class="card-actionbar-row">
											<?php echo Form::submit("Save Settings",["class"=>"btn ink-reaction btn-primary-dark"]); ?>

											<?php echo Form::close(); ?>

										</div>
									</div>
							    <?php echo Form::close(); ?>

							</div><!--end .card-body -->
						</div><!--end .card -->
					</div><!--end .col -->
				</div><!--end .row -->
				<!-- END VERTICAL FORM -->

				<!-- BEGIN VERTICAL FORM -->
				<div class="row">
					<div class="col-lg-12">
						<h1 class="text-primary"></h1>
					</div><!--end .col -->

					<div class="col-md-12">
						<?php echo Form::open(["url"=>"admin/settings/mail/testing","class"=>"form"]); ?>

							<div class="card">
								<div class="card-head style-primary">
									<header>Test Mail</header>
								</div>
								
								<div class="card-body">
									<p>
										Send a test message.
										The message will be sent from the current store administrator address with a Subject of '<?php echo Option::getvalue("portalName"); ?> Test Mail' and the current settings in the message body.
									</p>

									<div class="form-group <?php if($errors->has('testEmail')): ?>has-error <?php endif; ?>">
										<?php echo Form::text("testEmail",Option::getvalue("testEmail"),["class"=>"form-control"]); ?>

											<?php if($errors->has("testEmail")): ?>
												<span id="testEmail-error" class="help-block"><?php echo $errors->first("testEmail"); ?></span>
											<?php endif; ?>
										<?php echo HTML::decode(Form::label("testEmail","Test Email Address<span class='text-danger'>*</span>")); ?>

									</div>

									<div class="card-actionbar">
										<div class="card-actionbar-row">
											<?php echo Form::submit("Send Mail",["class"=>"btn ink-reaction btn-primary-dark"]); ?>

										</div>
									</div>
								</div><!--end .card-body -->
							</div><!--end .card -->
						<?php echo Form::close(); ?>

					</div><!--end .col -->
				</div><!--end .row -->
				<!-- END VERTICAL FORM -->
			</div>
		</section>
	</div><!--end #content-->
	<!-- END CONTENT -->
<?php $__env->stopSection(); ?>

<?php $__env->startSection("script"); ?>
	<?php echo HTML::script('backend/js/bala.js'); ?>

<?php $__env->stopSection(); ?>
<?php echo $__env->make("backend/master", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/adclubmadras/public_html/resources/views/backend/settings/mailSettings.blade.php ENDPATH**/ ?>