
<?php $__env->startSection('maincontent'); ?>
	<!-- BEGIN CONTENT-->
	<div id="content">
		<section>
			<div class="section-header ">
				<ol class="breadcrumb">
					<li class="active">Home</li>
					<li class="active">Event Categories</li>
					<li class="active">Modify Event Category</li>
				</ol>
			</div>

			<div class="section-body">
				<!-- BEGIN VERTICAL FORM -->
				<div class="row">
					<div class="col-lg-12">
						<h1 class="text-primary">Modify Event Category</h1>
					</div><!--end .col -->

					<div class="col-lg-3 col-md-4">
						<div class="section-header">
							<?php echo HTML::link("admin/events/categories/get","Manage Events Categories",["class"=>"btn ink-reaction btn-block btn-primary"]); ?>

						</div>
					</div><!--end .col -->

					<div class="col-md-9">
						<?php echo Form::open(["url"=>"admin/events/categories/modify/post/".$category->categorySlug."/".Crypt::encrypt($category->id), "class"=>"form", "files"=>true]); ?>

							<div class="card">
								<div class="card-head style-primary">
									<header>Modify Event Category</header>
								</div>

								<?php if(Session::has('success')): ?> <?php echo HTML::display_success('success'); ?> <?php endif; ?>

								<div class="card-body">
									<div class="form-group <?php if($errors->has('eventCategoryTitle')): ?>has-error <?php endif; ?>">
										<?php echo Form::text("eventCategoryTitle",$category->categoryName,["class"=>"form-control"]); ?>

											<?php if($errors->has("eventCategoryTitle")): ?>
												<span id="eventCategoryTitle-error" class="help-block"><?php echo $errors->first("eventCategoryTitle"); ?></span>
											<?php endif; ?>
										<?php echo HTML::decode(Form::label("eventCategoryTitle","Title <span class='text-danger'>*</span>")); ?>

									</div>

									<div class="form-group <?php if($errors->has('eventCategoryDescription')): ?>has-error <?php endif; ?>">
										<?php echo HTML::decode(Form::label("eventCategoryDescription","Description <span class='text-danger'>*</span>")); ?>

										<?php echo Form::textarea("eventCategoryDescription",$category->categoryDescription,["class"=>"form-control"]); ?>

										<?php if($errors->has("eventCategoryDescription")): ?>
											<span id="eventCategoryDescription-error" class="help-block"><?php echo $errors->first("eventCategoryDescription"); ?></span>
										<?php endif; ?>
									</div>
								</div><!--end .card-body -->

								<div class="card-actionbar">
									<div class="card-actionbar-row">
										<button type="submit" class="btn ink-reaction btn-primary-dark">Modify Event Category</button>
									</div>
								</div>
							</div><!--end .card -->
						<?php echo Form::close(); ?>

					</div><!--end .col -->
				</div><!--end .row -->
				<!-- END VERTICAL FORM -->
			</div>
		</section>
	</div><!--end #content-->
	<!-- END CONTENT -->
<?php $__env->stopSection(); ?>

<?php $__env->startSection("script"); ?>
	<?php echo HTML::script('backend/ckeditor/ckeditor.js'); ?>

	<script type="text/javascript">
	    $(document).ready(function(){
	      	CKEDITOR.replace('eventCategoryDescription');
	    });
	</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make("backend/master", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/adclubmadras/public_html/resources/views/backend/events/modifyEventCategories.blade.php ENDPATH**/ ?>