<?php
    use App\Models\Faculties;
?>

<?php $__env->startSection('content'); ?>
    <div class="hero-area">
        <div class="page-header bg-color1 text-center">
            <div class="container">
                <h1>Faculty</h1>
                <ol class="breadcrumb">
                    <li><a href="<?php echo URL::to(''); ?>">Home</a></li>
                    <li><a href="<?php echo URL::to('course-offered'); ?>">Course Offered</a></li>
                    <li>Faculty</li>
                </ol>
            </div>
        </div>
    </div>

    <?php
        $faculties = Faculties::where("status", "active")->get();
    ?>

    <div id="main-container">
        <div class="content padding-b40">
            <div class="container">
                <div class="col-md-2 col-sm-12 parallax">
                    <?php echo $__env->make('frontend/course-sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                </div>

                <div class="col-md-10">
                    <ul class="team-list row">
                        <?php $__currentLoopData = $faculties; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $faculty): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li class="team-list-item col-md-12">
                                <img src="<?php echo $faculty->facultyImage != "" ? $faculty->facultyImage : 'http://placehold.it/400x400&amp;text=IMAGE+PLACEHOLDER'; ?>" alt="">
                                <h5><?php echo $faculty->facultyName; ?></h5>
                                <span class="meta-data"><?php echo $faculty->facultyDesignatione; ?></span>
                                <span class="meta-desc"><?php echo $faculty->description; ?></span>
                            </li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('frontend/master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/adclubmadras/public_html/resources/views/frontend/faculty.blade.php ENDPATH**/ ?>