<?php 
	use App\Models\CustomPages; 
	use App\Models\Option;
?>

<?php $__env->startSection('maincontent'); ?>
	<!-- BEGIN CONTENT-->
	<div id="content">
		<section>
			<div class="section-header ">
				<ol class="breadcrumb">
					<li class="active">Home</li>
					<li class="active">Pages</li>
					<li class="active"><?php echo CustomPages::getcontent("termsAndConditionsPageTitle"); ?></li>
				</ol>
			</div>
			<div class="section-body">
				<!-- BEGIN VERTICAL FORM -->
				<div class="row">
					<div class="col-lg-12">
						<h1 class="text-primary"><?php echo CustomPages::getcontent("termsAndConditionsPageTitle"); ?></h1>
					</div><!--end .col -->

					<div class="clearfix"></div>
					<?php if(Session::has('success')): ?> <?php echo HTML::display_success('success'); ?> <?php endif; ?>

					<div class="col-lg-12 col-md-12">
						<?php echo Form::open(["url"=>"admin/pages/aboutus/post","class"=>"form","enctype"=>"multipart/form-data"]); ?>

						<div class="panel panel-default">
				        <div class="panel-body">
				            <div class="row">
				                <div class="col-md-8 col-lg-8">
					                <div class="form-group <?php if($errors->has('termsAndConditionsPageTitle')): ?>has-error <?php endif; ?>">
										<?php echo Form::text("termsAndConditionsPageTitle",CustomPages::getcontent("termsAndConditionsPageTitle"),["class"=>"form-control","placeholder"=>"enter title here"]); ?>

											<?php if($errors->has("termsAndConditionsPageTitle")): ?>
												<span id="termsAndConditionsPageTitle-error" class="help-block"><?php echo $errors->first("termsAndConditionsPageTitle"); ?></span>
											<?php endif; ?>
										<?php echo HTML::decode(Form::label("pageTitle","Page Title <span class='text-danger'>*</span>")); ?>

									</div>
				                </div>

				                <?php
		                    		$data = CustomPages::where("fieldName", "termsAndConditionsPageTitle")->first();
		                    	?>

				                <div class="col-md-4 col-lg-4 brd-left">
				                  	<div class="text-right">
				                    	<?php echo e(Form::submit('Save & Publish',['class'=>'btn ink-reaction btn-primary'])); ?>

				                      	<?php if($data): ?>
			                    			<p>
			                    				<b>Last Modified:</b>  <?php echo strtoupper($data->updatedByName); ?> (<?php echo date(Option::fetchDateFormat()." ".Option::fetchTimeFormat(),strtotime($data->updated_at)); ?>)
			                    			</p>
			                    		<?php endif; ?>
				                  	</div>
				                </div>
				            </div>
				        </div>
				        </div>

				        <div class="panel panel-default">
					        <div class="panel-body">
					            <div class="row">
					                <div class="col-md-12 col-lg-12">
					                	<div class="form-group <?php if($errors->has('termsAndConditionsPageContent')): ?>has-error <?php endif; ?>">
											<?php echo HTML::decode(Form::label("termsAndConditionsPageContent","Content <span class='text-danger'>*</span>")); ?>

											<?php echo Form::textarea("termsAndConditionsPageContent",CustomPages::getcontent("termsAndConditionsPageContent"),["class"=>"form-control","cols"=>20,"rows"=>20]); ?>

											<?php if($errors->has("termsAndConditionsPageContent")): ?>
												<span id="termsAndConditionsPageContent-error" class="help-block"><?php echo $errors->first("termsAndConditionsPageContent"); ?></span>
											<?php endif; ?>
										</div>
					                </div>
					            </div>
					        </div>
				        </div>

				        <div class="panel panel-default">
			        		<div class="panel-body">
			            		<div class="row">
			            			<div class="col-md-12 col-lg-12">
				                		<h4 class="text-primary"><b>Search Engine Optimization</b></h4>

										<div class="form-group">
											<?php echo Form::text("termsAndConditionsMetaTitle",CustomPages::getcontent("termsAndConditionsMetaTitle"),["class"=>"form-control","placeholder"=>"Meta Title","rows"=>"4"]); ?>

											<?php if($errors->has("termsAndConditionsMetaTitle")): ?>
												<span id="termsAndConditionsMetaTitle-error" class="help-block"><?php echo $errors->first("termsAndConditionsMetaTitle"); ?></span>
											<?php endif; ?>
											<?php echo HTML::decode(Form::label("termsAndConditionsMetaTitle","Meta Title <span class='text-danger'>*</span>")); ?>

										</div>

										<div class="form-group">
											<?php echo Form::textarea("termsAndConditionsMetaDescription",CustomPages::getcontent("termsAndConditionsMetaDescription"),["class"=>"form-control","placeholder"=>"Meta Description","rows"=>"4"]); ?>

											<?php if($errors->has("termsAndConditionsMetaDescription")): ?>
												<span id="termsAndConditionsMetaDescription-error" class="help-block"><?php echo $errors->first("termsAndConditionsMetaDescription"); ?></span>
											<?php endif; ?>
											<?php echo HTML::decode(Form::label("termsAndConditionsMetaDescription","Meta Description <span class='text-danger'>*</span>")); ?>

										</div>

										<div class="form-group">
											<?php echo Form::text("termsAndConditionsMetaKeywords",CustomPages::getcontent("termsAndConditionsMetaKeywords"),["class"=>"form-control","placeholder"=>"Meta Keywords","rows"=>"4"]); ?>

											<?php if($errors->has("termsAndConditionsMetaKeywords")): ?>
												<span id="termsAndConditionsMetaKeywords-error" class="help-block"><?php echo $errors->first("termsAndConditionsMetaKeywords"); ?></span>
											<?php endif; ?>
											<?php echo HTML::decode(Form::label("termsAndConditionsMetaKeywords","Meta Keywords <span class='text-danger'>*</span>")); ?>

											<p class="help-block">Enter keywords seperated with comma</p>
										</div>
									</div>
								</div>
							</div>
						</div>

				        <?php echo Form::close(); ?>

					</div><!--end .col -->
				</div><!--end .row -->
				<!-- END VERTICAL FORM -->
			</div>
		</section>
	</div><!--end #content-->
	<!-- END CONTENT -->
<?php $__env->stopSection(); ?>

<?php $__env->startSection("script"); ?>
	<?php echo HTML::script('backend/js/bala.js'); ?>

	<?php echo HTML::script('backend/ckeditor/ckeditor.js'); ?>

	<script type="text/javascript">
	    $(document).ready(function() 
	    {
	      CKEDITOR.replace('termsAndConditionsPageContent');
	    });
	</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make("backend/master", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/adclubmadras/public_html/resources/views/backend/pages/termsAndConditions.blade.php ENDPATH**/ ?>