<?php
  use App\Models\User;
?>

<?php $__env->startSection('styles'); ?>
  <style type="text/css">
    .icon-box {
      padding: 0 0 0 80px;
    }

    .icon-box .ibox-icon i, .icon-box .ibox-icon img {
      border-radius: 0;
    }
  </style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
  <div class="hero-area">
    <div class="page-header bg-color1">
      <div class="container">
        <div class="text-center">
          <h1>Forgot Password</h1>
          <ol class="breadcrumb">
            <li><a href="<?php echo URL::to(''); ?>">Home</a></li>
            <li>Forgot Password</li>
          </ol>
        </div>

        <div class="spacer-40"></div>

        

        <div class="col-md-8 col-md-offset-2">
          <div class="row" id="signinDiv">
            
            <?php if(Session::has('success')): ?> <?php echo HTML::display_success('success'); ?> <?php endif; ?>

            <?php if(Session::has('error')): ?> <?php echo HTML::display_error('error'); ?> <?php endif; ?>

            <?php if(!Session::has('success')): ?>
              <div class="bg-color3 padding-all25 clearfix">
                <?php echo Form::open(["url"=>"forgot/password/reset/".Crypt::encrypt($code)."/".Crypt::encrypt($time), "name"=>"resetForgotPasswordForm", "novalidate"=>""]); ?>

                  <div class="col-md-7" style="margin-left: 155px;">
                    <div class="form-group">
                      <label>Password</label>
                      <div class="form-icon">
                        <i class="fa fa-key"></i>
                        <input type="password" class="form-control" placeholder="Enter password" name="password" autofocus="autofocus">
                      </div>
                      <?php if($errors->has('password')): ?> 
                        <div class="req">
                          <?php echo e($errors->first('password')); ?>

                        </div> 
                      <?php endif; ?>
                    </div>

                    <div class="form-group">
                      <label>Confirm Password</label>
                      <div class="form-icon">
                        <i class="fa fa-key"></i>
                        <input type="password" class="form-control" placeholder="Enter confirm password" name="password_confirmation">
                      </div>
                      <?php if($errors->has('password_confirmation')): ?> 
                        <div class="req">
                          <?php echo e($errors->first('password_confirmation')); ?>

                        </div> 
                      <?php endif; ?>
                    </div>

                    <div class="form-group">
                      <button type="submit" class="btn btn-primary">Continue</button>
                    </div>
                  </div><!--end col-md-6-->
                <?php echo Form::close(); ?>

              </div><!--end row-->
            <?php else: ?>
              <div class="bg-color3 padding-all25 text-center clearfix">
                Now you can login with your new password
                <div><a href="<?php echo URL::to('login'); ?>" class="btn ink-reaction btn-bg btn-warning">Login Now</a></div>
              </div>
            <?php endif; ?>
          </div>
        </div>



        <?php if(Session::has("success")): ?>
          <?php
            $update = User::where('code', $code)->where('status', 'active')->first();
            if($update){
              $update->code = "";
              $update->save();
            }
          ?>
        <?php endif; ?>

        

        <div class="spacer-40"></div>
      </div>
    </div>

    <div id="main-container">
      <div class="content padding-b40">
        <div class="container">
          <div class="row">
            <div class="col-md-4">
              <div class="icon-box">
                <div class="ibox-icon">
                  <img src="<?php echo URL::asset('frontend/images/icons/membership.png'); ?>">
                </div>

                <h3>Manage Membership</h3>
                <p>Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam.</p>
              </div>
            </div>

            <div class="col-md-4">
              <div class="icon-box">
                <div class="ibox-icon">
                  <img src="<?php echo URL::asset('frontend/images/icons/save-time.png'); ?>">
                </div>

                <h3>Save Time</h3>
                <p>Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam.</p>
              </div>
            </div>

            <div class="col-md-4">
              <div class="icon-box">
                <div class="ibox-icon">
                  <img src="<?php echo URL::asset('frontend/images/icons/payment-reports.png'); ?>">
                </div>

                <h3>Payment Records</h3>
                <p>Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam.</p>
              </div>
            </div>
          </div>
        </div>
      </div>

      <div class="padding-tb45 bg-color2">
        <h4 class="text-align-center margin-0">For more details contact: <a href="mailto:advertisingclubmadras@gmail.com">advertisingclubmadras@gmail.com</a><br>or 044 28141 1581, 044 281 42250</h4>
      </div>
    </div>
  </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('frontend/master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/adclubmadras/public_html/resources/views/frontend/forgotPassword.blade.php ENDPATH**/ ?>