<?php
    use App\Models\EventCategories;
    use App\Models\Events;
    use App\Models\Upload;
?>


<?php $__env->startSection('styles'); ?>
    <style type="text/css">
        .grid-item-inner {
            min-height: 45px;
        }
        .event-grid-time {
            background-color: rgba(5, 60, 90,0.8);
            padding: 5px 10px;
            top: -35px;
        }
        .grid-item h4 {
            text-overflow: ellipsis;
            white-space: nowrap;
            overflow: hidden;
        }
        .grid-item-inner p {
            font-size: 14px;
            margin-bottom: 0
        }
    </style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="hero-area">
        <div class="page-header bg-color1 text-center">
            <div class="container">
                <h1>Events</h1>
                <ol class="breadcrumb">
                    <li><a href="<?php echo URL::to(''); ?>">Home</a></li>
                    <li>Events</li>
                </ol>
            </div>
        </div>
    </div>

    <div id="main-container">
        <div class="content padding-b40">
            <div class="container">
                <div class="row">
                    <div class="col-lg-3 col-md-3 sidebar left-sidebar positioned hidden-xs">
                        <div class="widget sidebar-widget custom_menu">
                            <ul class="pages-sub-menu">
                                <li class='active'><a href="<?php echo URL::to('events/'); ?>">All Events</a></li>
                                <?php
                                    $categories = EventCategories::where("status", "active")->get();
                                ?>
                                <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php $link = $category->categorySlug?>
                                    <li><a href="<?php echo URL::to('events/'.$link); ?>"><?php echo ucwords($category->categoryName); ?></a></li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ul>
                        </div>
                    </div>

                    <div class="col-md-9 col-xs-12">
                        <?php
                            $events = Events::where("status", "active")->orderBy("eventDate", "DESC")->get();
                        ?>

                        <h5 class="subhead"><?php echo count($events); ?> Events</h5>
                        <h3 class="accent-color">All Events</h3>
                        <ul class="events-list events-list-compact">
                            <?php $__currentLoopData = $events; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $event): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php
                                        $categorySlug = EventCategories::geteventcategoryslug($event->eventCategoryID);
                                        $link = 'events';
                                        if($categorySlug != ''){
                                            $link = $categorySlug."/".$event->eventSlug;
                                        }
                                        
                                        $feature = "http://placehold.it/600x400";
                                        $check = Upload::where("productid", $event->id)->where("type", "feature")->first();
                                        if($check){
                                            $feature = $check->path;
                                        }
                                    ?>
                                <li>
                                    <div class="event-date">
                                        <div class="event-month"><?php echo date("M'y", strtotime($event->eventDate)); ?></div>
                                        <div class="event-day"><?php echo date("d", strtotime($event->eventDate)); ?></div>
                                    </div>
                                    <a href="<?php echo URL::to('events/'.$link); ?>" class="btn btn-default btn-sm">Event Details</a>
                                    <a href="<?php echo URL::to('events/'.$link); ?>"><strong><?php echo ucwords($event->eventTitle); ?></strong></a>
                                    <span class="meta-data"><?php echo date("l", strtotime($event->eventDate)); ?>, <?php echo gmdate("h:i A", $event->eventTime); ?></span>
                                </li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('frontend/master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/adclubmadras/public_html/resources/views/frontend/events.blade.php ENDPATH**/ ?>