<?php
    use App\Models\CustomPages;
?>

<?php $__env->startSection('content'); ?>
    <div class="hero-area">
        <div class="page-header bg-color1 text-center">
            <div class="container">
                <h1>Jobs Opportunities</h1>
                <ol class="breadcrumb">
                    <li><a href="<?php echo URL::to(''); ?>">Home</a></li>
                    <li>Job Opportunities</li>
                </ol>
            </div>
        </div>
    </div>

    <div id="main-container">
        <div class="content padding-b40">
            <div class="container">
                <div class="row">
                    <div class="col-md-7">
                        <?php if(Session::has('success')): ?>
                            <div class="alert alert-success"><?php echo e(Session::get('success')); ?></div>
                        <?php endif; ?>
                        <?php if(Session::has('error')): ?>
                            <div class="alert alert-danger"><?php echo e(Session::get('error')); ?></div>
                        <?php endif; ?>
                        <h4 class="widgettitle">Post a Job</h4>
                       <?php echo e(Form::open(['url' => '/job-opportunities/save', 'method' => 'POST', 'files' => true])); ?>

                            <?php if(Auth::guest()): ?>
                                <div class="row">
                                    <div class="col-md-12 col-sm-12">
                                        <label>Your Email <span class="req">*</span></label>
                                        <?php echo e(Form::text('email', '', ['class' => 'form-control input-lg'])); ?>

                                        <?php if($errors->has("email")): ?>
                                            <span class="required"><?php echo $errors->first("email"); ?></span>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            <?php else: ?>
                                <input type="hidden" id="email" name="email" value="<?php echo e(Auth::user()->email); ?>">
                            <?php endif; ?>
                            <div class="row">
                                <div class="col-md-12 col-sm-12">
                                    <label>Job Title <span class="req">*</span></label>
                                    <?php echo e(Form::text('job_title', '', ['class' => 'form-control input-lg'])); ?>

                                    <?php if($errors->has("job_title")): ?>
                                        <span class="required"><?php echo $errors->first("job_title"); ?></span>
                                    <?php endif; ?>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-12 col-sm-12">
                                    <label>Location</label>
                                    <?php echo e(Form::text('location', '', ['class' => 'form-control input-lg'])); ?>

                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-12 col-sm-12">
                                    <label>Job Type</label>
                                    <?php echo e(Form::select('job_type', ['full-time' => 'Full-time', 'part-time' => 'Part-time', 'internship' => 'Internship'], '', ['class' => 'form-control input-lg', 'placeholder' => 'Select'])); ?>

                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-12 col-sm-12">
                                    <label>Description <span class="req">*</span></label>
                                    <?php echo e(Form::textarea('description', '', ['class' => 'form-control input-lg', 'rows' => 4])); ?>

                                    <?php if($errors->has("description")): ?>
                                        <span class="required"><?php echo $errors->first("description"); ?></span>
                                    <?php endif; ?>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-12 col-sm-12">
                                    <label>Application Email/URL <span class="req">*</span></label>
                                    <?php echo e(Form::text('application_email', '', ['class' => 'form-control input-lg'])); ?>

                                    <?php if($errors->has("application_email")): ?>
                                        <span class="required"><?php echo $errors->first("application_email"); ?></span>
                                    <?php endif; ?>
                                </div>
                            </div>

                            <h2>Company Details</h2>
                            <div class="row">
                                <div class="col-md-12 col-sm-12">
                                    <label>Company Name <span class="req">*</span></label>
                                    <?php echo e(Form::text('company_name', '', ['class' => 'form-control input-lg'])); ?>

                                    <?php if($errors->has("company_name")): ?>
                                        <span class="required"><?php echo $errors->first("company_name"); ?></span>
                                    <?php endif; ?>
                                </div>
                            </div>

                             <div class="row">
                                <div class="col-md-12 col-sm-12">
                                    <label>Website</label>
                                    <?php echo e(Form::text('website', '', ['class' => 'form-control input-lg'])); ?>

                                    <?php if($errors->has("website")): ?>
                                        <span class="required"><?php echo $errors->first("website"); ?></span>
                                    <?php endif; ?>
                                </div>
                            </div>

                             <div class="row">
                                <div class="col-md-12 col-sm-12">
                                    <label>Tagline</label>
                                    <?php echo e(Form::text('tagline', '', ['class' => 'form-control input-lg'])); ?>

                                </div>
                            </div>

                            <div class="row">
                                <div class="col-md-12 col-sm-12">
                                    <label>Video</label>
                                    <?php echo e(Form::text('video', '', ['class' => 'form-control input-lg'])); ?>

                                </div>
                            </div>

                             <div class="row">
                                <div class="col-md-12 col-sm-12">
                                    <label>Twitter Username</label>
                                    <?php echo e(Form::text('twitter_username', '', ['class' => 'form-control input-lg'])); ?>

                                </div>
                            </div>

                            <div class="row">
                                <div class="col-md-12 col-sm-12">
                                    <label>Logo</label>
                                    <?php echo e(Form::file('logo', ['class' => 'form-control input-lg'])); ?>

                                    <em>File formats: png, jpg, jpeg, gif</em>
                                    <?php if($errors->has("logo")): ?>
                                        <span class="required"><?php echo $errors->first("logo"); ?></span>
                                    <?php endif; ?>
                                </div>
                            </div>

                            <div class="spacer-10"></div>

                            <div class="clearfix">
                                <button type="submit" class="btn btn-primary btn-lg">Submit</button>
                            </div>
                        <?php echo e(Form::close()); ?>

                    </div>
                    <div class="col-md-4 col-md-offset-1">
                        <h4 class="widgettitle">Get in touch with us</h4>
                        <h4 class="accent-color"><b>ADVERTISING CLUB MADRAS</b></h4>
                        <p>
                            <?php echo CustomPages::getcontent("contactUsAddress"); ?><br><br>
                            <b>Phone:</b> <?php echo CustomPages::getcontent("contactUsPhone"); ?><br>
                            <!--<b>Fax:</b> <?php echo CustomPages::getcontent("contactUsFax"); ?><br>-->
                            <b>Email:</b> 
                            <?php
                                $emails = CustomPages::getcontent("contactUsEmail");
                                $emailArray = explode(",", $emails);
                                $i = 0;
                            ?>

                            <?php $__currentLoopData = $emailArray; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $array): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php if($i > 0): ?> , <?php endif; ?>
                                <a href="mailto:<?php echo $array; ?>"><?php echo $array; ?></a>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </p>

                        <p>
                            <b>PAN No.:</b> AAAAA5944J<br>
                            <b>GST No.:</b> 33AAAAA5944J1ZV
                        </p>
                    </div>
                </div>
            </div>
        </div>

    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('frontend/master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/adclubmadras/public_html/resources/views/frontend/job-opportunities.blade.php ENDPATH**/ ?>