<?php
	use App\Models\User;
	use App\Models\Option;
	$title = Option::getvalue("siteTitle");
?>
<!DOCTYPE html>
<html lang="en">
	<head>
		<title><?php echo Option::portalName(); ?> - Admin Login</title>

		<!-- BEGIN META -->
		<meta charset="utf-8">
		<meta name="viewport" content="width=device-width, initial-scale=1.0">
		<meta name="keywords" content="your,keywords">
		<meta name="description" content="Short explanation about this website">
		<!-- END META -->

		<!-- BEGIN STYLESHEETS -->
		<link href='http://fonts.googleapis.com/css?family=Roboto:300italic,400italic,300,400,500,700,900' rel='stylesheet' type='text/css'/>
		<?php echo HTML::style('backend/assets/css/theme-default/bootstrap.css'); ?>

		<?php echo HTML::style('backend/assets/css/theme-default/materialadmin.css'); ?>

		<?php echo HTML::style('backend/assets/css/theme-default/font-awesome.min.css'); ?>

		<?php echo HTML::style('backend/assets/css/theme-default/material-design-iconic-font.min.css'); ?>

		<?php echo HTML::style('backend/assets/css/theme-default/libs/rickshaw/rickshaw.css'); ?>

		<?php echo HTML::style('backend/assets/css/theme-default/libs/morris/morris.core.css.css'); ?>

		<?php echo HTML::style('backend/assets/css/theme-default/libs/select2/select2.css'); ?>

		<?php echo HTML::style('backend/assets/css/theme-default/libs/multi-select/multi-select.css'); ?>

		<?php echo HTML::style('backend/assets/css/theme-default/libs/toastr/toastr.css?1425466569'); ?>

		<!-- END STYLESHEETS -->

		<!-- HTML5 shim and Respond.js IE8 support of HTML5 elements and media queries -->
		<!--[if lt IE 9]>
		<script type="text/javascript" src="../../assets/js/libs/utils/html5shiv.js?1403934957"></script>
		<script type="text/javascript" src="../../assets/js/libs/utils/respond.min.js?1403934956"></script>
		<![endif]-->
	</head>
	<body class="menubar-hoverable header-fixed ">

		<!-- BEGIN LOGIN SECTION -->
		<section class="section-account">
			<div class="card contain-sm style-transparent">
				<div class="card-body">
					<div class="row">
						<div class="col-sm-8 col-sm-offset-2">
							
							<div class="text-center">
							<img src="<?php echo URL::asset('backend/assets/img/logo.png'); ?>"><br><br>
							</div>
							<br/><br/>
							<?php if(Session::has("error")): ?>
							<?php echo Session::get("error"); ?>

							<?php endif; ?>
							<?php echo Form::open(["url"=>"admin/acm/console/login","class"=>"form"]); ?>

								<div class="form-group <?php if($errors->has('userName')): ?>has-error <?php endif; ?>">
									<?php echo Form::text("userName","",["class"=>"form-control","autofocus"]); ?>

										<?php if($errors->has("userName")): ?>
											<span id="userName-error" class="help-block"><?php echo $errors->first("userName"); ?></span>
										<?php endif; ?>
									<?php echo Form::label("userName","Email"); ?>

								</div>
								<div class="form-group <?php if($errors->has('password')): ?>has-error <?php endif; ?>">
									<?php echo Form::password("password",["class"=>"form-control"]); ?>

										<?php if($errors->has("password")): ?>
											<span id="password-error" class="help-block"><?php echo $errors->first("password"); ?></span>
										<?php endif; ?>
									<?php echo Form::label("password","Password"); ?>

								</div>
								<br/>
								<div class="row">
									<div class="col-xs-6 text-left">

									</div><!--end .col -->
									<div class="col-xs-6 text-right">
										<button class="btn btn-primary btn-raised" type="submit">Login</button>
									</div><!--end .col -->
								</div><!--end .row -->
							<?php echo Form::close(); ?>

						</div><!--end .col -->
						</div><!--end .row -->
						</div><!--end .card-body -->
					</div><!--end .card -->
				</section>
				<!-- END LOGIN SECTION -->

			</body>
		</html>
<?php /**PATH /home/adclubmadras/public_html/resources/views/backend/login.blade.php ENDPATH**/ ?>