<?php
    use App\Models\GalleryCategories;
    use App\Models\Gallery;
    use App\Models\Upload;
?>


<?php $__env->startSection('styles'); ?>
    <?php echo HTML::style('frontend/css/jquery.lightbox.css'); ?>

    <style type="text/css">
        .grid-item-inner {
            min-height: auto;
            margin-bottom: 25px;
        }
    </style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="hero-area">
        <div class="page-header bg-color1 text-center">
            <div class="container">
                <h1>Gallery</h1>
                <ol class="breadcrumb">
                    <li><a href="<?php echo URL::to(''); ?>">Home</a></li>
                    <li>Gallery</li>
                </ol>
            </div>
        </div>
    </div>

    <div id="main-container">
        <div class="content padding-b40">
            <div class="container">
                <div class="row">
                    <div class="col-lg-3 col-md-3 sidebar left-sidebar positioned">
                        <div class="widget sidebar-widget custom_menu">
                            <ul class="pages-sub-menu">
                                <li><a href="<?php echo URL::to('gallery'); ?>">All Gallery</a></li>
                                <?php
                                    $categories = GalleryCategories::where("status", "active")->get();
                                ?>
                                <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php $link = $category->categorySlug ?>
                                    <li <?php if($category->id == $album->galleryCategoryID): ?> <?php echo "class='active'"; ?> <?php endif; ?>><a href="<?php echo URL::to('gallery/'.$link); ?>"><?php echo ucwords($category->categoryName); ?></a></li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ul>
                        </div>
                    </div>
                    <div class="col-md-9">
                        <h5 class="subhead"><?php echo $totalCount; ?> Photos</h5>
                        <h3 class="accent-color"><?php echo $album->galleryTitle; ?></h3>
                        

                        <?php if($album->description != ""): ?>
                            <div class="grid-item-inner">
                                <h4 class="margin-0"><?php echo $album->descriptionTitle; ?></h4>
                                <div>
                                    <?php echo $album->description; ?>

                                </div>
                            </div>
                        <?php endif; ?>
                        

                        <div class="row" id="thumbnails">
                            <?php $__currentLoopData = $photos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $photo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="col-md-3 col-sm-3 col-xs-6">
                                    <a href="<?php echo $photo->path; ?>"><img src="<?php echo $photo->path; ?>" class="img-icon" alt="turntable"></a>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                        <?php echo e($photos->links()); ?>

                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>


<?php $__env->startSection('script'); ?>
    <?php echo HTML::script('frontend/js/jquery.lightbox-0.5.min.js'); ?>

    <script type="text/javascript">
        $(function() {
            $('#thumbnails a').lightBox();
        });
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('frontend/master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/adclubmadras/public_html/resources/views/frontend/gallery-details.blade.php ENDPATH**/ ?>