<?php
    use App\Models\GalleryCategories;
    use App\Models\Gallery;
    use App\Models\Upload;
?>

<?php $__env->startSection('styles'); ?>
    <style type="text/css">
        .grid-item-inner {
            min-height: 145px;
        }
        .grid-item-inner p {
            font-size: 13px;
            margin-bottom: 0
        }
    </style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="hero-area">
        <div class="page-header bg-color1 text-center">
            <div class="container">
                <h1>Gallery</h1>
                <ol class="breadcrumb">
                    <li><a href="<?php echo URL::to(''); ?>">Home</a></li>
                    <li>Gallery</li>
                </ol>
            </div>
        </div>
    </div>

    <div id="main-container">
        <div class="content padding-b40">
            <div class="container">
                <div class="row">
                    <div class="col-lg-3 col-md-3 sidebar left-sidebar positioned">
                        <div class="widget sidebar-widget custom_menu">
                            <ul class="pages-sub-menu">
                                <li class='active'><a href="<?php echo URL::to('gallery'); ?>">All Gallery</a></li>
                                <?php
                                    $categories = GalleryCategories::where("status", "active")->get();
                                ?>

                                <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php $link = $category->categorySlug ?>
                                    <li><a href="<?php echo URL::to('gallery/'.$link); ?>"><?php echo ucwords($category->categoryName); ?></a></li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ul>
                        </div>
                    </div>

                    <div class="col-md-9">
                        
                        <?php
                            $albums = Gallery::where("status", "active")->orderBy("galleryDate", "DESC")->get();
                        ?>
                        <h5 class="subhead"><?php echo count($albums); ?> Albums</h5>
                        <h3 class="accent-color">All Gallery</h3>
                        <div class="row">
                            <ul class="list-style">
                                <?php $__currentLoopData = $albums; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $album): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php
                                        $categorySlug = GalleryCategories::getgallerycategoryslug($album->galleryCategoryID);
                                        $link = 'gallery';
                                        if($categorySlug != ''){
                                            $link = $categorySlug."/".$album->gallerySlug;
                                        }
                                        
                                        $feature = "http://placehold.it/600x400";
                                        $check = Upload::where("productid", $album->id)->where("type", "feature")->first();
                                        if($check){
                                            $feature = $check->path;
                                        }
                                    ?>
                                    <li class="grid-item event-grid-item col-md-4 col-sm-4 format-standard">
                                        <a href="<?php echo URL::to('gallery/'.$link); ?>" class="media-box h-195">
                                            <img src="<?php echo $feature; ?>" alt="<?php echo ucwords($album->galleryTitle ); ?>">
                                        </a>

                                        <div class="grid-item-inner">
                                            <span class="event-grid-time"><?php echo date("F d, Y", strtotime($album->galleryDate)); ?></span>
                                            <h4><a href="<?php echo URL::to('gallery/'.$link); ?>" title="<?php echo ucwords($album->galleryTitle ); ?>"><?php echo ucwords($album->galleryTitle ); ?></a></h4>
                                            <b><?php echo $album->galleryHostedBy; ?></b><br>
                                            <?php echo $album->hostDesignation; ?><br>
                                            <?php echo $album->hostCompanyName; ?>

                                        </div>
                                    </li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('frontend/master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/adclubmadras/public_html/resources/views/frontend/gallery.blade.php ENDPATH**/ ?>