<?php

    use App\Models\EventCategories;

    use App\Models\Events;

    use App\Models\Upload;

    use App\Models\GalleryCategories;

    use App\Models\Gallery;

    use App\Models\Option;

     use App\Models\Customfieldmeta;

?>



<?php $__env->startSection('metadetails'); ?>

    <meta property="og:url"           content="<?php echo Request::url(); ?>" />

    <meta property="og:type"          content="article" />

    <meta property="og:title"         content="<?php echo $event->eventTitle; ?> - Advertising Club Madras" />

    <meta property="og:description"   content="<?php echo $event->eventVenue; ?>" />

    <meta property="og:image"         content="<?php echo $event->eventPoster; ?>" />



    <meta name="twitter:card" content="summary_large_image">

    <meta name="twitter:site" content="@AdvertisingClubMadras">

    <meta name="twitter:title" content="<?php echo $event->eventTitle; ?> - Advertising Club Madras">

    <meta name="twitter:description" content="<?php echo $event->eventVenue; ?>">

    <meta name="twitter:creator" content="@AdvertisingClubMadras">

    <meta name="twitter:image" content="<?php echo $event->eventPoster; ?>">

<?php $__env->stopSection(); ?>

<?php $__env->startSection('styles'); ?>

    <?php echo HTML::style('backend/assets/css/jquery-ui.css'); ?>


    <link rel="stylesheet" type="text/css" href="https://cdnjs.cloudflare.com/ajax/libs/jquery-ui-timepicker-addon/1.6.3/jquery-ui-timepicker-addon.min.css">

    <?php echo HTML::style('frontend/css/jquery.lightbox.css'); ?>


<?php $__env->stopSection(); ?>



<?php $__env->startSection('content'); ?>

    <div class="hero-area">

        <div class="page-header bg-color1 text-center">

            <div class="container">

                <h1>Events</h1>

                <ol class="breadcrumb">

                    <li><a href="<?php echo URL::to(''); ?>">Home</a></li>

                    <li>Events</li>

                </ol>

            </div>

        </div>

    </div>



    <div id="main-container">

        <div class="content padding-b40">

            <div class="container">

                <div class="row">

                    <div class="col-lg-3 col-md-3 sidebar left-sidebar positioned hidden-xs">

                        <div class="widget sidebar-widget custom_menu">

                            <ul class="pages-sub-menu">

                                <li><a href="<?php echo URL::to('events/'); ?>">All Events</a></li>

                                <?php

                                    $categories = EventCategories::where("status", "active")->get();

                                ?>

                                <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                                    <?php $link = $category->categorySlug?>

                                    <li  <?php if($event->eventCategoryID == $category->id): ?> <?php echo "class='active'"; ?> <?php endif; ?>><a href="<?php echo URL::to('events/'.$link); ?>"><?php echo ucwords($category->categoryName); ?></a></li>

                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                            </ul>

                        </div>

                    </div>

                    <div class="col-md-9 col-xs-12">

                        <div class="single-event">

                            <div class="row">

                                <?php if(Session::has('errorMessage')): ?>

                                    <div class="alert alert-danger"><?php echo Session::get('errorMessage'); ?></div>

                                <?php endif; ?>

                                <div class="col-lg-4 col-md-5 col-sm-5">

                                    <div class="hidden-md hidden-lg"><div class="single-event-right"><h2><?php echo ucwords($event->eventTitle); ?></h2></div></div>

                                    <div class="single-event-left dgray-bg">

                                        <a href="<?php echo $event->eventPoster; ?>" title="<?php echo ucwords($event->eventTitle); ?>" target="_blank"><img src="<?php echo $event->eventPoster; ?>" class="img-icon" alt="<?php echo ucwords($event->eventTitle); ?>"></a>

                                        

                                        <?php if($event->gallery != '' && $event->gallery > 0): ?>

                                            <?php

                                                $categorySlug = '';

                                                $gallerySlug = '';

                                                $check = Gallery::find($event->gallery);

                                                if($check){

                                                    $gallerySlug = $check->gallerySlug;



                                                    $checkCat = GalleryCategories::find($check->galleryCategoryID);

                                                    if($checkCat){

                                                        $categorySlug = $checkCat->categorySlug;

                                                    }

                                                }

                                                $link = '';

                                                if($categorySlug != '' && $gallerySlug != ''){

                                                    $link = $categorySlug."/".$gallerySlug;

                                                }

                                            ?>

                                            <div class="spacer-30"></div>

                                            <a href="<?php echo URL::to('gallery/'.$link); ?>" class="btn btn-default btn-ghost btn-light btn-block">View Gallery</a>

                                        <?php endif; ?>

                                    </div>

                                </div>

                                <div class="col-lg-8 col-md-7 col-sm-7">

                                    <div class="single-event-right">

                                        <div class="hidden-xs"><h2><?php echo ucwords($event->eventTitle); ?></h2></div>

                                        <div class="alert alert-primary">

                                            <p><b>Date:</b><br><?php echo date("F d, Y", strtotime($event->eventDate)); ?></p>

                                            <p><b>Time:</b><br><?php echo gmdate("h:i A", $event->eventTime); ?> <?php if($event->eventEndTime != ''): ?> - <?php echo gmdate("h:i A", $event->eventEndTime); ?> <?php endif; ?></p>

                                            

                                            <?php if($event->reportingTime): ?>

                                                <p><b>Reporting Time:</b><br><?php echo gmdate("h:i A", $event->reportingTime); ?></p>

                                            <?php endif; ?>



                                            <?php if($event->memberFeeText): ?>

                                                <p><b>Entry Fee:</b><br><?php echo $event->memberFeeText; ?></p>

                                            <?php endif; ?>


                                            <?php if($event->eventVenue): ?>
                                                <p><b>Venue:</b><br><?php echo $event->eventVenue; ?></p>
                                            <?php endif; ?>

                                            <?php if($event->eventInformation): ?>
                                                <p><b>Information:</b><br><?php echo $event->eventInformation; ?></p>
                                            <?php endif; ?>



                                            <?php if($event->streaming_link): ?>

                                                <p><b>Registration or Streaming Link:</b><br><a href="<?php echo e($event->streaming_link); ?>" target="_blank">Click to View/Register</a></p>

                                            <?php endif; ?>



                                            <?php $__currentLoopData = $custom_info; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $info): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                                                <?php if($info->field_type == 'single_file_upload' || $info->field_type == 'multiple_file_upload'): ?>

                                                    <p><b><?php echo $info->label_name; ?>:</b>

                                                        <a href="<?php echo asset($info->field_value); ?>" target="_blank"><i class="fa fa-file"></i></a>

                                                    </p>

                                                <?php else: ?>

                                                    <p><b><?php echo $info->label_name; ?>:</b><br><?php echo $info->field_value; ?></p>

                                                <?php endif; ?>

                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                        </div>

                                        <?php if($event->entryType == 'paid'): ?>

                                            <form id="registerAndPaymentForm" enctype="multipart/form-data" method="post">

                                                <input type="hidden" name="hiddenId" id="hiddenId" value="<?php echo e(encrypt($event->id)); ?>">

                                                <?php $gst = Option::getvalue('GST'); ?>

                                                <?php if($event->isSportEvent == 'no'): ?>

                                                    <div class="row">

                                                        <div class="col-md-6">

                                                        <label>Entry Tickets</label>

                                                        <select name="tickets" id="tickets" class="form-control">

                                                            <option value="1" selected="selected">1</option>

                                                            <option value="2">2</option>

                                                            <option value="3">3</option>

                                                            <option value="4">4</option>

                                                            <option value="5">5</option>

                                                            <option value="6">6</option>

                                                            <option value="7">7</option>

                                                            <option value="8">8</option>

                                                            <option value="9">9</option>

                                                            <option value="10">10</option>

                                                        </select>

                                                        </div>

                                                    </div>

                                                <?php else: ?>

                                                    <input type="hidden" name="tickets" value="1" id="tickets">

                                                <?php endif; ?>



                                                <div class="form-group">

                                                    <label>Are you a Adclubmadras Regsitered Member?&nbsp;&nbsp; </label>

                                                    <input type="radio" class="" name="userType" value="yes">&nbsp;Yes

                                                    <input type="radio" class="" name="userType" value="no" checked="checked">&nbsp;No

                                                </div>

                                                

                                                <?php $__currentLoopData = $custom_fields_reg; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $fields): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                                                    <div class="form-group">

                                                    <label><?php echo e($fields->label_name); ?> <?php if($fields->is_required == 'yes'): ?> <span class='text-danger'>*</span> <?php endif; ?></label>

                                                    <?php if($fields->field_type == 'plain_text' || $fields->field_type == 'datepicker' || $fields->field_type == 'dateandtime' || $fields->field_type == 'phonenumber' || $fields->field_type == 'numbers' || $fields->field_type == 'amount' || $fields->field_type == 'email'): ?>

                                                        <input type="text" class="form-control <?php if($fields->field_type == 'datepicker'): ?> R_custom_fields_date <?php endif; ?> <?php if($fields->field_type == 'dateandtime'): ?> R_custom_fields_datetime <?php endif; ?>" id="<?php echo e($fields->field_slug); ?>" name="<?php echo e($fields->field_slug); ?>" value="<?php echo e($fields->field_value); ?>">

                                                    <?php endif; ?>



                                                    <?php if($fields->field_type == 'text_area'): ?>

                                                            <textarea class="form-control" id="<?php echo e($fields->field_slug); ?>" name="<?php echo e($fields->field_slug); ?>"></textarea>

                                                    <?php endif; ?>



                                                    <?php if($fields->field_type == 'checkbox' || $fields->field_type == 'radio'): ?>

                                                            <?php

                                                                $metadata = Customfieldmeta::where('custom_field_id',$fields->id)->get();

                                                            ?>

                                                            <?php $__currentLoopData = $metadata; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $m): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                                                                <?php echo e($m->field_value); ?><input type="<?php echo e($fields->field_type); ?>" id="<?php echo e($fields->field_slug); ?>" name="<?php echo e($fields->field_slug); ?>[]">

                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                                    <?php endif; ?>



                                                    <?php if($fields->field_type == 'dropdown'): ?>

                                                        <?php

                                                            $metadata = Customfieldmeta::where('custom_field_id',$fields->id)->get();

                                                        ?>

                                                            <select class="form-control" id="<?php echo e($fields->field_slug); ?>" name="<?php echo e($fields->field_slug); ?>">

                                                                <option value="">Select</option>

                                                                <?php $__currentLoopData = $metadata; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $m): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                                                                    <option value="<?php echo e($m->field_value); ?>"><?php echo e($m->field_value); ?></option>

                                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                                            </select>

                                                    <?php endif; ?>



                                                    <?php if($fields->field_type == 'single_file_upload'): ?>

                                                        <input type="file" class="form-control" name="<?php echo e($fields->field_slug); ?>" id="<?php echo e($fields->field_slug); ?>">

                                                        <?php if($fields->field_value != ''): ?>

                                                            <div class="form-group">

                                                                <a href="<?php echo e(asset($fields->field_value)); ?>" target="_blank" style="color: green;"><?php echo e($fields->extra_field); ?> <i class="fa fa-file"></i></a>

                                                                <a href="javascript:;" class="removeCustomFieldFile" data-field="single" data-id="<?php echo e(encrypt($fields->id)); ?>" style="color: red;"><i class="fa fa-trash"></i></a>

                                                                <label>Preview</label>

                                                            </div>

                                                        <?php endif; ?>

                                                    <?php endif; ?>



                                                    <?php if($fields->field_type == 'multiple_file_upload'): ?>

                                                            <input type="file" class="form-control" name="<?php echo e($fields->field_slug); ?>[]" id="<?php echo e($fields->field_slug); ?>" multiple="">

                                                        <?php

                                                            $metadata = Customfieldmeta::where('custom_field_id',$fields->id)->get();

                                                        ?>

                                                        <?php if(count($metadata) != 0): ?>

                                                            <div class="form-group">

                                                                <label>Preview</label>

                                                                <ul>

                                                                    <?php $__currentLoopData = $metadata; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $meta): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                                                                        <li>

                                                                            <a href="<?php echo e(asset($meta->field_value)); ?>" target="_blank" style="color: green;"><?php echo e($meta->extra_field); ?> <i class="fa fa-file"></i></a>

                                                                            <a href="javascript:;" class="removeCustomFieldFile" data-field="multiple" data-id="<?php echo e(encrypt($meta->id)); ?>" style="color: red;"><i class="fa fa-trash"></i></a>

                                                                        </li>

                                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                                                </ul>

                                                            </div>

                                                        <?php endif; ?>

                                                    <?php endif; ?>

                                                    </div>

                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>



                                                <?php if($event->isSportEvent != 'no'): ?>

                                                    <?php if($event->isSportEvent == 'badminton' || $event->isSportEvent == 'tennis'): ?>

                                                        <?php if($event->typeOfTeam == 'single'): ?>

                                                            <div class="form-group ">

                                                                <label>Type of Team *</label>

                                                                <?php echo Form::select("typeOfTeam",[''=>'Select','single'=> 'Singles'], '',["class"=>"form-control", 'id' => 'typeOfTeam']); ?>


                                                            </div>

                                                            

                                                            <div class="form-group" id="singlePlayerCountBox" style="display: none;">

                                                                <label>Singles *</label>

                                                                <select class="form-control" id="singlePlayerCount" name="singlePlayerCount">

                                                                    <option value="">Select Player</option>

                                                                    <?php for($i = 0; $i< $event->maxSinglesCount; $i++): ?>

                                                                        <option value="<?php echo e($i+1); ?>"><?php echo e($i+1); ?> Player</option>

                                                                    <?php endfor; ?>

                                                                </select>

                                                            </div>



                                                            <div id="SinglePlayerDetail" style="display: none;">

                                                                <p>Singles Player Details</p>

                                                                <hr>

                                                                <?php for($i = 0; $i< $event->maxSinglesCount; $i++): ?>

                                                                    <div class="form-group singleplayerbox" id="singleplayerbox_<?php echo e($i+1); ?>">

                                                                        <label>Player <?php echo e($i+1); ?> *</label>

                                                                        <input class="form-control" type="text" name="singleplayer_<?php echo e($i+1); ?>" id="singleplayer_<?php echo e($i+1); ?>">

                                                                    </div>

                                                                <?php endfor; ?>

                                                            </div>



                                                        <?php endif; ?>

                                                        <?php if($event->typeOfTeam == 'double'): ?>

                                                            <div class="form-group ">

                                                                <label>Type of Team *</label>

                                                                <?php echo Form::select("typeOfTeam",[''=>'Select','double' => 'Dobles'], '',["class"=>"form-control", 'id' => 'typeOfTeam']); ?>


                                                            </div>



                                                            <div class="form-group" id="doublePlayerCountBox" style="display: none;">

                                                                <label>Doubles *</label>

                                                                <select class="form-control" id="doublePlayerCount" name="doublePlayerCount">

                                                                    <option value="">Select Team</option>

                                                                    <?php for($i = 0; $i< $event->maxDoublesCount; $i++): ?>

                                                                        <option class="form-control" value="<?php echo e($i+1); ?>"><?php echo e($i+1); ?> Team</option>

                                                                    <?php endfor; ?>

                                                                </select>

                                                            </div>



                                                            <div id="DoublePlayerDetail" style="display: none;">

                                                                <p>Doubles Player Details</p>

                                                                <hr>

                                                                <?php for($i = 0; $i< ($event->maxDoublesCount*2); $i++): ?>

                                                                    <div class="form-group doubleplayerbox" id="doubleplayerbox_<?php echo e($i+1); ?>">

                                                                        <label>Player <?php echo e($i+1); ?> *</label>

                                                                        <input class="form-control" type="text" name="doubleplayer_<?php echo e($i+1); ?>" id="doubleplayer_<?php echo e($i+1); ?>">

                                                                    </div>

                                                                <?php endfor; ?>

                                                            </div>



                                                        <?php endif; ?>

                                                        <?php if($event->typeOfTeam == 'both'): ?>

                                                            <div class="form-group ">

                                                                <label>Type of Team *</label>

                                                                <?php echo Form::select("typeOfTeam",[''=>'Select','single'=> 'Singles','double' => 'Dobles', 'both' => 'Singles and Doubles'], '',["class"=>"form-control", 'id' => 'typeOfTeam']); ?>


                                                            </div>



                                                            <div class="form-group" id="singlePlayerCountBox" style="display: none;">

                                                                <label>Singles *</label>

                                                                <select class="form-control" id="singlePlayerCount" name="singlePlayerCount">

                                                                    <option value="">Select Player</option>

                                                                    <?php for($i = 0; $i< $event->maxSinglesCount; $i++): ?>

                                                                        <option value="<?php echo e($i+1); ?>"><?php echo e($i+1); ?> Player</option>

                                                                    <?php endfor; ?>

                                                                </select>

                                                            </div>





                                                            <div class="form-group" id="doublePlayerCountBox" style="display: none;">

                                                                <label>Dobules *</label>

                                                                <select class="form-control" id="doublePlayerCount" name="doublePlayerCount">

                                                                    <option value="">Select Team</option>

                                                                    <?php for($i = 0; $i< $event->maxDoublesCount; $i++): ?>

                                                                        <option value="<?php echo e($i+1); ?>"><?php echo e($i+1); ?> Team</option>

                                                                    <?php endfor; ?>

                                                                </select>

                                                            </div>



                                                            <div id="SinglePlayerDetail" style="display: none;">

                                                                <p>Singles Player Details</p>

                                                                <hr>

                                                                 <?php for($i = 0; $i< $event->maxSinglesCount; $i++): ?>

                                                                    <div class="form-group singleplayerbox" id="singleplayerbox_<?php echo e($i+1); ?>">

                                                                        <label>Player <?php echo e($i+1); ?> *</label>

                                                                        <input class="form-control" type="text" name="singleplayer_<?php echo e($i+1); ?>" id="singleplayer_<?php echo e($i+1); ?>">

                                                                    </div>

                                                                <?php endfor; ?>

                                                            </div>



                                                            <div id="DoublePlayerDetail" style="display: none;">

                                                                <p>Doubles Player Details</p>

                                                                <hr>

                                                                 <?php for($i = 0; $i< ($event->maxDoublesCount*2); $i++): ?>

                                                                    <div class="form-group doubleplayerbox" id="doubleplayerbox_<?php echo e($i+1); ?>">

                                                                        <label>Player <?php echo e($i+1); ?> *</label>

                                                                        <input class="form-control" type="text" name="doubleplayer_<?php echo e($i+1); ?>" id="doubleplayer_<?php echo e($i+1); ?>">

                                                                    </div>

                                                                <?php endfor; ?>

                                                            </div>



                                                        <?php endif; ?>



                                                    <?php endif; ?>

                                                    <?php if($event->isSportEvent == 'cricket'): ?>

                                                        <p>Player Details</p>

                                                        <hr>

                                                        <?php for($i = 0; $i< $event->maximumPlayer; $i++): ?>

                                                            <div class="form-group ">

                                                                <label>Player <?php echo e($i+1); ?> *</label>

                                                                <input class="form-control" type="text" name="cplayer_<?php echo e($i+1); ?>" id="cplayer_<?php echo e($i+1); ?>">

                                                            </div>

                                                        <?php endfor; ?>

                                                    <?php endif; ?>

                                                <?php endif; ?>

                                                <button type="submit" id="eventRegisterBtn" class="btn btn-default">Register & Payment</button>

                                            </form>

                                        <?php endif; ?>

                                        

                                        <div class="spacer-30"></div>


                                        <?php if($event->eventDescription): ?>
                                            <div><b>Terms & Conditions:</b></div>

                                            <?php echo $event->eventDescription; ?>

                                         <?php endif; ?>



                                        <div class="spacer-30"></div>

                                        

                                        <ul class="social-icons social-icons-colored social-icons-inverted">

                                            <li class="meta-data">SHARE EVENT</li>

                                            <li class="facebook"><a href="https://www.facebook.com/sharer/sharer.php?u=<?php echo Request::url(); ?>" title="Facebook"  class="social-button "><i class="fa fa-facebook"></i></a>

                                            </li>

                                            <li class="twitter"><a href="https://twitter.com/intent/tweet?text=<?php echo $event->eventTitle; ?>&amp;url=<?php echo Request::url(); ?>" title="Twitter" class="social-button " id=""><i class="fa fa-twitter"></i></a></li>

                                        </ul>

                                    </div>

                                </div>

                            </div>

                        </div>

                    </div>

                </div>

            </div>

        </div>

    </div>

    <div id="hiddenForm" style="display: none;"></div>

<?php $__env->stopSection(); ?>



<?php $__env->startSection('script'); ?>

   <?php echo HTML::script('backend/assets/js/jquery-ui.js'); ?>


    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-ui-timepicker-addon/1.6.3/jquery-ui-timepicker-addon.min.js"></script>

    <?php echo HTML::script('frontend/js/share.js'); ?>


    <?php echo HTML::script('frontend/js/jquery.lightbox-0.5.min.js'); ?>


    <script type="text/javascript">

        $(function() {

            $('#event-poster a').lightBox();

        });



        $(document).on('click', '.eventRegister', function () {

            <?php if(Auth::guest()): ?>

                swal({

                    title: "Login!",

                    text: "Please login to continue.",

                    icon: "warning",

                    buttons: ["Cancel", "Login"],

                    dangerMode: true,

                })

                .then((willDelete) => {

                    if (willDelete) {

                        <?php

                            Session::put('redirectUrl', Request::path());

                        ?>

                        window.location = '/login';

                    }

                });

                return false;

            <?php endif; ?>

        });



        $(".R_custom_fields_date").datepicker({

            dateFormat:'yy-mm-dd',

        });

        $(".R_custom_fields_datetime").datetimepicker({

            dateFormat:'yy-mm-dd', 

            timeFormat: 'h:mm',

        });



        $('#typeOfTeam').on('change', function(){

            var t = $(this).val();

            $('#singlePlayerCount').val('');

            $('#doublePlayerCount').val('');

            $('#singlePlayerCountBox').hide();

            $('#SinglePlayerDetail').hide();

            $('.singleplayerbox').hide();



            $('#doublePlayerCountBox').hide();

            $('#DoublePlayerDetail').hide();

            $('.doubleplayerbox').hide();



            if(t == 'single' || t == 'both'){

                $('#singlePlayerCountBox').show();

            }



            if(t == 'double' || t == 'both'){

                $('#doublePlayerCountBox').show();

            }

        });



        $('#singlePlayerCount').on('change', function(){

            var c = $(this).val();

            $('.singleplayerbox').hide();

            $('#SinglePlayerDetail').hide();

            if(c == '' || c == undefined ){

                return false;

            }

            for(i=1; i<=c; i++){

                $('#singleplayerbox_'+i).show();

            }

            $('#SinglePlayerDetail').show();

        });



        $('#doublePlayerCount').on('change', function(){

            var c = $(this).val();

            $('.doubleplayerbox').hide();

            $('#DoublePlayerDetail').hide();

            if(c == '' || c == undefined ){

                return false;

            }

            for(i=1; i<=(c*2); i++){

                $('#doubleplayerbox_'+i).show();

            }

            $('#DoublePlayerDetail').show();

        });



        $('#registerAndPaymentForm').submit(function(e) {

            e.preventDefault();

            var t = $('#eventRegisterBtn'); $('.validate').remove(); $('.smsg').remove();

            var txt = t.text();

            var hiddenId = $('#hiddenId').val();

            var tickets = $('#tickets').val(); $('.validate').remove();

            let formData = new FormData(this);

                <?php if(Auth::guest()): ?>

                    swal({

                        title: "Login!",

                        text: "Please login to continue.",

                        icon: "warning",

                        buttons: ["Cancel", "Login"],

                        dangerMode: true,

                    })

                    .then((willDelete) => {

                        if (willDelete) {

                            <?php

                                Session::put('redirectUrl', Request::path());

                            ?>

                            window.location = '/login';

                        }

                    });

                    return false;

                <?php endif; ?>

            t.text('Procssing...').prop( "disabled", true );

            $.ajax({

                contentType: false,

                processData: false,

                type: "POST",

                url:  "<?php echo e(route('event.registration')); ?>",

                headers: { 'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content'), },

                data: formData,

                dataType: "json",

                success: function(data){

                    t.text(txt).prop( "disabled", false );

                    if(data.status == "success"){

                        $('#hiddenForm').html(data.template);

                        $('#hiddenFormBox').submit();

                    }else if(data.status == "validation"){

                        $.each(data.validation, function(k,v){

                            k = k.split('.')[0];

                            $('#'+k).after('<span class="validate" style="color:red;">'+v+'</span>');

                        });

                    }else{

                         t.text(txt).prop( "disabled", false );

                         alert(data.msg);

                    }

                    return false;

                },

                error: function(e){

                    t.text(txt).prop( "disabled", false );

                    alert('Error. Please try again');

                    return false;

                }

            });/* end of ajax */



        });



    </script>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('frontend/master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/adclubmadras/public_html/resources/views/frontend/event-details.blade.php ENDPATH**/ ?>