<?php
    use App\Models\PastPresidents;
?>

<?php $__env->startSection('content'); ?>
    <div class="hero-area">
        <div class="page-header bg-color1 text-center">
            <div class="container">
                <h1>Past Presidents</h1>
                <ol class="breadcrumb">
                    <li><a href="<?php echo URL::to(''); ?>">Home</a></li>
                    <li><a href="<?php echo URL::to('about'); ?>">About Us</a></li>
                    <li>Past Presidents</li>
                </ol>
            </div>
        </div>
    </div>

    <div id="main-container">
        <div class="content padding-b40 past-presidents">
            <div class="container">
                <div class="col-md-2 col-sm-12 parallax">
                    <?php echo $__env->make('frontend/about-sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                </div>

                <?php
                    $presidents = PastPresidents::where("status", "active")->orderBy('id','DESC')->get();
                ?>

                <div class="col-md-10">
                    <ul class="list-style">
                        <?php $__currentLoopData = $presidents; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $president): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li class="grid-item col-md-3 col-sm-4 text-center">
                                <div class="team-grid-item format-standard">
                                    <img src="<?php echo $president->presidentsImage; ?>" alt="<?php echo ucwords($president->presidentName); ?>" class="img_icon">
                                    <div class="grid-item-inner">
                                        <h4><?php echo ucwords($president->presidentName); ?></h4>
                                        <span class="meta-data"><?php echo $president->yearRange; ?></span>
                                        <p class="margin-0"><?php echo $president->companyName; ?></p>
                                    </div>
                                </div>
                            </li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('frontend/master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/adclubmadras/public_html/resources/views/frontend/past-presidents.blade.php ENDPATH**/ ?>