<?php

	use App\Models\EventCategories;

?>



<?php $__env->startSection('styles'); ?>

	<?php echo HTML::style('backend/assets/css/jquery-ui.css'); ?>


	<link rel="stylesheet" type="text/css" href="https://cdnjs.cloudflare.com/ajax/libs/jquery-ui-timepicker-addon/1.6.3/jquery-ui-timepicker-addon.min.css">

<?php $__env->stopSection(); ?>

<?php $__env->startSection('maincontent'); ?>

	<!-- BEGIN CONTENT-->

	<div id="content">

		<section>

			<div class="section-header ">

				<ol class="breadcrumb">

					<li class="active">Home</li>

					<li class="active">Events</li>

					<li class="active">Modify Events</li>

				</ol>

			</div>



			<div class="section-body">

				<!-- BEGIN VERTICAL FORM -->

				<?php echo Form::open(["url"=>"admin/events/modify/post/".$event->eventSlug."/".Crypt::encrypt($event->id), "class"=>"form", "files"=>true]); ?>


					<div class="row">

						<div class="col-lg-12">

							<h1 class="text-primary">Modify Events</h1>

						</div><!--end .col -->



						<?php

							$time = [];

							$seconds = 60;

							while($seconds <= 86400){

								$time[$seconds] = gmdate("H:i", $seconds);

								$seconds += 60;

							}

						?>



						<div class="col-md-9">

							<div class="card">

								<div class="card-head style-primary">

									<header>Modify Events</header>

								</div>



								<?php if(Session::has('success')): ?> <?php echo HTML::display_success('success'); ?> <?php endif; ?>

								<?php if(Session::has('error')): ?> <?php echo HTML::display_error('error'); ?> <?php endif; ?>

								<div class="card-body">

									<div class="form-group <?php if($errors->has('eventTitle')): ?>has-error <?php endif; ?>">

										<?php echo Form::text("eventTitle",$event->eventTitle,["class"=>"form-control"]); ?>


											<?php if($errors->has("eventTitle")): ?>

												<span id="eventTitle-error" class="help-block"><?php echo $errors->first("eventTitle"); ?></span>

											<?php endif; ?>

										<?php echo HTML::decode(Form::label("eventTitle","Title <span class='text-danger'>*</span>")); ?>


									</div>



									<div class="form-group <?php if($errors->has('eventDate')): ?>has-error <?php endif; ?>">

										<?php echo Form::text("eventDate",$event->eventDate,["class"=>"form-control", 'id'=>'eventDate']); ?>


											<?php if($errors->has("eventDate")): ?>

												<span id="eventDate-error" class="help-block"><?php echo $errors->first("eventDate"); ?></span>

											<?php endif; ?>

										<?php echo HTML::decode(Form::label("eventDate","Date <span class='text-danger'>*</span>")); ?>


									</div>



									<div class="form-group <?php if($errors->has('eventStartTime')): ?>has-error <?php endif; ?>">

										<?php echo Form::select("eventStartTime",$time,$event->eventTime,["class"=>"form-control","placeholder"=>"Start Time"]); ?>


											<?php if($errors->has("eventStartTime")): ?>

												<span id="eventStartTime-error" class="help-block"><?php echo $errors->first("eventStartTime"); ?></span>

											<?php endif; ?>

										<?php echo HTML::decode(Form::label("eventStartTime","Start Time <span class='text-danger'>*</span>")); ?>


									</div>



									<div class="form-group">

										<?php echo Form::select("eventEndTime",$time,$event->eventEndTime,["class"=>"form-control","placeholder"=>"End Time"]); ?>


										<?php echo HTML::decode(Form::label("eventEndTime","End Time")); ?>


									</div>



									<div class="form-group <?php if($errors->has('reportingTime')): ?>has-error <?php endif; ?>">

										<?php echo Form::select("reportingTime",$time,$event->reportingTime,["class"=>"form-control","placeholder"=>"Time"]); ?>


											<?php if($errors->has("reportingTime")): ?>

												<span id="reportingTime-error" class="help-block"><?php echo $errors->first("reportingTime"); ?></span>

											<?php endif; ?>

										<?php echo HTML::decode(Form::label("reportingTime","Reporting Time <span class='text-danger'></span>")); ?>


									</div>



									<div class="row">

										<div class="col-md-6">

											<div class="form-group <?php if($errors->has('currentPoster')): ?>has-error <?php endif; ?>">

												<?php echo HTML::image($event->eventPoster, $event->eventTitle, ["width"=>100, "height"=>100]); ?>


													

												<?php echo HTML::decode(Form::label("currentPoster","Current Poster <span class='text-danger'></span>")); ?>


											</div>

										</div>



										<div class="col-md-6">

											<div class="form-group <?php if($errors->has('eventPoster')): ?>has-error <?php endif; ?>">

												<?php echo Form::file("eventPoster",["class"=>"form-control"]); ?>


													<?php if($errors->has("eventPoster")): ?>

														<span id="eventPoster-error" class="help-block"><?php echo $errors->first("eventPoster"); ?></span>

													<?php endif; ?>

												<?php echo HTML::decode(Form::label("eventPoster","Event Poster <span class='text-danger'></span>")); ?>


											</div>

										</div>

									</div>



									<div class="form-group <?php if($errors->has('entryType')): ?>has-error <?php endif; ?>">

										<?php echo Form::select("entryType",['general'=> 'General','free' => 'Free', 'paid' => 'Paid'], $event->entryType,["class"=>"form-control","placeholder"=>"Select", 'id' => 'entryType']); ?>


											<?php if($errors->has("entryType")): ?>

												<span id="entryType-error" class="help-block"><?php echo $errors->first("entryType"); ?></span>

											<?php endif; ?>

										<?php echo HTML::decode(Form::label("entryType","Entry Fee Type <span class='text-danger'></span>")); ?>


									</div>



									



									<div id="badmintonandtennisModule" class="sportEventModule" style="display: none;">

										<div class="form-group <?php if($errors->has('typeOfTeam')): ?>has-error <?php endif; ?>">

											<?php echo Form::select("typeOfTeam",['single'=> 'Singles Only','double' => 'Dobles Only', 'both' => 'Both Singles and Doubles'], $event->typeOfTeam,["class"=>"form-control", 'id' => 'typeOfTeam']); ?>


												<?php if($errors->has("typeOfTeam")): ?>

													<span id="typeOfTeam-error" class="help-block"><?php echo $errors->first("typeOfTeam"); ?></span>

												<?php endif; ?>

											<?php echo HTML::decode(Form::label("typeOfTeam","Allow type of team <span class='text-danger'></span>")); ?>


										</div>



										<div class="row">

											<div class="col-md-6 <?php if($errors->has('maxSinglesCount')): ?>has-error <?php endif; ?>">

												<?php echo HTML::decode(Form::label("maxSinglesCount","Maximum singles allowed<span class='text-danger'></span>")); ?>


												<?php echo Form::number("maxSinglesCount", $event->maxSinglesCount,["class"=>"form-control",'id'=>'maxSinglesCount']); ?>


												<em>Maximum player allowed per register</em>

												<?php if($errors->has("maxSinglesCount")): ?>

													<span id="maxSinglesCount-error" class="help-block"><?php echo $errors->first("maxSinglesCount"); ?></span>

												<?php endif; ?>

											</div>



											<div class="col-md-6 <?php if($errors->has('maxDoublesCount')): ?>has-error <?php endif; ?>">

												<?php echo HTML::decode(Form::label("maxDoublesCount","Maximum doubles allowed<span class='text-danger'></span>")); ?>


												<?php echo Form::number("maxDoublesCount", $event->maxDoublesCount,["class"=>"form-control",'id'=>'maxDoublesCount']); ?>


												<em>Maximum team allowed per register</em>

												<?php if($errors->has("maxDoublesCount")): ?>

													<span id="maxDoublesCount-error" class="help-block"><?php echo $errors->first("maxDoublesCount"); ?></span>

												<?php endif; ?>

											</div>



											<div class="col-md-6 <?php if($errors->has('singlesMemberFee')): ?>has-error <?php endif; ?>">

												<?php echo HTML::decode(Form::label("singlesMemberFee","Singes Fee (Member) / per head<span class='text-danger'></span>")); ?>


												<?php echo Form::text("singlesMemberFee", $event->memberFee,["class"=>"form-control",'id'=>'singlesMemberFee']); ?>


												<?php if($errors->has("singlesMemberFee")): ?>

													<span id="singlesMemberFee-error" class="help-block"><?php echo $errors->first("singlesMemberFee"); ?></span>

												<?php endif; ?>

											</div>



											<div class="col-md-6 <?php if($errors->has('singlesNonMemberFee')): ?>has-error <?php endif; ?>">

												<?php echo HTML::decode(Form::label("singlesNonMemberFee","Singles Fee (Non Member)  / per head<span class='text-danger'></span>")); ?>


												<?php echo Form::text("singlesNonMemberFee", $event->nonMemberFee,["class"=>"form-control",'id'=>'singlesNonMemberFee']); ?>


												<?php if($errors->has("singlesNonMemberFee")): ?>

													<span id="singlesNonMemberFee-error" class="help-block"><?php echo $errors->first("singlesNonMemberFee"); ?></span>

												<?php endif; ?>

											</div>



											<div class="col-md-6 <?php if($errors->has('doublesMemberFee')): ?>has-error <?php endif; ?>">

												<?php echo HTML::decode(Form::label("doublesMemberFee","Doubles Fee (Member)  / per team<span class='text-danger'></span>")); ?>


												<?php echo Form::text("doublesMemberFee", $event->doublesMemberFee,["class"=>"form-control",'id'=>'doublesMemberFee']); ?>


												<?php if($errors->has("doublesMemberFee")): ?>

													<span id="doublesMemberFee-error" class="help-block"><?php echo $errors->first("doublesMemberFee"); ?></span>

												<?php endif; ?>

											</div>



											<div class="col-md-6 <?php if($errors->has('doublesNonMemberFee')): ?>has-error <?php endif; ?>">

												<?php echo HTML::decode(Form::label("doublesNonMemberFee","Doubles Fee (Non Member)   / per team<span class='text-danger'></span>")); ?>


												<?php echo Form::text("doublesNonMemberFee", $event->doublesNonMemberFee,["class"=>"form-control",'id'=>'doublesNonMemberFee']); ?>


												<?php if($errors->has("doublesNonMemberFee")): ?>

													<span id="doublesNonMemberFee-error" class="help-block"><?php echo $errors->first("doublesNonMemberFee"); ?></span>

												<?php endif; ?>

											</div>



										</div>



									</div>



									<div id="cricketModule" class="sportEventModule"  style="display: none;">

										<div class="form-group <?php if($errors->has('maximumPlayer')): ?>has-error <?php endif; ?>">

											<?php echo HTML::decode(Form::label("maximumPlayer","Maximum Player / per team<span class='text-danger'></span>")); ?>


											<?php echo Form::number("maximumPlayer", $event->maximumPlayer,["class"=>"form-control",'id'=>'maximumPlayer']); ?>


											<em>Maximum player</em>

											<?php if($errors->has("maximumPlayer")): ?>

												<span id="maximumPlayer-error" class="help-block"><?php echo $errors->first("maximumPlayer"); ?></span>

											<?php endif; ?>

										</div>

									</div>



									<div id="paidEntryFee" style="display: none;">

										<div class="form-group <?php if($errors->has('memberFee')): ?>has-error <?php endif; ?>">

											<?php echo HTML::decode(Form::label("memberFee","Member Fee <span class='text-danger'></span>")); ?>


											<?php echo Form::text("memberFee", $event->memberFee,["class"=>"form-control",'id'=>"memberFee"]); ?>


											<em>Enter fee without GST</em>

											<?php if($errors->has("memberFee")): ?>

												<span id="memberFee-error" class="help-block"><?php echo $errors->first("memberFee"); ?></span>

											<?php endif; ?>

										</div>



										<div class="form-group <?php if($errors->has('nonMemberFee')): ?>has-error <?php endif; ?>">

											<?php echo HTML::decode(Form::label("nonMemberFee","Non-member Fee <span class='text-danger'></span>")); ?>


											<?php echo Form::text("nonMemberFee", $event->nonMemberFee,["class"=>"form-control",'id'=>"nonMemberFee"]); ?>


											<em>Enter fee without GST</em>

											<?php if($errors->has("nonMemberFee")): ?>

												<span id="nonMemberFee-error" class="help-block"><?php echo $errors->first("nonMemberFee"); ?></span>

											<?php endif; ?>

										</div>



										<div class="form-group <?php if($errors->has('memberFeeText')): ?>has-error <?php endif; ?>">

											<?php echo HTML::decode(Form::label("memberFeeText","Entry Fee Text <span class='text-danger'></span>")); ?>


											<?php echo Form::textarea("memberFeeText", $event->memberFeeText,["class"=>"form-control","rows"=>2, "cols"=>2,'id'=>"memberFeeText"]); ?>


											<?php if($errors->has("memberFeeText")): ?>

												<span id="memberFeeText-error" class="help-block"><?php echo $errors->first("memberFeeText"); ?></span>

											<?php endif; ?>

										</div>

									</div>



									



									<div class="form-group <?php if($errors->has('partnerEvent')): ?>has-error <?php endif; ?>">

										<?php echo HTML::decode(Form::label("partnerEvent","Partner Event")); ?>


										<?php echo Form::radio("partnerEvent", 'yes', $event->partner_event == 'yes', ['class' => 'partner_event']); ?>&nbsp;Yes&nbsp;

										<?php echo Form::radio("partnerEvent", 'no', $event->partner_event == 'no', ['class' => 'partner_event']); ?>&nbsp;No&nbsp;

									</div>



									<div class="form-group partnerNameDiv <?php if($errors->has('partnerName')): ?>has-error <?php endif; ?>" style="display: none;">

										<?php echo HTML::decode(Form::label("partnerName","Partner Name <span class='text-danger'></span>")); ?>


										<?php echo Form::text("partnerName", $event->partner_name,["class"=>"form-control"]); ?>


										<?php if($errors->has("partnerName")): ?>

											<span id="partnerName-error" class="help-block"><?php echo $errors->first("partnerName"); ?></span>

										<?php endif; ?>

									</div>



									<div class="form-group <?php if($errors->has('streaming_link')): ?>has-error <?php endif; ?>">

										<?php echo HTML::decode(Form::label("streaming_link","Streaming Link <span class='text-danger'></span>")); ?>


										<?php echo Form::text("streaming_link", $event->streaming_link,["class"=>"form-control"]); ?>


										<?php if($errors->has("streaming_link")): ?>

											<span id="streaming_link-error" class="help-block"><?php echo $errors->first("streaming_link"); ?></span>

										<?php endif; ?>

									</div>



									<div class="form-group <?php if($errors->has('eventVenue')): ?>has-error <?php endif; ?>">

										<?php echo HTML::decode(Form::label("eventVenue","Venue <span class='text-danger'></span>")); ?>


										<?php echo Form::textarea("eventVenue",$event->eventVenue,["class"=>"form-control","rows"=>3, "cols"=>2]); ?>


										<?php if($errors->has("eventVenue")): ?>

											<span id="eventVenue-error" class="help-block"><?php echo $errors->first("eventVenue"); ?></span>

										<?php endif; ?>

									</div>

									<div class="form-group <?php if($errors->has('eventInformation')): ?>has-error <?php endif; ?>">

										<?php echo HTML::decode(Form::label("eventInformation","Event Information <span class='text-danger'></span>")); ?>


										<?php echo Form::textarea("eventInformation",$event->eventInformation,["class"=>"form-control"]); ?>


										<?php if($errors->has("eventInformation")): ?>

											<span id="eventInformation-error" class="help-block"><?php echo $errors->first("eventInformation"); ?></span>

										<?php endif; ?>

									</div>

									<div class="form-group <?php if($errors->has('eventDescription')): ?>has-error <?php endif; ?>">

										<?php echo HTML::decode(Form::label("eventDescription","Terms & Conditions <span class='text-danger'></span>")); ?>


										<?php echo Form::textarea("eventDescription",$event->eventDescription,["class"=>"form-control"]); ?>


										<?php if($errors->has("eventDescription")): ?>

											<span id="eventDescription-error" class="help-block"><?php echo $errors->first("eventDescription"); ?></span>

										<?php endif; ?>

									</div>

								</div><!--end .card-body -->

							</div><!--end .card -->

						</div><!--end .col -->



						<div class="col-md-3">

							<div class="card">

								<div class="card-head style-primary">

									<header>Manage</header>

								</div><!--end .card-head -->



								<div class="publishActions">

									<div class="card-actionbar">

										<div class="card-actionbar-row">

											<?php echo HTML::link("admin/events/get", "Manage Events", ["class"=>"btn ink-reaction btn-block btn-primary"]); ?>


										</div>

									</div>

								</div>

							</div><!--end .card -->



							<div class="card">

								<div class="card-head style-primary">

									<header>Gallery</header>

								</div><!--end .card-head -->



								<div class="publishActions">

									<div class="card-actionbar">

										<div class="card-actionbar-row">

											<?php echo Form::select("gallery",$gallery,$event->gallery,["class"=>"form-control","placeholder"=>"Select Gallery"]); ?>


										</div>

									</div>

								</div>

							</div><!--end .card -->



							<div class="card">

								<div class="card-head style-primary">

									<header>Categories</header>

								</div><!--end .card-head -->



								<div class="card-body small-padding height-8 productCategories">

									<ul data-sortable="true" class="list">

										<?php 

											$categories = EventCategories::where('status', 'active')->get(); 

										?>

										<?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

											<?php

												$checked = "";

												if($category->id == $event->eventCategoryID){

													$checked = "checked='checked'";

												}

											?>

											<li class="tile">

												<div class="radio radio-styled">

													<label>

														<input type="radio" name="eventCategory" value="<?php echo $category->id; ?>" class="eventCategories" <?php echo $checked; ?>>

														<span><?php echo $category->categoryName; ?></span>

													</label>

												</div>

											</li>

										<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!-- 1-->



										<?php if($errors->has("eventCategory")): ?>

											<span id="eventCategory-error" class="help-block"><?php echo $errors->first("eventCategory"); ?></span>

										<?php endif; ?>		

									</ul>

								</div>

							</div><!--end .card -->



							<div class="card">

								<div class="card-head style-primary">

									<header>Publish</header>

								</div><!--end .card-head -->



								<div class="publishActions">

									<div class="card-actionbar">

										<div class="card-actionbar-row">

											<!-- <button class="btn ink-reaction btn-primary">Preview</button> -->

											<button type="submit" id="publishEvent" class="btn ink-reaction btn-primary-dark">Modify Event</button>

										</div>

									</div>

								</div>

							</div><!--end .card -->

						</div>

					</div><!--end .row -->

				<?php echo Form::close(); ?>


				<!-- END VERTICAL FORM -->





				<div class="row">



					

					<div class="col-md-6">

						<div class="card">

							<div class="card">

							<div class="card-head style-primary">

								<header>Add Event Custom Fields</header>

							</div><!--end .card-head -->



							<div class="publishActions">

								<div class="card-actionbar">

									<div class="card-actionbar-row text-left">

										

		                                <div class="card-body">

		                                    <input type="hidden" name="add_type" id="add_type" value="">

		                                    <input type="hidden" name="update_field_id" id="update_field_id" value="">



		                                    <div class="form-group" id="fieldTypeBox">

		                                        <label>Select Field Type <span>*</span></label>

		                                        <select class="form-control" id="fieldType">

		                                            <option value="">--Choose--</option>

		                                            <option value="plain_text">Plain Text</option>

		                                            

		                                            <option value="datepicker">Date Picker</option>

		                                            <option value="dateandtime">Date & Time</option>

		                                            

		                                            <option value="single_file_upload">Single File Upload</option>

		                                            <option value="multiple_file_upload">Multiple File Upload</option>

		                                            

		                                        </select>

		                                    </div>



		                                    <div class="bx-2 mb-2">

		                                        <div class="form-group" id="labelBox">

		                                            <label>Label <span>*</span></label>

		                                            <input class="form-control" type="text" id="labelName" placeholder="enter label name">

		                                        </div>



		                                        <div class="form-group" id="propertyBox" style="display: none;">

		                                            <label>Options <span>*</span></label>

		                                            <ul id="sortable">

		                                              

		                                            </ul>

		                                            <div class="input-group mb-3">

		                                              <input type="text" class="form-control" placeholder="add new option" id="addOption">

		                                              <div class="input-group-append">

		                                                <a href="javascript:;" id="addOptionBtn" class="btn btn-primary">Add</a>

		                                              </div>

		                                            </div> 



		                                        </div>

		                                    </div>

		                                    <input type="hidden" value="12" id="field_column_length">

		                                    



		                                    



		                                    <div class="form-group">

		                                        <a href="javascript:;" id="addCustomField" class="btn btn-sm btn-primary">Add</a> &nbsp;

		                                        <a href="javascript:;" id="cancelCustomField" class="btn btn-sm btn-default">Cancel</a>

		                                        <div id="error_msg"></div>

		                                    </div>



		                                </div>

		                                

									</div>

								</div>

							</div>

						</div><!--end .card -->

						</div>

					</div>



					<div class="col-md-6">

						<div class="card">

							<div class="card-head style-primary">

								<header>Custom Fields Data</header>

							</div>

							<div class="card-body">

								<form method="post" class="form" id="customEventDataForm" enctype="multipart/form-data">

									<div id="eventCustomFieldsDataBox">

										

									</div>

								</form>

							</div><!--end .card-body -->

						</div><!--end .card -->

					</div><!--end .col -->



				</div><!--end .row -->



				

				





				<div class="row">

					<div class="col-md-6">

						<div class="card">

							<div class="card">

							<div class="card-head style-primary">

								<header>Add Event Register Form</header>

							</div><!--end .card-head -->



							<div class="publishActions">

								<div class="card-actionbar">

									<div class="card-actionbar-row">

										

		                                <div class="card-body">

		                                    <div class="form-group" id="R_fieldTypeBox">

		                                        <label>Select Field Type <span>*</span></label>

		                                        <select class="form-control" id="R_fieldType">

		                                            <option value="">--Choose--</option>

		                                            <option value="plain_text">Plain Text</option>

		                                            <option value="text_area">Textarea</option>

		                                            <option value="datepicker">Date Picker</option>

		                                            <option value="dateandtime">Date & Time</option>

		                                            

		                                            <option value="single_file_upload">Single File Upload</option>

		                                            <option value="multiple_file_upload">Multiple File Upload</option>

		                                            <option value="dropdown">Dropdown</option>

		                                            <option value="checkbox">Checkbox</option>

		                                            <option value="radio">Radio</option>

		                                            <option value="phonenumber">Phone</option>

		                                            <option value="numbers">Number</option>

		                                            <option value="amount">Amount</option>

		                                            <option value="email">Email</option>

		                                        </select>

		                                    </div>



		                                    <div class="bx-2 mb-2">

		                                        <div class="form-group" id="R_labelBox">

		                                            <label>Label <span>*</span></label>

		                                            <input class="form-control" type="text" id="R_labelName" placeholder="enter label name">

		                                        </div>



		                                        <div class="form-group" id="R_propertyBox" style="display: none;">

		                                            <label>Options <span>*</span></label>

		                                            <ul id="R_sortable">

		                                              

		                                            </ul>

		                                            <div class="input-group mb-3">

		                                              <input type="text" class="form-control" placeholder="add new option" id="R_addOption">

		                                              <div class="input-group-append">

		                                                <a href="javascript:;" id="R_addOptionBtn" class="btn btn-primary">Add</a>

		                                              </div>

		                                            </div> 



		                                        </div>

		                                    </div>

		                                    <input type="hidden" value="12" id="R_field_column_length">

		                                    

		                                    <div class="form-group">

		                                        <label class="checkbox checkbox-primary">

		                                            <input type="checkbox" id="R_is_required"><span>&nbsp;&nbsp;Required Field?</span><span class="checkmark"></span>

		                                        </label>

		                                    </div>



		                                    <div class="form-group">

		                                        <a href="javascript:;" id="R_addCustomField" class="btn btn-sm btn-primary">Add</a> &nbsp;

		                                        <a href="javascript:;" id="R_cancelCustomField" class="btn btn-sm btn-default">Cancel</a>

		                                        <div id="error_msg"></div>

		                                    </div>



		                                </div>

		                                

									</div>

								</div>

							</div>

						</div><!--end .card -->

						</div>

					</div>



					<div class="col-md-6">

						<div class="card">

							<div class="card-head style-primary">

								<header>Register Form Preview</header>

							</div>



							<div class="card-body">

								<form method="post" class="form" id="R_customEventDataForm" enctype="multipart/form-data">

									<div id="R_eventCustomFieldsDataBox" class="customFormfields">

										

									</div>

								</form>

							</div><!--end .card-body -->

						</div><!--end .card -->

					</div><!--end .col -->



				</div><!--end .row -->





			</div>

		</section>

	</div><!--end #content-->

	<input type="hidden" name="" id="eventId" value="<?php echo e(Crypt::encrypt($event->id)); ?>">

	<!-- END CONTENT -->

<?php $__env->stopSection(); ?>



<?php $__env->startSection("script"); ?>

	<?php echo HTML::script('backend/assets/js/jquery-ui.js'); ?>


	<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-ui-timepicker-addon/1.6.3/jquery-ui-timepicker-addon.min.js"></script>

	<?php echo HTML::script('backend/ckeditor/ckeditor.js'); ?>


	<script type="text/javascript">

	    $(document).ready(function(){

	      	CKEDITOR.replace('eventDescription');
	      	CKEDITOR.replace('eventInformation');

	      	$("select").select2();

	      	$("#eventDate").datepicker({

		      	changeMonth: false,

		      	dateFormat:'yy-mm-dd',

		      	numberOfMonths: 1

		    });

	    });



	    $(document).on("click", "#publishEvent", function(){

			if(!$("input[name='eventCategory']").is(':checked')){

                swal("Please Select", "Please select event category", "info");

                return false;

            }

            var e_type = $('#entryType').val();

			var m_type = $('#sportEvent').val();



            if(e_type == ''){

            	swal("Please Select", "Entry fee type required", "info");

            	return false;

			}

			if(m_type == ''){

				swal("Please Select", "Is sport required", "info");

            	return false;

			}

			if(m_type == 'badminton' || m_type == 'tennis'){

				if(e_type == 'paid'){

					if($('#maxSinglesCount').val() == '' || !$.isNumeric($('#maxSinglesCount').val())) {

						swal("Please Select", "Maximum singles allowed required", "info");

            			return false;

					}

					if($('#maxDoublesCount').val() == '' || !$.isNumeric($('#maxDoublesCount').val())) {

						swal("Please Select", "Maximum doubles team allowed required", "info");

            			return false;

					}

					if($('#singlesMemberFee').val() == '' || !$.isNumeric($('#singlesMemberFee').val())) {

						swal("Please Select", "Singles member fee required", "info");

            			return false;

					}

					if($('#singlesNonMemberFee').val() == '' || !$.isNumeric($('#singlesNonMemberFee').val())) {

						swal("Please Select", "Singles non-member fee required", "info");

            			return false;

					}

					if($('#doublesMemberFee').val() == '' || !$.isNumeric($('#doublesMemberFee').val())) {

						swal("Please Select", "Doubles member fee required", "info");

            			return false;

					}

					if($('#doublesNonMemberFee').val() == '' || !$.isNumeric($('#doublesNonMemberFee').val())) {

						swal("Please Select", "Doubles non-member fee required", "info");

            			return false;

					}

				}

			}else if(m_type == 'cricket'){

				if(e_type == 'paid'){

					if($('#memberFee').val() == '' || !$.isNumeric($('#memberFee').val())) {

						swal("Please Select", "Member fee required", "info");

            			return false;

					}

					if($('#nonMemberFee').val() == '' || !$.isNumeric($('#nonMemberFee').val())) {

						swal("Please Select", "Non-member fee required", "info");

            			return false;

					}

				}

			}else if(m_type == 'no'){

				if(e_type == 'paid'){

					if($('#memberFee').val() == '' || !$.isNumeric($('#memberFee').val())) {

						swal("Please Select", "Member fee required", "info");

            			return false;

					}

					if($('#nonMemberFee').val() == '' || !$.isNumeric($('#nonMemberFee').val())) {

						swal("Please Select", "Non-member fee required", "info");

            			return false;

					}

				}

			}

		});



		function sportEventModule() {

			var e_type = $('#entryType').val();

			$('#paidEntryFee').hide();

			$('.sportEventModule').hide();

			var m_type = $('#sportEvent').val();

			if(m_type == 'badminton' || m_type == 'tennis'){

				$('#badmintonandtennisModule').show();

			}else if(m_type == 'cricket'){

				$('#cricketModule').show();	

				if(e_type == 'paid'){

					$('#paidEntryFee').show();

				}

			}else if(m_type == 'no'){

				if(e_type == 'paid'){

					$('#paidEntryFee').show();	

				}

			}

		}



		$(document).on('change', '#entryType', function(){

			sportEventModule();

			return false;

		});



		$(document).on('change', '#sportEvent', function(){

			sportEventModule();

			return false;

		});



		sportEventModule();

		partnerevent();



		$(document).on('click', '.partner_event', function(){

			partnerevent();

		});



		function partnerevent(){

			var partner_event = $("input[name='partnerEvent']:checked").val();

			if(partner_event == 'yes'){

				$('.partnerNameDiv').show();

			}else{

				$('.partnerNameDiv').hide();

			}

		}





	    //========================Custom Event Info Related Script========================

			$('#addCustomField').on('click', function(){

	            var t = $(this);

	            var field_type = $('#fieldType').val();

	            var label_name = $('#labelName').val();

	            var field_column_length = $('#field_column_length').val();

	            if(field_type == ''){ swal("Validation", "Field type required", "info"); return false; }

	            if(label_name == ''){ swal("Validation", "Label name required", "info"); return false; }

	            is_required = 'no';

	            // if($('#is_required').prop('checked') == true){

	            //     is_required = 'yes';

	            // }

	            datas = { field_type:field_type,label_name:label_name,is_required:is_required,field_column_length:field_column_length,event_id: $('#eventId').val() };

	            t.text('Processing...').attr('disabled', true);

	            $.ajax({

	                url: '/admin/events/modify/customfields/add',

	                headers: { 'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content'), },

	                data: datas,

	                dataType: 'json',

	                type: 'POST',

	                success: function(res){

	                	t.text('Add').attr('disabled', false);

	                    if(res.status == 'success'){

	                    	geteventcustomfields();

							swal("Success!", "New field added", "success");

	                    }else{

	                        swal("Error", res.msg, "error");

	                    }

	                    return false;

	                }, error: function(e){

	                    

	                    alert(e.responseText);

	                    return false;

	                }

	            });

	        });

			geteventcustomfields();



			function geteventcustomfields() {

				$('#eventCustomFieldsDataBox').html('<b>Fetching...</b>');

				$.ajax({

	                url: '/admin/events/modify/customfields/gettemplate',

	                headers: { 'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content'), },

	                data: { event_id: $('#eventId').val() },

	                dataType: 'json',

	                type: 'POST',

	                success: function(res){

	                    if(res.status == 'success'){

	                    	$('#eventCustomFieldsDataBox').html(res.template);

	                    	$(".custom_fields_date").datepicker({

						      	dateFormat:'yy-mm-dd',

						    });

						    $(".custom_fields_datetime").datetimepicker({

						      	dateFormat:'yy-mm-dd', 

						      	timeFormat: 'h:mm',

						    });



						    $('#eventCustomFieldsDataBox #sortable').sortable({

						        update: function(event, ui) {

						            $('#sortable li').removeClass('highlights');

						            pos = [];

						            $( "#eventCustomFieldsDataBox #sortable li" ).each(function( index ) {

									  var id = $(this).attr('data-id');

									  if(id != undefined){

									  	pos.push(id);

									  }

									});

									setTimeout(function() {  updateeventcustomfieldssort(pos);     }, 500);

						        }

						    });





	                    }else{

	                        swal("Error", "Fetching event field template", "error");

	                    }

	                    return false;

	                }, error: function(e){

	                     swal("Error", "Fetching event field template", "error");

	                    return false;

	                }

	            });

			}



			$('#customEventDataForm').submit(function(e) {

			     e.preventDefault();

			       var t = $('#customEventDataBtn'); $('.validate').remove(); $('.smsg').remove();

			        var txt = t.text();

			        t.text('Processing...').attr('disabled', true);

			        let formData = new FormData(this);

			        $.ajax({

			            contentType: false,

			            processData: false,

			            url: '/admin/events/modify/customfields/updatedata',

			            headers: { 'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content'), },

			            data: formData,

			            dataType: 'json',

			            type: 'POST',

			            success: function(res){

			                t.text(txt).attr('disabled', false);

			                $('.validate').remove();

			                if(res.status == 'validation'){

			                    $.each(res.validation, function(k,v){

			                    	k = k.split('.')[0];

			                        $('#'+k).after('<span class="validate" style="color:red;">'+v+'</span>');

			                    });

			                }else if(res.status == 'success'){

			                	swal("Success!", "Field data updated", "success");

			                    geteventcustomfields();

			                }else{

			                    toastr.error(res.msg);

			                }

			                return false;

			            }, error: function(e){

			                t.text(txt).attr('disabled', false);

			                toastr.error('Error. Please try again');

			                return false;

			            }

			        });

			});



			$(document).on("click",".removeCustomFieldFile",function() {

				var t = $(this);

				swal({

				        title: "Are you sure?",

				        text: "You will not be able to recover this file!",

				        type: "warning",

				        showCancelButton: true,

				        confirmButtonColor: "#DD6B55",

				        confirmButtonText: "Yes, delete it!",

				        cancelButtonText: "No, cancel!",

				        closeOnConfirm: false,

				        closeOnCancel: false 

				    },

				    function(isConfirm) {

				        if (isConfirm) {

					            $('.removeFile').remove();

					            var field = t.attr('data-field');

					            var id = t.attr('data-id');

					            datas = { field:field,id:id,event_id: $('#eventId').val() };

					            t.after('<span class="removeFile" style="color:red">Processing....</span>');

					            $.ajax({

					                url: '/admin/events/modify/customfields/file/remove',

					                headers: { 'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content'), },

					                data: datas,

					                dataType: 'json',

					                type: 'POST',

					                success: function(res){

					                	$('.removeFile').remove();

					                    if(res.status == 'success'){

					                    	geteventcustomfields();

											swal("Success!", "File removed", "success");

					                    }else{

					                        swal("Error", res.msg, "error");

					                    }

					                    return false;

					                }, error: function(e){

					                	swal.close();

					                	$('.removeFile').remove();

					                    alert(e.responseText);

					                    return false;

					                }

					            });



				        } else {

				            swal("Cancelled", "File is safe :)", "error");

				        }

				    }

				);

	        });



	        $(document).on("click",".removeCustomField",function() {

				var t = $(this);

				swal({

				        title: "Are you sure?",

				        text: "Do you want to remove this field?",

				        type: "warning",

				        showCancelButton: true,

				        confirmButtonColor: "#DD6B55",

				        confirmButtonText: "Yes, remove it!",

				        cancelButtonText: "No, cancel!",

				        closeOnConfirm: false,

				        closeOnCancel: false 

				    },

				    function(isConfirm) {

				        if (isConfirm) {

					            $('.removeFile').remove();

					            var id = t.attr('data-id');

					            datas = { id:id,event_id: $('#eventId').val() };

					            t.after('<span class="removeFile" style="color:red">Processing....</span>');

					            $.ajax({

					                url: '/admin/events/modify/customfields/remove',

					                headers: { 'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content'), },

					                data: datas,

					                dataType: 'json',

					                type: 'POST',

					                success: function(res){

					                	$('.removeFile').remove();

					                    if(res.status == 'success'){

					                    	geteventcustomfields();

											swal("Success!", "Field removed", "success");

					                    }else{

					                        swal("Error", res.msg, "error");

					                    }

					                    return false;

					                }, error: function(e){

					                	$('.removeFile').remove();

					                	swal.close();

					                    alert(e.responseText);

					                    return false;

					                }

					            });



				        } else {

				            swal("Cancelled", "File is safe :)", "error");

				        }

				    }

				);

	        });



	        function updateeventcustomfieldssort(pos) {

	        	$.ajax({

		            url: '/admin/events/modify/customfields/sorting',

		            headers: { 'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content'), },

		            data: { pos:pos,event_id: $('#eventId').val() },

		            dataType: 'json',

		            type: 'POST',

		            success: function(res){

		            	if(res.status == 'success'){

		                	swal("Success!", "Field sorting updated", "success");

		                    geteventcustomfields();

		                }else{

		                    toastr.error(res.msg);

		                }

		                return false;

		            }, error: function(e){

		                t.text(txt).attr('disabled', false);

		                toastr.error('Error. Please try again');

		                return false;

		            }

		        });

	        }

        //========================Custom Event Info Related Script========================



        //========================Custom Event Register Related Script========================

	        $('#R_fieldType').on('change', function(){

	            $('#R_labelBox').hide();

	            $('#R_propertyBox').hide();

	            var tval = $(this).val();

	            if(tval == ''){

	                return false;

	            }

	            if(tval == 'dropdown' || tval == 'checkbox' || tval == 'radio'){

	                $('#R_labelBox').show();

	                $('#R_propertyBox').show();

	            }else{

	                $('#R_labelBox').show();

	            }

	        });



	        $('#R_addOptionBtn').on('click', function(){

	            var v = $('#R_addOption').val();

	            if($.trim(v) == '' || v == undefined){

	                $('#R_addOption').focus();

	                return false;

	            }

	            $('#R_sortable').append('<li class="ui-state-default R_option_field_txt">'+$.trim(v)+' <span class="R_removeOption" style="color:red;"><i class="fa fa-trash font-weight-bold"></i></span></li>');

	            $('#R_addOption').val('');

	        });



	        $("#R_sortable").sortable({

	            revert: false,

	        });



	        $(document).on('click', '.R_removeOption', function(){

	            $(this).closest('li').remove();

	        });



	        $('#R_addCustomField').on('click', function(){

	            var t = $(this);

	            var field_type = $('#R_fieldType').val();

	            var label_name = $('#R_labelName').val();

	            var field_column_length = $('#R_field_column_length').val();

	            if(field_type == ''){ swal("Validation", "Field type required", "info"); return false; }

	            if(label_name == ''){ swal("Validation", "Label name required", "info"); return false; }

	            is_required = 'no';

	            if($('#R_is_required').prop('checked') == true){

	                is_required = 'yes';

	            }

	            var options = [];

	            if(field_type == 'dropdown' || field_type == 'checkbox' || field_type == 'radio'){

	                $('.R_option_field_txt').each(function(){

	                    options.push($(this).text());

	                });

	                if(options.length == 0){ $('#R_addOption').focus(); return false; }

	            }

	            options = JSON.stringify(options);

	            datas = { field_type:field_type,label_name:label_name,is_required:is_required,options:options,field_column_length:field_column_length,event_id: $('#eventId').val() };

	            t.text('Processing...').attr('disabled', true);

	            $.ajax({

	                url: '/admin/events/modify/customfields/reg/add',

	                headers: { 'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content'), },

	                data: datas,

	                dataType: 'json',

	                type: 'POST',

	                success: function(res){

	                	t.text('Add').attr('disabled', false);

	                    if(res.status == 'success'){

	                    	geteventregistercustomfields();

							swal("Success!", "New field added", "success");

	                    }else{

	                        swal("Error", res.msg, "error");

	                    }

	                    return false;

	                }, error: function(e){

	                    t.text('Add').attr('disabled', false);

	                    alert(e.responseText);

	                    return false;

	                }

	            });

	        });



	        geteventregistercustomfields();



			function geteventregistercustomfields() {

				$('#R_eventCustomFieldsDataBox').html('<b>Fetching...</b>');

				$.ajax({

	                url: '/admin/events/modify/customfields/reg/gettemplate',

	                headers: { 'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content'), },

	                data: { event_id: $('#eventId').val() },

	                dataType: 'json',

	                type: 'POST',

	                success: function(res){

	                    if(res.status == 'success'){

	                    	$('#R_eventCustomFieldsDataBox').html(res.template);

	                    	$(".R_custom_fields_date").datepicker({

						      	dateFormat:'yy-mm-dd',

						    });

						    $(".R_custom_fields_datetime").datetimepicker({

						      	dateFormat:'yy-mm-dd', 

						      	timeFormat: 'h:mm',

						    });



						    $('#R_eventCustomFieldsDataBox #Reg_sortable').sortable({

						        update: function(event, ui) {

						            $('#Reg_sortable li').removeClass('highlights');

						            pos = [];

						            $( "#R_eventCustomFieldsDataBox #Reg_sortable li" ).each(function( index ) {

									  var id = $(this).attr('data-id');

									  if(id != undefined){

									  	pos.push(id);

									  }

									});

									setTimeout(function() {  updateeventregistercustomfieldssort(pos);     }, 500);

						        }

						    });

	                    }else{

	                        swal("Error", "Fetching event field template", "error");

	                    }

	                    return false;

	                }, error: function(e){

	                     swal("Error", "Fetching event field template", "error");

	                    return false;

	                }

	            });

			}



			function updateeventregistercustomfieldssort(pos) {

	        	$.ajax({

		            url: '/admin/events/modify/customfields/sorting/reg',

		            headers: { 'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content'), },

		            data: { pos:pos,event_id: $('#eventId').val() },

		            dataType: 'json',

		            type: 'POST',

		            success: function(res){

		            	if(res.status == 'success'){

		                	swal("Success!", "Field sorting updated", "success");

		                    geteventregistercustomfields();

		                }else{

		                    toastr.error(res.msg);

		                }

		                return false;

		            }, error: function(e){

		                t.text(txt).attr('disabled', false);

		                toastr.error('Error. Please try again');

		                return false;

		            }

		        });

	        }



	         $(document).on("click",".R_removeCustomField",function() {

				var t = $(this);

				swal({

				        title: "Are you sure?",

				        text: "Do you want to remove this field?",

				        type: "warning",

				        showCancelButton: true,

				        confirmButtonColor: "#DD6B55",

				        confirmButtonText: "Yes, remove it!",

				        cancelButtonText: "No, cancel!",

				        closeOnConfirm: false,

				        closeOnCancel: false 

				    },

				    function(isConfirm) {

				        if (isConfirm) {

					            $('.removeFile').remove();

					            var id = t.attr('data-id');

					            datas = { id:id,event_id: $('#eventId').val() };

					            t.after('<span class="removeFile" style="color:red">Processing....</span>');

					            $.ajax({

					                url: '/admin/events/modify/customfields/remove/reg',

					                headers: { 'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content'), },

					                data: datas,

					                dataType: 'json',

					                type: 'POST',

					                success: function(res){

					                	$('.removeFile').remove();

					                    if(res.status == 'success'){

					                    	geteventregistercustomfields();

											swal("Success!", "Field removed", "success");

					                    }else{

					                        swal("Error", res.msg, "error");

					                    }

					                    return false;

					                }, error: function(e){

					                	$('.removeFile').remove();

					                	swal.close();

					                    alert(e.responseText);

					                    return false;

					                }

					            });



				        } else {

				            swal("Cancelled", "File is safe :)", "error");

				        }

				    }

				);

	        });



        //========================Custom Event Register Related Script========================

	</script>

<?php $__env->stopSection(); ?>
<?php echo $__env->make("backend/master", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/adclubmadras/public_html/resources/views/backend/events/modifyEvent.blade.php ENDPATH**/ ?>