<?php



namespace App\Http\Controllers;

use App\Http\Controllers\Input;

use Illuminate\Contracts\Filesystem\Filesystem;

use Illuminate\Support\Facades\Auth;

use Illuminate\Support\Facades\Hash;

use Illuminate\Support\Facades\Storage;

use Illuminate\Support\Facades\File;

use Illuminate\Support\Facades\URL;

use Illuminate\Support\Str;

use Illuminate\Support\Facades\Mail;

use Illuminate\Http\Request;

use App\Models\User;

use App\Models\Usergroup;

use App\Models\Location;

use App\Models\Option;

use App\Models\Upload;

use App\Libraries\UploadHandler;

use App\Models\Invoice;

use App\Models\Subscriptions;

use App\Models\Emailtemplates;

use App\Models\News;

use App\Models\NewsCategories;

use App\Models\NewsMeta;

use App\Models\CustomPages;

use App\Models\Testimonials;

use App\Models\FAQ;

use App\Models\State;

use App\Models\NewsletterGroup;

use App\Models\SubscribersMeta; 

use App\Models\Subscribers;

use App\Models\Newsletters;

use App\Models\Downloads;

use App\Models\FAQMeta;  

use App\Models\Adminmenu;

use App\Models\TrackingReports;

use App\Models\Adminmenumanage;

use App\Models\PastPresidents;

use App\Models\Faculties;

use App\Models\CourseApplied;

use App\Models\ExecutiveCommitteeMembers;

use App\Models\Members;

use App\Models\EventCategories;

use App\Models\Events;

use App\Models\GalleryCategories;

use App\Models\Gallery;

use App\Models\Jobopportunities;

use App\Models\Customfield;

use App\Models\Customfieldmeta;

use App\Models\Usergroupmeta;

use App\Models\Productdetails;



use Response;

use DateTime;

use Crypt;

use Validator;

use Redirect;

use Session;

use Excel;

use DB;



class AdminController extends Controller

{

    //login

    public function loginget(){

    	return view("backend/login");

    }



    public function loginpost(Request $req){

    	$input = $req->input();

    	$rules = [

    		"userName"=>"required",

    		"password"=>"required"

    	];

    	$validation = Validator::make($input, $rules);

    	if($validation->fails()){

    		return redirect()->back()->withErrors($validation)->withInput();

    	}



    	if(Auth::attempt(['email' => $input['userName'], 'password' => $input['password'], 'status' => 'active']) || Auth::attempt(['userName' => $input['userName'], 'password' => $input['password'], 'status' => 'active'])){

		    $user = User::find(Auth::user()->id);

		    $user->lastLogin = date("Y-m-d h:i:s");

		    $user->ipAddress = $_SERVER['REMOTE_ADDR'];

		    $user->save();

		    $con = Auth::User()->userName.' has logged in from this ip '.$_SERVER['REMOTE_ADDR'];

        	TrackingReports::track('login', $con, '', 0, 'login');

		    return redirect()->intended('admin');

		}

    	return redirect()->back()->with('error','Please enter correct email & password.');

    }



    public function logoutpost(){

    	$con = Auth::user()->userName.' has logged out at '.date("H:i:s");

    	TrackingReports::track('logout', $con, '', '', 'logout');

    	Auth::logout();

    	Session::flush();

    	return redirect("admin/acm/console/login");

    }



    //Change Password

    public function getchangepassword(){

		return view("backend/users/changePassword");

	}



	public function postchangepassword(Request $req){

		$input = $req->input();

		$rules = array(

			'currentPassword'=>'required',

			'newPassword' => 'required|min:6|max:15',

			'confirmPassword' => 'required|min:6|max:15|same:newPassword'

		); 

		$validation = Validator::make($input, $rules);

		if($validation->fails()){

			return Redirect('admin/users/change/password')->withErrors($validation)->withInput();

		}

		   

		$currentpassword = $input['currentPassword'];

		$currentpassword1 = Auth::User()->password;

		if(Hash::check($currentpassword,$currentpassword1)){

			$update=User::find(Auth::user()->id);

			$newpassword=Hash::make($input['newPassword']);

			$update->password=$newpassword;

			if($update->save()){

				return Redirect::to('admin/users/change/password')->with('success','Password changed successfully');

			}

		}

		return Redirect::to('admin/users/change/password')->with('error','Your current password was wrong');

	}



	public function regeneratepassword(Request $req){

		$id = $req->input("id");

		$update = User::find($id);

		$newpassword = Str::random(8);

		$hash = Hash::make($newpassword);

		$update->password = $hash;

		if($update->save()){

			Mail::send('emails/regeneratePassword',array('username'=>$update->userName,'password'=>$newpassword),function($message) use ($update) {

            	$message->from(Option::getvalue('senderEmail') , Option::getvalue('senderName'));

            	$message->to($update->email,$update->name)->subject(Option::getvalue('portalName').' new password!');    

          	});

            return Response::json(['status'=>'success', "msg"=>"Password regenerated successfully"]);

		}

		return Response::json(['status'=>'error']);

	}



	public function index(){

		return view('backend/index');

	}



	public function admin(){

		return view('backend/admin');

	}



	//Users

	public function usersget(){

		$users = User::where("status", "!=", "deleted")->where("userGroup", "!=", 0)->get();

		return view("backend/users/users")->with("users",$users);

	}



	public function addusersget(){

		$usergroup = Usergroup::where('status','active')->pluck('name','id');

		return view("backend/users/AddUser")->with('usergroup',$usergroup);

	}



	public function statelists(Request $req){

		$input = $req->input('id');

		$states = Location::where("status","active")->where("locationType",1)->where("parentId",$input)->pluck("name","id");

		return Response::json(["status"=>"success","states"=>$states,"count"=>count($states)]);

	}



	public function adduserspost(Request $req){

		$input = $req->input();

		$rules = [

			"firstName"=>"required",

			"lastName"=>"required",

			"userName"=>"required|unique:users,userName",

			"email"=>"required|email|unique:users,email,NULL,id,status,active",

			"userGroup"=>"required"

		];

		$validation = Validator::make($input, $rules);

		if($validation->fails()){

			return redirect("admin/users/add")->withErrors($validation)->withInput();

		}

		$password = Str::random(8);

		$insert = new User();

		$insert->firstName = $input["firstName"];

		$insert->lastName = $input["lastName"];

		$insert->userName = $input["userName"];

		$insert->email = $input["email"];

		$insert->password = Hash::make($password);

		$insert->address = $input["address"];

		$insert->country = $input["country"];

		$insert->state = $input["state"];

		$insert->phone = $input["phone"];

		$insert->city = $input["city"];

		$insert->pincode = $input["pincode"];

		$insert->userGroup = $input["userGroup"];

		$insert->status = "active";

		if($insert->save()){

			Mail::send("emails/adminCredentials",["userName"=>$input["userName"],"email"=>$input["email"],"password"=>$password],function($message) use ($input){

				$message->from(Option::getvalue("senderEmail"), Option::getvalue("senderName"));

		        $message->to($input['email'], $input['userName'])

		        ->subject('Admin Access Credential');

			});

		}

		return redirect("admin/users/add")->with("success","New user created successfully");

	}



	public function modifyusersget($id){

		$user=User::find($id);

		$usergroup=Usergroup::where('status','active')->pluck('name','id');

		$states=Location::where("status","active")->where("locationType",1)->where("parentId",$user->country)->pluck("name","id");

		return view("backend/users/modifyUser")->with(["user"=>$user,"states"=>$states,'usergroup'=>$usergroup]);

	}



	public function modifyuserspost(Request $req, $id){

		$input=$req->input();

		$rules=["firstName"=>"required","lastName"=>"required","userName"=>"required","email"=>"required|email|unique:users,email,".$id,"userGroup"=>"required"];

		$validation=Validator::make($input,$rules);

		if($validation->fails()){

			return redirect("admin/users/modify/".$id)->withErrors($validation)->withInput();

		}

		$insert=User::find($id);

		$insert->firstName=$input["firstName"];

		$insert->lastName=$input["lastName"];

		$insert->userName=$input["userName"];

		$insert->email=$input["email"];

		$insert->address=$input["address"];

		$insert->country=$input["country"];

		$insert->state=$input["state"];

		$insert->phone=$input["phone"];

		$insert->city=$input["city"];

		$insert->pincode=$input["pincode"];

		$insert->userGroup=$input["userGroup"];

		$insert->status="active";

		$insert->save();

		return redirect("admin/users/modify/".$id)->with("success","User details have been updated successfully");

	}



	public function statususerspost(Request $req){

		$input=$req->input('id');

		$users=User::find($input);

		$status=$users->status=="active"?$current="inactive":$current="active";

		$users->status=$current;

		$users->save();

		return Response::json(["status"=>"success","current"=>ucfirst($current),"msg"=>"Updated Successfully"]);

	}



	public function deleteuserspost(Request $req){

		$input=$req->input('id');

		$users=User::find($input);

		$users->status="deleted";

		$users->save();

		return Response::json(["status"=>"success","msg"=>"Deleted Successfully"]);

	}



	// Settings

	public function generalsettingsget(){

		return view("backend/settings/generalSettings");

	}



	public function mailsettingsget(){

		return view("backend/settings/mailSettings");

	}



	public function getsystemsettings(){

		return view("backend/settings/systemSettings");

	}



	public function designsget(){

		return view("backend/settings/designs");

	}



	public function storesettingsget(){

		return view("backend/settings/storeSettings");

	}



	public function postsystemsettings(Request $req){

		$input=$req->input("keyVal");

		$check=Option::where("key",$input)->get();

		if(count($check)==1){

			$check[0]->value=="inactive"?$current="active":$current="inactive";

			$update = Option::where('key',$input)->update(array('value'=>$current)); 

			return Response::json(["status"=>"success","name"=>$input,"val"=>ucfirst($current),"msg"=>"Updated successfully"]);

		}

		else{

			$in = new Option; 

			$in->key=$input; 

			$in->value="active"; 

			$in->timestamps=false; 

			$in->save();

			return Response::json(["status"=>"success","name"=>$input,"val"=>ucfirst($in->$v),"msg"=>"Updated successfully"]); 

		}

	}



	public function settingspost(Request $req){

		$input=$req->input();

		array_shift($input);

		foreach($input as $key => $value)

		{

			if($key=="emailNotification" || $key=="senderEmail" || $key=="smtpEmail"){

				$rules[$key] = 'required|email';

			}

			elseif($key=="smsNotification"){

				$rules[$key] = 'required|numeric:min:';

			}

			else{

				$rules[$key] = 'required';

			}

			

		}

		$validator = Validator::make($input, $rules);

		if($validator->fails()){

			return redirect()->back()->withErrors($validator)->withInput();

		}

		

		foreach($input as $key => $value)

		{

			$op = Option::where('key',$key)->count();

			if($op == 1) 

			{ 

				$update = Option::where('key',$key)->update(array('value'=>$value)); 

			} 

			else 

			{ 

				$k = 'key'; $v = 'value'; 

				$in = new Option; 

				$in->$k=$key; 

				$in->$v=$value; 

				$in->timestamps=false; 

				$in->save(); 

			}

		}

		return redirect()->back()->withInput()->with('success','Updated Successfully');

	}



	public function testmailpost(Request $req){

		$input=$req->input();

		Mail::send([],[],function($message)  use ($input){

	        $message->from(Option::getvalue("senderEmail"), Option::getvalue("senderName"));

	        $message->to($input['testEmail'], "Testing Mail")

	        ->subject(Option::getvalue("portalName").' Test Mail')

	        ->setBody("It works my friend, then what are you waiting for? just go ahead!!");

	    });

		return redirect()->back()->withSuccess("Your mail sent successfully");

	}



	public function designspost(Request $req){

		$input=$req->input();

		array_shift($input);

		

		foreach($input as $key => $value)

		{

			$op = Option::where('key',$key)->count();

			if($op == 1) 

			{ 

				$update = Option::where('key',$key)->update(array('value'=>$value)); 

			} 

			else 

			{ 

				$k = 'key'; $v = 'value'; 

				$in = new Option; 

				$in->$k=$key; 

				$in->$v=$value; 

				$in->timestamps=false; 

				$in->save(); 

			}

		}

		return redirect('admin/tools/designs')->with('success','Updated Successfully');

	}



	public function uploadFiles(){

 

        $input = Input::all();

 

        $rules = array(

            'file' => 'image|max:3000',

        );

 

        $validation = Validator::make($input, $rules);

 

        if ($validation->fails()) {

            return Response::make($validation->errors->first(), 400);

        }

 

        $destinationPath = 'backend/uploads/designs'; // upload path

        $extension = Input::file('file')->getClientOriginalExtension(); // getting file extension

        $fileName = rand(11111, 99999) . '.' . $extension; // renameing image

        $upload_success = Input::file('file')->move($destinationPath, $fileName); // uploading file to given path

 

        if ($upload_success) {

            return Response::json('success', 200);

        } else {

            return Response::json('error', 400);

        }

    }



    public function getemailtemplates(){

    	return view("backend/settings/emailTemplates");

    }



    public function posttemplateupload(){

	    $year = date('Y');

	    $month = date('m');

	    $options = array('accept_file_types' => '/\.(gif|jpe?g|png)$/i',

	            'upload_dir'=>'uploads/'.$year.'/'.$month.'/', 

	            'upload_url'=>'uploads/'.$year.'/'.$month.'/', 

	            'image_versions' => array(),

	        );

	    $upload_handler = new UploadHandler($options);

			    //  $options = array('accept_file_types' => '/\.(gif|jpe?g|png)$/i',

			    //         'upload_dir'=>'backend/products/', 

			    //         'upload_url'=>'backend/products/',

			    //         'image_versions' => array(

			    //             'thumbnail' => array(

			    //                 'upload_dir' => 'backend/',

			    //                 'upload_url' => 'backend/',

			    //                 'max_width' => 80,

			    //                 'max_height' => 80

			    //             )

			    //         )

			    //     );

			    // $upload_handler = new UploadHandler($options);

	}



	public function saveimages(Request $req){

		$input = $req->input();

		$check=Emailtemplates::where("type",$input["key"])->count();

		if($check==0){

			$insert=new Emailtemplates();

			$insert->type=$input["key"];

			$insert->image=$input["u"];

			$insert->save();

		}

		else{

			$check=Emailtemplates::where("type",$input["key"])->update(["image"=>$input["u"]]);

		}

		return Response::json(['status'=>'success']);

	}



	public function gettemplates(Request $req){

		$input = $req->input();

		$templates = Emailtemplates::where("type",$input["key"])->first();

		if($templates)

		{

			return Response::json(["status"=>"success","image"=>$templates->image]);

		}

		return Response::json(["msg"=>"No Template Available Currently"]);

	}



	public function postemailsettings(Request $req){

		$input=$req->input("keyVal");

		$check=Emailtemplates::where("type",$input)->first();

		if($check){

			$check->image=="inactive"?$current="active":$current="inactive";

			$update = Emailtemplates::where('type',$input)->update(array('image'=>$current)); 

			return Response::json(["status"=>"success","val"=>ucfirst($current),"msg"=>"Updated successfully"]);

		}

		else{

			$in = new Emailtemplates; 

			$in->type=$input; 

			$in->image="active"; 

			$in->timestamps=true; 

			$in->save();

			return Response::json(["status"=>"success","val"=>ucfirst($in->image),"msg"=>"Updated successfully"]); 

		}

	}



	public function postfooter(Request $req){

		$input = $req->all();

		$check = Emailtemplates::where("type","footerText")->first();

		if($check)

		{

			$update = Emailtemplates::where('type',"footerText")->update(array('image'=>$input['content'])); 

			$save = "success";

		}

		else

		{

			$in = new Emailtemplates; 

			$in->type = "footerText"; 

			$in->image = $input['content']; 

			$in->timestamps = true; 

			$in->save();

			$save = "success";

		}



		$check = Emailtemplates::where("type","regards")->first();

		if($check)

		{

			$update = Emailtemplates::where('type',"regards")->update(array('image'=>$input['regards'])); 

			$save = "success";

		}

		else

		{

			$in = new Emailtemplates; 

			$in->type = "regards"; 

			$in->image = $input['regards']; 

			$in->timestamps = true; 

			$in->save();

			$save = "success";

		}



		if($save = "success")

		{

			return Response::json(["status"=>"success","regards"=>$input["regards"],"content"=>$input["content"],"msg"=>"Updated successfully"]); 

		}

	}



	// Locations

	public function getcountrylist(){

		$countries=Location::where("locationType",0)->get();

		return view("backend/masters/countries")->with("countries",$countries);

	}



	public function getaddcountry(){

		return view("backend/masters/addCountry");

	}



	public function postaddcountry(Request $req){

		$input=$req->input();

		$rules=["countryName"=>"required","countryCode"=>"required"];

		$validation=Validator::make($input,$rules);

		if($validation->fails()){

			return redirect("admin/masters/locations/country/add")->withErrors($validation)->withInput();

		}

		$insert=new Location();

		$insert->name=$input["countryName"];

		$insert->code=$input["countryCode"];

		$insert->locationType=0;

		$insert->parentId=0;

		$insert->status="active";

		$insert->save();

		return redirect("admin/masters/locations/country/add")->withSuccess("New country has been stored successfully");

	}



	public function getstatelist(){

		$countries=Location::where("locationType",0)->pluck("name","id");

		return view("backend/masters/states")->with("countries",$countries);

	}



	public function getmodifycountry($id){

		$countries=Location::find($id);

		return view("backend/masters/modifyCountry")->with("countries",$countries);

	}



	public function postmodifycountry(Request $req,$id){

		$input=$req->input();

		$rules=["countryName"=>"required","countryCode"=>"required"];

		$validation=Validator::make($input,$rules);

		if($validation->fails()){

			return redirect("admin/masters/locations/country/modify/".$id)->withErrors($validation)->withInput();

		}

		$insert=Location::find($id);

		$insert->name=$input["countryName"];

		$insert->code=$input["countryCode"];

		$insert->save();

		return redirect("admin/masters/locations/country/modify/".$id)->withSuccess("Country has been updated successfully");

	}



	public function poststatelist(Request $req){

		$input=$req->input("country");

		$states=Location::where("locationType",1)->where("parentId",$input)->get();

		if(count($states)>0){

			$i=0;

			$result=[];

			foreach ($states as $state) {

				$state->status=="active"?$class="success":$class="danger";

				$result[$i]["name"]=$state->name;

				$result[$i]["code"]=$state->code;

				$result[$i]["status"]='<button type="button" class="btn ink-reaction btn-xs btn-'.$class.' stateStatus" data-id="'.$state->id.'">'.ucfirst($state->status).'</button>';

				$result[$i]["action"]='<a href="'.URL::to("admin/masters/locations/state/modify/".$state->id).'"><button type="button" class="btn btn-icon-toggle ink-reaction" data-toggle="tooltip" data-placement="top" data-original-title="Edit row"><i class="fa fa-pencil"></i></button></a><button type="button" class="btn btn-icon-toggle ink-reaction stateDelete" data-toggle="tooltip" data-placement="top" data-original-title="Delete row" data-id="'.$state->id.'"><i class="fa fa-trash-o"></i></button>';

				$i++;

			}

		}

		return Response::json(["result"=>$result]);

	}



	public function getaddstatelist(){

		$countries=Location::where("locationType",0)->pluck("name","id");

		return view("backend/masters/addStateList")->with("countries",$countries);

	}



	public function postaddstatelist(Request $req){

		$input=$req->input();

		$rules=["countryName"=>"required","stateName"=>"required","stateCode"=>"required"];

		$validation=Validator::make($input,$rules);

		if($validation->fails()){

			return redirect("admin/masters/locations/state/add")->withErrors($validation)->withInput();

		}

		$insert=new Location();

		$insert->name=$input["stateName"];

		$insert->code=$input["stateCode"];

		$insert->locationType=1;

		$insert->parentId=$input["countryName"];

		$insert->status="active";

		$insert->save();

		return redirect("admin/masters/locations/state/add")->withSuccess("New state has been stored successfully");

	}



	public function getmodifystatelist($id){

		$countries=Location::where("locationType",0)->pluck("name","id");

		$state=Location::find($id);

		return view("backend/masters/modifyStateList")->with("countries",$countries)->with("state",$state);

	}



	public function postmodifystatelist(Request $req,$id){

		$input=$req->input();

		$rules=["countryName"=>"required","stateName"=>"required","stateCode"=>"required"];

		$validation=Validator::make($input,$rules);

		if($validation->fails()){

			return redirect("admin/masters/locations/state/modify/".$id)->withErrors($validation)->withInput();

		}

		$insert=Location::find($id);

		$insert->name=$input["stateName"];

		$insert->code=$input["stateCode"];

		$insert->parentId=$input["countryName"];

		$insert->save();

		return redirect("admin/masters/locations/state/modify/".$id)->withSuccess("State information has been updated successfully");

	}



	public function postcountrystatus(Request $req){

		$input=$req->input('id');

		$taxes=Location::find($input);

		$status=$taxes->status=="active"?$current="inactive":$current="active";

		$taxes->status=$current;

		$taxes->save();

		return Response::json(["status"=>"success","msg"=>"Country status has been updated successfully","current"=>ucfirst($current)]);

	}



	public function postcountrydelete(Request $req){

		$input=$req->input('id');

		$taxes=Location::find($input);

		$taxes->status="deleted";

		$taxes->save();

		return Response::json(["status"=>"success","msg"=>"Country has been deleted successfully"]);

	}



	public function poststatestatus(Request $req){

		$input=$req->input('id');

		$taxes=Location::find($input);

		$status=$taxes->status=="active"?$current="inactive":$current="active";

		$taxes->status=$current;

		$taxes->save();

		return Response::json(["status"=>"success","msg"=>"Country status has been updated successfully","current"=>ucfirst($current)]);

	}



	public function poststatedelete(Request $req){

		$input=$req->input('id');

		$taxes=Location::find($input);

		$taxes->status="deleted";

		$taxes->save();

		return Response::json(["status"=>"success","msg"=>"Country has been deleted successfully"]);

	}



	public function getcitylist(){

		$countries=Location::where("locationType",0)->pluck("name","id");

		return view("backend/masters/city")->with("countries",$countries);

	}



	public function postcitylist(Request $req){

		$input=$req->input("state");

		$cities=Location::where("locationType",2)->where("parentId",$input)->get();

		if(count($cities)>0){

			$i=0;

			$result=[];

			foreach ($cities as $city) {

				$city->status=="active"?$class="success":$class="danger";

				$result[$i]["name"]='<a href="javascript:void(0)">'.$city->name.'</a><div class="cityName" style="display:none"><input type="text" class="cityNameVal" value="'.$city->name.'" data-id="'.$city->id.'">&nbsp;&nbsp;<button class="btn ink-reaction btn-raised btn-xs btn-accent-dark" id="modifyCityName">Save</button>&nbsp;&nbsp;<button class="btn ink-reaction btn-raised btn-xs btn-warning" id="modifyCityNameCancel">Cancel</button></div>';

				$result[$i]["status"]='<button type="button" class="btn ink-reaction btn-xs btn-'.$class.' cityStatus" data-id="'.$city->id.'">'.ucfirst($city->status).'</button>';

				$result[$i]["action"]='<a href="javascript:void(0);"><button type="button" class="btn btn-icon-toggle ink-reaction modifyCityNameClick" data-toggle="tooltip" data-placement="top" data-original-title="Edit row"><i class="fa fa-pencil"></i></button></a><button type="button" class="btn btn-icon-toggle ink-reaction cityDelete" data-toggle="tooltip" data-placement="top" data-original-title="Delete row" data-id="'.$city->id.'"><i class="fa fa-trash-o"></i></button>';

				$i++;

			}

		}

		return Response::json(["result"=>$result,"count"=>count($cities)]);

	}



	public function postcityoptionlist(Request $req){

		$input=$req->input("state");

		$cities=Location::where("locationType",2)->where("parentId",$input)->pluck('name','id');

		$html='<option value="">Select City</option>';

		foreach($cities as $cityKey=>$cityValue){

			$html.='<option value="'.$cityKey.'">'.$cityValue.'</option>';

		}

		return Response::json(["result"=>$html,"count"=>count($cities)]);

	}



	public function postcitystatus(Request $req){

		$input=$req->input('id');

		$taxes=Location::find($input);

		$status=$taxes->status=="active"?$current="inactive":$current="active";

		$taxes->status=$current;

		$taxes->save();

		return Response::json(["status"=>"success","msg"=>"City status has been updated successfully","current"=>ucfirst($current)]);

	}



	public function postcitydelete(Request $req){

		$input=$req->input('id');

		$taxes=Location::find($input);

		$taxes->status="deleted";

		$taxes->save();

		return Response::json(["status"=>"success","msg"=>"City has been deleted successfully"]);

	}



	public function getaddcity(){

		$countries=Location::where("locationType",0)->pluck("name","id");

		return view("backend/masters/addCity")->with("countries",$countries);

	}



	public function postaddcity(Request $req){

		$input=$req->input();

		$rules=["cityName"=>"required","country"=>"required","state"=>"required"];

		$validation=Validator::make($input,$rules);

		if($validation->fails()){

			return redirect("admin/masters/locations/city/add")->withErrors($validation)->withInput();

		}

		$insert=new Location();

		$insert->name=$input["cityName"];

		$insert->locationType=2;

		$insert->parentId=$input["state"];

		$insert->status="active";

		$insert->save();

		return redirect("admin/masters/locations/city/add")->withSuccess("New state has been stored successfully");

	}



	public function citynametogglepost(Request $req){

		$id=$req->input("id");

		$divVal=$req->input("divVal");

		$cityName=Location::find($id);

		$cityName->name=$divVal;

		$cityName->save();

		return Response::json(["status"=>"success","toggleVal"=>$cityName->name,"msg"=>"City name has been updated successfully"]);

	}



	// Store front

	public function headerget(){

		return view("backend/storefront/header");

	}



	public function footerget(){

		return view("backend/storefront/footer");

	}



	public function socialget(){

		return view("backend/storefront/social");

	}



	public function gethomecustompage(){

		$eventCategories = EventCategories::where("status", "active")->pluck("categoryName", "id");

		$newsCategories = NewsCategories::where('status', 'active')->pluck('categoryName', 'id');

		$news = News::where('status', 'active')->pluck('newsTitle', 'id');

		return view("backend/storefront/homePage", compact('newsCategories', 'news'))->with(["eventCategories"=>$eventCategories]);

	}



	public function postfetchevents(Request $req){

		$input = $req->all();

		$events = Events::where("status", "active")->where("eventCategoryID", $input["ID"])->pluck("eventTitle", "id");

		return Response::json(["status"=>"success", "events"=>$events]);

	}



	public function posthomecustompage(Request $req){

		$input = $req->all();

		array_shift($input);

		foreach($input as $key=>$val){

			if($key != "HPHSOneBgSlider" || $key != "HPHSOneProductSlider"  || $k != "HPHSTwoBgSlider" || $k != "HPHSTwoProductSlider" || 

				$k != "HPHSThreeBgSlider" || $k != "HPHSThreeProductSlider" || $k != "HPHSFourBgSlider" || $k != "HPHSFourProductSlider"){

				$rules[$key] = "required";

			}

		}



		$validation = Validator::make($input,$rules);

		if($validation->fails()){

			return back()->withInput()->withErrors($validation);

		}

		

		if(isset($input['HPCBSproducts'])){ 

			$input['HPCBSproducts'] = implode(',', $input['HPCBSproducts']); 

		}



		foreach($input as $k=>$v){

			if($k != "HPHSOneBgSlider" && $k != "HPHSOneProductSlider" && $k != "HPHSTwoBgSlider" && $k != "HPHSTwoProductSlider" && 

				$k != "HPHSThreeBgSlider" && $k != "HPHSThreeProductSlider" && $k != "HPHSFourBgSlider" && $k != "HPHSFourProductSlider"){

				$count = CustomPages::where('fieldName',$k)->count();

		        if($count == 1){

		          $update = CustomPages::where('fieldName',$k)->update(['fieldContent'=>$v,'lastUpdate'=>date("Y-m-d H:i:s"),'updatedByName'=>Auth::User()->userName,'updatedByID'=>Auth::User()->id]);

		        }else{

		          $insert = new CustomPages();

		          $insert->fieldName = $k;

		          $insert->fieldContent = $v;

		          $insert->lastUpdate = date("Y-m-d H:i:s");

		          $insert->updatedByName = Auth::User()->userName;

		          $insert->updatedByID = Auth::User()->id;

		          $insert->save();

		        }

		    }

		}

		return back()->with("success", "Info updated successfully");

	}



	public function posthomepagecontentheaderportion(Request $req){

		$input = $req->all();

		array_shift($input);

		foreach($input as $key=>$val){

			$rules[$key] = "required";

		}



		$msg = ["required"=>"You can't leave this field empty"];



		$validation = Validator::make($input, $rules, $msg);

		if($validation->fails()){

			return back()->withInput()->withErrors($validation);

		}

		

		if(isset($input['HPHPWidOneEvents'])){ 

			$input['HPHPWidOneEvents'] = implode(',', $input['HPHPWidOneEvents']); 

		}



		if(isset($input['HPHPWidTwoEvents'])){ 

			$input['HPHPWidTwoEvents'] = implode(',', $input['HPHPWidTwoEvents']); 

		}



		if(isset($input['HPHPWidThreeEvents'])){ 

			$input['HPHPWidThreeEvents'] = implode(',', $input['HPHPWidThreeEvents']); 

		}



		foreach($input as $k=>$v){

			$count = CustomPages::where('fieldName', $k)->count();

	        if($count == 1){

	          	$update = CustomPages::where('fieldName', $k)->update(['fieldContent'=>$v, 'lastUpdate'=>date("Y-m-d H:i:s"), 'updatedByName'=>Auth::User()->userName, 'updatedByID'=>Auth::User()->id]);

	        }else{

	          	$insert = new CustomPages();

	          	$insert->fieldName = $k;

	          	$insert->fieldContent = $v;

	          	$insert->lastUpdate = date("Y-m-d H:i:s");

	          	$insert->updatedByName = Auth::User()->userName;

	          	$insert->updatedByID = Auth::User()->id;

	          	$insert->save();

	        }

		}

		return back()->with("success", "Info updated successfully");

	}



	public function posthomepagecontentmiddleportion(Request $req){

		$input = $req->all();

		array_shift($input);

		foreach($input as $key=>$val){

			$rules[$key] = "required";

		}



		$msg = ["required"=>"You can't leave this field empty"];



		$validation = Validator::make($input, $rules, $msg);

		if($validation->fails()){

			return back()->withInput()->withErrors($validation);

		}

		

		if(isset($input['HPCMPWidThreeEvents'])){ 

			$input['HPCMPWidThreeEvents'] = implode(',', $input['HPCMPWidThreeEvents']); 

		}



		foreach($input as $k=>$v){

			$count = CustomPages::where('fieldName', $k)->count();

	        if($count == 1){

	          	$update = CustomPages::where('fieldName', $k)->update(['fieldContent'=>$v, 'lastUpdate'=>date("Y-m-d H:i:s"), 'updatedByName'=>Auth::User()->userName, 'updatedByID'=>Auth::User()->id]);

	        }else{

	          	$insert = new CustomPages();

	          	$insert->fieldName = $k;

	          	$insert->fieldContent = $v;

	          	$insert->lastUpdate = date("Y-m-d H:i:s");

	          	$insert->updatedByName = Auth::User()->userName;

	          	$insert->updatedByID = Auth::User()->id;

	          	$insert->save();

	        }

		}

		return back()->with("success", "Info updated successfully");

	}



	public function posthomepagecontentbandportion(Request $req){

		$input = $req->all();

		array_shift($input);

		foreach($input as $key=>$val){

			$rules[$key] = "required";

		}



		$msg = ["required"=>"You can't leave this field empty"];



		$validation = Validator::make($input, $rules, $msg);

		if($validation->fails()){

			return back()->withInput()->withErrors($validation);

		}

		

		if(isset($input['HPCBPEvents'])){ 

			$input['HPCBPEvents'] = implode(',', $input['HPCBPEvents']); 

		}



		foreach($input as $k=>$v){

			$count = CustomPages::where('fieldName', $k)->count();

	        if($count == 1){

	          	$update = CustomPages::where('fieldName', $k)->update(['fieldContent'=>$v, 'lastUpdate'=>date("Y-m-d H:i:s"), 'updatedByName'=>Auth::User()->userName, 'updatedByID'=>Auth::User()->id]);

	        }else{

	          	$insert = new CustomPages();

	          	$insert->fieldName = $k;

	          	$insert->fieldContent = $v;

	          	$insert->lastUpdate = date("Y-m-d H:i:s");

	          	$insert->updatedByName = Auth::User()->userName;

	          	$insert->updatedByID = Auth::User()->id;

	          	$insert->save();

	        }

		}

		return back()->with("success", "Info updated successfully");

	}



	public function customerget(){

		$customers = User::where('status','!=','deleted')->where('userGroup','0')->latest()->paginate(10);

		return view('backend.users.customers')->with('customers',$customers);

	}



    public function postsearchcustomers(Request $req){

		$input = $req->input('searchName');

		$customers = User::where('firstName', 'LIKE', '%'.$input.'%')->orWhere('lastName', 'LIKE', '%'.$input.'%')->orWhere('email', 'LIKE', '%'.$input.'%')->where('status', '!=', 'deleted')->where('userGroup', '0')->paginate(10);

		return view('backend/users/customers')->with('customers', $customers);

	}



	public function getsearchcustomers(){

		$customers = User::where('status','!=','deleted')->where('userGroup','0')->paginate(10);

		return view('backend.users.customers')->with('customers',$customers);

	}



	public function customerstatuspost(Request $req){

		$input=$req->input('id');

		$users=User::find($input);

		$status=$users->status=="active"?$current="inactive":$current="active";

		$users->status=$current;

		$users->save();

		return Response::json(["status"=>"success","current"=>ucfirst($current),"msg"=>"Updated Successfully"]);

	}



	public function deletecustomer(Request $req){

		$input=$req->input('id');

		$users=User::find($input);

		$users->status="deleted";

		$users->save();

		return Response::json(["status"=>"success","msg"=>"Deleted Successfully"]);

	}



	public function modifycustomerget($id){

		$customers= User::find($id);

		return view('backend.users.modifyCustomer')->with('customer',$customers);

	}



	// Subscriptions

	public function addsubscriptionslistget(){

		return view("backend/marketing/addSubscriptionList");

	}



	public function addsubscribergetpage(){

		$list=Subscriptions::where("listId","=",0)->where("status","active")->get();

		return view("backend/marketing/addSubscriber")->with("lists",$list);

	}



	public function addsubscriberpost(Request $req){

		$input=$req->input();

		$rules=["email"=>"required|email|unique:subscriptions,email","listId"=>"required"];

		$validation=Validator::make($input,$rules);

		if($validation->fails()){

			return redirect("admin/marketing/subscriptions/subscribers/add")->withErrors($validation)->withInput();

		}

		$insert=new Subscriptions();

		$insert->email=$input["email"];

		$insert->listId=implode(",",$input["listId"]);

		$insert->save();

		return redirect("admin/marketing/subscriptions/subscribers/add")->withSuccess("Subscriber added successfully");

	}



	public function modifysubscriberget($id){

		$list=Subscriptions::where("listId","=",0)->where("status","active")->get();

		$subscriber=Subscriptions::find($id);

		return view("backend/marketing/modifySubscriber")->with("subscriber",$subscriber)->with("lists",$list);

	}



	public function modifysubscriberpost(Request $req,$id){

		$input=$req->input();

		$rules=["email"=>"required|email","listId"=>"required"];

		$validation=Validator::make($input,$rules);

		if($validation->fails()){

			return redirect("admin/marketing/subscriptions/subscribers/modify/".$id)->withErrors($validation)->withInput();

		}

		$insert=Subscriptions::find($id);

		$insert->email=$input["email"];

		$insert->listId=implode(",",$input["listId"]);

		$insert->save();

		return redirect("admin/marketing/subscriptions/subscribers/modify/".$id)->withSuccess("Subscriober updated successfully");

	}



	public function subscriptionsget(){

		$list=Subscriptions::where("listId",0)->where("status","!=","deleted")->get();

		return view("backend/marketing/subscriptions")->with("lists",$list);

	}



	public function subscribersget($listId){

		$list=Subscriptions::where("listId",$listId)->get();

		return view("backend/marketing/subscribers")->with("lists",$list);

	}



	public function subscriptionsstatuspost(Request $req){

		$input=$req->input();

		$input=$req->input('id');

		$lists=Subscriptions::find($input);

		$status=$lists->status=="active"?$current="inactive":$current="active";

		$lists->status=$current;

		$lists->save();

		return Response::json(["status"=>"success","msg"=>"Subscription status updated successfully","current"=>ucfirst($current)]);

	}



	//News

	public function getnewspage(){

	    $news = News::orderBy("id","DESC")->get();

	    return view("backend/news/news")->with(["news"=>$news]);

	}



  	public function postnewsstatus(Request $req){

	  	try{

	    	$input = $req->input('id');

			$news = News::find($input);

			$status = $news->status == "active" ? $current = "inactive" : $current = "active";

			$news->status = $current;

			$news->save();

			return Response::json(["status"=>"success","current"=>ucfirst($current),"msg"=>"Updated Successfully"]);

	  	}catch(Exception $e){

	    	//TrackingReport::track("error",$e->getMessage(),"","","news status");

	    	return Response::json(["status"=>"error"]);

	  	}

  	}



  	public function postnewsdelete(Request $req){

	    try{

		    $input = $req->input('id');

			$news = News::find($input);

			$news->delete();

			return Response::json(["status"=>"success","msg"=>"Deleted Successfully"]);

	    }catch(Exception $e){

	        return Response::json(["status"=>"error"]);

	    }

  	}



  	public function getaddpostpage(){

	    $authors = User::where("status","active")->where("userGroup", 1)->pluck("userName","id");

	    $categories = NewsCategories::where("status","active")->pluck("categoryName","id");

	    return view("backend/news/addNews")->with(["authors"=>$authors,"categories"=>$categories]);

  	}



  	public function postaddnewspost(Request $req){

    	try{

	      	$input = $req->all();

	      	$rules = ["postTitle"=>"required",

			  "postDescription"=>"required",

			  "newsDate" => "required|Date",

			  "postCategories"=>"required",

			  "postAuthor"=>"required",

			  "featureImage"=>"required_if:featureImage,

			  $req->hasFile('featureImage')|image|mimes:png,jpg,jpeg,gif",

			  "newsLink" => 'required|url'

			  ];

	      	$msg = ["required"=>"You can't leave this field empty"];

	      	$validation = Validator::make($input,$rules);

	      

		    if($validation->fails()){

		        return back()->withInput()->withErrors($validation);

		    }



	      	$insert = new News();

	      	$insert->newsTitle = $input["postTitle"];

	      	$insert->newsSlug = News::getSlug($input["postTitle"]);

	      	$insert->newsContent = $input["postDescription"];

	      	$insert->newsDate = $input['newsDate'];

	      	$insert->newsCategories = implode(",",$input["postCategories"]);

	      	$insert->newsAuthorName = User::getusername($input["postAuthor"]);

	      	$insert->newsAuthorID = $input["postAuthor"];

	      	$insert->newsSettings = isset($input["postSettings"]) ? $input["postSettings"] = "yes" : $input["postSettings"] = "no";

	      	$insert->newsCreatorName = Auth::User()->userName;

	      	$insert->newsCreatorId = Auth::User()->id;

	      	$insert->status = "active";

	      	$insert->news_link = $input['newsLink'];

	      	$url = NULL;

	      	if($req->hasFile('featureImage')){

	        	$file = $req->file('featureImage');

	        	$destinationPath = 'backend/uploads/news/'; // upload path

	        	$extension = $file->getClientOriginalExtension(); // getting file extension

	        	$fileName = rand(11111, 99999) . '.' . $extension; // renameing image

	        	$upload_success = $file->move($destinationPath, $fileName); // uploading file to given path

	        	$img_url = $destinationPath.$fileName;

	        	$url = URL::asset($img_url);

	      	}

	      	$insert->featureImage = $url;

	      	$insert->save();



	      	foreach(explode(",", implode(",",$input["postCategories"])) as $category){

	      		$insertMeta = new NewsMeta();

	      		$insertMeta->newsID = $insert->id;

	      		$insertMeta->categoryID = $category;

	      		$insertMeta->save();

	      	}

	      	// $con = 'New news post created  by '.Auth::user()->userName.". News title is ".$input["postTitle"];

	      	// TrackingReport::track('news',$con,'','','add');

	      	return back()->with("success","New news post created successfully!!");

	    }catch(Exception $e){

	      TrackingReport::track("error",$e->getMessage(),"","","add news");

	      return Redirect::back()->with("error","Error processing your request")->withInput();

	    }

  	}



	public function geteditnewspostpage($id){

		$authors = User::where("status","active")->where("userGroup", 1)->pluck("userName","id");

		$categories = NewsCategories::where("status","active")->pluck("categoryName","id");

		$news = News::find($id);

		return view("backend/news/editNews")->with(["authors"=>$authors,"news"=>$news,"categories"=>$categories]);

	}



 	 public function posteditnewspostpage(Request $req,$id){

	    try{

	      	$input = $req->input();

	      	$rules = ["postTitle"=>"required",

				"postDescription"=>"required",

				"postCategories"=>"required",

				"newsDate" => "required|Date",

				"postAuthor"=>"required",

				"featureImage"=>"required_if:featureImage,

				$req->hasFile('featureImage')|image|mimes:png,jpg,jpeg,gif",

				"newsLink" => 'required|url'

			];

	      	$msg = ["required"=>"You can't leave this fieldempty"];

	      	$validation = Validator::make($input,$rules,$msg);

	      

	      	if($validation->fails()){

	        	return back()->withInput()->withErrors($validation);

	      	}



	      	$insert = News::find($id);

	      	$insert->newsTitle = $input["postTitle"];

	      	if($input["postTitle"] != $insert->newsTitle){

	      		$insert->newsSlug = News::getSlug($input["postTitle"]);

	      	}

	      	$insert->newsContent = $input["postDescription"];

	      	$insert->newsCategories = implode(",",$input["postCategories"]);

	      	$insert->newsAuthorName = User::getusername($input["postAuthor"]);

	      	$insert->newsDate = $input['newsDate'];

	      	$insert->newsAuthorID = $input["postAuthor"];

	      	$insert->newsSettings = isset($input["postSettings"]) ? $input["postSettings"] = "yes" : $input["postSettings"] = "no";

	      	$insert->newsUpdatorName = Auth::User()->userName;

	      	$insert->newsUpdatorID = Auth::User()->id;

	      	$insert->status = "active";

	      	$insert->news_link = $input['newsLink'];

	      	$url = NULL;

	      	if($req->hasFile('featureImage')){

		      	if($insert->featureImage != ""){

		  			$unlinkurl = explode('news/',$insert->featureImage);

		        	unlink(public_path()."/backend/uploads/news/".end($unlinkurl));

		  		}

		        $file = $req->file('featureImage');

		        $destinationPath = 'backend/uploads/news/'; // upload path

		        $extension = $file->getClientOriginalExtension(); // getting file extension

		        $fileName = rand(11111, 99999) . '.' . $extension; // renameing image

		        $upload_success = $file->move($destinationPath, $fileName); // uploading file to given path

		        $img_url = $destinationPath.$fileName;

		        $url = URL::asset($img_url);

		     }

		     $insert->featureImage = $url;

	      	$insert->save();

	      	$delete = NewsMeta::where("newsID", $id)->delete();

	      	foreach(explode(",", implode(",",$input["postCategories"])) as $category){

		      	$insertMeta = new NewsMeta();

		      	$insertMeta->newsID = $insert->id;

		      	$insertMeta->categoryID = $category;

		      	$insertMeta->save();

	      	}

	      	// $con = 'New news post created  by '.Auth::user()->userName.". News title is ".$input["postTitle"];

	      	// TrackingReport::track('news',$con,'','','add');

	      	return back()->with("success","News details updated successfully!!");

	    }catch(Exception $e){

	      TrackingReport::track("error",$e->getMessage(),"","","add news");

	      return Redirect::back()->with("error","Error processing your request")->withInput();

	    }

  	}



  	public function modifycustomerpost(Request $req,$id){

		$input = $req->input();

		$insert=User::find($id);

		$insert->firstName = $input["firstName"];

		$insert->lastName = $input["lastName"];

		$insert->phone = $input["phone"];

		$insert->gender = $input["gender"];

		$insert->address = $input["address"];

		$insert->landmark = $input["landmark"];

		$insert->city = $input["city"];

		$insert->pincode = $input["pincode"];

		$insert->state = $input["state"];

		$insert->dob=date('Y-m-d',strtotime($input["dob"]));

		$insert->save();

		return Redirect("admin/customer/modify/".$id)->with("success","Customer details have been updated successfully");

	}



	//News Categories

	public function getaddnewscategory(){

		return view("backend/news/addNewsCategory");

	}



	public function postaddnewscategory(Request $req){

		$input = $req->input();

		$rules = [

			"postCategoryTitle"=>"required"

		];

		$validation = Validator::make($input,$rules);



		if($validation->fails()){

			return back()->withInput()->withErrors($validation);

		}



		$insert = new NewsCategories();

		$insert->categoryName = $input["postCategoryTitle"];

		$insert->categorySlug = NewsCategories::getCategorySlug($input["postCategoryTitle"]);

		$insert->addedByName = Auth::User()->userName;

		$insert->addedByID = Auth::User()->id;

		$insert->status = "active";

		$insert->save();

		return back()->with("success", "New post category title created successfully");

	}



	public function getnewscategory(){

		$categories = NewsCategories::all();

		return view("backend/news/newsCategories")->with("categories", $categories);

	}



	public function postnewscategorystatus(Request $req){

	  	try{

	    	$input = $req->input('id');

			$news = NewsCategories::find($input);

			$status = $news->status == "active" ? $current = "inactive" : $current = "active";

			$news->status = $current;

			$news->save();

			return Response::json(["status"=>"success","current"=>ucfirst($current),"msg"=>"Updated Successfully"]);

	  	}catch(Exception $e){

	    	//TrackingReport::track("error",$e->getMessage(),"","","news status");

	    	return Response::json(["status"=>"error"]);

	  	}

	}



  	public function postnewscategorydelete(Request $req){

    	try{

		    $input = $req->input('id');

			$news = NewsCategories::find($input);

			$news->delete();

			return Response::json(["status"=>"success","msg"=>"Deleted Successfully"]);

    	}catch(Exception $e){

	        //TrackingReport::track("error",$e->getMessage(),"","","delete news");

	        return Response::json(["status"=>"error"]);

	    }

  	}



  	public function postnewscategorymodify(Request $req){

    	try{

		    $input = $req->input();

			$news = NewsCategories::find($input["id"]);

			if($news->categoryName != $input["value"]){

				$news->categorySlug = NewsCategories::getCategorySlug($input["value"]);

			}

			$news->categoryName = $input["value"];

			$news->save();

			return Response::json(["status"=>"success","msg"=>"Updated Successfully","name"=>$news->categoryName]);

    	}catch(Exception $e){

	        //TrackingReport::track("error",$e->getMessage(),"","","delete news");

	        return Response::json(["status"=>"error"]);

	    }

  	}



  	//Pages

  	public function getallpages(){

  		return view("backend/pages/allPages");

  	}



  	public function getaboutuspage(){

  		return view("backend/about/aboutUs");

  	}



  	public function getcontactuspage(){

  		return view("backend/pages/contactUs");

  	}



  	public function getprivacypolicypage(){

  		return view("backend/pages/privacyPolicy");

  	}



  	public function gettermsandconditionspage(){

  		return view("backend/pages/termsAndConditions");

  	}



  	public function getreturnpolicypage(){

  		return view("backend/pages/returnPolicy");

  	}



  	public function getshippingpolicypage(){

  		return view("backend/pages/shippingPolicy");

  	}



  	public function getdisclaimerpage(){

  		return view("backend/pages/disclaimer");

  	}



  	public function getourfacilitiespage(){

  		return view("backend/about/ourFacilities");

  	}



  	public function getcourseofferedpage(){

  		return view("backend/courses/courseOffered");

  	}



  	public function getcourseeligibilitypage(){

  		return view("backend/courses/courseEligibility");

  	}



  	public function postaboutuspage(Request $req){

  		$input = $req->all();

  		array_shift($input);

  		foreach($input as $key=>$val){

  			if($key == "aboutUsWidgetAreaOneIcon" || $key == "contactUsWidgetOneIcon" || $key == "contactUsWidgetTwoIcon"){

	    		$rules[$key] = "image|mimes:png,jpg,jpeg,gif";

	    	}else{

	    		$rules[$key] = "required";

	    	}

  		}



  		$validation = Validator::make($input,$rules);

  		if($validation->fails()){

	      return back()->withInput()->withErrors($validation);

	    }



	    foreach($input as $k=>$v){

	    	if($k != "aboutUsWidgetAreaOneIcon" && $k != "aboutUsWidgetAreaTwoIcon"){

	    		$count = CustomPages::where('fieldName',$k)->count();

		        if($count == 1){

		          $update = CustomPages::where('fieldName',$k)->update(['fieldContent'=>$v,'lastUpdate'=>date("Y-m-d H:i:s"),'updatedByName'=>Auth::User()->userName,'updatedByID'=>Auth::User()->id]);

		        }else{

		          $insert = new CustomPages();

		          $insert->fieldName = $k;

		          $insert->fieldContent = $v;

		          $insert->lastUpdate = date("Y-m-d H:i:s");

		          $insert->updatedByName = Auth::User()->userName;

		          $insert->updatedByID = Auth::User()->id;

		          $insert->save();

		        }

	    	}

	    }



	    //Contact Us Images

	    if($req->hasFile('contactUsWidgetOneIcon')){

	        $file = $req->file('contactUsWidgetOneIcon');

	        $destinationPath = 'backend/uploads/pages/'; // upload path

	        $extension = $file->getClientOriginalExtension(); // getting file extension

	        $fileName = rand(11111, 99999) . '.' . $extension; // renameing image

	        $upload_success = $file->move($destinationPath, $fileName); // uploading file to given path

	        $img_url = $destinationPath.$fileName;

	        $url = URL::asset($img_url);

	        $count = CustomPages::where('fieldName','contactUsWidgetOneIcon')->first();

	        if($count){

	          //$unlinkurl = explode('pages/',$count->fieldContent);

	          //unlink(public_path()."/backend/uploads/pages/".end($unlinkurl));

	          $update = CustomPages::where('fieldName','contactUsWidgetOneIcon')->update(['fieldContent'=>$url,'lastUpdate'=>date("Y-m-d H:i:s"),'updatedByName'=>Auth::User()->userName,'updatedByID'=>Auth::User()->id]);

	        }else{

	          $insert = new CustomPages();

	          $insert->fieldName = $k;

	          $insert->fieldContent = $url;

	          $insert->lastUpdate = date("Y-m-d H:i:s");

	          $insert->updatedByName = Auth::User()->userName;

	          $insert->updatedByID = Auth::User()->id;

	          $insert->save();

	        }

	    }



	    if($req->hasFile('contactUsWidgetTwoIcon')){

	        $file = $req->file('contactUsWidgetTwoIcon');

	        $destinationPath = 'backend/uploads/pages/'; // upload path

	        $extension = $file->getClientOriginalExtension(); // getting file extension

	        $fileName = rand(11111, 99999) . '.' . $extension; // renameing image

	        $upload_success = $file->move($destinationPath, $fileName); // uploading file to given path

	        $img_url = $destinationPath.$fileName;

	        $url = URL::asset($img_url);

	        $count = CustomPages::where('fieldName','contactUsWidgetTwoIcon')->first();

	        if($count){

	          //$unlinkurl = explode('pages/',$count->fieldContent);

	          //unlink(public_path()."/backend/uploads/pages/".end($unlinkurl));

	          $update = CustomPages::where('fieldName','contactUsWidgetTwoIcon')->update(['fieldContent'=>$url,'lastUpdate'=>date("Y-m-d H:i:s"),'updatedByName'=>Auth::User()->userName,'updatedByID'=>Auth::User()->id]);

	        }else{

	          $insert = new CustomPages();

	          $insert->fieldName = $k;

	          $insert->fieldContent = $url;

	          $insert->lastUpdate = date("Y-m-d H:i:s");

	          $insert->updatedByName = Auth::User()->userName;

	          $insert->updatedByID = Auth::User()->id;

	          $insert->save();

	        }

	    }

	    return back()->with("success", "Info updated successfully!");

  	}



  	//FAQs

  	public function getaddfaq(){

  		$products = [];//Productdetails::lists("productname", "id");

  		return view("backend/faqs/addFAQ")->with(["products"=>$products]);

  	}



  	public function postaddfaq(Request $req){

  		$input = $req->all();

  		$rules = [

  			"FAQQuestion"=>"required",

  			"FAQAnswer"=>"required"

  			//,"FAQProducts"=>"required"

  		];

  		$validation = Validator::make($input,$rules);



  		if($validation->fails()){

  			return back()->withInput()->withErrors($validation);

  		}



  		$insert = new FAQ();

  		$insert->FAQQuestion = $input["FAQQuestion"];

  		$insert->FAQAnswer = $input["FAQAnswer"];

  		$insert->products = implode(",",$input["FAQProducts"]);

  		$insert->FAQCreatorName = Auth::User()->userName;

  		$insert->FAQCreatorId = Auth::User()->id;

  		$insert->save();



  		//insert the faq meta table for normalization

  		foreach($input["FAQProducts"] as $productID){

  			$insertMeta = new FAQMeta();

  			$insertMeta->FAQID = $insert->id;

  			$insertMeta->productID = $productID;

  			$insertMeta->save();

  		}



  		return back()->with("success", "New FAQ created successfully");

  	}



  	public function getmodifyfaq($id){

  		$products = Productdetails::lists("productname", "id");

  		$faq = FAQ::find($id);

  		return view("backend/faqs/modifyFAQ")->with(["products"=>$products,"faq"=>$faq]);

  	}



  	public function postmodifyfaq(Request $req,$id){

  		$input = $req->all();

  		$rules = [

  			"FAQQuestion"=>"required",

  			"FAQAnswer"=>"required"

  			//,"FAQProducts"=>"required"

  		];

  		$validation = Validator::make($input,$rules);



  		if($validation->fails()){

  			return back()->withInput()->withErrors($validation);

  		}



  		$insert = FAQ::find($id);

  		$insert->FAQQuestion = $input["FAQQuestion"];

  		$insert->FAQAnswer = $input["FAQAnswer"];

  		$insert->products = implode(",",$input["FAQProducts"]);

  		$insert->FAQUpdatorName = Auth::User()->userName;

  		$insert->FAQUpdatorId = Auth::User()->id;

  		$insert->save();



  		$delete = FAQMeta::where("FAQID", $id)->delete();

  		//update the faq meta table for normalization

  		foreach($input["FAQProducts"] as $productID){

  			$insertMeta = new FAQMeta();

  			$insertMeta->FAQID = $id;

  			$insertMeta->productID = $productID;

  			$insertMeta->save();

  		}

  		return back()->with("success", "FAQ updated successfully");

  	}



  	public function getfaq(){

  		$FAQs = FAQ::orderBy("id","DESC")->get();

  		return view("backend/faqs/FAQ")->with(["FAQs"=>$FAQs]);

  	}



  	public function postfaqstatus(Request $req){

	  	try{

	    	$input = $req->input('id');

			$faq = FAQ::find($input);

			$status = $faq->status == "active" ? $current = "inactive" : $current = "active";

			$faq->status = $current;

			$faq->save();

			return Response::json(["status"=>"success","current"=>ucfirst($current),"msg"=>"Updated Successfully"]);

	  	}catch(Exception $e){

	    	//TrackingReport::track("error",$e->getMessage(),"","","faq status");

	    	return Response::json(["status"=>"error"]);

	  	}

	}



  	public function postfaqdelete(Request $req){

    	try{

		    $input = $req->input('id');

			$faq = FAQ::find($input);

			$faq->delete();

			return Response::json(["status"=>"success","msg"=>"Deleted Successfully"]);

    	}catch(Exception $e){

	        //TrackingReport::track("error",$e->getMessage(),"","","delete faq");

	        return Response::json(["status"=>"error"]);

	    }

  	}



  	//Testimonials

  	public function gettestimonials(){

  		$testimonials = Testimonials::orderBy("id", "DESC")->get();

  		return view("backend/testimonials/testimonials")->with(["testimonials"=>$testimonials]);

  	}



  	public function posttestimonialsstatus(Request $req){

	  	try{

	    	$input = $req->input('id');

			$testimonials = Testimonials::find($input);

			$status = $testimonials->status == "active" ? $current = "inactive" : $current = "active";

			$testimonials->status = $current;

			$testimonials->save();

			return Response::json(["status"=>"success","current"=>ucfirst($current),"msg"=>"Updated Successfully"]);

	  	}catch(Exception $e){

	    	//TrackingReport::track("error",$e->getMessage(),"","","testimonials status");

	    	return Response::json(["status"=>"error"]);

	  	}

	}



  	public function posttestimonialsdelete(Request $req){

    	try{

		    $input = $req->input('id');

			$testimonials = Testimonials::find($input);

			$testimonials->delete();

			return Response::json(["status"=>"success","msg"=>"Deleted Successfully"]);

    	}catch(Exception $e){

	        //TrackingReport::track("error",$e->getMessage(),"","","delete testimonials");

	        return Response::json(["status"=>"error"]);

	    }

  	}



  	public function getaddtestimonials(){

  		return view("backend/testimonials/addTestimonials");

  	}



  	public function postaddtestimonials(Request $req){

  		$input = $req->all();

  		$rules = [

  			"testimonialContent"=>"required",

  			"authName"=>"required",

  			"authCategory"=>"required",

  			"authImg"=>"required_if:authImg,$req->hasFile('authImg')|image|mimes:png,jpg,jpeg,gif"

  		];

  		$validation = Validator::make($input,$rules);



  		if($validation->fails()){

  			return back()->withInput()->withErrors($validation);

  		}



  		$insert = new Testimonials();

  		$insert->testimonialContent = $input["testimonialContent"];

  		$insert->authName = $input["authName"];

  		$insert->authCategory = $input["authCategory"];

  		$insert->status = "active";

  		$insert->createdByName = Auth::User()->userName;

  		$insert->createdByID = Auth::User()->id;

  		if($req->hasFile('authImg')){

        	$file = $req->file('authImg');

        	$destinationPath = 'backend/uploads/testimonial/'; // upload path

        	$extension = $file->getClientOriginalExtension(); // getting file extension

        	$fileName = rand(11111, 99999) . '.' . $extension; // renameing image

        	$upload_success = $file->move($destinationPath, $fileName); // uploading file to given path

        	$img_url = $destinationPath.$fileName;

        	$url = URL::asset($img_url);

        	$insert->authImg = $url;

      	}

  		$insert->save();



  		return back()->with("success", "New testimonial created successfully");

  	}



  	public function getmodifytestimonials($id){

  		$testimonial = Testimonials::find($id);

  		return view("backend/testimonials/modifyTestimonials")->with("testimonial",$testimonial);

  	}



  	public function postmodifytestimonials(Request $req,$id){

  		$input = $req->all();

  		$rules = [

  			"testimonialContent"=>"required",

  			"authName"=>"required",

  			"authCategory"=>"required",

  			"authImg"=>"required_if:authImg,$req->hasFile('authImg')|image|mimes:png,jpg,jpeg,gif"

  		];

  		$validation = Validator::make($input,$rules);



  		if($validation->fails()){

  			return back()->withInput()->withErrors($validation);

  		}



  		$insert = Testimonials::find($id);

  		$insert->testimonialContent = $input["testimonialContent"];

  		$insert->authName = $input["authName"];

  		$insert->authCategory = $input["authCategory"];

  		$insert->updatedByName = Auth::User()->userName;

  		$insert->updatedByID = Auth::User()->id;

  		if($req->hasFile('authImg')){

      		if($insert->authImg != ""){

      			$unlinkurl = explode('testimonial/',$insert->authImg);

	        	unlink(public_path()."/backend/uploads/testimonial/".end($unlinkurl));

      		}

      		

        	$file = $req->file('authImg');

        	$destinationPath = 'backend/uploads/testimonial/'; // upload path

        	$extension = $file->getClientOriginalExtension(); // getting file extension

        	$fileName = rand(11111, 99999) . '.' . $extension; // renameing image

        	$upload_success = $file->move($destinationPath, $fileName); // uploading file to given path

        	$img_url = $destinationPath.$fileName;

        	$url = URL::asset($img_url);

        	$insert->authImg = $url;

      	}

  		$insert->save();



  		return back()->with("success", "Testimonial updated successfully");

  	}



  	//Pop uP Banner Settings

	public function getpopupbannersettings(){

	    return view("backend/settings/popupBannerSettings");

	}



	public function postpopupbannersettings(Request $req){

		$input = $req->all();

		array_shift($input);

		foreach($input as $key=>$val){

			if($key == "popUpBannerImg"){

				$rules[$key] = "image|mimes:png,jpg,jpeg";

			}else{

				$rules[$key] = "required";

			}

		}



		isset($input["popupAllProducts"]) ? $input["popupAllProducts"] = "yes" : $input["popupAllProducts"] = "no";

		isset($input["popUpEnable"]) ? $input["popUpEnable"] = "yes" : $input["popUpEnable"] = "no";

		isset($input["manualPopUpClose"]) ? $input["manualPopUpClose"] = "yes" : $input["manualPopUpClose"] = "no";

		isset($input["enablePopUpCookie"]) ? $input["enablePopUpCookie"] = "yes" : $input["enablePopUpCookie"] = "no";



		foreach($input as $k=>$v){

			if($k != "popUpBannerImg"){

				$count = CustomPages::where('fieldName',$k)->count();

		        if($count == 1){

		          $update = CustomPages::where('fieldName',$k)->update(['fieldContent'=>$v,'lastUpdate'=>date("Y-m-d H:i:s"),'updatedByName'=>Auth::User()->userName,'updatedByID'=>Auth::User()->userId]);

		        }else{

		          $insert = new CustomPages();

		          $insert->fieldName = $k;

		          $insert->fieldContent = $v;

		          $insert->lastUpdate = date("Y-m-d H:i:s");

		          $insert->updatedByName = Auth::User()->userName;

		          $insert->updatedByID = Auth::User()->id;

		          $insert->save();

		        }

			}

		}/* end of foreach	 */



		if($req->hasFile('popUpBannerImg')){

	        $file = $req->file('popUpBannerImg');

	        $destinationPath = 'backend/uploads/pages/'; // upload path

	        $extension = $file->getClientOriginalExtension(); // getting file extension

	        $fileName = rand(11111, 99999) . '.' . $extension; // renameing image

	        $upload_success = $file->move($destinationPath, $fileName); // uploading file to given path

	        $img_url = $destinationPath.$fileName;

	        $url = URL::asset($img_url);

	        $count = CustomPages::where('fieldName','popUpBannerImg')->first();

	        if($count){

	          $unlinkurl = explode('pages/',$count->fieldContent);

	          unlink(public_path()."/backend/uploads/pages/".end($unlinkurl));

	          $update = CustomPages::where('fieldName','popUpBannerImg')->update(['fieldContent'=>$url,'lastUpdate'=>date("Y-m-d H:i:s"),'updatedByName'=>Auth::User()->userName,'updatedByID'=>Auth::User()->id]);

	        }else{

	          $insert = new CustomPages();

	          $insert->fieldName = "popUpBannerImg";

	          $insert->fieldContent = $url;

	          $insert->lastUpdate = date("Y-m-d H:i:s");

	          $insert->updatedByName = Auth::User()->userName;

	          $insert->updatedByID = Auth::User()->id;

	          $insert->save();

	        }

	    }

		return back()->with("success", "Settings updated successfully");

	}



	public function postpopupdietbannersettings(Request $req){

		$input = $req->all();

		array_shift($input);

		foreach($input as $key=>$val){

			if($key == "popUpDietBannerImg"){

				$rules[$key] = "image|mimes:png,jpg,jpeg";

			}else{

				$rules[$key] = "required";

			}

		}



		isset($input["popUpDietEnable"]) ? $input["popUpDietEnable"] = "yes" : $input["popUpDietEnable"] = "no";

		isset($input["manualPopUpDietClose"]) ? $input["manualPopUpDietClose"] = "yes" : $input["manualPopUpDietClose"] = "no";

		isset($input["enablePopUpDietCookie"]) ? $input["enablePopUpDietCookie"] = "yes" : $input["enablePopUpDietCookie"] = "no";



		isset($input["dietPlanOneStatus"]) ? $input["dietPlanOneStatus"] = "active" : $input["dietPlanOneStatus"] = "inactive";

		isset($input["dietPlanTwoStatus"]) ? $input["dietPlanTwoStatus"] = "active" : $input["dietPlanTwoStatus"] = "inactive";

		isset($input["dietPlanThreeStatus"]) ? $input["dietPlanThreeStatus"] = "active" : $input["dietPlanThreeStatus"] = "inactive";

		isset($input["dietPlanFourStatus"]) ? $input["dietPlanFourStatus"] = "active" : $input["dietPlanFourStatus"] = "inactive";



		foreach($input as $k=>$v){

			if($k != "popUpDietBannerImg"){

				$count = CustomPages::where('fieldName',$k)->count();

		        if($count == 1){

		          $update = CustomPages::where('fieldName',$k)->update(['fieldContent'=>$v,'lastUpdate'=>date("Y-m-d H:i:s"),'updatedByName'=>Auth::User()->userName,'updatedByID'=>Auth::User()->userId]);

		        }else{

		          $insert = new CustomPages();

		          $insert->fieldName = $k;

		          $insert->fieldContent = $v;

		          $insert->lastUpdate = date("Y-m-d H:i:s");

		          $insert->updatedByName = Auth::User()->userName;

		          $insert->updatedByID = Auth::User()->id;

		          $insert->save();

		        }

			}

		}/* end of foreach	 */



		if($req->hasFile('popUpDietBannerImg')){

	        $file = $req->file('popUpDietBannerImg');

	        $destinationPath = 'backend/uploads/pages/'; // upload path

	        $extension = $file->getClientOriginalExtension(); // getting file extension

	        $fileName = rand(11111, 99999) . '.' . $extension; // renameing image

	        $upload_success = $file->move($destinationPath, $fileName); // uploading file to given path

	        $img_url = $destinationPath.$fileName;

	        $url = URL::asset($img_url);

	        $count = CustomPages::where('fieldName','popUpDietBannerImg')->first();

	        if($count){

	          $unlinkurl = explode('pages/',$count->fieldContent);

	          unlink(public_path()."/backend/uploads/pages/".end($unlinkurl));

	          $update = CustomPages::where('fieldName','popUpDietBannerImg')->update(['fieldContent'=>$url,'lastUpdate'=>date("Y-m-d H:i:s"),'updatedByName'=>Auth::User()->userName,'updatedByID'=>Auth::User()->id]);

	        }else{

	          	$insert = new CustomPages();

	          	$insert->fieldName = "popUpDietBannerImg";

	          	$insert->fieldContent = $url;

	          	$insert->lastUpdate = date("Y-m-d H:i:s");

	          	$insert->updatedByName = Auth::User()->userName;

	          	$insert->updatedByID = Auth::User()->id;

	          	$insert->save();

	        }

	    }

		return back()->with("success", "Settings updated successfully");

	}





	public function postpopupproductbannersettings(Request $req){

		$input = $req->all();

		array_shift($input);

		isset($input["popUpProductEnable"]) ? $input["popUpProductEnable"] = "yes" : $input["popUpProductEnable"] = "no";

		isset($input["manualPopUpProductClose"]) ? $input["manualPopUpProductClose"] = "yes" : $input["manualPopUpProductClose"] = "no";

		isset($input["enablePopUpProductCookie"]) ? $input["enablePopUpProductCookie"] = "yes" : $input["enablePopUpProductCookie"] = "no";

		foreach($input as $k=>$v){

				$count = CustomPages::where('fieldName',$k)->count();

		        if($count == 1){

		          $update = CustomPages::where('fieldName',$k)->update(['fieldContent'=>$v,'lastUpdate'=>date("Y-m-d H:i:s"),'updatedByName'=>Auth::User()->userName,'updatedByID'=>Auth::User()->userId]);

		        }else{

		          $insert = new CustomPages();

		          $insert->fieldName = $k;

		          $insert->fieldContent = $v;

		          $insert->lastUpdate = date("Y-m-d H:i:s");

		          $insert->updatedByName = Auth::User()->userName;

		          $insert->updatedByID = Auth::User()->id;

		          $insert->save();

		        }

		}/* end of foreach	 */

		return back()->with("success", "Settings updated successfully");

	}



	//Downloads

	public function getadddownload(){

		$products = Productdetails::lists("productname", "id");

		return view("backend/downloads/addDownload")->with(["products"=>$products]);

	}



	public function postadddownload(Request $req){

		$input = $req->all();

		$rules = [

			"downloadProducts"=>"required|unique:downloads,products",

			//"uploadBrochure"=>"required|mimes:jpg,jpeg,png,pdf",

			"uploadCertification"=>"required|mimes:jpg,jpeg,png,pdf",

			//"uploadPoster"=>"required|mimes:jpg,jpeg,png,pdf"

		];

		$validation = Validator::make($input,$rules);

		if($validation->fails())

		{

			return back()->withErrors($validation)->withInput();

		}



		$insert = new Downloads();

		$insert->products = $input["downloadProducts"];

		//Brochure

		if($req->hasFile('uploadBrochure'))

	    {

	        $file = $req->file('uploadBrochure');

	        $destinationPath = 'backend/uploads/pages/'; // upload path

	        $extension = $file->getClientOriginalExtension(); // getting file extension

	        $fileName = rand(11111, 99999) . '.' . $extension; // renameing image

	        $upload_success = $file->move($destinationPath, $fileName); // uploading file to given path

	        $img_url = $destinationPath.$fileName;

	        $url = URL::asset($img_url);

	        $insert->productBrochure = $url;

	    }

	    //Certification

		if($req->hasFile('uploadCertification'))

	    {

	        $file = $req->file('uploadCertification');

	        $destinationPath = 'backend/uploads/pages/'; // upload path

	        $extension = $file->getClientOriginalExtension(); // getting file extension

	        $fileName = rand(11111, 99999) . '.' . $extension; // renameing image

	        $upload_success = $file->move($destinationPath, $fileName); // uploading file to given path

	        $img_url = $destinationPath.$fileName;

	        $url = URL::asset($img_url);

	        $insert->productCertification = $url;

	    }

	    //Poster

		if($req->hasFile('uploadPoster'))

	    {

	        $file = $req->file('uploadPoster');

	        $destinationPath = 'backend/uploads/pages/'; // upload path

	        $extension = $file->getClientOriginalExtension(); // getting file extension

	        $fileName = rand(11111, 99999) . '.' . $extension; // renameing image

	        $upload_success = $file->move($destinationPath, $fileName); // uploading file to given path

	        $img_url = $destinationPath.$fileName;

	        $url = URL::asset($img_url);

	        $insert->productPoster = $url;

	    }

		$insert->addedByID = Auth::User()->id;

		$insert->addedByName = Auth::User()->userName;

		$insert->save();

		return back()->with("success", "Download info added successfully :)");

	}



	public function getmodifydownload($id){

		$products = Productdetails::lists("productname", "id");

		$download = Downloads::find($id);

		return view("backend/downloads/modifyDownload")->with(["products"=>$products,"download"=>$download]);

	}



	public function postmodifydownload(Request $req,$id){

		$input = $req->all();

		$rules = [

			"downloadProducts"=>"required|unique:downloads,products,".$id,

			"uploadBrochure"=>"mimes:jpg,jpeg,png,pdf",

			"uploadCertification"=>"mimes:jpg,jpeg,png,pdf",

			"uploadPoster"=>"mimes:jpg,jpeg,png,pdf"

		];

		$validation = Validator::make($input,$rules);

		if($validation->fails())

		{

			return back()->withErrors($validation)->withInput();

		}



		$modify = Downloads::find($id);

		$modify->products = $input["downloadProducts"];

		//Brochure

		if($req->hasFile('uploadBrochure'))

	    {

	    	$unlinkurl = explode('pages/',$modify->productBrochure);

	        unlink(public_path()."/backend/uploads/pages/".end($unlinkurl));

	        $file = $req->file('uploadBrochure');

	        $destinationPath = 'backend/uploads/pages/'; // upload path

	        $extension = $file->getClientOriginalExtension(); // getting file extension

	        $fileName = rand(11111, 99999) . '.' . $extension; // renameing image

	        $upload_success = $file->move($destinationPath, $fileName); // uploading file to given path

	        $img_url = $destinationPath.$fileName;

	        $url = URL::asset($img_url);

	        $modify->productBrochure = $url;

	    }

	    //Certification

		if($req->hasFile('uploadCertification'))

	    {

	    	$unlinkurl = explode('pages/',$modify->productCertification);

	        unlink(public_path()."/backend/uploads/pages/".end($unlinkurl));

	        $file = $req->file('uploadCertification');

	        $destinationPath = 'backend/uploads/pages/'; // upload path

	        $extension = $file->getClientOriginalExtension(); // getting file extension

	        $fileName = rand(11111, 99999) . '.' . $extension; // renameing image

	        $upload_success = $file->move($destinationPath, $fileName); // uploading file to given path

	        $img_url = $destinationPath.$fileName;

	        $url = URL::asset($img_url);

	        $modify->productCertification = $url;

	    }

	    //Poster

		if($req->hasFile('uploadPoster'))

	    {

	    	$unlinkurl = explode('pages/',$modify->productPoster);

	        unlink(public_path()."/backend/uploads/pages/".end($unlinkurl));

	        $file = $req->file('uploadPoster');

	        $destinationPath = 'backend/uploads/pages/'; // upload path

	        $extension = $file->getClientOriginalExtension(); // getting file extension

	        $fileName = rand(11111, 99999) . '.' . $extension; // renameing image

	        $upload_success = $file->move($destinationPath, $fileName); // uploading file to given path

	        $img_url = $destinationPath.$fileName;

	        $url = URL::asset($img_url);

	        $modify->productPoster = $url;

	    }

		$modify->updatedByID = Auth::User()->id;

		$modify->updatedByName = Auth::User()->userName;

		$modify->save();

		return back()->with("success", "Download info modified successfully :)");

	}



	public function getdownloads(){

		$downloads = Downloads::orderBy("id", "DESC")->get();

		return view("backend/downloads/downloads")->with("downloads", $downloads);

	}



	public function postdownloadsdelete(Request $req){

		try

      	{

        	$input = $req->input('id');

        	$download = Downloads::find($input);

        	if($download)

        	{

        		//Brochure

        		$unlinkurl = explode('pages/',$download->productBrochure);

	          	unlink(public_path()."/backend/uploads/pages/".end($unlinkurl));

	          	//Certification

        		$unlinkurl = explode('pages/',$download->productCertification);

	          	unlink(public_path()."/backend/uploads/pages/".end($unlinkurl));

	          	//Poster

        		$unlinkurl = explode('pages/',$download->productPoster);

	          	unlink(public_path()."/backend/uploads/pages/".end($unlinkurl));

        	}

        	$download->delete();

        	//$con = 'Offer slider deleted by '.Auth::user()->userName.'. (User Id: '.Auth::user()->userId.')';

        	//TrackingReport::track('offer slider',$con,'','','delete');

        	return Response::json(["status"=>"success","msg"=>"Deleted Successfully"]);

      	}

	    catch(Exception $e)

	    {

	        //TrackingReport::track("error",$e->getMessage(),"","","offer slider delete ");

	        return Response::json(["status"=>"error"]);

	    }

	}



	//System Logs

	public function getsystemlogs(){

		return view("backend/logs/systemLogs");

	}



	public function postsystemlogs(Request $req){

		$inputs = $req->input('form');

		parse_str($inputs,$input);

		$query = DB::table('trackingreports')->orderBy('id','desc');

		if($input['dateFrom'] != ''){

			$query = $query->where(DB::raw('date(created_at)'),'>=',date('Y-m-d',strtotime($input['dateFrom'])));

		}

		if($input['dateTo'] != ''){

			$query=$query->where(DB::raw('date(created_at)'),'<=',date('Y-m-d',strtotime($input['dateTo'])));

		}

		// if($input['user'] != '')

		// {

		// 	$query = $query->where('userid',$input['user']);

		// }

		if($input['logType'] != ''){

			$query = $query->where('logType',$input['logType']);

		}

		if($input['process'] != ''){

			$query=$query->where('process',$input['process']);

		}

		$query = $query->get();

		$result = [];

		$i = 1;

		$count = count($query);

		foreach($query as $query)

		{

			$result[$i]['sNo'] = $i;

			$result[$i]['name'] = $query->userName;

			$result[$i]['logType'] = ucfirst($query->logType);

			$result[$i]['process'] = $query->process;

			$result[$i]['date'] = date(Option::fetchDateFormat()." ".Option::fetchTimeFormat(), strtotime($query->created_at));

			$result[$i]['activity'] = $query->activity;

			$i++;

		}

		return Response::json(['status'=>'success','count'=>$count,'result'=>$result]);

	}



	//Menu manage start

	public function categoryreorderpage(){

		$category=Category::where('status','active')->get();

		$menuOrder=Menumanage::where('parentId','0')->get();

		$activemenu=Menumanage::pluck('categoryId');

		return view('backend.storefront.reorderCategories')->with('category',$category)->with('menuOrder',$menuOrder)->with('activemenu',$activemenu);

	}





	public function categoryreorderpost(Request $req){

		$input=json_decode($req->input('data'));

		Menumanage::truncate();

		foreach($input as $record){

			$firstId=$record->id;

			$firstInsert=new Menumanage();

			$firstInsert->categoryId=$firstId;

			$firstInsert->parentId=0;

			$firstInsert->save();



			if(isset($record->children)){

				foreach($record->children as $record){

					$secondId=$record->id;

					$secondInsert=new Menumanage();

					$secondInsert->categoryId=$secondId;

					$secondInsert->parentId=$firstId;

					$secondInsert->save();



					if(isset($record->children)){

						foreach($record->children as $record){

							$thirdId=$record->id;

							$thirdInsert=new Menumanage();

							$thirdInsert->categoryId=$thirdId;

							$thirdInsert->parentId=$secondId;

							$thirdInsert->save();

						}

					}

				}

			}

		}



		return Response::json(['status'=>'success']);

	}





	public function addadminmenuget(){

		$menutable = Adminmenu::where('status','!=','deleted')->get();

		return view('backend.settings.adminmenus')->with('menutable',$menutable);

	}



	public function addadminmenupost(Request $req){

		$inputs = $req->input('q');

		parse_str($inputs,$input);

		$edit = $req->input('edit');

		if($edit == ''){

			$rules=['menuname'=>'required','menutype'=>'required']; 

			$msg = ['required'=>'this field is required.']; 

			$validation=Validator::make($input,$rules,$msg);

	        if($validation->fails()){

	             return Response::json(['status'=>'validation','val'=>$validation->messages()]);

	        }

			$insert=new Adminmenu();

			$insert->menuname=$input['menuname'];

			$insert->menutype=$input['menutype'];

			$insert->url=$input['menuurl'];

			$insert->menuicon=$input['menuicon'];

			$insert->status='active';

			$insert->save();

			return Response::json(['status'=>'success','id'=>$insert->id]);

		}else{

			$update=Adminmenu::find($edit);

			$update->menuname=$input['menuname'];

			$update->menutype=$input['menutype'];

			$update->url=$input['menuurl'];

			$update->menuicon=$input['menuicon'];

			$update->save();

			return Response::json(['status'=>'success','id'=>'','menuname'=>$input['menuname']]);

		}		



		

	}





	public function statusadminmenupost(Request $req){

		try{

			$cid = $req->input('cid');

			$category = Adminmenu::where('id',$cid)->first();

			if($category){

				$update = Adminmenu::find($cid);

				if($category->status == 'inactive'){

					$query = DB::table('adminmenumanage')->where('menuId',$cid)->update(['status'=>'active']);

					$update->status = 'active'; $cl = 'btn-primary';

				}else{

					$query = DB::table('adminmenumanage')->where('menuId',$cid)->update(['status'=>'inactive']);

					$update->status = 'inactive'; $cl = 'btn-danger';

				}

				$update->save();





				if($category->status == 'inactive'){

					$update->status = 'active'; $cl = 'btn-primary';

				}else{

					$update->status = 'inactive'; $cl = 'btn-danger';

				}

				if($update->save()){

					return Response::json(['status'=>'success','st'=>ucfirst($update->status),'msg'=>'Updated successfully.','ct'=>$cl]);

				}

			}

		}catch(Exception $e){

			return Response::json(['status'=>'error','msg'=>$e->messages()]);

		}

			return Response::json(['status'=>'error','msg'=>'Error processing your request.']);

	}





	public function editadminmenupost(Request $req){

		$id=$req->input('id');

		$select=Adminmenu::find($id);

		$name=$select->menuname;

		$menutype=$select->menutype;

		$url=$select->url;

		$icon=$select->menuicon;

		return Response::json(['status'=>'success','name'=>$name,'type'=>$menutype,'url'=>$url,'icon'=>$icon]);

	}







	public function adminmenumanagerget(){

		$adminmenu=Adminmenu::where('status','active')->where('menutype','sidebar')->get();

		$menuOrder=Adminmenumanage::where('parentId','0')->where('status','active')->get();

		$activemenu=Adminmenumanage::pluck('menuId');

		return view('backend.settings.adminMenuManager')->with('adminmenu',$adminmenu)->with('menuOrder',$menuOrder)->with('activemenu',$activemenu);

	}





	public function adminmenumanagerpost(Request $req){

		$input=json_decode($req->input('data'));

		Adminmenumanage::truncate();

		foreach($input as $record){

			$firstId=$record->id;

			$firstInsert=new Adminmenumanage();

			$firstInsert->menuId=$firstId;

			$firstInsert->parentId=0;

			$firstInsert->save();



			if(isset($record->children)){

				foreach($record->children as $record){

					$secondId=$record->id;

					$secondInsert=new Adminmenumanage();

					$secondInsert->menuId=$secondId;

					$secondInsert->parentId=$firstId;



					$secondInsert->save();



					if(isset($record->children)){

						foreach($record->children as $record){

							$thirdId=$record->id;

							$thirdInsert=new Adminmenumanage();

							$thirdInsert->menuId=$thirdId;

							$thirdInsert->parentId=$secondId;

							$thirdInsert->save();

						}

					}

				}

			}

		}



		return Response::json(['status'=>'success']);

	}







	public function userrole(){

		$roles=Usergroup::where('status','!=','deleted')->get();

		return view('backend.users.userrole')->with('roles',$roles);

	}





	public function adduserroleget(){

			$menus=Adminmenumanage::where('parentId',0)->where('status','active')->get();

		   return view('backend.users.adduserrole')->with('menus',$menus);

	}





	public function adminmenudelete(Request $req){

		$input=$req->input('id');

		$users=Adminmenu::find($input);

		$users->status="deleted";

		$users->save();

		$query = DB::table('adminmenumanage')->where('menuId',$input)->update(['status'=>'deleted']);

		return Response::json(["status"=>"success","msg"=>"Admin menu has been deleted successfully"]);

	}



	public function adduserrolepost(Request $req){

		$roleName=$req->input('roleName');

		$details=$req->input('details');



		$count=Usergroup::where('name',$roleName)->count();

		if($count==1){

			return Response::json(['status'=>'validation','val'=>'User role name already taken.']);

		}



		$insert=new Usergroup();

		$insert->name=$roleName;

		$insert->status='active';

		$insert->save();



		$roleId=$insert->id;



		



		foreach($details as $record)

		{

			$insert=new Usergroupmeta();

			$insert->usergroupId=$roleId;

			$insert->pageId=$record['menuId'];

			$insert->mainMenuID = Adminmenumanage::getMainMenuID($record['menuId']);

			$insert->viewPermission=$record['view'];

			$insert->createPermission=$record['create'];

			$insert->updatePermission=$record['update'];

			$insert->deletePermission=$record['deleteId'];

			$insert->save();

			unset($insert);

		}



		return Response::json(['status'=>'success','msg'=>'New user role added successfully.']);

	}



	public function userrolestatus(Request $req){

		$input=$req->input('id');

		$users=Usergroup::find($input);

		$status=$users->status=="active"?$current="inactive":$current="active";

		$users->status=$current;

		$users->save();

		return Response::json(["status"=>"success","msg"=>"User role status has been updated successfully","current"=>ucfirst($current)]);

	}





	public function userroledelete(Request $req){

		$input=$req->input('id');

		$users=Usergroup::find($input);

		$users->status="deleted";

		$users->save();

		return Response::json(["status"=>"success","msg"=>"User role has been deleted successfully"]);

	}



	public function userrolemodifyget($id){

		$menus=Adminmenumanage::where('parentId',0)->where('status','active')->get();

		$role=Usergroup::where('id',$id)->first();

		$rolename = '';

		if($role){

			$rolename = $role->name;

		}

		return view('backend.users.modifyuserrole')->with(['menus'=>$menus,'roleName'=>$rolename,'roleId'=>$id]);

	}



	public function userrolemodifypost(Request $req){

			//return $req->all();die();

		$roleName = $req->input('roleName');

		$details = $req->input('details');

		$roleId = $req->input('roleId');

		$update = Usergroup::find($roleId);

		$update->name = $roleName;

		$update->save();



		Usergroupmeta::where('usergroupId',$roleId)->delete();

		foreach($details as $record)

		{

			$insert=new Usergroupmeta();

			$insert->usergroupId = $roleId;

			$insert->pageId = $record['menuId'];

			$insert->mainMenuID = Adminmenumanage::getMainMenuID($record['menuId']);

			$insert->viewPermission = $record['view'];

			$insert->createPermission = $record['create'];

			$insert->updatePermission = $record['update'];

			$insert->deletePermission = $record['deleteId'];

			$insert->save();

			unset($insert);

		}



		return Response::json(['status'=>'success','msg'=>'New user role updated successfully.']);

	}



	//CMS Pages

	public function aboutget(){

		$details=Cmspages::where('type','about')->first();

		if($details){

			$title=$details->title;

			$content=$details->content;

		}else{

			$title='';

			$content='';

		}

		return view('backend.storefront.about')->with('title',$title)->with('content',$content);

	}



	public function aboutpost(Request $req){

		$input=$req->input();

		$rules=["pageTitle"=>"required","pageContent"=>"required"];

		$validation=Validator::make($input,$rules);

		if($validation->fails()){

			return redirect("admin/storefront/cms/about")->withErrors($validation)->withInput();

		}

		Cmspages::where('type','about')->delete();

		$insert=new Cmspages();

		$insert->type='about';

		$insert->title=$input['pageTitle'];

		$insert->content=$input['pageContent'];

		$insert->save();

		return redirect("admin/storefront/cms/about")->with("success","About page details saved successfully.");

	}





	public function privacyget(){

		$details=Cmspages::where('type','privacy')->first();

		if($details){

			$title=$details->title;

			$content=$details->content;

		}else{

			$title='';

			$content='';

		}

		return view('backend.storefront.privacy')->with('title',$title)->with('content',$content);

	}



	public function privacypost(Request $req){

		$input=$req->input();

		$rules=["pageTitle"=>"required","pageContent"=>"required"];

		$validation=Validator::make($input,$rules);

		if($validation->fails()){

			return redirect("admin/storefront/cms/privacy")->withErrors($validation)->withInput();

		}

		Cmspages::where('type','privacy')->delete();

		$insert=new Cmspages();

		$insert->type='privacy';

		$insert->title=$input['pageTitle'];

		$insert->content=$input['pageContent'];

		$insert->save();

		return redirect("admin/storefront/cms/privacy")->with("success","Privacy policy details saved successfully.");

	}





	public function termsget(){

		$details=Cmspages::where('type','terms')->first();

		if($details){

			$title=$details->title;

			$content=$details->content;

		}else{

			$title='';

			$content='';

		}

		return view('backend.storefront.terms')->with('title',$title)->with('content',$content);

	}



	public function termspost(Request $req){

		$input=$req->input();

		$rules=["pageTitle"=>"required","pageContent"=>"required"];

		$validation=Validator::make($input,$rules);

		if($validation->fails()){

			return redirect("admin/storefront/cms/terms")->withErrors($validation)->withInput();

		}

		Cmspages::where('type','terms')->delete();

		$insert=new Cmspages();

		$insert->type='terms';

		$insert->title=$input['pageTitle'];

		$insert->content=$input['pageContent'];

		$insert->save();

		return redirect("admin/storefront/cms/terms")->with("success","Terms & Conditions details saved successfully.");

	}





	public function addfaqget(){

		return view('backend.storefront.addfaq');

	}



	public function addfaqpost(Request $req){

		$input = $req->input();

		$rules = [

			"question"=>"required",

			"answer"=>"required"

		];

		$validation = Validator::make($input,$rules);

		if($validation->fails()){

			return redirect("admin/storefront/cms/faq/add")->withErrors($validation)->withInput();

		}

		$insert = new Cmspages();

		$insert->type = 'faq';

		$insert->title = $input['question'];

		$insert->content = $input['answer'];

		$insert->status = 'active';

		$insert->save();

		return redirect("admin/storefront/cms/faq/add")->with("success","New FAQ added successfully.");

	}



	public function faqget(){

		$faqs = Cmspages::where('type', 'faq')->where('status', '!=', 'deleted')->get();

		return view('backend.storefront.faq')->with('faqs', $faqs);

	}



	public function faqstatus(Request $req){

		$input=$req->input('id');

		$users=Cmspages::find($input);

		$status=$users->status=="active"?$current="inactive":$current="active";

		$users->status=$current;

		$users->save();

		return Response::json(["status"=>"success","msg"=>"FAQ status has been updated successfully","current"=>ucfirst($current)]);

	}



	public function faqdelete(Request $req){

		$input=$req->input('id');

		$users=Cmspages::find($input);

		$users->status="deleted";

		$users->save();

		return Response::json(["status"=>"success","msg"=>"FAQ has been deleted successfully"]);

	}



	public function modifyfaqget($id){

		$faqs=Cmspages::find($id);

		$question=$faqs->title;

		$answer=$faqs->content;

		return view('backend.storefront.modifyfaq')->with(['question'=>$question,'answer'=>$answer,'editId'=>$id]);

	}



	public function modifyfaqpost(Request $req){

		$input=$req->input();

		$rules=["question"=>"required","answer"=>"required"];

		$validation=Validator::make($input,$rules);

		if($validation->fails()){

			return redirect("admin/storefront/cms/faq/modify/".$input['editId'])->withErrors($validation)->withInput();

		}

		$update=Cmspages::find($input['editId']);

		$update->title=$input['question'];

		$update->content=$input['answer'];

		$update->save();

		return redirect("admin/storefront/cms/faq/modify/".$input['editId'])->with('success','FAQ details updated successfully.');

	}



	public function imageupload(){

	    $year = date('Y');

	    $month = date('m');

	    $options = array('accept_file_types' => '/\.(gif|jpe?g|png)$/i',

	            'upload_dir'=>'uploads/'.$year.'/'.$month.'/', 

	            'upload_url'=>'uploads/'.$year.'/'.$month.'/', 

	            'image_versions' => array(),

	        );

	    $upload_handler = new UploadHandler($options);

	}





	public function imageuploadwiththumbnail(Request $req){

		try{

			$year = date('Y');

		    $month = date('m'); $input = $req->input();

		    if(isset($input['type'])){ $type = $req->input('type'); }else{ $type = ''; }

		    $max_width = 80; $max_height = 80; $max_width1 = 40; $max_height1 = 40;

		     $uurl = public_path().'/frontend/uploads/'.$year.'/'.$month.'/'.'thumbnail';

		     $uurl1 = public_path().'/frontend/uploads/'.$year.'/'.$month.'/'.'thumbnail1';

		    if (!file_exists($uurl)) {

			    mkdir($uurl, 0777, true);

			}



			if (!file_exists($uurl1)) {

			    mkdir($uurl1, 0777, true);

			}



		    if($type == 'gallery'){ 

		    	if(Option::getvalue('storeproduct_thumbnailimgwidth')!='' && Option::getvalue('storeproduct_thumbnailimgwidth')!=''){ 

		    		$max_width = Option::getvalue('storeproduct_productimgwidth');

		    		$max_height = Option::getvalue('storeproduct_productimgheight');



		    		$max_width1 = Option::getvalue('storeproduct_productimgwidth');

		    		$max_height1 = Option::getvalue('storeproduct_productimgheight');

		    	}

		    }

		     $options = array('accept_file_types' => '/\.(gif|jpe?g|png)$/i',

		            'upload_dir'=>'uploads/'.$year.'/'.$month.'/', 

		            'upload_url'=>'uploads/'.$year.'/'.$month.'/', 

		            'image_versions' => array(

		                'thumbnail' => array(

		                    'max_width' => $max_width,

		                    'max_height' => $max_height,

		                ),

		                 'thumbnail1' => array(

		                    'max_width' => $max_width1,

		                    'max_height' => $max_height1

		                )

		            )

		        );

		    $upload_handler = new UploadHandler($options);



		    //return response()->json(['status' => 'success', 'result' => $upload_handler]);

		

		}catch(\Exception $e){

			return response()->json(['status' => 'error', 'msg' => $e->getMessage()."_".$e->getLine()]);

		}

	 //    $year = date('Y');

	 //    $month = date('m'); $input = $req->input();

	 //    if(isset($input['type'])){ $type = $req->input('type'); }else{ $type = ''; }

	 //    $max_width = 80; $max_height = 80; $max_width1 = 40; $max_height1 = 40;

	 //     $uurl = public_path().'/frontend/uploads/'.$year.'/'.$month.'/'.'thumbnail';

	 //     $uurl1 = public_path().'/frontend/uploads/'.$year.'/'.$month.'/'.'thumbnail1';

	 //    if (!file_exists($uurl)) {

		//     mkdir($uurl, 0777, true);

		// }



		// if (!file_exists($uurl1)) {

		//     mkdir($uurl1, 0777, true);

		// }



	 //    if($type == 'gallery'){ 

	 //    	if(Option::getvalue('storeproduct_thumbnailimgwidth')!='' && Option::getvalue('storeproduct_thumbnailimgwidth')!=''){ 

	 //    		$max_width = Option::getvalue('storeproduct_productimgwidth');

	 //    		$max_height = Option::getvalue('storeproduct_productimgheight');



	 //    		$max_width1 = Option::getvalue('storeproduct_productimgwidth');

	 //    		$max_height1 = Option::getvalue('storeproduct_productimgheight');

	 //    	}

	 //    }

	 //     $options = array('accept_file_types' => '/\.(gif|jpe?g|png)$/i',

	 //            'upload_dir'=>'uploads/'.$year.'/'.$month.'/', 

	 //            'upload_url'=>'uploads/'.$year.'/'.$month.'/', 

	 //            'image_versions' => array(

	 //                'thumbnail' => array(

	 //                    'max_width' => $max_width,

	 //                    'max_height' => $max_height,

	 //                ),

	 //                 'thumbnail1' => array(

	 //                    'max_width' => $max_width1,

	 //                    'max_height' => $max_height1

	 //                )

	 //            )

	 //        );

	 //    $upload_handler = new UploadHandler($options);

	}



	public function storeimages(Request $req){

		$url = $req->input('u'); 

		$key = $req->input('key');

		$upload = DB::table('upload')->insertGetId(['path'=>$url]);

		Option::storetooption($key, $upload);

		return Response::json(['status'=>'success']);

	}



	public function headertooption(Request $req){

		$inputs = $req->input();

		foreach($inputs as $key => $val){

				if($key == 'header_logo' || $key == 'header_favicon'){

					if(Option::checkifoptionkey($key) == 'yes'){

						$ops = Option::where('key',$key)->first();

						$id = $ops->value; Upload::where('id', $id)->update(['path'=>$val]);

					}

				}else{

					Option::storetooption($key, $val);

				}

		}

		if(!isset($inputs['header_scrolltotopbutton'])){ Option::storetooption('header_scrolltotopbutton',''); }

		if(!isset($inputs['header_signupbutton'])){ Option::storetooption('header_signupbutton',''); }

		return Response::json(['status'=>'success','msg'=>'Settings Saved.']);

	}



	public function footertooption(Request $req){

		$inputs = $req->input();

		foreach($inputs as $key => $val)

		{

				if($key == 'header_logo' || $key == 'header_favicon' || $key == 'footer_icon')

				{

					if(Option::checkifoptionkey($key) == 'yes')

					{

						$ops = Option::where('key',$key)->first();

						$id = $ops->value; Upload::where('id',$id)->update(['path'=>$val]);

					}

				}

				else

				{

					Option::storetooption($key,$val);

				}

		}

		if(!isset($inputs['footer_subscriptionform'])){ Option::storetooption('footer_subscriptionform',''); }

		// if(!isset($inputs['header_signupbutton'])){ Option::storetooption('header_signupbutton',''); }

		return Response::json(['status'=>'success','msg'=>'Settings Saved.']);

	}



	public function socialtooption(Request $req){

		$inputs = $req->input();

		foreach($inputs as $key => $val){ Option::storetooption($key,$val); }

		if(!isset($inputs['social_facebookicon'])){ Option::storetooption('social_facebookicon',''); }

		if(!isset($inputs['social_twittericon'])){ Option::storetooption('social_twittericon',''); }

		if(!isset($inputs['social_googleplusicon'])){ Option::storetooption('social_googleplusicon',''); }

		if(!isset($inputs['social_emailicon'])){ Option::storetooption('social_emailicon',''); }

		return Response::json(['status'=>'success','msg'=>'Settings Saved.']);

	}



	public function storegeneraltooption(Request $req){

		$inputs = $req->input();

		foreach($inputs as $key => $val){ Option::storetooption($key,$val); }

		return Response::json(['status'=>'success','msg'=>'Settings Saved.']);

	}



	public function storefootericonimages(Request $req){

		$url = $req->input('u'); 

		$key = $req->input('key');

		$upload = DB::table('upload')->insertGetId(['path'=>$url]);

		if(Option::checkifoptionkey('footer_icon') == 'yes'){

			$ops = Option::where('key','footer_icon')->first();

			Option::where('key','footer_icon')->update(['value'=>$upload]);

		}else{

			Option::insert(['key'=>'footer_icon', 'value'=>$upload]);

		}

		return Response::json(['status'=>'success']);

	}



	public function statefromcountry(Request $req){

		$cid = $req->input('cid'); $html = '<option value="">Select City</option>';

		if($cid==''){ $cid = -23; }

		$statelist = Location::where('parentId',$cid)->where('locationType',1)->where('status','active')->get();

		foreach($statelist as $state){

			$html = $html.'<option value="'.$state->id.'">'.$state->name.'</option>';

		}

		return Response::json(['status'=>'success','list'=>$html]);

	}



	public function cityfromstate(Request $req){

		$sid = $req->input('sid'); $html = '';

		if($sid==''){ $sid = -23; }

		$citylist = Location::where('parentId',$sid)->where('locationType',2)->where('status','active')->get();

		foreach($citylist as $city){

			$html = $html.'<option value="'.$city->id.'">'.$city->name.'</option>';

		}

		return Response::json(['status'=>'success','list'=>$html]);

	}



	public function getfootersectionone(){

		return view("backend/storefront/footerSectionOne");

	}



	public function postfootersectionone(Request $req){

		$input = $req->all();

  		array_shift($input);

  		foreach($input as $key=>$val){

	    		$rules[$key] = "required";

  		}



  		$validation = Validator::make($input,$rules);

  		if($validation->fails()){

	      return back()->withInput()->withErrors($validation);

	    }



	    foreach($input as $k=>$v){

    		$count = CustomPages::where('fieldName',$k)->count();

	        if($count == 1){

	          	$update = CustomPages::where('fieldName',$k)->update(['fieldContent'=>$v, 'lastUpdate'=>date("Y-m-d H:i:s"), 'updatedByName'=>Auth::User()->userName, 'updatedByID'=>Auth::User()->id]);

	        }else{

	          	$insert = new CustomPages();

	          	$insert->fieldName = $k;

	          	$insert->fieldContent = $v;

	          	$insert->lastUpdate = date("Y-m-d H:i:s");

	          	$insert->updatedByName = Auth::User()->userName;

	          	$insert->updatedByID = Auth::User()->id;

	          	$insert->save();

	        }

	    }



	    return back()->with("success", "Info updated successfully!");

	}



	//Past Presidents

	public function getaddpastpresidentspage(){

		return view("backend/about/addPastPresidents");

	}



	public function addpastpresidentspost(Request $req){

		$input = $req->input();

		$rules = [

			"presidentName"=>"required",

			"yearRange"=>"required",

			'companyName'=>'required',

			'presidentsImage'=>'required',

		];

		$validation = Validator::make($input, $rules);

		if($validation->fails()){

			return redirect()->back()->withErrors($validation)->withInput();

		}

		$insert = new PastPresidents();

		$insert->presidentName = $input['presidentName'];

		$insert->yearRange = $input['yearRange'];

		$insert->companyName = $input['companyName'];

		$insert->presidentsImage = $input['presidentsImage'];

		$insert->status = "active";

		$insert->save();

		return redirect()->back()->withSuccess("Given info submitted successfully!!!");

	}



	public function getmodifypastpresidentspage($key){

		$id = Crypt::decrypt($key);

		$president = PastPresidents::find($id);

		return view("backend/about/modifyPastPresidents")->with("president", $president);

	}



	public function postmodifypastpresidentspage(Request $req, $key){

		$input = $req->input();

		$rules = [

			"presidentName"=>"required",

			"yearRange"=>"required",

			'companyName'=>'required',

			'presidentsImage'=>'required',

		];

		$validation = Validator::make($input, $rules);

		if($validation->fails()){

			return redirect()->back()->withErrors($validation)->withInput();

		}

		$id = Crypt::decrypt($key);

		$modify = PastPresidents::find($id);

		$modify->presidentName = $input['presidentName'];

		$modify->yearRange = $input['yearRange'];

		$modify->companyName = $input['companyName'];

		$modify->presidentsImage = $input['presidentsImage'];

		$modify->save();

		return redirect()->back()->withSuccess("Given info submitted successfully!!!");

	}



	public function getpastpresidentspage(){

		$presidents = PastPresidents::where("status", "!=", "deleted")->orderBy('id','DESC')->get();

		return view("backend/about/pastPresidents")->with("presidents", $presidents);

	}



	public function postpastpresidentsstatus(Request $req){

		$input = $req->input('id');

		$id = Crypt::decrypt($input);

		$president = PastPresidents::find($id);

		$status = $president->status == "active" ? $current = "inactive" : $current = "active";

		$president->status = $current;

		$president->save();

		return Response::json(["status"=>"success", "current"=>ucfirst($current), "msg"=>"Updated Successfully"]);

	}



	public function postpastpresidentsdelete(Request $req){

		$input = $req->input('id');

		$id = Crypt::decrypt($input);

		$president = PastPresidents::find($id);

		$president->status = "deleted";

		$president->save();

		return Response::json(["status"=>"success", "msg"=>"Deleted Successfully"]);

	}



	//Executive Committee Members

	public function getaddexecutivecommitteemembers(){

		return view("backend/about/addExecutiveCommitteeMembers");

	}



	public function postaddexecutivecommitteemembers(Request $req){

		$input = $req->input();

		$rules = [

			"yearTitle"=>"required",

			"membersDescription"=>"required",

		];

		$validation = Validator::make($input, $rules);

		if($validation->fails()){

			return redirect()->back()->withErrors($validation)->withInput();

		}

		$insert = new ExecutiveCommitteeMembers();

		$insert->yearTitle = $input['yearTitle'];

		$insert->membersDescription = $input['membersDescription'];

		$insert->status = "active";

		$insert->save();

		return redirect()->back()->withSuccess("Given info submitted successfully!!!");

	}



	public function getmodifyexecutivecommitteemembers($key){

		$id = Crypt::decrypt($key);

		$member = ExecutiveCommitteeMembers::find($id);

		return view("backend/about/modifyExecutiveCommitteeMembers")->with("member", $member);

	}



	public function postmodifyexecutivecommitteemembers(Request $req, $key){

		$input = $req->input();

		$rules = [

			"yearTitle"=>"required",

			"membersDescription"=>"required",

		];

		$validation = Validator::make($input, $rules);

		if($validation->fails()){

			return redirect()->back()->withErrors($validation)->withInput();

		}

		$id = Crypt::decrypt($key);

		$modify = ExecutiveCommitteeMembers::find($id);

		$modify->yearTitle = $input['yearTitle'];

		$modify->membersDescription = $input['membersDescription'];

		$modify->status = "active";

		$modify->save();

		return redirect()->back()->withSuccess("Given info submitted successfully!!!");

	}



	public function getexecutivecommitteememberspage(){

		$members = ExecutiveCommitteeMembers::where("status", "!=", "deleted")->orderBy('id', 'DESC')->get();

		return view("backend/about/executiveCommitteeMembers")->with("members", $members);

	}



	public function postexecutivecommitteemembersstatus(Request $req){

		$input = $req->input('id');

		$id = Crypt::decrypt($input);

		$committee = ExecutiveCommitteeMembers::find($id);

		$status = $committee->status == "active" ? $current = "inactive" : $current = "active";

		$committee->status = $current;

		$committee->save();

		return Response::json(["status"=>"success", "current"=>ucfirst($current), "msg"=>"Updated Successfully"]);

	}



	public function postexecutivecommitteemembersdelete(Request $req){

		$input = $req->input('id');

		$id = Crypt::decrypt($input);

		$committee = ExecutiveCommitteeMembers::find($id);

		$committee->status = "deleted";

		$committee->save();

		return Response::json(["status"=>"success", "msg"=>"Deleted Successfully"]);

	}



	//Faculty

	public function getaddfacultiespage(){

		return view("backend/courses/addFaculties");

	}



	public function addfacultiespost(Request $req){

		$input = $req->input();

		$rules = [

			"facultyName"=>"required",

			"facultyDesignation"=>"required",

			'description'=>'required',

			'facultyImage'=>'required',

		];

		$validation = Validator::make($input, $rules);

		if($validation->fails()){

			return redirect()->back()->withErrors($validation)->withInput();

		}

		$insert = new Faculties();

		$insert->facultyName = $input['facultyName'];

		$insert->facultyDesignation = $input['facultyDesignation'];

		$insert->description = $input['description'];

		$insert->facultyImage = $input['facultyImage'];

		$insert->status = "active";

		$insert->save();

		return redirect()->back()->withSuccess("Given info submitted successfully!!!");

	}



	public function getmodifyfacultiespage($key){

		$id = Crypt::decrypt($key);

		$faculty = Faculties::find($id);

		return view("backend/courses/modifyFaculties")->with("faculty", $faculty);

	}



	public function postmodifyfacultiespage(Request $req, $key){

		$input = $req->input();

		$rules = [

			"facultyName"=>"required",

			"facultyDesignation"=>"required",

			'description'=>'required',

			'facultyImage'=>'required',

		];

		$validation = Validator::make($input, $rules);

		

		if($validation->fails()){

			return redirect()->back()->withErrors($validation)->withInput();

		}



		$id = Crypt::decrypt($key);

		$modify = Faculties::find($id);

		$modify->facultyName = $input['facultyName'];

		$modify->facultyDesignation = $input['facultyDesignation'];

		$modify->description = $input['description'];

		$modify->facultyImage = $input['facultyImage'];

		$modify->save();

		return redirect()->back()->withSuccess("Given info submitted successfully!!!");

	}



	public function getfacultiespage(){

		$faculties = Faculties::where("status", "!=", "deleted")->get();

		return view("backend/courses/faculties")->with("faculties", $faculties);

	}



	public function postfacultiesstatus(Request $req){

		$input = $req->input('id');

		$id = Crypt::decrypt($input);

		$faculty = Faculties::find($id);

		$status = $faculty->status == "active" ? $current = "inactive" : $current = "active";

		$faculty->status = $current;

		$faculty->save();

		return Response::json(["status"=>"success", "current"=>ucfirst($current), "msg"=>"Updated Successfully"]);

	}



	public function postfacultiesdelete(Request $req){

		$input = $req->input('id');

		$id = Crypt::decrypt($input);

		$faculty = Faculties::find($id);

		$faculty->status = "deleted";

		$faculty->save();

		return Response::json(["status"=>"success", "msg"=>"Deleted Successfully"]);

	}



	//Courses Applied

	public function getcoursesappliedpage(){

		return view("backend/courses/coursesApplied");

	}



	public function postcoursesappliedpage(Request $req){

		try {

			$input = $req->all();

			$query = DB::table('courseapplied');

			

			if($input['dateFrom'] != ''){

				$dateFrom = date('Y-m-d', strtotime($input['dateFrom']));

				$query = $query->where('registration_date', '>=', $dateFrom);

			}



			if($input['dateTo'] != ''){

				$dateTo = date('Y-m-d', strtotime($input['dateTo']));

				$query = $query->where('registration_date', '<=', $dateTo);

			}



			if($input['paymentType'] != ''){

				$query = $query->where('paymentType', $input['paymentType']);

			}



			$query = $query->where('status', '!=', 'deleted')->select('id', 'unique_id', 'name', 'emailid', 'mobile', 'registration_date', 'paymentType', 'paymentStatus')->orderBy('registration_date', 'DESC')->get();

			if(count($query) > 0){

				$result = [];

				$i = 0;

				foreach($query as $que){

					$f = 'D, d-M-Y' . (date('H:i:s', strtotime($que->registration_date)) != '00:00:00' ? ' H:i:s' : '');

				    $date = new DateTime($que->registration_date);

				    $registeredDate = $date->format($f);



					$result[$i]['sno'] = $i + 1;

					$result[$i]['id'] = Crypt::encrypt($que->id);

					$result[$i]['unique_id'] = $que->unique_id;

					$result[$i]['name'] = $que->name;

					$result[$i]['emailid'] = $que->emailid;

					$result[$i]['mobile'] = $que->mobile;

					$result[$i]['registration_date'] = $que->registration_date;

					$result[$i]['paymentType'] = $que->paymentType;

					$result[$i]['paymentStatus'] = $que->paymentStatus;

					$i++;

				}

				return json_encode(["status"=>"success", "result"=>$result]);

			}

			return json_encode(["status"=>"failure"]);

		} catch (Exception $e) {

			//TrackingReport::track("error",$e->getMessage(),"","","course status");

	    	return Response::json(["status"=>"error"]);

		}

	}



	public function getmodifyappliedcourse($key){

		$id = Crypt::decrypt($key);

		$course = CourseApplied::findOrFail($id);

		if($course != NULL){

			return view('backend/courses/modifyAppliedCourse')->with(['course'=>$course]);

		}

		

		return "Records not found";

	}



	public function getuploadcoursesappliedtable(){

		return view("backend/courses/wp_course_application");

	}



	public function postmodifyappliedcourse(Request $req, $key){

		try {

            return DB::transaction(function() use($req, $key){

                $input = $req->all();

                $rules = [

                    "name"=>"required",

                    "father_name"=>"required",

                    "address1"=>"required",

                    "address2"=>"required",

                    "dob"=>"required|date",

                    "phone"=>"required",

                    "mobile"=>"required",

                    "emailid"=>"required",

                    "photo"=>"image|mimes:jpg,png,jpeg",

                    "comment"=>"required",

                ];

                $messages = [

                    "required"=>"You can't leave this field empty",

                    "image"=>"Please upload image file only",

                    "date"=>"Please enter a valid date",

                ];

                $validation = Validator::make($input, $rules, $messages);

                if($validation->fails()){

                    return redirect()->back()->withInput()->withErrors($validation);

                }



                $id = Crypt::decrypt($key);



                $url = "";

                if($req->hasFile('photo')){

                    $file = $req->file('photo');

                    $destinationPath = 'frontend/uploads/'; // upload path

                    $extension = $file->getClientOriginalExtension(); // getting file extension

                    $name = $file->getClientOriginalName();// getting original file name

                    $check = CourseApplied::checkimages(substr($name, 0, -(strlen($extension) + 1)), "/".$destinationPath, $extension);

                    $fileName = $check.'.'.$extension; // renameing image

                    $upload_success = $file->move($destinationPath, $fileName); // uploading file to given path

                    $img_url = $destinationPath.$fileName;

                    $url = URL::asset($img_url);

                }



                $education = array();

                for($i = 0;$i < $input["educationLength"];$i++){

                    $education[$i]['year'] = $input['year'.$i];

                    $education[$i]['school'] = $input['school'.$i];

                    $education[$i]['university'] = $input['university'.$i];

                    $education[$i]['degree'] = $input['degree'.$i];

                    $education[$i]['mark'] = $input['mark'.$i];

                }



                $education = json_encode($education);

                



                $experience = array();

                for($i = 0;$i < $input["experienceLength"];$i++){

                    $experience[$i]['period'] = $input['period'.$i];

                    $experience[$i]['organisation'] = $input['organisation'.$i];

                    $experience[$i]['designation'] = $input['designation'.$i];

                    $experience[$i]['work'] = $input['work'.$i];

                }

                $experience = json_encode($experience);



                $courseFee = 59000;



                $modify = CourseApplied::find($id);

                $modify->name = $input["name"];

                $modify->father_name = $input["father_name"];

                $modify->address1 = $input["address1"];

                $modify->address2 = $input["address2"];

                $modify->dob = date("Y-m-d", strtotime($input["dob"]));

                $modify->phone = $input["phone"];

                $modify->mobile = $input["mobile"];

                $modify->emailid = $input["emailid"];

                $modify->comment = $input["comment"];

                $modify->education = $education;

                $modify->workexp = $experience;

                

                if($url != ""){

                	$modify->photo = $url;

                }

                

                $modify->registration_date = date("Y-m-d H:i:s");

                $modify->courseFee = $courseFee;

                $modify->paymentType = $input["paymentType"];

                //$modify->status = "inactive";

                $modify->save();

                return redirect()->back()->withSuccess('Application details submitted successfully!!!');

            });

        } catch (Exception $e) {

            //Trackingreport::track("error", $e->getMessage(), "", "", "Course Application");

            return redirect()->back()->with("error", "Something went wrong");

        }

	}



	//Membership Main Page

	public function getmembershipfirstpage(){

		return view("backend/members/membership");

	}



	public function postmembershipfirstpage(Request $req){

		$input = $req->all();

  		array_shift($input);

  		foreach($input as $key=>$val){

  			if($key == "uploadMembershipRegForm" || $key == "uploadMembershipRenewalForm"){

	    		$rules[$key] = "mimes:pdf";

	    	}else{

	    		$rules[$key] = "required";

	    	}

  		}



  		$validation = Validator::make($input,$rules);

  		if($validation->fails()){

	      return back()->withInput()->withErrors($validation);

	    }



	    foreach($input as $k=>$v){

	    	if($k != "uploadMembershipRegForm" && $k != "uploadMembershipRenewalForm"){

	    		$count = CustomPages::where('fieldName', $k)->count();

		        if($count == 1){

		          	$update = CustomPages::where('fieldName', $k)->update(['fieldContent'=>$v, 'lastUpdate'=>date("Y-m-d H:i:s"), 'updatedByName'=>Auth::User()->userName, 'updatedByID'=>Auth::User()->id]);

		        }else{

		          	$insert = new CustomPages();

		          	$insert->fieldName = $k;

		          	$insert->fieldContent = $v;

		          	$insert->lastUpdate = date("Y-m-d H:i:s");

		          	$insert->updatedByName = Auth::User()->userName;

		          	$insert->updatedByID = Auth::User()->id;

		          	$insert->save();

		        }

	    	}

	    }



	    if($req->hasFile('uploadMembershipRegForm')){

	    	$count = CustomPages::where('fieldName', $k)->first();

	    	if($count && $count->fieldContent != ""){

	          	$unlinkurl = explode('pages/', $count->fieldContent);

	          	unlink(public_path()."/backend/uploads/pages/".end($unlinkurl));

	        }



	        $file = $req->file('uploadMembershipRegForm');

	        $destinationPath = 'backend/uploads/pages/'; // upload path

	        $name = $file->getClientOriginalName();// getting original file name

	        $extension = $file->getClientOriginalExtension(); // getting file extension

	        $check = CustomPages::checkFileNames(substr($name, 0, -(strlen($extension) + 1)), "/".$destinationPath, $extension);

	        $fileName = $check.'.'.$extension; // renameing image

	        $upload_success = $file->move($destinationPath, $fileName); // uploading file to given path

	        $img_url = $destinationPath.$fileName;

	        $url = URL::asset($img_url);

	        

	        if($count){

	          	$update = CustomPages::where('fieldName', 'uploadMembershipRegForm')->update(['fieldContent'=>$url, 'lastUpdate'=>date("Y-m-d H:i:s"), 'updatedByName'=>Auth::User()->userName, 'updatedByID'=>Auth::User()->id]);

	        }else{

	          	$insert = new CustomPages();

	          	$insert->fieldName = $k;

	          	$insert->fieldContent = $url;

	          	$insert->lastUpdate = date("Y-m-d H:i:s");

	          	$insert->updatedByName = Auth::User()->userName;

	          	$insert->updatedByID = Auth::User()->id;

	          	$insert->save();

	        }

	    }



	    if($req->hasFile('uploadMembershipRenewalForm')){

	    	$count = CustomPages::where('fieldName', $k)->first();

	    	if($count && $count->fieldContent != ""){

	          	$unlinkurl = explode('pages/', $count->fieldContent);

	          	unlink(public_path()."/backend/uploads/pages/".end($unlinkurl));

	        }



	        $file = $req->file('uploadMembershipRenewalForm');

	        $destinationPath = 'backend/uploads/pages/'; // upload path

	        $extension = $file->getClientOriginalExtension(); // getting file extension

            $name = $file->getClientOriginalName();// getting original file name

	        $check = CustomPages::checkFileNames(substr($name, 0, -(strlen($extension) + 1)), "/".$destinationPath, $extension);

	        $fileName = $check.'.'.$extension; // renameing image

	        $upload_success = $file->move($destinationPath, $fileName); // uploading file to given path

	        $img_url = $destinationPath.$fileName;

	        $url = URL::asset($img_url);

	        $count = CustomPages::where('fieldName', 'uploadMembershipRenewalForm')->first();

	        if($count){

	          	$update = CustomPages::where('fieldName', 'uploadMembershipRenewalForm')->update(['fieldContent'=>$url, 'lastUpdate'=>date("Y-m-d H:i:s"), 'updatedByName'=>Auth::User()->userName, 'updatedByID'=>Auth::User()->id]);

	        }else{

	          	$insert = new CustomPages();

	          	$insert->fieldName = $k;

	          	$insert->fieldContent = $url;

	          	$insert->lastUpdate = date("Y-m-d H:i:s");

	          	$insert->updatedByName = Auth::User()->userName;

	          	$insert->updatedByID = Auth::User()->id;

	          	$insert->save();

	        }

	    }

	    return back()->withSuccess("Info updated successfully!");

	}



	//Individual Members

	public function getindividualmemberspage(){

		return view("backend/members/individualMembers");

	}



	public function postindividualmemberspage(Request $req){

		try {

			$input = $req->all();

			$members = Members::where('mem_category', '!=', 'corporate')->where('status', '!=', 'deleted');

			

			if($input['dateFrom'] != ''){

				$members = $members->where(DB::raw('date(date_registered)'), '>=', date('Y-m-d', strtotime($input['dateFrom'])));

			}



			if($input['dateTo'] != ''){

				$members = $members->where(DB::raw('date(date_registered)'), '<=', date('Y-m-d', strtotime($input['dateTo'])));

			}



			if($input['membershipID'] != ''){

				$members = $members->where('unique_id', '=', $input['membershipID']);

			}



			if($input['membership'] != ''){

				$members = $members->where('mem_category', '=', $input['membership']);

			}



			$members = $members->get();

			return $members;

		} catch (Exception $e) {

			//Trackingreport::track("error", $e->getMessage(), "", "", "Course Application");

            return redirect()->back()->with("error", "Something went wrong");

		}

	}





	public function statusindividualpost(Request $req){

		$input=$req->input('id');

		$users=Members::find($input);

		$status=$users->status=="active"?$current="inactive":$current="active";

		$users->status=$current;

		$users->save();

		return Response::json(["status"=>"success","current"=>ucfirst($current),"msg"=>"Updated Successfully"]);

	}



	//Corporate Members

	public function getcorporatememberspage(){

		return view("backend/members/corporateMembers");

	}



	public function postcorporatememberspage(Request $req){

		try {

			$input = $req->all();

			$members = Members::where('mem_category', '=', 'corporate')->where('status', '!=', 'deleted');

			

			if($input['dateFrom'] != ''){

				$members = $members->where(DB::raw('date(date_registered)'), '>=', date('Y-m-d', strtotime($input['dateFrom'])));

			}



			if($input['dateTo'] != ''){

				$members = $members->where(DB::raw('date(date_registered)'), '<=', date('Y-m-d', strtotime($input['dateTo'])));

			}



			if($input['membershipID'] != ''){

				$members = $members->where('unique_id', '=', $input['membershipID']);

			}



			$members = $members->get();

			return $members;

		} catch (Exception $e) {

			//Trackingreport::track("error", $e->getMessage(), "", "", "Course Application");

            return redirect()->back()->with("error", "Something went wrong");

		}

	}



	//Members Applied

	public function getmembersappliedpage(){

		return view("backend/members/membersApplied");

	}



	public function postmembersappliedpage(Request $req){

		try {

			$input = $req->all();

			$members = Members::where('status', '!=', 'deleted');

			

			if($input['dateFrom'] != ''){

				$members = $members->where(DB::raw('date(date_registered)'), '>=', date('Y-m-d', strtotime($input['dateFrom'])));

			}



			if($input['dateTo'] != ''){

				$members = $members->where(DB::raw('date(date_registered)'), '<=', date('Y-m-d', strtotime($input['dateTo'])));

			}



			if($input['membershipID'] != ''){

				$members = $members->where('unique_id', '=', $input['membershipID']);

			}



			if($input['membership'] != ''){

				$members = $members->where('mem_category', '=', $input['membership']);

			}



			$members = $members->orderBy('date_registered', 'DESC')->get();



			$results = [];

			$i = 0;

			if(count($members) > 0){

				foreach($members as $member){

					$f = 'D, d-M-Y' . (date('H:i:s', strtotime($member->date_registered)) != '00:00:00' ? ' H:i:s' : '');

				    $date = new DateTime($member->date_registered);

				    $registeredDate = $date->format($f);

					$results[$i]['sno'] = $i + 1;

					$results[$i]['id'] = Crypt::encrypt($member->id);

					$results[$i]['unique_id'] = $member->unique_id;

					$results[$i]['mem_category'] = $member->mem_category;

					$results[$i]['org_name'] = $member->org_name;

					$results[$i]['date_registered'] = $registeredDate;

					$results[$i]['con_person'] = $member->con_person;

					$results[$i]['total_mem'] = $member->total_mem;

					$results[$i]['address'] = $member->address;

					$results[$i]['mobile'] = $member->mobile;

					$results[$i]['email'] = $member->email;

					$results[$i]['price'] = $member->price;

					$results[$i]['status'] = $member->status;

					$results[$i]['paymentStatus'] = $member->paymentStatus;

					$i++;

				}

			}

			return $results;

		} catch (Exception $e) {

			//Trackingreport::track("error", $e->getMessage(), "", "", "Course Application");

            return redirect()->back()->with("error", "Something went wrong");

		}

	}



	public function postmembersappliedstatus(Request $req){

		try {

			$input = $req->input('id');

			$id = Crypt::decrypt($input);

			$members = Members::find($id);

			if($members){

				$status = $members->status == "active" ? $current = "inactive" : $current = "active";

				$members->status = $current;

				$members->save();

				return Response::json(['status'=>'success', 'current'=>$members->status]);

			}

			return Response::json(['status'=>'failure']);

		} catch (Exception $e) {

			//Trackingreport::track("error", $e->getMessage(), "", "", "Course Application");

            return Response::json(['status'=>'failure']);

		}

	}



	public function postmembersapplieddelete(Request $req){

		try {

			$input = $req->input('id');

			$id = Crypt::decrypt($input);

			$members = Members::find($id);

			if($members){

				$members->status = 'deleted';

				$members->save();

				return Response::json(['status'=>'success']);

			}

			return Response::json(['status'=>'failure']);

		} catch (Exception $e) {

			//Trackingreport::track("error", $e->getMessage(), "", "", "Course Application");

            return Response::json(['status'=>'failure']);

		}

	}



	public function getmembersappliedmodifypage($key){

		$id = Crypt::decrypt($key);

		$member = Members::find($id);

		return view('backend/members/modifyAppliedMembers')->with('member', $member);

	}



	public function postmembersappliedmodifypage(Request $req, $key){

		try {

            return DB::transaction(function() use($req, $key){

                $input = $req->all();

                $id = Crypt::decrypt($key);

                $rules = [

                    "category"=>"required",

                    "companyname_c"=>"required_if:category, corporate",

                    "contactperson_c"=>"required_if:category, corporate",

                    "address1_c"=>"required_if:category, corporate",

                    "phoneno_c"=>"required_if:category, corporate",

                    "mobileno_c"=>"required_if:category, corporate",

                    "emailid_c"=>"required_if:category, corporate|unique:members,email,".$id,

                    "fb_c"=>"required_if:category, corporate",

                    "twi_c"=>"required_if:category, corporate",

                    "ln_c"=>"required_if:category, corporate",

                    "companyname_i" => "required_if:category, individual",

                    "contactperson_i" => "required_if:category, student|required_if:category, individual",

                    "address1_i" => "required_if:category, student|required_if:category, individual",

                    "phoneno_i" => "required_if:category, student|required_if:category, individual",

                    "mobileno_i" => "required_if:category, student|required_if:category, individual",

                    "emailid_i" => "required_if:category, student|required_if:category, individual",

                    "fb_i" => "required_if:category, student|required_if:category, individual",

                    "twi_i" => "required_if:category, student|required_if:category, individual",

                    "ln_i" => "required_if:category, student|required_if:category, individual",

                ];

                $messages = [

                    "required"=>"You can't leave this field empty",

                    "required_if"=>"You can't leave this field empty",

                    "image"=>"Please upload image file only",

                    "date"=>"Please enter a valid date",

                ];

                $validation = Validator::make($input, $rules, $messages);

                if($validation->fails()){

                    return redirect()->back()->withInput()->withErrors($validation);

                }



                if(!isset($input["sortByAlphabet"])){$input["sortByAlphabet"] = "";}



                if($input["category"] == "corporate"){

                    $endDate = date("Y-m-d", strtotime("+365 Day"));

                    $time = date("H:i:s");

                    $parsed = date_parse($time);

                    $seconds = $parsed['hour'] * 3600 + $parsed['minute'] * 60 + $parsed['second'];

                    $members = [];

                    $tot_member = 0;

                    for($i = 0; $i < $input['tot_mem']; $i++){

                        $members[$i]['name'] = trim($input['name'.$i]); 

                        $members[$i]['designation'] = trim($input['designation'.$i]);

                        $members[$i]['email'] = trim($input['email'.$i]);

                        $members[$i]['mobile'] = trim($input['mobile'.$i]); 

                        $tot_member++;

                    }

                    $members = json_encode($members);



                    if($input['tot_mem'] > 5){

                        $payable = Option::getvalue('corporate') + (600 * ($input['tot_mem'] - 5));

                    }else{

                        $payable = Option::getvalue('corporate');

                    }

                    $GST = Option::getvalue('GST');

                    $amount = $payable / 100;

                    $pay = ceil($payable + ($amount * $GST));

                    $status = "inactive";



                    $check = Members::where('email', $input['emailid_c'])->count();

                    if($check > 1){

                        return redirect()->back()->with('warnings', 'Registered email-id already exist!!!');

                    }



                    $modify = Members::find($id);

                    $modify->mem_category = $input["category"];

                    $modify->org_name = $input["companyname_c"];

                    $modify->con_person = $input["contactperson_c"];

                    $modify->address = $input["address1_c"];

                    $modify->phone = $input["phoneno_c"];

                    $modify->mobile = $input["mobileno_c"];

                    $modify->email = $input["emailid_c"];

                    $modify->facebook = $input["fb_c"];

                    $modify->twitter = $input["twi_c"];

                    $modify->linkedin = $input["ln_c"];

                    $modify->members = $members;

                    //$modify->date_registered = date('Y-m-d');

                    //$modify->status = 'inactive';

                    $modify->price = $pay;

                    $modify->total_mem = $tot_member;

                    $modify->expiryDate = $endDate;

                    $modify->timing = $seconds;

                    $modify->sortBy = $input["sortByAlphabet"];

                    $modify->save();

                }elseif($input["category"] == "individual"){

                    $status = "inactive";

                    $individual = Option::getvalue('individual');

                    $GST = Option::getvalue('GST');

                    $amount = $individual / 100;

                    $pay = ceil($individual + ($amount * $GST));

                    $endDate = date("Y-m-d", strtotime("+365 Day"));

                    $time = date("H:i:s");

                    $parsed = date_parse($time);

                    $seconds = $parsed['hour'] * 3600 + $parsed['minute'] * 60 + $parsed['second'];



                    $update = Members::find($id);

                    $update->mem_category = $input["category"];

                    $update->org_name = $input["companyname_i"];

                    $update->con_person = $input["contactperson_i"];

                    $update->address = $input["address1_i"];

                    $update->phone = $input["phoneno_i"];

                    $update->mobile = $input["mobileno_i"];

                    $update->email = $input["emailid_i"];

                    $update->facebook = $input["fb_i"];

                    $update->twitter = $input["twi_i"];

                    $update->linkedin = $input["ln_i"];

                    //$update->date_registered = date('Y-m-d');

                    //$update->status = 'inactive';

                    $update->price = $pay;

                    $update->expiryDate = $endDate;

                    $update->timing = $seconds;

                    $update->sortBy = $input["sortByAlphabet"];

                    $update->save();

                }else if($input["category"] == "student"){

                    $status = "inactive";

                    $student = Option::getvalue('student');

                    $GST = Option::getvalue('GST');

                    $amount_stu = $student / 100;

                    $pay = ceil($student + ($amount_stu * $GST));

                    $endDate = date("Y-m-d", strtotime("+365 Day"));

                    $time = date("H:i:s");

                    $parsed = date_parse($time);

                    $seconds = $parsed['hour'] * 3600 + $parsed['minute'] * 60 + $parsed['second'];



                    $modify = Members::find($id);

                    $modify->mem_category = $input["category"];

                    $modify->org_name = $input["companyname_i"];

                    $modify->con_person = $input["contactperson_i"];

                    $modify->address = $input["address1_i"];

                    $modify->phone = $input["phoneno_i"];

                    $modify->mobile = $input["mobileno_i"];

                    $modify->email = $input["emailid_i"];

                    $modify->facebook = $input["fb_i"];

                    $modify->twitter = $input["twi_i"];

                    $modify->linkedin = $input["ln_i"];

                    //$modify->date_registered = date('Y-m-d');

                    //$modify->status = 'inactive';

                    $modify->price = $pay;

                    $modify->expiryDate = $endDate;

                    $modify->timing = $seconds;

                    $modify->sortBy = $input["sortByAlphabet"];

                    $modify->save();

                }

                return redirect()->back()->withSuccess('Members details updated successfully!!!');

            });

        } catch (Exception $e) {

            //Trackingreport::track("error", $e->getMessage(), "", "", "Course Application");

            return redirect()->back()->with("error", "Something went wrong");

        }

	}



	public function getcorporatemembersaddpage(){

		return view("backend/members/addCorporateMembers");

	}



	public function getindividualmembersaddpage(){

		return view("backend/members/addIndividualMembers");

	}



	public function postcorporatemembersaddpage(Request $req){

		try {

            return DB::transaction(function() use($req){

                $input = $req->all();

                if($input["category"] == "corporate"){

                	$rules = [

	                    "category"=>"required",

	                    "companyname_c"=>"required",

	                    "contactperson_c"=>"required",

	                    "address1_c"=>"required",

	                    //"phoneno_c"=>"required",

	                    "mobileno_c"=>"required",

	                    "emailid_c"=>"required|unique:members,email",

	                    // "fb_c"=>"required",

	                    // "twi_c"=>"required",

	                    // "ln_c"=>"required",

	                ];

                } else{

                	$rules = [

	                    "category"=>"required",

	                    "companyname_i" => "required",

	                    "contactperson_i" => "required",

	                    "address1_i" => "required",

	                    //"phoneno_i" => "required",

	                    "mobileno_i" => "required",

	                    "emailid_i" => "required|unique:members,email",

	                    // "fb_i" => "required",

	                    // "twi_i" => "required",

	                    // "ln_i" => "required",

	                ];

                }

                

                $messages = [

                    "required"=>"You can't leave this field empty",

                    "required_if"=>"You can't leave this field empty",

                    "image"=>"Please upload image file only",

                    "date"=>"Please enter a valid date",

                    "unique"=>"Given Email has already been taken"

                ];

                $validation = Validator::make($input, $rules, $messages);

                if($validation->fails()){

                    return redirect()->back()->withInput()->withErrors($validation);

                }



                if(!isset($input["sortByAlphabet"])){$input["sortByAlphabet"] = "";}



                if($input["category"] == "corporate"){

                    $endDate = date("Y-m-d", strtotime("+365 Day"));

                    $time = date("H:i:s");

                    $parsed = date_parse($time);

                    $seconds = $parsed['hour'] * 3600 + $parsed['minute'] * 60 + $parsed['second'];

                    $members = [];

                    $tot_member = 0;

                    for($i = 0; $i < $input['tot_mem']; $i++){

                        $members[$i]['name'] = trim($input['name'.$i]); 

                        $members[$i]['designation'] = trim($input['designation'.$i]);

                        $members[$i]['email'] = trim($input['email'.$i]);

                        $members[$i]['mobile'] = trim($input['mobile'.$i]); 

                        $tot_member++;

                    }

                    $members = json_encode($members);



                    if($input['tot_mem'] > 5){

                        $payable = Option::getvalue('corporate') + (600 * ($input['tot_mem'] - 5));

                    } else{

                        $payable = Option::getvalue('corporate');

                    }

                    $GST = Option::getvalue('GST');

                    $amount = $payable / 100;

                    $pay = ceil($payable + ($amount * $GST));

                    $status = "inactive";



                    $check = Members::where('email', $input['emailid_c'])->count();

                    if($check > 0){

                        return redirect()->back()->withInput()->with('warnings', 'Registered email-id already exist!!!');

                    }



                    $modify = new Members();

                    $modify->mem_category = $input["category"];

                    $modify->org_name = $input["companyname_c"];

                    $modify->con_person = $input["contactperson_c"];

                    $modify->address = $input["address1_c"];

                    $modify->phone = $input["phoneno_c"];

                    $modify->mobile = $input["mobileno_c"];

                    $modify->email = $input["emailid_c"];

                    $modify->facebook = $input["fb_c"];

                    $modify->twitter = $input["twi_c"];

                    $modify->linkedin = $input["ln_c"];

                    $modify->members = $members;

                    //$modify->date_registered = date('Y-m-d');

                    //$modify->status = 'inactive';

                    $modify->price = $pay;

                    $modify->total_mem = $tot_member;

                    $modify->expiryDate = $endDate;

                    $modify->timing = $seconds;

                    $modify->sortBy = $input["sortByAlphabet"];

                    $modify->save();



                    $uniqueID = "ACM".date('Ymd').str_pad($modify->id, 3, '0', STR_PAD_LEFT);

                    $update = Members::find($modify->id);

                    $update->unique_id = $uniqueID;

                    $update->save();

                } elseif($input["category"] == "individual"){

                    $status = "inactive";

                    $individual = Option::getvalue('individual');

                    $GST = Option::getvalue('GST');

                    $amount = $individual / 100;

                    $pay = ceil($individual + ($amount * $GST));

                    $endDate = date("Y-m-d", strtotime("+365 Day"));

                    $time = date("H:i:s");

                    $parsed = date_parse($time);

                    $seconds = $parsed['hour'] * 3600 + $parsed['minute'] * 60 + $parsed['second'];



                    $update = new Members();

                    $update->mem_category = $input["category"];

                    $update->org_name = $input["companyname_i"];

                    $update->con_person = $input["contactperson_i"];

                    $update->address = $input["address1_i"];

                    $update->phone = $input["phoneno_i"];

                    $update->mobile = $input["mobileno_i"];

                    $update->email = $input["emailid_i"];

                    $update->facebook = $input["fb_i"];

                    $update->twitter = $input["twi_i"];

                    $update->linkedin = $input["ln_i"];

                    //$update->date_registered = date('Y-m-d');

                    //$update->status = 'inactive';

                    $update->price = $pay;

                    $update->expiryDate = $endDate;

                    $update->timing = $seconds;

                    $update->sortBy = $input["sortByAlphabet"];

                    $update->save();



                    $uniqueID = "ACM".date('Ymd').str_pad($update->id, 3, '0', STR_PAD_LEFT);

                    $modify = Members::find($update->id);

                    $modify->unique_id = $uniqueID;

                    $modify->save();

                } else if($input["category"] == "student"){

                    $status = "inactive";

                    $student = Option::getvalue('student');

                    $GST = Option::getvalue('GST');

                    $amount_stu = $student / 100;

                    $pay = ceil($student + ($amount_stu * $GST));

                    $endDate = date("Y-m-d", strtotime("+365 Day"));

                    $time = date("H:i:s");

                    $parsed = date_parse($time);

                    $seconds = $parsed['hour'] * 3600 + $parsed['minute'] * 60 + $parsed['second'];



                    $modify = new Members();

                    $modify->mem_category = $input["category"];

                    $modify->org_name = $input["companyname_i"];

                    $modify->con_person = $input["contactperson_i"];

                    $modify->address = $input["address1_i"];

                    $modify->phone = $input["phoneno_i"];

                    $modify->mobile = $input["mobileno_i"];

                    $modify->email = $input["emailid_i"];

                    $modify->facebook = $input["fb_i"];

                    $modify->twitter = $input["twi_i"];

                    $modify->linkedin = $input["ln_i"];

                    //$modify->date_registered = date('Y-m-d');

                    //$modify->status = 'inactive';

                    $modify->price = $pay;

                    $modify->expiryDate = $endDate;

                    $modify->timing = $seconds;

                    $modify->sortBy = $input["sortByAlphabet"];

                    $modify->save();



                    $uniqueID = "ACM".date('Ymd').str_pad($modify->id, 3, '0', STR_PAD_LEFT);

                    $update = Members::find($modify->id);

                    $update->unique_id = $uniqueID;

                    $update->save();

                }

                return redirect()->back()->withSuccess(ucfirst($input["category"]).' Members details saved successfully!!!');

            });

        } catch (Exception $e) {

            //Trackingreport::track("error", $e->getMessage(), "", "", "Course Application");

            return redirect()->back()->with("error", "Something went wrong");

        }

	}



	public function getcorporatemembersmodifypage($key){

		//$id = Crypt::decrypt($key);

		$id = $key;

		$member = Members::find($id);

		if($member){

			return view("backend/members/modifyCorporateMembers")->with("member", $member);

		}

		return "Member details not found";

	}



	public function getindividualmembersmodifypage($key){

		//$id = Crypt::decrypt($key);

		$id = $key;

		$member = Members::find($id);

		if($member){

			return view("backend/members/modifyIndividualMembers")->with("member", $member);

		}

		return "Member details not found";

	}



	public function postindividualmembersmodifypage(Request $req, $key){

		try {

            return DB::transaction(function() use($req, $key){

                $input = $req->all();

                $id = Crypt::decrypt($key);

                if($input["category"] == "corporate"){

                	$rules = [

	                    "category"=>"required",

	                    "companyname_c"=>"required",

	                    //"contactperson_c"=>"required",

	                    //"address1_c"=>"required",

	                    //"phoneno_c"=>"required",

	                    //"mobileno_c"=>"required",

	                    //"emailid_c"=>"required|unique:members,email,".$id,

	                    // "fb_c"=>"required",

	                    // "twi_c"=>"required",

	                    // "ln_c"=>"required",

	                ];

                } else{

                	$rules = [

	                    "category"=>"required",

	                    "companyname_i" => "required",

	                    "contactperson_i" => "required",

	                    //"address1_i" => "required",

	                    //"phoneno_i" => "required",

	                    //"mobileno_i" => "required",

	                    //"emailid_i" => "required|unique:members,email,".$id,

	                    // "fb_i" => "required",

	                    // "twi_i" => "required",

	                    // "ln_i" => "required",

	                ];

                }

                

                $messages = [

                    "required"=>"You can't leave this field empty",

                    "required_if"=>"You can't leave this field empty",

                    "image"=>"Please upload image file only",

                    "date"=>"Please enter a valid date",

                ];

                $validation = Validator::make($input, $rules, $messages);

                if($validation->fails()){

                    return redirect()->back()->withInput()->withErrors($validation);

                }



                if(!isset($input["sortByAlphabet"])){$input["sortByAlphabet"] = "";}



                if($input["category"] == "corporate"){

                    $endDate = date("Y-m-d", strtotime("+365 Day"));

                    $time = date("H:i:s");

                    $parsed = date_parse($time);

                    $seconds = $parsed['hour'] * 3600 + $parsed['minute'] * 60 + $parsed['second'];

                    $members = [];

                    $tot_member = 0;

                    for($i = 0; $i < $input['tot_mem']; $i++){

                        $members[$i]['name'] = trim($input['name'.$i]); 

                        $members[$i]['designation'] = trim($input['designation'.$i]);

                        $members[$i]['email'] = trim($input['email'.$i]);

                        $members[$i]['mobile'] = trim($input['mobile'.$i]); 

                        $tot_member++;

                    }

                    $members = json_encode($members);



                    if($input['tot_mem'] > 5){

                        $payable = Option::getvalue('corporate') + (600 * ($input['tot_mem'] - 5));

                    } else{

                        $payable = Option::getvalue('corporate');

                    }



                    $GST = Option::getvalue('GST');

                    $amount = $payable / 100;

                    $pay = ceil($payable + ($amount * $GST));

                    $status = "inactive";



                    if($input['emailid_c'] != ''){

                    	$check = Members::where('email', $input['emailid_c'])->count();

	                    if($check > 1){

	                        return redirect()->back()->with('warnings', 'Registered email-id already exist!!!');

	                    }

                    }



                    $expiryDate = NULL;

                    if($input['renewalDate'] != ''){

                    	$expiryDate = date('Y-m-d', strtotime($input['renewalDate']));

                    }



                    $modify = Members::find($id);

                    $modify->mem_category = $input["category"];

                    $modify->org_name = $input["companyname_c"];

                    $modify->con_person = $input["contactperson_c"];

                    $modify->address = $input["address1_c"];

                    $modify->phone = $input["phoneno_c"];

                    $modify->mobile = $input["mobileno_c"];

                    $modify->email = $input["emailid_c"];

                    $modify->facebook = $input["fb_c"];

                    $modify->twitter = $input["twi_c"];

                    $modify->linkedin = $input["ln_c"];

                    $modify->members = $members;

                    //$modify->date_registered = date('Y-m-d');

                    //$modify->status = 'inactive';

                    $modify->price = $pay;

                    $modify->total_mem = $tot_member;

                    $modify->expiryDate = $expiryDate;

                    $modify->timing = $seconds;

                    $modify->sortBy = $input["sortByAlphabet"];

                    $modify->save();

                } elseif($input["category"] == "individual"){

                    $status = "inactive";

                    $individual = Option::getvalue('individual');

                    $GST = Option::getvalue('GST');

                    $amount = $individual / 100;

                    $pay = ceil($individual + ($amount * $GST));

                    $endDate = date("Y-m-d", strtotime("+365 Day"));

                    $time = date("H:i:s");

                    $parsed = date_parse($time);

                    $seconds = $parsed['hour'] * 3600 + $parsed['minute'] * 60 + $parsed['second'];



                    $expiryDate = NULL;

                    if($input['renewalDate'] != ''){

                    	$expiryDate = date('Y-m-d', strtotime($input['renewalDate']));

                    }



                    $update = Members::find($id);

                    $update->mem_category = $input["category"];

                    $update->org_name = $input["companyname_i"];

                    $update->con_person = $input["contactperson_i"];

                    $update->address = $input["address1_i"];

                    $update->phone = $input["phoneno_i"];

                    $update->mobile = $input["mobileno_i"];

                    $update->email = $input["emailid_i"];

                    $update->facebook = $input["fb_i"];

                    $update->twitter = $input["twi_i"];

                    $update->linkedin = $input["ln_i"];

                    //$update->date_registered = date('Y-m-d');

                    //$update->status = 'inactive';

                    $update->price = $pay;

                    $update->expiryDate = $expiryDate;

                    $update->timing = $seconds;

                    $update->sortBy = $input["sortByAlphabet"];

                    $update->save();

                } else if($input["category"] == "student"){

                    $status = "inactive";

                    $student = Option::getvalue('student');

                    $GST = Option::getvalue('GST');

                    $amount_stu = $student / 100;

                    $pay = ceil($student + ($amount_stu * $GST));

                    $endDate = date("Y-m-d", strtotime("+365 Day"));

                    $time = date("H:i:s");

                    $parsed = date_parse($time);

                    $seconds = $parsed['hour'] * 3600 + $parsed['minute'] * 60 + $parsed['second'];

                    $expiryDate = NULL;

                    if($input['renewalDate'] != ''){

                    	$expiryDate = date('Y-m-d', strtotime($input['renewalDate']));

                    }



                    $modify = Members::find($id);

                    $modify->mem_category = $input["category"];

                    $modify->org_name = $input["companyname_i"];

                    $modify->con_person = $input["contactperson_i"];

                    $modify->address = $input["address1_i"];

                    $modify->phone = $input["phoneno_i"];

                    $modify->mobile = $input["mobileno_i"];

                    $modify->email = $input["emailid_i"];

                    $modify->facebook = $input["fb_i"];

                    $modify->twitter = $input["twi_i"];

                    $modify->linkedin = $input["ln_i"];

                    //$modify->date_registered = date('Y-m-d');

                    //$modify->status = 'inactive';

                    $modify->price = $pay;

                    $modify->expiryDate = $expiryDate;

                    $modify->timing = $seconds;

                    $modify->sortBy = $input["sortByAlphabet"];

                    $modify->save();

                }

                return redirect()->back()->withSuccess('Members details updated successfully!!!');

            });

        } catch (Exception $e) {

            //Trackingreport::track("error", $e->getMessage(), "", "", "Course Application");

            return redirect()->back()->with("error", "Something went wrong");

        }

	}



	//Event Categories

	public function getaddeventcategorypage(){

		return view("backend/events/addEventCategories");

	}



	public function postaddeventcategorypage(Request $req){

		try {

			$input = $req->all();

			$rules = array(

				"eventCategoryTitle" => "required",

				"eventCategoryDescription"=>"required",

			);

			$message = [

				"required" => "You can't leave this field empty" 

			];

			$validation = Validator::make($input, $rules, $message);

			if($validation->fails()){

				return redirect()->back()->withInput()->withErrors($validation);

			}



			$insert = new EventCategories();

			$insert->categoryName = $input["eventCategoryTitle"];

			$insert->categorySlug = EventCategories::getCategorySlug($input["eventCategoryTitle"]);

			$insert->categoryDescription = $input["eventCategoryDescription"];

			$insert->addedByName = Auth::User()->userName;

			$insert->addedByID = Auth::User()->id;

			$insert->status = "active";

			$insert->save();

			return redirect()->back()->withSuccess("New event category created successfully!!!");

		} catch (Exception $e) {

						

		}

	}



	public function geteventcategorymodifypage($slug, $key){

		$id = Crypt::decrypt($key);

		$category = EventCategories::findOrFail($id);

		return view("backend/events/modifyEventCategories")->with(["category"=>$category]);

	}



	public function posteventcategorymodify(Request $req, $slug, $key){

    	try{

		    $input = $req->all();

		    $id = Crypt::decrypt($key);

		    $rules = array(

				"eventCategoryTitle" => "required",

				"eventCategoryDescription"=>"required",

			);

			$message = [

				"required" => "You can't leave this field empty" 

			];

			$validation = Validator::make($input, $rules, $message);

			if($validation->fails()){

				return redirect()->back()->withInput()->withErrors($validation);

			}

			$modify = EventCategories::find($id);

			$modify->categoryName = $input["eventCategoryTitle"];

			$modify->categoryDescription = $input["eventCategoryDescription"];

			$modify->updatedByName = Auth::User()->userName;

			$modify->updatedByID = Auth::User()->id;

			$modify->save();

			return redirect()->back()->withSuccess("Event category updated successfully!!!");

    	} catch(Exception $e){

	        //TrackingReport::track("error",$e->getMessage(),"","","delete event category");

	        return Response::json(["status"=>"error"]);

	    }

  	}



  	public function geteventcategorypage(){

		$eventsCategories = EventCategories::where("status", "!=", "deleted")->get();

		return view("backend/events/eventsCategories")->with(["eventsCategories"=>$eventsCategories]);

	}



	public function posteventcategorystatus(Request $req){

		$input = $req->input('id');

		$id = Crypt::decrypt($input);

		$check = EventCategories::find($id);

		if($check){

			$check->status == "active" ? $current = "inactive" : $current = "active";

			$check->status = $current;

			$check->updatedByName = Auth::User()->userName;

			$check->updatedByID = Auth::User()->id;

			$check->save();

			return Response::json(["status"=>"success", "current"=>ucfirst($current), "msg"=>"Updated Successfully!!!"]);

		}

		return Response::json(["status"=>"failure"]);

	}



	public function posteventcategorydelete(Request $req){

		$input = $req->input('id');

		$id = Crypt::decrypt($input);

		$delete = EventCategories::find($id);

		if($delete){

			$delete->status = "deleted";

			$delete->updatedByName = Auth::User()->userName;

			$delete->updatedByID = Auth::User()->id;

			$delete->save();

			return Response::json(["status"=>"success", "msg"=>"Deleted Successfully!!!"]);

		}

		return Response::json(["status"=>"failure"]);

	}



	//Events

	public function getaddeventpage(){

		$gallery = Gallery::where('status', 'active')->pluck('galleryTitle', 'id');

		return view("backend/events/addEvent", compact('gallery'));

	}



	public function postaddeventpage(Request $req){

		try{

		    $input = $req->all();

		    $rules = array(

				"eventTitle" => "required",

				"eventDate"=>"required|date",

				"eventStartTime"=>"required",

				"eventPoster"=>"required|image|mimes:png,jpg,jpeg",

				"eventCategory"=>"required",

				"entryType" => "required",

				"memberFee" => 'required_if:entryType,paid,nullable,numeric',

				"nonMemberFee" => 'required_if:entryType,paid,nullable,numeric'

			);

			$message = [

				"required" => "You can't leave this field empty" 

			];

			$validation = Validator::make($input, $rules, $message);

			if($validation->fails()){

				return redirect()->back()->withInput()->withErrors($validation);

			}



			$eventPoster = "";

	      	if($req->hasFile('eventPoster')){

                $file = $req->file('eventPoster');

                $destinationPath = 'backend/uploads/pages/'; // upload path

                $extension = $file->getClientOriginalExtension(); // getting file extension

                $name = $file->getClientOriginalName();// getting original file name

                $check = Events::checkEventPoster(substr($name, 0, -(strlen($extension) + 1)), "/".$destinationPath, $extension);

                $fileName = $check.'.'.$extension; // renameing image

                $upload_success = $file->move($destinationPath, $fileName); // uploading file to given path

                $img_url = $destinationPath.$fileName;

                $eventPoster = URL::asset($img_url);

            }

            $memberFee = NULL;

            if($input['memberFee'] > 0){

            	$memberFee = $input['memberFee'];

            }

            $nonMemberFee = NULL;

            if($input['nonMemberFee'] > 0){

            	$nonMemberFee = $input['nonMemberFee'];

            }

            



			$insert = new Events();

			$insert->eventCategoryID = $input["eventCategory"];

			$insert->eventTitle = $input["eventTitle"];

			$insert->eventSlug = Events::getEventSlug($input["eventTitle"]);

			$insert->eventDate = date("Y-m-d", strtotime($input["eventDate"]));

			$insert->eventTime = $input["eventStartTime"];

			$insert->eventEndTime = $input["eventEndTime"];

			$insert->reportingTime = $input["reportingTime"];

			$insert->eventPoster = $eventPoster;

			$insert->entryType = $input["entryType"];

			if($input['entryType'] == 'paid'){

				$insert->memberFee = $memberFee;

				$insert->nonMemberFee = $nonMemberFee;

				$insert->memberFeeText = $input["memberFeeText"];

				$insert->nonMemberFeeText = NULL;//$input["nonMemberFeeText"];

			}else{

				$insert->memberFee = 0;

				$insert->nonMemberFee = 0;

				$insert->memberFeeText = NULL;

				$insert->nonMemberFeeText = NULL;

			}

			$insert->partner_event = $input['partnerEvent'];

			$insert->partner_name = $input['partnerName'];

			$insert->streaming_link = $input['streaming_link'];

			$insert->eventVenue = $input["eventVenue"];

			$insert->eventDescription = $input["eventDescription"];

			$insert->eventInformation = $input["eventInformation"];

			$insert->gallery = $input['gallery'];

			$insert->createdByName = Auth::User()->userName;

			$insert->createdByID = Auth::User()->id;

			$insert->status = "active";

			$insert->save();

			return redirect()->back()->withSuccess("Event created successfully!!!");

    	} catch(Exception $e){

	        //TrackingReport::track("error",$e->getMessage(),"","","delete events");

	        return Response::json(["status"=>"error"]);

	    }

	}



	public function geteventspage(){

		$events = Events::where("status", "active")->latest()->get();

		return view("backend/events/events")->with(["events"=>$events]);

	}



	public function posteventsstatus(Request $req){

		$input = $req->input('id');

		$id = Crypt::decrypt($input);

		$check = Events::find($id);

		if($check){

			$check->status == "active" ? $current = "inactive" : $current = "active";

			$check->status = $current;

			$check->updatedByName = Auth::User()->userName;

			$check->updatedByID = Auth::User()->id;

			$check->save();

			return Response::json(["status"=>"success", "current"=>ucfirst($current), "msg"=>"Updated Successfully!!!"]);

		}

		return Response::json(["status"=>"failure"]);

	}



	public function posteventsdelete(Request $req){

		$input = $req->input('id');

		$id = Crypt::decrypt($input);

		$delete = Events::find($id);

		if($delete){

			$delete->status = "deleted";

			$delete->updatedByName = Auth::User()->userName;

			$delete->updatedByID = Auth::User()->id;

			$delete->save();

			return Response::json(["status"=>"success", "msg"=>"Deleted Successfully!!!"]);

		}

		return Response::json(["status"=>"failure"]);

	}



	public function geteventmodifypage($slug, $key){

		$id = Crypt::decrypt($key);

		$event = Events::findOrFail($id);

		$gallery = Gallery::where('status', 'active')->pluck('galleryTitle', 'id');

		return view("backend/events/modifyEvent", compact('gallery'))->with(["event"=>$event]);

	}



	public function posteventmodify(Request $req, $slug, $key){

		try{

		    $input = $req->all();

		    $id = Crypt::decrypt($key);



		    $rules = array(

				"eventTitle" => "required",

				"eventDate"=>"required|date",

				"eventStartTime"=>"required",

				"eventPoster"=>"image|mimes:png,jpg,jpeg",

				"eventCategory"=>"required",

				"entryType" => "required",

				"memberFee" => 'required_if:entryType,paid,nullable,numeric',

				"nonMemberFee" => 'required_if:entryType,paid,nullable,numeric'

			);



			$message = [

				"required" => "You can't leave this field empty" 

			];



			$validation = Validator::make($input, $rules, $message);

			if($validation->fails()){

				return redirect()->back()->withInput()->withErrors($validation);

			}



			$eventPoster = "";

	      	



	      	$memberFee = NULL;

            if($input['memberFee'] > 0){

            	$memberFee = $input['memberFee'];

            }

            $nonMemberFee = NULL;

            if($input['nonMemberFee'] > 0){

            	$nonMemberFee = $input['nonMemberFee'];

            }



			$modify = Events::findOrFail($id);

			$modify->eventCategoryID = $input["eventCategory"];

			$modify->eventTitle = $input["eventTitle"];

			//$modify->eventSlug = Events::getEventSlug($input["eventTitle"]);

			$modify->eventDate = date("Y-m-d", strtotime($input["eventDate"]));

			$modify->eventTime = $input["eventStartTime"];

			$modify->eventEndTime = $input['eventEndTime'];

			$modify->reportingTime = $input["reportingTime"];



			if($req->hasFile('eventPoster')){

				if($modify->eventPoster != ""){

					$path = urldecode($modify->eventPoster);

					$url = parse_url($path);

					unlink(substr($url["path"], 1));

				}

                $file = $req->file('eventPoster');

                $destinationPath = 'backend/uploads/pages/'; // upload path

                $extension = $file->getClientOriginalExtension(); // getting file extension

                $name = $file->getClientOriginalName();// getting original file name

                $check = Events::checkEventPoster(substr($name, 0, -(strlen($extension) + 1)), "/".$destinationPath, $extension);

                $fileName = $check.'.'.$extension; // renameing image

                $upload_success = $file->move($destinationPath, $fileName); // uploading file to given path

                $img_url = $destinationPath.$fileName;

                $eventPoster = URL::asset($img_url);

                $modify->eventPoster = $eventPoster;

            }



            $modify->entryType = $input["entryType"];

            if($input['entryType'] == 'paid'){

            	$modify->memberFee = $memberFee;

				$modify->nonMemberFee = $nonMemberFee;

				$modify->memberFeeText = $input["memberFeeText"];

				$modify->nonMemberFeeText = NULL;//$input["nonMemberFeeText"];

            }else{

            	$modify->memberFee = 0;

				$modify->nonMemberFee = 0;

				$modify->memberFeeText = NULL;

				$modify->nonMemberFeeText = NULL;

            }

            

            $modify->partner_event = $input['partnerEvent'];

			$modify->partner_name = $input['partnerName'];

			$modify->streaming_link = $input['streaming_link'];

			$modify->eventVenue = $input["eventVenue"];

			$modify->eventDescription = $input["eventDescription"];
			
			$modify->eventInformation = $input["eventInformation"];

			$modify->gallery = $input['gallery'];

			$modify->updatedByName = Auth::User()->userName;

			$modify->updatedByID = Auth::User()->id;

			$modify->save();

			return redirect()->back()->withSuccess("Event updated successfully!!!");

    	} catch(Exception $e){

	        //TrackingReport::track("error",$e->getMessage(),"","","delete events");

	        return Response::json(["status"=>"error"]);

	    }

	}



	//event info custom fields start

	public function posteventmodifycustomfields(Request $req){

		try{

            $input = $req->all();

            $event_id = Crypt::decrypt($input['event_id']);

            $field_type = $input['field_type'];

            $label_name = $input['label_name'];

            $column_length = $input['field_column_length'];

            $is_required = $input['is_required'];

            //validation

                $rules = [

                            'field_type' => 'required',

                            'label_name' => 'required'

                        ];

                $msg = [];

                $validation = Validator::make($input, $rules, $msg);

                if ($validation->fails()) {

                    return response()->json(['status'=>'validation', 'validation'=>$validation->messages()]);

                }

            //validation

                $insert = new Customfield();

                $insert->field_type = $field_type;

                $insert->label_name = $label_name;

                $insert->column_length = $column_length;

                $insert->is_required = $is_required;

                $insert->status = 'active';

                $insert->user_id = Auth::id();

                $insert->event_id = $event_id;

                $insert->module_name = 'event_info';

                $insert->save();



                if($insert->field_slug == '') {

                    $field_slug = 'eventinfo_'.$insert->id.'_'.$event_id;

                    $insert->field_slug = \Str::slug($field_slug, '_');

                    $insert->save();

                }



                return response()->json(['status'=>'success','msg'=>$msg]);

        }catch(\Exception $e){

            return response()->json(['status'=>'error','msg'=>$e->getMessage().'__'.$e->getLine()]);

        }

	}



	public function eventcustomfieldstemplate(Request $req){

		try{

            $eventId = Crypt::decrypt($req->get('event_id'));

            $custom_fields = Customfield::Event($eventId)->NotDeleted()->ModuleName('event_info')->orderBy('sort_order','ASC')->get();

            $template = view('backend.events.eventInfoTemplate')->with('custom_fields',$custom_fields)->with('eventId',$eventId)->render();

            return response()->json(['status'=>'success','template'=>$template]);

        }catch(\Exception $e){

            return response()->json(['status'=>'error','msg'=>$e->getMessage().'__'.$e->getLine()]);

        }

	}

	

	public function posteventupdatecustomfieldsdata(Request $req){

		try{

            $input = $req->all();

            $eventId = $req->get('eventHiddenId');

            $rules = [];

            $validInput = [];



            $custom_fields = Customfield::Event($eventId)->NotDeleted()->ModuleName('event_info')->Required()->get();

            foreach($custom_fields as $field){

    			if($field->field_type == 'single_file_upload' || $field->field_type == 'multiple_file_upload') {

    				if($field->field_type == 'single_file_upload' && $field->field_value == ''){

    					if(!$req->hasFile($field->field_slug)){

	    					$input[$field->field_slug] = '';

	    					$rules[$field->field_slug] = 'required';

	    				}

	    				$rules[$field->field_slug.'.*'] = "mimes:png,jpg,jpeg,pdf,doc";

    				}else if($field->field_type == 'multiple_file_upload') {

    					$metacount = Customfieldmeta::where('custom_field_id',$field->id)->count();

    					if($metacount == 0){

    						if(!$req->hasFile($field->field_slug)){

		    					$input[$field->field_slug] = '';

		    					$rules[$field->field_slug] = 'required';

		    				}

		    				$rules[$field->field_slug.'.*'] = "mimes:png,jpg,jpeg,pdf,doc";

    					}

    				}

    			}else{

    				//$validInput[$field->field_slug] = $req->has($field->field_slug)?$input[$field->field_slug]:'';

    				$rules[$field->field_slug] = 'required';

    			}

            }

            //return $req->hasFile('eventinfo_10_46')?'yes':'no';

            $msg = ['required'=>'this field is required','image'=>'file required','mimes'=>'wrong file format'];

            $validation = Validator::make($input, $rules, $msg);

            if ($validation->fails()) {

                return response()->json(['status'=>'validation', 'validation'=>$validation->messages()]);

            }

            $v = 1;

            foreach($input as $key=>$value) {

            	$custom_fields = Customfield::Event($eventId)->NotDeleted()->ModuleName('event_info')->Slug($key)->first();

            	if($custom_fields){

            		if($custom_fields->field_type == 'multiple_file_upload' || $custom_fields->field_type == 'single_file_upload'){

            			$destinationPath = 'backend/uploads/customfields/'; 

			            if($custom_fields->field_type == 'multiple_file_upload') {

			            	$files = $req->file($key);

	                        foreach($files as $file){

	                            $original_name = pathinfo($file, PATHINFO_FILENAME);

	                            $filename = $file->getClientOriginalName();

	                            $extension = $file->getClientOriginalExtension();

	                            //check if name exist

	                                $tmp_name = $filename;

	                                if ($pos = strrpos($filename, '.')) {

	                                    $name = substr($filename, 0, $pos);

	                                    $ext = substr($filename, $pos);

	                                } else {

	                                    $name = $filename;

	                                }

	                                $uniq_no = 0;

	                                $file_exists = public_path($destinationPath . $filename);

	                                while (file_exists($file_exists)) {

	                                    $tmp_name = $name .'_'. $uniq_no . $ext;

	                                    $uniq_no++;

	                                    $file_exists = public_path($destinationPath . $tmp_name);

	                                }

	                                $upload_success = $file->move($destinationPath, $tmp_name);

	                            	$img_url = $destinationPath.$tmp_name;

	                            $meta = new Customfieldmeta();

	                            $meta->custom_field_id = $custom_fields->id;

	                            $meta->field_value = $img_url;

	                            $meta->extra_field = $tmp_name;

	                            $meta->save();

	                        }

			            }else{

			            	$file = $req->file($key);

	                        $original_name = pathinfo($file, PATHINFO_FILENAME);

	                        $filename = $file->getClientOriginalName();

	                        $extension = $file->getClientOriginalExtension();

                            //check if name exist

                                $tmp_name = $filename;

                                if ($pos = strrpos($filename, '.')) {

                                    $name = substr($filename, 0, $pos);

                                    $ext = substr($filename, $pos);

                                } else {

                                    $name = $filename;

                                }

                                $uniq_no = 0;

                                $file_exists = public_path($destinationPath . $filename);

                                while (file_exists($file_exists)) {

                                    $tmp_name = $name .'_'. $uniq_no . $ext;

                                    $uniq_no++;

                                    $file_exists = public_path($destinationPath . $tmp_name);

                                }

                                $upload_success = $file->move($destinationPath, $tmp_name);

                                $img_url = $destinationPath.$tmp_name;

                                $custom_fields->field_value = $img_url;

                                $custom_fields->extra_field = $tmp_name;

			            }

            		}else{

            			$custom_fields->field_value = $value;

            		}

            		$custom_fields->save();

            		 $v++;

            	}

            }



            return response()->json(['status'=>'success','msg'=>'Custom field data updated']);

        }catch(\Exception $e){

            return response()->json(['status'=>'error','msg'=>$e->getMessage().'__'.$e->getLine()]);

        }

	}



	public function posteventremovecustomfieldfile(Request $req){

		try{

            $eventId = Crypt::decrypt($req->get('event_id'));

            $field = $req->get('field');

            $id = decrypt($req->get('id'));

            if($field == 'single') {

            	$custom_fields = Customfield::Id($id)->ModuleName('event_info')->first();

            	if(file_exists(public_path().$custom_fields->field_value)){

            		unlink(public_path().$custom_fields->field_value);

            	}

            	$custom_fields->field_value = '';

            	$custom_fields->save();

            }else{

				$custom_fields_meta = Customfieldmeta::find($id);

            	if($custom_fields_meta->field_value != '' && file_exists(public_path().$custom_fields_meta->field_value)){

            		unlink(public_path().$custom_fields_meta->field_value);

            	}

            	$custom_fields_meta->delete();

            }

            return response()->json(['status'=>'success','msg'=>'File removed']);

        }catch(\Exception $e){

            return response()->json(['status'=>'error','msg'=>$e->getMessage().'__'.$e->getLine()]);

        }

	}



	public function posteventremovecustomfield(Request $req){

		try{

            $eventId = Crypt::decrypt($req->get('event_id'));

            $id = decrypt($req->get('id'));

            $custom_fields = Customfield::Id($id)->ModuleName('event_info')->first();

            $custom_fields->status = 'deleted';

            $custom_fields->save();

            return response()->json(['status'=>'success','msg'=>'Field removed']);

        }catch(\Exception $e){

            return response()->json(['status'=>'error','msg'=>$e->getMessage().'__'.$e->getLine()]);

        }

	}



	public function posteventsortingcustomfield(Request $req){

		try{

            $eventId = Crypt::decrypt($req->get('event_id'));

            $pos = $req->get('pos');

            $v = 1;

            foreach($pos as $p) {

            	$id = Crypt::decrypt($p);

            	$custom_fields = Customfield::Id($id)->Event($eventId)->ModuleName('event_info')->first();

            	if($custom_fields){

            		$custom_fields->sort_order = $v;

		            $custom_fields->save();

		            $v++;

            	}

            }

            return response()->json(['status'=>'success','msg'=>'Field sorting updated']);

        }catch(\Exception $e){

            return response()->json(['status'=>'error','msg'=>$e->getMessage().'__'.$e->getLine()]);

        }

	}

	//event info custom fields end



	//event register custom fields start

		public function posteventmodifycustomfieldsreg(Request $req){

			try{

	            $input = $req->all();

	            $event_id = Crypt::decrypt($input['event_id']);

	            $field_type = $input['field_type'];

	            $label_name = $input['label_name'];

	            $column_length = $input['field_column_length'];

	            $is_required = $input['is_required'];

	            //validation

	                $rules = [

	                            'field_type' => 'required',

	                            'label_name' => 'required'

	                        ];

	                $msg = [];

	                $validation = Validator::make($input, $rules, $msg);

	                if ($validation->fails()) {

	                    return response()->json(['status'=>'validation', 'validation'=>$validation->messages()]);

	                }

	            //validation

	                $insert = new Customfield();

	                $insert->field_type = $field_type;

	                $insert->label_name = $label_name;

	                $insert->column_length = $column_length;

	                $insert->is_required = $is_required;

	                $insert->status = 'active';

	                $insert->user_id = Auth::id();

	                $insert->event_id = $event_id;

	                $insert->module_name = 'event_reg';

	                $insert->save();



	                if($insert->field_slug == '') {

	                    $field_slug = 'eventreg_'.$insert->id.'_'.$event_id;

	                    $insert->field_slug = \Str::slug($field_slug, '_');

	                    $insert->save();

	                }



	                $delete = Customfieldmeta::where('custom_field_id', $insert->id)->delete();

	                if($field_type == 'dropdown' || $field_type == 'checkbox' || $field_type == 'radio'){

	                	$options = $input['options'];

	                    $options = json_decode($options);

	                    foreach($options as $option){

	                        $insertmeta = new Customfieldmeta();

	                        $insertmeta->field_value = $option;

	                        $insertmeta->custom_field_id = $insert->id;

	                        $insertmeta->save();

	                    }

	                }

	                return response()->json(['status'=>'success','msg'=>'Field added']);

	        }catch(\Exception $e){

	            return response()->json(['status'=>'error','msg'=>$e->getMessage().'__'.$e->getLine()]);

	        }

		}



		public function eventcustomfieldstemplatereg(Request $req){

			try{

	            $eventId = Crypt::decrypt($req->get('event_id'));

	            $custom_fields = Customfield::Event($eventId)->NotDeleted()->ModuleName('event_reg')->orderBy('sort_order','ASC')->get();

	            $template = view('backend.events.eventRegTemplate')->with('custom_fields',$custom_fields)->with('eventId',$eventId)->render();

	            return response()->json(['status'=>'success','template'=>$template]);

	        }catch(\Exception $e){

	            return response()->json(['status'=>'error','msg'=>$e->getMessage().'__'.$e->getLine()]);

	        }

		}



		public function posteventsortingcustomfieldreg(Request $req){

			try{

	            $eventId = Crypt::decrypt($req->get('event_id'));

	            $pos = $req->get('pos');

	            $v = 1;

	            foreach($pos as $p) {

	            	$id = Crypt::decrypt($p);

	            	$custom_fields = Customfield::Id($id)->Event($eventId)->ModuleName('event_reg')->first();

	            	if($custom_fields){

	            		$custom_fields->sort_order = $v;

			            $custom_fields->save();

			            $v++;

	            	}

	            }

	            return response()->json(['status'=>'success','msg'=>'Field sorting updated']);

	        }catch(\Exception $e){

	            return response()->json(['status'=>'error','msg'=>$e->getMessage().'__'.$e->getLine()]);

	        }

		}



		public function posteventremovecustomfieldreg(Request $req){

			try{

	            $eventId = Crypt::decrypt($req->get('event_id'));

	            $id = decrypt($req->get('id'));

	            $custom_fields = Customfield::Id($id)->ModuleName('event_reg')->first();

	            $custom_fields->status = 'deleted';

	            $custom_fields->save();

	            return response()->json(['status'=>'success','msg'=>'Field removed']);

	        }catch(\Exception $e){

	            return response()->json(['status'=>'error','msg'=>$e->getMessage().'__'.$e->getLine()]);

	        }

		}



		//event register custom fields end



	//Gallery Category

	public function getaddgallerycategorypage(){

		return view("backend/gallery/addGalleryCategories");

	}



	public function postaddgallerycategorypage(Request $req){

		try {

			$input = $req->all();

			$rules = array(

				"galleryCategoryTitle" => "required"

			);

			$message = [

				"required" => "You can't leave this field empty" 

			];

			$validation = Validator::make($input, $rules, $message);

			if($validation->fails()){

				return redirect()->back()->withInput()->withErrors($validation);

			}



			$insert = new GalleryCategories();

			$insert->categoryName = $input["galleryCategoryTitle"];

			$insert->categorySlug = GalleryCategories::getCategorySlug($input["galleryCategoryTitle"]);

			$insert->addedByName = Auth::User()->userName;

			$insert->addedByID = Auth::User()->id;

			$insert->status = "active";

			$insert->save();

			return redirect()->back()->withSuccess("New gallery category created successfully!!!");

		} catch (Exception $e) {

						

		}

	}



	public function getgallerycategorypage(){

		$galleryCategories = GalleryCategories::where("status", "!=", "deleted")->get();

		return view("backend/gallery/galleryCategories")->with(["galleryCategories"=>$galleryCategories]);

	}



	public function postgallerycategorymodify(Request $req){

    	try{

		    $input = $req->input();

		    $id = Crypt::decrypt($input["id"]);

			$modify = GalleryCategories::find($id);

			// if($modify->categoryName != $input["value"]){

			// 	$modify->categorySlug = GalleryCategories::getCategorySlug($input["value"]);

			// }

			$modify->categoryName = $input["value"];

			$modify->updatedByName = Auth::User()->userName;

			$modify->updatedByID = Auth::User()->id;

			$modify->save();

			return Response::json(["status"=>"success", "msg"=>"Updated Successfully", "name"=>$modify->categoryName]);

    	}catch(Exception $e){

	        //TrackingReport::track("error",$e->getMessage(),"","","delete gallery categories");

	        return Response::json(["status"=>"error"]);

	    }

  	}



	public function postgallerycategorystatus(Request $req){

		$input = $req->input('id');

		$id = Crypt::decrypt($input);

		$check = GalleryCategories::find($id);

		if($check){

			$check->status == "active" ? $current = "inactive" : $current = "active";

			$check->status = $current;

			$check->updatedByName = Auth::User()->userName;

			$check->updatedByID = Auth::User()->id;

			$check->save();

			return Response::json(["status"=>"success", "current"=>ucfirst($current), "msg"=>"Updated Successfully!!!"]);

		}

		return Response::json(["status"=>"failure"]);

	}



	public function postgallerycategorydelete(Request $req){

		$input = $req->input('id');

		$id = Crypt::decrypt($input);

		$delete = GalleryCategories::find($id);

		if($delete){

			$delete->status = "deleted";

			$delete->updatedByName = Auth::User()->userName;

			$delete->updatedByID = Auth::User()->id;

			$delete->save();

			return Response::json(["status"=>"success", "msg"=>"Deleted Successfully!!!"]);

		}

		return Response::json(["status"=>"failure"]);

	}



	//Gallery

	public function getaddgallerypage(){

		return view("backend/gallery/addGallery");

	}



	public function postaddgallerypage(Request $req){

		try {

			return DB::transaction(function() use($req){

				$input = $req->all();

				if(!isset($input["galleryCategory"])){$input["galleryCategory"] = "";}



				$galleryDate = NULL;

				if($input['galleryDate'] != ''){

					$galleryDate = date("Y-m-d", strtotime($input["galleryDate"]));

				}



				$insert = new Gallery();

				$insert->galleryTitle = $input["galleryTitle"];

				$insert->gallerySlug = Gallery::getCategorySlug($input["galleryTitle"]);

				$insert->galleryDate = $galleryDate;

				$insert->galleryHostedBy = $input["galleryHostedBy"];

				$insert->hostDesignation = $input["venue"];

				$insert->descriptionTitle = $input['descriptionTitle'];

				$insert->description = $input['description'];

				$insert->hostCompanyName = $input["hostCompanyName"];

				$insert->galleryCategoryID = $input["galleryCategory"];

				$insert->createdByName = Auth::User()->userName;

				$insert->createdByID = Auth::User()->id;

				$insert->status = "active";

				$insert->save();



				//feature images

				if(isset($input['pro_featureimage']) && $input['pro_featureimage'] != ''){ 

					Upload::insert(['productid'=>$insert->id,'type'=>'feature', 'path'=>$input['pro_featureimage'], 'thumbnail'=>$input['pro_featurethumbimage']]);

				}



				//gallery images

				if(isset($input['pro_galleryimage'])){ $i = 0;

					foreach($input['pro_galleryimage'] as $img){

						$upload = new Upload();

						$upload->type = 'gallery';

						$upload->productid = $insert->id;

						$upload->path = $img;

						$upload->thumbnail = $input['pro_gallerythumbimage'][$i];

						$upload->thumbnail1 = $input['pro_gallerythumb1image'][$i];

						$upload->save(); 

						unset($upload); 

						$i++;

					}

				}



				return redirect()->back()->withSuccess("Gallery created successfully!!!");

			});/* end of transaction */

		} catch (Exception $e) {

			return $e->getMessage();

		}

	}



	public function getgallerypage(){

		$galleries = Gallery::where("status", "!=", "deleted")->get();

		return view("backend/gallery/gallery")->with(["galleries"=>$galleries]);

	}



	public function postgallerystatus(Request $req){

		$input = $req->input('id');

		$id = Crypt::decrypt($input);

		$check = Gallery::find($id);

		if($check){

			$check->status == "active" ? $current = "inactive" : $current = "active";

			$check->status = $current;

			$check->updatedByName = Auth::User()->userName;

			$check->updatedByID = Auth::User()->id;

			$check->save();

			return Response::json(["status"=>"success", "current"=>ucfirst($current), "msg"=>"Updated Successfully!!!"]);

		}

		return Response::json(["status"=>"failure"]);

	}



	public function postgallerydelete(Request $req){

		$input = $req->input('id');

		$id = Crypt::decrypt($input);

		$delete = Gallery::find($id);

		if($delete){

			$delete->status = "deleted";

			$delete->updatedByName = Auth::User()->userName;

			$delete->updatedByID = Auth::User()->id;

			$delete->save();

			return Response::json(["status"=>"success", "msg"=>"Deleted Successfully!!!"]);

		}

		return Response::json(["status"=>"failure"]);

	}



	public function getmodifygallerypage($slug, $key){

		$id = Crypt::decrypt($key);

		$gallery = Gallery::find($id);

		return view("backend/gallery/modifyGallery")->with(["gallery"=>$gallery]);

	}



	public function postdeletegalleryimage(Request $req){

		try {

			$input = $req->all();

			$id = Crypt::decrypt($input["ID"]);

			$check = Upload::findOrFail($id);

			if($check){

				$path = urldecode($check->path);

				$url = parse_url($path);

				//unlink(substr($url["path"], 1));

				$check->delete();

				return Response::json(["status", "success"]);

			}

			return Response::json(["status"=>"failure"]);

		} catch (Exception $e) {

			return $e->getMessage()." Line ".$e->getLine();

		}

	}



	public function postmodifygallerypage(Request $req, $slug, $key){

		try {

			return DB::transaction(function() use($req, $key){

				$input = $req->all();

				$id = Crypt::decrypt($key);

				if(!isset($input["galleryCategory"])){$input["galleryCategory"] = "";}

				$insert = Gallery::find($id);

				if($input["galleryTitle"] != $insert->galleryTitle ){

					$insert->gallerySlug = Gallery::getCategorySlug($input["galleryTitle"]);

				}

				$galleryDate = NULL;

				if($input['galleryDate'] != ''){

					$galleryDate = date("Y-m-d", strtotime($input["galleryDate"]));

				}

				$insert->galleryTitle = $input["galleryTitle"];

				$insert->galleryDate = $galleryDate;

				$insert->galleryHostedBy = $input["galleryHostedBy"];

				$insert->hostDesignation = $input["venue"];

				$insert->descriptionTitle = $input['descriptionTitle'];

				$insert->description = $input['description'];

				$insert->hostCompanyName = $input["hostCompanyName"];

				$insert->galleryCategoryID = $input["galleryCategory"];

				$insert->updatedByName = Auth::User()->userName;

				$insert->updatedByID = Auth::User()->id;

				//$insert->status = "active";

				$insert->save();



				//feature images

				if(isset($input['pro_featureimage']) && $input['pro_featureimage'] != ''){ 

					Upload::where('productid', $insert->id)->where('type', 'feature')->delete();

					Upload::insert(['productid'=>$insert->id,'type'=>'feature','path'=>$input['pro_featureimage'],'thumbnail'=>$input['pro_featurethumbimage']]);

				}



				//gallery images

				if(isset($input['pro_galleryimage'])){ 

					$i = 0;

					Upload::where('productid',$insert->id)->where('type','gallery')->delete();

					foreach($input['pro_galleryimage'] as $img){

						$upload = new Upload();

						$upload->type = 'gallery';

						$upload->productid = $insert->id;

						$upload->path = $img;

						$upload->thumbnail = $input['pro_gallerythumbimage'][$i];

						$upload->thumbnail1 = $input['pro_gallerythumb1image'][$i];

						$upload->save(); 

						unset($upload); 

						$i++;

					}

				}



				return redirect()->back()->withSuccess("Gallery updated successfully!!!");

			});/* end of transaction */

		} catch (Exception $e) {

			return $e->getMessage();

		}

	}



	//Events Registration

	public function geteventsregistration(){

		$events = Events::where('status', 'active')->pluck('eventTitle', 'id');

		return view('backend/events/eventsregistration', compact('events'));

	}



	public function posteventregistration(Request $req){

		try{

			//start

			$input = $req->input();

			$query = DB::table('eventregistration')->orderBy('id','desc');

			if($input['dateFrom'] != ''){

				$query = $query->where(DB::raw('date(paymentDate)'),'>=',date('Y-m-d',strtotime($input['dateFrom'])));

			}

			if($input['dateTo'] != ''){

				$query = $query->where(DB::raw('date(paymentDate)'),'<=',date('Y-m-d',strtotime($input['dateTo'])));

			}

			if($input['events'] != ''){

				$query = $query->where('eventId', $input['events']);

			}

			$query = $query->where('paymentStatus','Success');

			$query = $query->get();

			$totalAmount = 0;

			if(count($query) > 0){

				$result = []; $i = 0;

				$count = count($query);

				foreach($query as $query){

					$result[$i]['sno'] = $i + 1;

					$result[$i]['uniqueId'] = $query->uniqueId;

					$result[$i]['event'] = Events::geteventtitle($query->eventId);

					$result[$i]['user'] = User::getfullname($query->userId);

					$result[$i]['tickets'] = $query->tickets;

					$result[$i]['amount'] = $query->amount;

					$result[$i]['gst'] = $query->gstPercentage;

					$result[$i]['totalAmount'] = $query->totalAmount;

					$result[$i]['paymentDate'] = date(Option::fetchDateFormat()." ".Option::fetchTimeFormat(), strtotime($query->paymentDate));

					$i++;

				}

				return Response::json(['status'=>'success','count'=>$count,'result'=>$result]);

			}

			return Response::json(['status'=>'error','msg'=>'No records found.']);

			//end

		}catch(\Exception $e){

			return Response::json(['status'=>'error','msg'=>$e->getMessage()]);

		}

	}



	//Events Registration

	public function getjobopportunities(){

		$records = Jobopportunities::latest()->get();

		return view('backend/job-opportunities', compact('records'));

	}



	public function postjobopportunities(Request $req){

		try{

			//start

			$input = $req->input();

			$query = DB::table('job_opportunities')->orderBy('id','desc');

			if($input['dateFrom'] != ''){

				$query = $query->where(DB::raw('date(created_at)'),'>=',date('Y-m-d',strtotime($input['dateFrom'])));

			}

			if($input['dateTo'] != ''){

				$query = $query->where(DB::raw('date(created_at)'),'<=',date('Y-m-d',strtotime($input['dateTo'])));

			}

			$query = $query->get();

			$totalAmount = 0;

			if(count($query) > 0){

				$result = []; $i = 0;

				$count = count($query);

				foreach($query as $query){

					$result[$i]['sno'] = $i + 1;

					$result[$i]['email'] = $query->email;

					$result[$i]['job_title'] = $query->job_title;

					$result[$i]['location'] = $query->location;

					$result[$i]['job_type'] = ucfirst($query->job_type);

					$result[$i]['application_email'] = $query->application_email;

					$result[$i]['company_name'] = $query->company_name;

					$i++;

				}

				return Response::json(['status'=>'success','count'=>$count,'result'=>$result]);

			}

			return Response::json(['status'=>'error','msg'=>'No records found.']);

			//end

		}catch(\Exception $e){

			return Response::json(['status'=>'error','msg'=>$e->getMessage()]);

		}

	}





	//Reports

	public function getpaymentreportpage(){

		return view("backend/reports/payment");

	}



	public function postpaymentreportpage(Request $req){

		try {

			$input = $req->all();

			$payments = DB::table("payments");

			

			if($input['dateFrom'] != ''){

				$payments = $payments->where(DB::raw('date(trans_date)'), '>=', date('Y-m-d', strtotime($input['dateFrom'])));

			}



			if($input['dateTo'] != ''){

				$payments = $payments->where(DB::raw('date(trans_date)'), '<=', date('Y-m-d', strtotime($input['dateTo'])));

			}



			if($input['orderID'] != ''){

				$payments = $payments->where('order_id', '=', $input['orderID']);

			}



			if($input['paymentStatus'] != ''){

				$payments = $payments->where('order_status', '=', $input['paymentStatus']);

			}



			$payments = $payments->select('order_id', 'tracking_id', 'billing_name', 'billing_email', 'order_status', 'payment_mode', 'amount', 'merchant_param1', 'trans_date');



			$payments = $payments->orderBy('trans_date', 'DESC')->get();

			return $payments;

		} catch (Exception $e) {

			//Trackingreport::track("error", $e->getMessage(), "", "", "Course Application");

            return Response::json(["msg"=>$e->getMessage()]);

		}

	}



	



	public function getpaymentreportsexcelpage($from = NULL, $to = NULL, $order = NULL, $status = NULL){

		//Payment Details

		if(isset($_GET['from']) && $_GET['from'] != ''){

			$from = $_GET['from'];

		}



		if(isset($_GET['to']) && $_GET['to'] != ''){

			$to = $_GET['to'];

		}



		if(isset($_GET['order']) && $_GET['order'] != ''){

			$order = $_GET['order'];

		}



		if(isset($_GET['status']) && $_GET['status'] != ''){

			$status = $_GET['status'];

		}



		$payments = DB::table("payments");

			

		if($from != ''){

			$payments = $payments->where(DB::raw('date(trans_date)'), '>=', date('Y-m-d', strtotime($from)));

		}



		if($to != ''){

			$payments = $payments->where(DB::raw('date(trans_date)'), '<=', date('Y-m-d', strtotime($to)));

		}



		if($order != ''){

			$payments = $payments->where('unique_id', '=', $order);

		}



		if($status != ''){

			$payments = $payments->where('order_status', '=', $status);

		}



		$payments = $payments->select('order_id', 'tracking_id', 'billing_name', 'billing_email', 'order_status', 'payment_mode', 'amount', 'merchant_param1', 'trans_date');



		$payments = $payments->get();



		if(count($payments) > 0){

			Excel::create('Payment Reports', function($excel) use($payments){

		      	$excel->sheet('Payment Reports', function($sheet) use($payments){

		      		$sheet->mergeCells('A1:I1');

		      		$sheet->setOrientation('landscape');

			      		$sheet->row(1, function ($row){

			            $row->setFontFamily('Comic Sans MS');

			            $row->setFontSize(10);

			        });

		        	$sheet->loadView('backend/reports/paymentExcel', ['payments'=>$payments]);

		      	});

	    	})->download('xls');/* end of excel */

		}

		return "No records Found";

	}



	public function uploadgalleryhomepage(Request $req){

		$input = $req->all();

		//gallery images

		if(isset($input['pro_galleryimage'])){ $i = 0;

			$delete = Upload::where("type", "home")->delete();

			foreach($input['pro_galleryimage'] as $img){

				$upload = new Upload();

				$upload->type = 'home';

				$upload->path = $img;

				$upload->thumbnail = $input['pro_gallerythumbimage'][$i];

				$upload->thumbnail1 = $input['pro_gallerythumb1image'][$i];

				$upload->save(); 

				unset($upload); 

				$i++;

			}



			return redirect()->back()->withSuccess("Gallery images updated successfully!!!");

		}



		return redirect()->back()->with("error", "Error processing your request..");

	}







	//Maddys Reports

	public function getmaddysreportpage(){

		return view("backend/reports/maddys");

	}



	public function postmaddysreportpage(Request $req){

		try {

			$input = $req->all();

			$payments = DB::connection('wordpress')->table('wp_maddys_2018_step2')->where('paymentStatus', 'Success');

			

			if($input['dateFrom'] != ''){

				$payments = $payments->where(DB::raw('date(paymentDate)'), '>=', date('Y-m-d', strtotime($input['dateFrom'])));

			}



			if($input['dateTo'] != ''){

				$payments = $payments->where(DB::raw('date(paymentDate)'), '<=', date('Y-m-d', strtotime($input['dateTo'])));

			}



			$payments = $payments->select('entryID', 'name', 'email', 'payableAmount as amount', 'paymentMode as mode', 'trackingID as trackingId', 'paymentDate', 'contactNo', 'companyName');



			$payments = $payments->orderBy('paymentDate', 'DESC')->get();



			$results = [];

			$i = 0;



			foreach($payments as $payment){



				$record = DB::connection('wordpress')->table('wp_maddys_2018_step1')->where('entryID', $payment->entryID)->first();

				$category = [];

				if($record){



					if($record->groupA != ''){

						array_push($category, $record->groupA);

					}



					if($record->groupB != ''){

						array_push($category, $record->groupB);

					}



					if($record->groupC != ''){

						array_push($category, $record->groupC);

					}



					if($record->groupD != ''){

						array_push($category, $record->groupD);

					}



					if($record->groupE != ''){

						array_push($category, $record->groupE);

					}



					if($record->groupF != ''){

						array_push($category, $record->groupF);

					}



					if($record->groupACampaign != ''){

						array_push($category, $record->groupACampaign);

					}



				}



				$categories = '';

				if(count($category) > 0){

					$categories = implode(', ',$category);

				}





				$results[$i]['entryID'] = $payment->entryID;

				$results[$i]['name'] = $payment->name;

				$results[$i]['email'] = $payment->email;

				$results[$i]['amount'] = $payment->amount;

				$results[$i]['mode'] = $payment->mode;

				$results[$i]['trackingId'] = $payment->trackingId;

				$results[$i]['paymentDate'] = $payment->paymentDate;

				$results[$i]['contactNo'] = $payment->contactNo;

				$results[$i]['companyName'] = $payment->companyName;

				$results[$i]['categories'] = $categories;





				$i++;



			}





			return $results;

		} catch (Exception $e) {

            return Response::json(["msg"=>$e->getMessage()]);

		}

	}





	public function getmaddysreportsexcelpage($from = NULL, $to = NULL){

		$from = '';

		$to = '';

		if(isset($_GET['from']) && $_GET['from'] != ''){

			$from = $_GET['from'];

		}



		if(isset($_GET['to']) && $_GET['to'] != ''){

			$to = $_GET['to'];

		}



		$payments = DB::connection('wordpress')->table('wp_maddys_2018_step2')->where('paymentStatus', 'Success');

			

		if($from != ''){

			$payments = $payments->where(DB::raw('date(paymentDate)'), '>=', date('Y-m-d', strtotime($from)));

		}



		if($to != ''){

			$payments = $payments->where(DB::raw('date(paymentDate)'), '<=', date('Y-m-d', strtotime($to)));

		}



		$payments = $payments->select('entryID', 'name', 'email', 'payableAmount as amount', 'paymentMode as mode', 'trackingID as trackingId', 'paymentDate', 'contactNo', 'companyName');



		$payments = $payments->orderBy('paymentDate', 'DESC')->get();



		$results = [];

		$i = 0;



		foreach($payments as $payment){



			$record = DB::connection('wordpress')->table('wp_maddys_2018_step1')->where('entryID', $payment->entryID)->first();

			$category = [];

			if($record){



				if($record->groupA != ''){

					array_push($category, $record->groupA);

				}



				if($record->groupB != ''){

					array_push($category, $record->groupB);

				}



				if($record->groupC != ''){

					array_push($category, $record->groupC);

				}



				if($record->groupD != ''){

					array_push($category, $record->groupD);

				}



				if($record->groupE != ''){

					array_push($category, $record->groupE);

				}



				if($record->groupF != ''){

					array_push($category, $record->groupF);

				}



				if($record->groupACampaign != ''){

					array_push($category, $record->groupACampaign);

				}



			}



			$categories = '';

			if(count($category) > 0){

				$categories = implode(', ',$category);

			}





			$results[$i]['entryID'] = $payment->entryID;

			$results[$i]['name'] = $payment->name;

			$results[$i]['email'] = $payment->email;

			$results[$i]['amount'] = $payment->amount;

			$results[$i]['mode'] = $payment->mode;

			$results[$i]['trackingId'] = $payment->trackingId;

			$results[$i]['paymentDate'] = $payment->paymentDate;

			$results[$i]['contactNo'] = $payment->contactNo;

			$results[$i]['companyName'] = $payment->companyName;

			$results[$i]['categories'] = $categories;





			$i++;



		}



		if(count($results) > 0){

			Excel::create('Maddys Reports', function($excel) use($results){

		      	$excel->sheet('Maddys Reports', function($sheet) use($results){

		      		$sheet->mergeCells('A1:I1');

		      		$sheet->setOrientation('landscape');

			      		$sheet->row(1, function ($row){

			            $row->setFontFamily('Comic Sans MS');

			            $row->setFontSize(10);

			        });

		        	$sheet->loadView('backend/reports/maddysExcel', ['payments'=>$results]);

		      	});

	    	})->download('xls');/* end of excel */

		}

		return "No records Found";

	}





	//Entry Ticket Reports

	public function getentryticketreportpage(){

		return view("backend/reports/entryTicket");

	}



	public function postentryticketreportpage(Request $req){

		try {

			$input = $req->all();

			$payments = DB::connection('wordpress')->table('wp_maddys_entry_ticket')->where('paymentStatus', 'Success');

			

			if($input['dateFrom'] != ''){

				$payments = $payments->where(DB::raw('date(paymentDate)'), '>=', date('Y-m-d', strtotime($input['dateFrom'])));

			}



			if($input['dateTo'] != ''){

				$payments = $payments->where(DB::raw('date(paymentDate)'), '<=', date('Y-m-d', strtotime($input['dateTo'])));

			}



			$payments = $payments->select('entryID', 'fullName as name', 'emailAddress as email', 'payableAmount as amount', 'paymentMode as mode', 'trackingID as trackingId', 'paymentDate', 'contactNumber as contactNo', 'companyName', 'ticketsCount as tickets');



			$payments = $payments->orderBy('paymentDate', 'DESC')->get();

			return $payments;

		} catch (Exception $e) {

			//Trackingreport::track("error", $e->getMessage(), "", "", "Course Application");

            return Response::json(["msg"=>$e->getMessage()]);

		}

	}





	public function getentryticketreportsexcelpage($from = NULL, $to = NULL){

		//Payment Details

		$from = '';

		$to = '';

		if(isset($_GET['from']) && $_GET['from'] != ''){

			$from = $_GET['from'];

		}



		if(isset($_GET['to']) && $_GET['to'] != ''){

			$to = $_GET['to'];

		}



		$payments = DB::connection('wordpress')->table('wp_maddys_entry_ticket')->where('paymentStatus', 'Success');

			

		if($from != ''){

			$payments = $payments->where(DB::raw('date(paymentDate)'), '>=', date('Y-m-d', strtotime($from)));

		}



		if($to != ''){

			$payments = $payments->where(DB::raw('date(paymentDate)'), '<=', date('Y-m-d', strtotime($to)));

		}



		$payments = $payments->select('entryID', 'fullName as name', 'emailAddress as email', 'payableAmount as amount', 'paymentMode as mode', 'trackingID as trackingId', 'paymentDate', 'contactNumber as contactNo', 'companyName', 'ticketsCount as tickets');



		$payments = $payments->orderBy('paymentDate', 'DESC')->get();



		if(count($payments) > 0){

			Excel::create('Entry Ticket Reports', function($excel) use($payments){

		      	$excel->sheet('Entry Ticket Reports', function($sheet) use($payments){

		      		$sheet->mergeCells('A1:I1');

		      		$sheet->setOrientation('landscape');

			      		$sheet->row(1, function ($row){

			            $row->setFontFamily('Comic Sans MS');

			            $row->setFontSize(10);

			        });

		        	$sheet->loadView('backend/reports/entryTicketExcel', ['payments'=>$payments]);

		      	});

	    	})->download('xls');/* end of excel */

		}

		return "No records Found";

	}

}

