<?php 
namespace App\Models;
use Illuminate\Database\Eloquent\Model;

class BlogCategories extends Model 
{

	protected $table = 'blogcategories';

	public static function getCategorySlug($title)
	{
	    $slug = str_slug($title);
		$slugCount = count( BlogCategories::whereRaw("categorySlug REGEXP '^{$slug}(-[0-9]*)?$'")->get() );
		return ($slugCount > 0) ? "{$slug}-{$slugCount}" : $slug;
	}
}
