<?php 
namespace App\Models;
use Illuminate\Database\Eloquent\Model;
class Customfield extends Model 
{
	protected $table = 'custom_fields';

	public function scopeId($query,$id){
    	return $query->where('id', $id);
    }

    public function scopeNotDeleted($query){
    	return $query->where('status','!=','deleted');
    }

    public function scopeEvent($query,$event_id){
    	return $query->where('event_id',$event_id);
    }

    public function scopeSlug($query,$slug){
    	return $query->where('field_slug',$slug);
    }

    public function scopeModuleName($query,$name){
    	return $query->where('module_name',$name);
    }

    public function scopeRequired($query){
    	return $query->where('is_required','yes');
    }

}
