<?php 
namespace App\Models;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Str;

class EventCategories extends Model{

	protected $table = 'eventcategories';

	public static function getCategorySlug($title){
	    $slugText = Str::slug($title);
		$slugCount = count( EventCategories::whereRaw("categorySlug REGEXP '^{$slugText}(-[(0-9)]*)?$'")->get() );
		$slug = ($slugCount > 0) ? "{$slugText}-({$slugCount})" : $slugText;
		return $slug;
	}

	public static function getcategoryname($id){
		$record = EventCategories::find($id);
		if($record){
			return $record->categoryName;
		}
		return '';
	}

	public static function geteventcategoryslug($id){
		$record = EventCategories::find($id);
		if($record){
			return $record->categorySlug;
		}
		return '';
	}
}
