<?php 
namespace App\Models;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Str;

class Events extends Model{

	protected $table = 'events';

	public static function getEventSlug($title){
	    $slugText = Str::slug($title,'-');
		$slugCount = count( Events::whereRaw("eventSlug REGEXP '^{$slugText}(-[(0-9)]*)?$'")->get() );
		$slug = ($slugCount > 0) ? "{$slugText}-({$slugCount})" : $slugText;
		return $slug;
	}

	public static function checkEventPoster($name, $path, $extension){
		if(file_exists(public_path().$path.$name.".".$extension)) {
			return Events::checkEventPoster($name."(1)", $path, $extension);
		}
		return $name;
	}

	public static function geteventtitle($id){
		$record = Events::find($id);
		if($record){
			return $record->eventTitle;
		}
		return '';
	}
}
