<?php 
namespace App\Models;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Str;

class GalleryCategories extends Model{

	protected $table = 'gallerycategories';

	public static function getCategorySlug($title){
	    $slug = Str::slug($title);
		$slugCount = count(GalleryCategories::whereRaw("categorySlug REGEXP '^{$slug}(-[(0-9)]*)?$'")->get() );
		return ($slugCount > 0) ? "{$slug}-({$slugCount})" : $slug;
	}

	public static function getcategoryname($id){
		$record = GalleryCategories::find($id);
		if($record){
			return $record->categoryName;
		}
		return '';
	}

	public static function getgallerycategoryslug($id){
		$record = GalleryCategories::find($id);
		if($record){
			return $record->categorySlug;
		}
		return '';
	}
}
