<?php 
namespace App\Models;
use Illuminate\Support\Str;
use Illuminate\Database\Eloquent\Model;


class News extends Model 
{

	protected $table = 'news';

	public static function getSlug($title)
	{
	    $slug = Str::slug($title);
		$slugCount = count( News::whereRaw("newsSlug REGEXP '^{$slug}(-[0-9]*)?$'")->get() );
		return ($slugCount > 0) ? "{$slug}-{$slugCount}" : $slug;
	}
}
