<?php 
namespace App\Models;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Str;

class NewsCategories extends Model 
{

	protected $table = 'newscategories';

	public static function getCategorySlug($title)
	{
	    $slug = Str::slug($title);
		$slugCount = count( NewsCategories::whereRaw("categorySlug REGEXP '^{$slug}(-[0-9]*)?$'")->get() );
		return ($slugCount > 0) ? "{$slug}-{$slugCount}" : $slug;
	}
}
