<?php 
namespace App\Models;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Str;

class NewsletterGroup extends Model 
{

	protected $table = 'newslettergroup';


	public static function getSlug($title)
	{
	    $slug = Str::slug($title);
		$slugCount = count( NewsletterGroup::whereRaw("newsletterGroupSlug REGEXP '^{$slug}(-[0-9]*)?$'")->get() );
		return ($slugCount > 0) ? "{$slug}-({$slugCount})" : $slug;
	}

	public static function getnewslettergroupnames($id)
	{
		$groups = [];
		foreach (explode(",",$id) as $name) 
		{
			$check = NewsletterGroup::find($name);
			if($check)
			{
				array_push($groups, $check->newsletterGroupName);
			}
		}
		return implode(", ", array_map("ucwords",$groups));
	}
	
}
