<?php 
namespace App\Models;

use Illuminate\Database\Eloquent\Model;


class Option extends Model {

	protected $table = 'options';

	public static function getvalue($key){
		$option = Option::where('key', '=', $key)->first();
		if($option){
			return $option->value;
		}
		return '';
	}

	public static function storetooption($key,$value){
		$option = Option::where('key', $key)->first();
		if(!$option){
			Option::insert(['key'=>$key, 'value'=>$value]);
			return 'success';
		}else{
			Option::where('key', $key)->update(['value'=>$value]);
			return 'success';
		}
		return 'error';
	}

	public static function checkifoptionkey($key){
		$option = Option::where('key',$key)->first();
		if($option){
			return 'yes';
		}
		return 'no';
	}

	public static function fetchDateFormat(){
		return Option::getvalue("dateFormat");
	}

	public static function fetchTimeFormat(){
		return Option::getvalue("timeFormat");
	}

	public static function portalName(){
		return Option::getvalue("portalName");
	}

	public static function siteTitle(){
		return Option::getvalue("siteTitle");
	}

	public static function portalLogo(){
		$headerLogo = Option::getvalue("header_logo");
		if($headerLogo){
			return Upload::getimageurl($headerLogo);
		}
		return "";
	}

	public static function favicon(){
		$headerLogo = Option::getvalue("header_favicon");
		if($headerLogo){
			return Upload::getimageurl($headerLogo);
		}
		return "";
	}

	public static function moneyFormat($amount){

		if(Option::getvalue('storecurrency_thousandseparator') != ''){
			if(Option::getvalue('storecurrency_decimalseparator') != '' && Option::getvalue('storecurrency_noofdecimal')){
				$currencySymbol = Currency::symbolbyid(Option::getvalue('storecurrency_currency'));
				if(Option::getvalue('storecurrency_position') == 'left'){
					return number_format($amount,Option::getvalue('storecurrency_noofdecimal'),Option::getvalue('storecurrency_decimalseparator'),Option::getvalue('storecurrency_thousandseparator')).' '.$currencySymbol;
				}else{
					return $currencySymbol.' '.number_format($amount,Option::getvalue('storecurrency_noofdecimal'),Option::getvalue('storecurrency_decimalseparator'),Option::getvalue('storecurrency_thousandseparator'));
				}
			}
		}

		if(Option::getvalue('storecurrency_position') == 'left'){
			return number_format($amount,2).' '.$currencySymbol;
		}else{
			return $currencySymbol.' '.number_format($amount,2);
		}

	}
}
