<?php 
namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Auth;

class TrackingReports extends Model {

	protected $table = 'trackingreports';

	public static function track($logtype, $activity, $bookingid, $amount, $process)
	{
		if(Auth::check())
	  	{
	  		$userid = Auth::User()->id;
	  		$usergroup = Auth::User()->userGroup;
	  		$username = Auth::User()->userName;
	  	}
	  	else
	  	{
	  		$userid = '';
	  		$usergroup = '';
	  		$username = '';
	  	}
	  	if($amount == ''){
	  		$amount = 0;
	  	}
	 	$track = new TrackingReports();
	 	$track->logtype = $logtype;
	 	$track->userID = $userid;
	 	$track->userGroup = $usergroup;
	 	$track->bookingID = $bookingid;
	 	$track->activity = $activity;
	 	$track->userName = $username;
	 	$track->amount = $amount;
	 	$track->process = $process;
	 	$track->save();
	 	return 'success';
	}
}
