<?php 
namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Auth;
use App\Models\Adminmenumanage;
use App\Models\Usergroupmeta;
use App\Models\Usergroup;

class Usergroup extends Model 
{
	protected $table = 'usergroup';

	public static function getusergroupname($id)
	{
		return Usergroup::where('id',$id)->pluck('name');
	}

	public static function getviewulpermission($id,$parentID)
	{
		if(Auth::check())
		{
			$check = Usergroupmeta::where("mainMenuID", $parentID)->where("usergroupId",Auth::user()->userGroup)->where("viewPermission", "1")->get();
			if(count($check) > 0)
			{
				return true;
			}
			else
			{
				return false;
			}
		}
		else
		{
			return false;
		}
	}

	public static function getviewpermission($id,$pageId)
	{
		if(Auth::check())
		{
			$check = Usergroup::find($id);
			if($check && $check->status == "active")
			{
				$permission = Usergroupmeta::where("usergroupId",$id)->where('pageId',$pageId)->first();
				if($permission && $permission->viewPermission == '1')
				{
					return true;
				}
				else
				{
					return false;
				}
			}
			else
			{
				return false;
			}
		}
		else
		{
			return false;
		}
	}

	public static function getcreatepermissions($groupId,$pageId)
	{
		if(Auth::check())
		{
			$check = Usergroup::find($groupId);
			if($check && $check->status == "active")
			{
				$permission = Usergroupmeta::where("usergroupId",$groupId)->where("pageId",$pageId)->first();
				if($permission && $permission->createPermission == '1')
				{
					return true;
				}
				else
				{
					return false;
				}
			}
			else
			{
				return true;
			}
		}
		else
		{
			return false;
		}
	}

	public static function getupdatepermission($id,$pageId)
	{
		if(Auth::check())
		{
			$check = Usergroup::find($id);
			if($check && $check->status == "active")
			{
				$permission = Usergroupmeta::where("usergroupId",$id)->where('pageId',$pageId)->first();
				if($permission && $permission->updatePermission == '1')
				{
					return true;
				}
				else
				{
					return false;
				}
			}
			else
			{
				return true;
			}
		}
		else
		{
			return false;
		}
	}

	public static function getdeletepermission($groupId,$pageId)
	{
		if(Auth::check())
		{
			$check = Usergroup::find($groupId);
			if($check && $check->status == "active")
			{
				$permission = Usergroupmeta::where("usergroupId",$groupId)->where("pageId",$pageId)->first();
				if($permission && $permission->deletePermission == '1')
				{
					return true;
				}
				else
				{
					return false;
				}
			}
			else
			{
				return true;
			}
		}
		else
		{
			return false;
		}
	}
}
