<?php 
	use App\Models\User; 
	use App\Models\Option; 
?>
@extends("backend/master")

@section('styles')
	{!! HTML::style('backend/assets/css/theme-default/libs/DataTables/jquery.dataTables.css') !!}
	{!! HTML::style('backend/assets/css/theme-default/libs/DataTables/extensions/dataTables.colVis.css') !!}
	{!! HTML::style('backend/assets/css/theme-default/libs/DataTables/extensions/dataTables.tableTools.css') !!}
@stop

@section('maincontent')
	<!-- BEGIN CONTENT-->
	<div id="content">
		<section class="style-default-bright">
			<div class="section-header ">
				<ol class="breadcrumb">
					<li class="active">Home</li>
					<li>Executive Committee Members</li>
				</ol>
			</div>

			<div class="section-header">
				<div class="row">
					<div class="col-lg-6">
						<h2 class="text-primary">Executive Committee Members</h2>
					</div>
					<div class="col-lg-6">
						{!! HTML::link("admin/about/executive/committee/members/add/get", "Add New Executive Committee Members", ["class"=>"btn ink-reaction pull-right btn-primary"]) !!}
					</div>
				</div>
			</div>

			<div class="section-body">
				<div class="row">
					<div class="col-lg-12">
						<div class="table-responsive">
							<table id="myTable" class="table table-striped table-hover">
								<thead>
									<tr>
										<th>#</th>
										<th>Title</th>
										<th>Status</th>
										<th>Actions</th>
									</tr>
								</thead>

								<tbody>
									@if(count($members) > 0)
										<?php $i = 0; ?>
										@foreach($members as $member)
											<?php
												$id = Crypt::encrypt($member->id);
											?>
											<tr>
												<td>{!! ++$i !!}</td>
												<td>{!! $member->yearTitle !!}</td>
												@if($member->status == 'active')
													<td>
														<button type="button" class="btn ink-reaction btn-xs btn-success memberStatus" data-id="{!! $id !!}">Active</button>
													</td>
												@else
													<td>
														<button type="button" class="btn ink-reaction btn-xs memberStatus btn-danger" data-id="{!! $id !!}">Inactive</button>
													</td>
												@endif
												
												<td>
													<a href="{!! URL::to('admin/about/executive/committee/members/modify/get/'.$id) !!}" class="btn btn-icon-toggle" data-toggle="tooltip" data-placement="top" data-original-title="Edit row">
													<i class="fa fa-pencil"></i>
													</a>
													<button type="button" class="btn btn-icon-toggle presidentDelete" data-toggle="tooltip" data-placement="top" data-original-title="Delete row" data-id="{!! $id !!}"><i class="fa fa-trash-o"></i></button>
												</td>
											</tr>
										@endforeach
									@else
										No Presidents Found.
									@endif
								</tbody>
							</table>
						</div><!--end .table-responsive -->
					</div><!--end .col -->
				</div><!--end .row -->
				<!-- END DATATABLE 1 -->

			</div><!--end .section-body -->
		</section>
	</div><!--end #content-->
	<!-- END CONTENT -->
@stop

@section('script')
	{!! HTML::script('backend/assets/js/libs/DataTables/jquery.dataTables.min.js') !!}
	{!! HTML::script('backend/assets/js/libs/DataTables/extensions/ColVis/js/dataTables.colVis.min.js') !!}
	{!! HTML::script('backend/assets/js/libs/DataTables/extensions/TableTools/js/dataTables.tableTools.min.js') !!}
	{!! HTML::script('backend/assets/js/core/demo/DemoTableDynamic.js') !!}
	<script type="text/javascript">
		$(document).ready(function(){
	    	$('#myTable').DataTable();
		});

		$(document).on("click", ".memberStatus", function(){
			var clicked = $(this);
			var id = clicked.attr("data-id");
			$("#processingIcon").remove();
			swal({
		        title: "Are you sure?",
		        text: "Do you really want to change this members's status?",
		        type: "warning",
		        showCancelButton: true,
		        confirmButtonColor: "#EE2C47",
		        confirmButtonText: "Yes, change it!",
		        cancelButtonText: "No, cancel pls!",
		        closeOnConfirm: false,
		        closeOnCancel: false
		    },
		    function(isConfirm){
		        if(!isConfirm){
		          	swal("Cancelled", "This members's status is not being changed :)", "error");
		          	return false;
		        }

		        clicked.after('<span id="processingIcon" style="color:#399bff"><i class="fa fa-circle-o-notch fa-spin"></i></span>');

				$.ajax({
					type: "POST",
					url:  "/admin/about/executive/committee/members/status/post",
					headers: { 'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content'), },
					data: {id:id},
					dataType: "json",
					success: function(data){
						console.log(data);
						var colour = "";
						if(data.status == "success"){
							data.current == "Inactive" ? colour = "btn-danger" : colour = "btn-success";
							clicked.text(data.current);
							clicked.removeClass("btn-success btn-danger").addClass(colour);
							$("#processingIcon").remove();
							swal("Changed!", "This members's status changed to "+data.current, "success");
							success_msg(data.msg);
						}
						return false;
					},
					error: function(e){
						console.log(e.responseText);
						return false;
					}
				});/* end of ajax */
			});/* end of confirm function */
			return false;
		});/* end of click function */

		$(document).on("click", ".presidentDelete", function(){
			var clicked = $(this);
			var id = clicked.attr("data-id");
			$("#processingIcon").remove();
			swal({
	            title: "Are you sure?",
	            text: "Do you really want to delete this member's details?",
	            type: "warning",
	            showCancelButton: true,
	            confirmButtonColor: "#EE2C47",
	            confirmButtonText: "Yes, delete!",
	            cancelButtonText: "No, cancel pls!",
	            closeOnConfirm: false,
	            closeOnCancel: false
        	},
	        function(isConfirm){
            	if(!isConfirm){
              		swal("Cancelled", "This members's details are not being deleted:)", "error");
              		$("#processingIcon").remove();
              		return false;
            	}

            	clicked.after('<span id="processingIcon" style="color:#399bff"><i class="fa fa-circle-o-notch fa-spin"></i></span>');

				$.ajax({
					type: "POST",
					url:  "/admin/about/executive/committee/members/delete/post",
					headers: { 'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content'), },
					data: {id:id},
					dataType: "json",
					success: function(data){
						console.log(data);
						var colour="";
						if(data.status == "success"){
							clicked.closest("tr").hide();
							success_msg(data.msg);
							$("#processingIcon").remove();
							swal("Deleted!", "This member's details deleted successfully!!!", "success");
						}
						return false;
					},
					error: function(e){
						console.log(e.responseText);
						return false;
					}
				});/* end of ajax */
			});/* end of confirm function */
			return false;
		});/* end of click function */
	</script>
@stop