<?php 
	use App\Models\User; 
?>
@extends("backend/master")
@section('maincontent')
<!-- BEGIN CONTENT-->
<div id="content">
<section>
	<div class="section-header ">
		<ol class="breadcrumb">
			<li class="active">Home</li>
			<li class="active">Executive Committee Members</li>
			<li>Modify Executive Committee Members</li>
		</ol>
	</div>

	<div class="section-body">
		<!-- BEGIN VERTICAL FORM -->
		<div class="row">
			<div class="col-lg-12">
				<h1 class="text-primary">Modify Executive Committee Members</h1>
			</div><!--end .col -->

			<div class="col-lg-2 col-md-4">
				<div class="section-header">
					{!! HTML::link("admin/about/executive/committee/members/get", "Manage Exe. Comm. Membs",["class"=>"btn ink-reaction btn-block btn-primary"]) !!}
				</div>
			</div><!--end .col -->

			<?php
				$id = Crypt::encrypt($member->id);
			?>

			<div class="col-md-10">
				{!! Form::open(['url'=>'admin/about/executive/committee/members/modify/post/'.$id, 'class'=>'form']) !!}
					<div class="card">
						<div class="card-head style-primary">
							<header>Modify Executive Committee Members</header>
						</div>

						@if(Session::has('success')) {!! HTML::display_success('success') !!} @endif

						<div class="card-body">
							<div class="row">
								<div class="col-md-12">
									<div class="row">
										<div class="col-sm-12">
											<div class="form-group @if($errors->has('yearTitle'))has-error @endif">
												{!! Form::text("yearTitle",$member->yearTitle,["class"=>"form-control"]) !!}
												@if($errors->has("yearTitle"))
													<span id="yearTitle-error" class="help-block">{!! $errors->first("yearTitle") !!}</span>
												@endif
												{!! HTML::decode(Form::label("yearTitle","Title <span class='text-danger'>*</span>")) !!}
											</div>
										</div>

										<div class="col-sm-12">
											<div class="form-group @if($errors->has('membersDescription'))has-error @endif">
												{!! Form::textarea("membersDescription",$member->membersDescription,["class"=>"form-control"]) !!}
												@if($errors->has("membersDescription"))
													<span id="membersDescription-error" class="help-block">{!! $errors->first("membersDescription") !!}</span>
												@endif
												{!! HTML::decode(Form::label("membersDescription","Members Description <span class='text-danger'>*</span>")) !!}
											</div>
										</div>
									</div>
								</div>
							</div><!--end row-->
						</div><!--end card-body-->

						<div class="card-actionbar">
							<div class="card-actionbar-row">
								<button class="btn ink-reaction btn-primary-dark" type="submit">SAVE</button>
							</div>
						</div>
					</div><!--end col-md-10-->
				{!! Form::close() !!}
			</div>
		</div>
	</div>
</section>
</div>

@stop


@section('script')
	{!! HTML::script('backend/ckeditor/ckeditor.js') !!}
	<script type="text/javascript">
		CKEDITOR.replace('membersDescription');
  	</script>
@stop