<?php 
	use App\Models\User; 
	use App\Models\Taxes; 
?>
@extends("backend/master")
@section('maincontent')
<!-- BEGIN CONTENT-->
<div id="content">
<section>
	<div class="section-header ">
		<ol class="breadcrumb">
			<li class="active">Home</li>
			<li class="active">Past Presidents</li>
			<li>Modify Past Presidents</li>
		</ol>
	</div>

	<div class="section-body">
		<!-- BEGIN VERTICAL FORM -->
		<div class="row">
			<div class="col-lg-12">
				<h1 class="text-primary">Modify Past Presidents</h1>
			</div><!--end .col -->

			<div class="col-lg-2 col-md-4">
				<div class="section-header">
					{!! HTML::link("admin/about/past/presidents/get", "Manage Past Presidents", ["class"=>"btn ink-reaction btn-block btn-primary"]) !!}
				</div>
			</div><!--end .col -->

			<?php
				$id = Crypt::encrypt($president->id);
			?>

			<div class="col-md-10">
				{!! Form::open(['url'=>'admin/about/past/presidents/modify/post/'.$id, 'class'=>'form']) !!}
					<div class="card">
						<div class="card-head style-primary">
							<header>Modify Past Presidents</header>
						</div>

						@if(Session::has('success')) {!! HTML::display_success('success') !!} @endif

						<div class="card-body">
							<div class="row">
								<div class="col-md-6">
									<div class="row">
										<div class="col-sm-12">
											<div class="form-group @if($errors->has('presidentName'))has-error @endif">
												{!! Form::text("presidentName",$president->presidentName,["class"=>"form-control"]) !!}
												@if($errors->has("presidentName"))
													<span id="presidentName-error" class="help-block">{!! $errors->first("presidentName") !!}</span>
												@endif
												{!! HTML::decode(Form::label("presidentName","President's Name <span class='text-danger'>*</span>")) !!}
											</div>
										</div>

										<div class="col-sm-12">
											<div class="form-group @if($errors->has('yearRange'))has-error @endif">
												{!! Form::text("yearRange",$president->yearRange,["class"=>"form-control"]) !!}
												@if($errors->has("yearRange"))
													<span id="yearRange-error" class="help-block">{!! $errors->first("yearRange") !!}</span>
												@endif
												{!! HTML::decode(Form::label("yearRange","Year Range <span class='text-danger'>*</span>")) !!}
											</div>
										</div>
										
										<div class="col-sm-12">
											<div class="form-group @if($errors->has('companyName'))has-error @endif">
												{!! Form::text("companyName",$president->companyName,["class"=>"form-control"]) !!}
												@if($errors->has("companyName"))
													<span id="companyName-error" class="help-block">{!! $errors->first("companyName") !!}</span>
												@endif
												{!! HTML::decode(Form::label("companyName","Company Name <span class='text-danger'>*</span>")) !!}
											</div>
										</div>
									</div>
								</div>

								<div class="col-md-6">
									<div class="card">
										<div class="card-head">
											<header>Upload Image</header>
										</div><!--end .card-head -->

										<div class="card-body">
											<div class="form-group @if($errors->has('presidentsImage'))has-error @endif">
												<input type="text" value="{!! $president->presidentsImage !!}" class="form-control" name="presidentsImage" id="header_logo" readonly>
												@if($errors->has("presidentsImage"))
													<span id="presidentsImage-error" class="help-block">{!! $errors->first("presidentsImage") !!}</span>
												@endif
												<label for="uploadLogo">Upload President's Photo</label>
												<p class="help-block">Please upload President's Photo.</p>
											</div>

											<p>
												<button type="button" id="headerlogobox" class="btn ink-reaction btn-raised btn-sm btn-primary">Upload</button> &nbsp;&nbsp;
												<button type="button" id="header_removelogo" class="btn ink-reaction btn-raised btn-sm btn-default">Remove</button>
												<div class="progress progress-striped active" id="logoprogressbox" style="display:none;">
													<div class="progress-bar progress-bar-warning" id="logoprogress"></div>
												</div>
												<input type="file" id="headerlogo" style="display:none;">
											</p>

											<div class="row">
												<div class="col-md-3" id="logoplace"><img class="uploadedImage" src="{!! $president->presidentsImage !!}"></div>
											</div>
											<br>
										</div>
									</div>
								</div><!--end col-md-6-->
							</div><!--end row-->
						</div><!--end card-body-->

						<div class="card-actionbar">
							<div class="card-actionbar-row">
								<button class="btn ink-reaction btn-primary-dark" type="submit">SAVE</button>
							</div>
						</div>
					</div><!--end col-md-10-->
				{!! Form::close() !!}
			</div>
		</div>
	</div>
</section>
</div>

@stop


@section('script')
	{!! HTML::script('backend/assets/js/libs/global/iframe-transport.js') !!}
	{!! HTML::script('backend/assets/js/libs/global/jquery-ui.js') !!}
	{!! HTML::script('backend/assets/js/libs/global/fileupload.js') !!}
	{!! HTML::script('backend/js/adminmenu.js')!!}
	<script type="text/javascript">
		$('select').select2();

  		$('#headerlogobox').click(function () { $("#headerlogo").trigger('click'); });
  		$('#header_removelogo').on('click', function(){ $('#header_logo').val(''); $('#logoplace').remove(); });
  		$('#headerlogo').fileupload({
            url: '/imageupload',
            headers: { 'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content'), },
            dataType: 'json',
            formData: { path:'' },
            done: function (e, data) {
                var baseurl = document.location.origin;
                var src = baseurl+'/'+data.result.files[0].url;
                $('#logoplace').html('').html('<img src="'+src+'" id="logoplace" class="uploadedImage">');
                $('#header_logo').val(src);
                storeimages();
                console.log(src);
            },
            progressall: function (e, data) {
                $('#logoprogressbox').show();
                var progress = parseInt(data.loaded / data.total * 100, 10);
                $('#logoprogress').css(
                    'width',
                    progress + '%'
                ).text(progress+'%');
            },error: function(e){
              console.log(e.responseText);
            }
        }).prop('disabled', !$.support.fileInput)
        .parent().addClass($.support.fileInput ? undefined : 'disabled');

        function storeimages(){
         	$('.progress').next().css('width','0%').text(''); $('.progress').hide();
        	console.log(res); return false;
		}
  	</script>
@stop