<?php 
	use App\Models\CustomPages; 
	use App\Models\Option; 
?>
@extends("backend/master")
@section('maincontent')
	<!-- BEGIN CONTENT-->
	<div id="content">
		<section>
			<div class="section-header ">
				<ol class="breadcrumb">
					<li class="active">Home</li>
					<li class="active">Pages</li>
					<li class="active">{!! CustomPages::getcontent("ourFacilitiesPageTitle") !!}</li>
				</ol>
			</div>
			<div class="section-body">
				<!-- BEGIN VERTICAL FORM -->
				<div class="row">
					<div class="col-lg-12">
						<h1 class="text-primary">{!! CustomPages::getcontent("ourFacilitiesPageTitle") !!}</h1>
					</div><!--end .col -->
					
					<div class="clearfix"></div>
					@if(Session::has('success')) {!! HTML::display_success('success') !!} @endif

					<div class="col-lg-12 col-md-12">
						{!! Form::open(["url"=>"admin/pages/aboutus/post","class"=>"form","enctype"=>"multipart/form-data","files"=>true]) !!}
							<div class="panel panel-default">
				        		<div class="panel-body">
				            		<div class="row">
						                <div class="col-md-8 col-lg-8">
							                <div class="form-group @if($errors->has('ourFacilitiesPageTitle'))has-error @endif">
												{!! Form::text("ourFacilitiesPageTitle",CustomPages::getcontent("ourFacilitiesPageTitle"),["class"=>"form-control","placeholder"=>"enter title here"]) !!}
												@if($errors->has("ourFacilitiesPageTitle"))
													<span id="ourFacilitiesPageTitle-error" class="help-block">{!! $errors->first("ourFacilitiesPageTitle") !!}</span>
												@endif
												{!! HTML::decode(Form::label("ourFacilitiesPageTitle","Page Title <span class='text-danger'>*</span>")) !!}
											</div>
						                </div>

						                <div class="col-md-4 col-lg-4 brd-left">
						                  	<div class="text-right">
						                    	{!! Form::submit('Save & Publish',['class'=>'btn ink-reaction btn-primary']) !!}
						                    	<?php
						                    		$data = CustomPages::where("fieldName", "ourFacilitiesPageTitle")->first();
						                    	?>
					                    		@if($data)
					                    			<p><b>Last Modified:</b>  {!! strtoupper($data->updatedByName) !!} ({!! date(Option::fetchDateFormat()." ".Option::fetchTimeFormat(),strtotime($data->updated_at)) !!})</p>
					                    		@endif
						                      
						                  	</div>
						                </div>
				            		</div>
				        		</div>
				        	</div>

				        	<div class="panel panel-default">
				        		<div class="panel-body">
				            		<div class="row">
						                <div class="col-md-12 col-lg-12">
							                <div class="form-group @if($errors->has('ourFacilitiesDescription'))has-error @endif">
												{!! Form::textarea("ourFacilitiesDescription",CustomPages::getcontent("ourFacilitiesDescription"),["class"=>"form-control","placeholder"=>"enter about short description","rows"=>"4"]) !!}
													@if($errors->has("ourFacilitiesDescription"))
													<span id="ourFacilitiesDescription-error" class="help-block">{!! $errors->first("ourFacilitiesDescription") !!}</span>
													@endif
												{!! HTML::decode(Form::label("ourFacilitiesDescription","Short Description <span class='text-danger'>*</span>")) !!}
											</div>
						                </div>
				            		</div>
				        		</div>
				        	</div>
				        {!! Form::close() !!}
					</div><!--end .col -->
				</div><!--end .row -->
				<!-- END VERTICAL FORM -->
			</div>
		</section>
	</div><!--end #content-->
	<!-- END CONTENT -->
@stop

@section("script")
	{!! HTML::script('backend/js/bala.js') !!}
	{!! HTML::script('backend/ckeditor/ckeditor.js') !!}
	<script type="text/javascript">
	    CKEDITOR.replace('ourFacilitiesDescription');
	</script>
@stop