<?php 
	use App\Models\User; 
	use App\Models\Taxes; 
?>
@extends("backend/master")
@section('maincontent')
	<!-- BEGIN CONTENT-->
	<div id="content">
		<section>
			<div class="section-header ">
				<ol class="breadcrumb">
					<li class="active">Home</li>
					<li class="active">Posts</li>
					<li class="active">Add New Post</li>
				</ol>
			</div>
			<div class="section-body">
				<!-- BEGIN VERTICAL FORM -->
				<div class="row">
					<div class="col-lg-12">
						<h1 class="text-primary">Add New Post</h1>
					</div><!--end .col -->
					<div class="col-lg-3 col-md-4">
						
						<div class="section-header">
							{!! HTML::link("admin/blog/get","Manage Posts",["class"=>"btn ink-reaction btn-block btn-primary"]) !!}
						</div>
					</div><!--end .col -->
					<div class="col-md-9">
						{!! Form::open(["url"=>"admin/blog/add/post","class"=>"form","enctype"=>"multipart/form-data","files"=>true]) !!}
							<div class="card">
								<div class="card-head style-primary">
									<header>Create Post</header>
								</div>
								@if(Session::has('success')) {!! HTML::display_success('success') !!} @endif
								<div class="card-body">
									<div class="form-group @if($errors->has('postTitle'))has-error @endif">
										{!! Form::text("postTitle","",["class"=>"form-control"]) !!}
											@if($errors->has("postTitle"))
												<span id="postTitle-error" class="help-block">{!! $errors->first("postTitle") !!}</span>
											@endif
										{!! HTML::decode(Form::label("postTitle","Title <span class='text-danger'>*</span>")) !!}
									</div>
									<div class="form-group @if($errors->has('metaTitle'))has-error @endif">
										{!! Form::text("metaTitle","",["class"=>"form-control"]) !!}
											@if($errors->has("metaTitle"))
												<span id="metaTitle-error" class="help-block">{!! $errors->first("metaTitle") !!}</span>
											@endif
										{!! HTML::decode(Form::label("metaTitle","Meta Title <span class='text-danger'>*</span>")) !!}
									</div>
										
									<div class="form-group @if($errors->has('metaDesc'))has-error @endif">
									
									{!! Form::textarea("metaDesc","",["class"=>"form-control"]) !!}
										@if($errors->has("metaDesc"))
											<span id="metaDesc-error" class="help-block">{!! $errors->first("metaDesc") !!}</span>
										@endif
										{!! HTML::decode(Form::label("metaDesc","Meta Description <span class='text-danger'>*</span>")) !!}
									</div>
										
									<div class="form-group @if($errors->has('metaKeyword'))has-error @endif">
										{!! Form::text("metaKeyword","",["class"=>"form-control"]) !!}
											@if($errors->has("metaKeyword"))
												<span id="metaKeyword-error" class="help-block">{!! $errors->first("metaKeyword") !!}</span>
											@endif
										{!! HTML::decode(Form::label("metaKeyword","Meta Keyword <span class='text-danger'>*</span>")) !!}
									</div>
									
									<div class="form-group @if($errors->has('postDescription'))has-error @endif">
									
									{!! Form::textarea("postDescription","",["class"=>"form-control"]) !!}
										@if($errors->has("postDescription"))
											<span id="postDescription-error" class="help-block">{!! $errors->first("postDescription") !!}</span>
										@endif
										{!! HTML::decode(Form::label("postDescription","Post Content <span class='text-danger'>*</span>")) !!}
									</div>

									<div class="form-group @if($errors->has('postCategories'))has-error @endif">
										{!! Form::select("postCategories[]",$categories,"",["class"=>"form-control","id"=>"postCategories","multiple"]) !!}
										@if($errors->has("postCategories"))
											<span id="postCategories-error" class="help-block">{!! $errors->first("postCategories") !!}</span>
										@endif
										{!! HTML::decode(Form::label("postCategories","Category<span class='text-danger'>*</span>")) !!}
									</div>

									<div class="form-group @if($errors->has('postAuthor'))has-error @endif">
										{!! Form::select("postAuthor",$authors,"",["class"=>"form-control","id"=>"postAuthor","placeholder"=>"Select Author"]) !!}
										@if($errors->has("postAuthor"))
											<span id="postAuthor-error" class="help-block">{!! $errors->first("postAuthor") !!}</span>
										@endif
										{!! HTML::decode(Form::label("postAuthor","Author<span class='text-danger'>*</span>")) !!}
									</div>

									<div class="form-group @if($errors->has('postSettings'))has-error @endif">
										<div class="checkbox checkbox-styled">
											<label>
												{!! Form::checkbox("postSettings","yes","",["class"=>""]) !!}
												<span>Display this blog in home page</span>
											</label>
										</div>
									</div>

									<div class="form-group @if($errors->has('featureImage'))has-error @endif">
										{!! HTML::decode(Form::label("featureImage","Featured Image")) !!}<br>
										{!! Form::file("featureImage",["class"=>"form-control"]) !!}
										<p class="help-block">Recommended Image Resolution 850px x 450px</p>
										@if($errors->has("featureImage"))
											<span id="featureImage-error" class="help-block">{!! $errors->first("featureImage") !!}</span>
										@endif
									</div>
								</div><!--end .card-body -->

								<div class="card-actionbar">
									<div class="card-actionbar-row">
										<button type="submit" class="btn ink-reaction btn-primary-dark">Add Post</button>
									</div>
								</div>

							</div><!--end .card -->
						{!! Form::close() !!}
					</div><!--end .col -->
				</div><!--end .row -->
				<!-- END VERTICAL FORM -->
			</div>
		</section>
	</div><!--end #content-->
	<!-- END CONTENT -->
@stop

@section("script")
	{!! HTML::script('backend/js/bala.js') !!}
	{!! HTML::script('backend/ckeditor/ckeditor.js') !!}
	<script type="text/javascript">
	    $(document).ready(function() 
	    {
	      CKEDITOR.replace('postDescription');
	    });
	</script>
@stop