<?php 
	use App\Models\User; 
?>
@extends("backend/master")
@section('maincontent')
	<!-- BEGIN CONTENT-->
	<div id="content">
		<section>
			<div class="section-header ">
				<ol class="breadcrumb">
					<li class="active">Home</li>
					<li class="active">Post Categories</li>
					<li class="active">Add New Post Category</li>
				</ol>
			</div>
			<div class="section-body">
				<!-- BEGIN VERTICAL FORM -->
				<div class="row">
					<div class="col-lg-12">
						<h1 class="text-primary">Add New Post Category</h1>
					</div><!--end .col -->
					<div class="col-lg-3 col-md-4">
						
						<div class="section-header">
							{!! HTML::link("admin/blog/categories/get","Manage Post Categories",["class"=>"btn ink-reaction btn-block btn-primary"]) !!}
						</div>
					</div><!--end .col -->
					<div class="col-md-9">
						{!! Form::open(["url"=>"admin/blog/category/add/post","class"=>"form","files"=>true]) !!}
							<div class="card">
								<div class="card-head style-primary">
									<header>Create Post Category</header>
								</div>
								@if(Session::has('success')) {!! HTML::display_success('success') !!} @endif
								<div class="card-body">
									<div class="form-group @if($errors->has('postCategoryTitle'))has-error @endif">
										{!! Form::text("postCategoryTitle","",["class"=>"form-control"]) !!}
											@if($errors->has("postCategoryTitle"))
												<span id="postCategoryTitle-error" class="help-block">{!! $errors->first("postCategoryTitle") !!}</span>
											@endif
										{!! HTML::decode(Form::label("postCategoryTitle","Title <span class='text-danger'>*</span>")) !!}
									</div>
									
									
								</div><!--end .card-body -->

								<div class="card-actionbar">
									<div class="card-actionbar-row">
										<button type="submit" class="btn ink-reaction btn-primary-dark">Add Blog Category</button>
									</div>
								</div>

							</div><!--end .card -->
						{!! Form::close() !!}
					</div><!--end .col -->
				</div><!--end .row -->
				<!-- END VERTICAL FORM -->
			</div>
		</section>
	</div><!--end #content-->
	<!-- END CONTENT -->
@stop

@section("script")
	{!! HTML::script('backend/js/bala.js') !!}
@stop