<?php 
	use App\Models\CustomPages; 
	use App\Models\Option; 
?>
@extends("backend/master")
@section('maincontent')
	<!-- BEGIN CONTENT-->
	<div id="content">
		<section>
			<div class="section-header ">
				<ol class="breadcrumb">
					<li class="active">Home</li>
					<li class="active">Pages</li>
					<li class="active">{!! CustomPages::getcontent("courseEligibilityPageTitle") !!}</li>
				</ol>
			</div>
			<div class="section-body">
				<!-- BEGIN VERTICAL FORM -->
				<div class="row">
					<div class="col-lg-12">
						<h1 class="text-primary">{!! CustomPages::getcontent("courseEligibilityPageTitle") !!}</h1>
					</div><!--end .col -->
					
					<div class="clearfix"></div>
					
					@if(Session::has('success')) {!! HTML::display_success('success') !!} @endif

					<div class="col-lg-12 col-md-12">
						{!! Form::open(["url"=>"admin/pages/aboutus/post","class"=>"form","enctype"=>"multipart/form-data","files"=>true]) !!}
							<div class="panel panel-default">
				        		<div class="panel-body">
				            		<div class="row">
						                <div class="col-md-8 col-lg-8">
							                <div class="form-group @if($errors->has('courseEligibilityPageTitle'))has-error @endif">
												{!! Form::text("courseEligibilityPageTitle",CustomPages::getcontent("courseEligibilityPageTitle"),["class"=>"form-control","placeholder"=>"enter title here"]) !!}
												@if($errors->has("courseEligibilityPageTitle"))
													<span id="courseEligibilityPageTitle-error" class="help-block">{!! $errors->first("courseEligibilityPageTitle") !!}</span>
												@endif
												{!! HTML::decode(Form::label("courseEligibilityPageTitle","Page Title <span class='text-danger'>*</span>")) !!}
											</div>
						                </div>

						                <div class="col-md-4 col-lg-4 brd-left">
						                  	<div class="text-right">
						                    	{{ Form::submit('Save & Publish',['class'=>'btn ink-reaction btn-primary']) }}
						                    	<?php
						                    		$data = CustomPages::where("fieldName", "courseEligibilityPageTitle")->first();
						                    	?>
					                    		@if($data)
					                    			<p><b>Last Modified:</b>  {!! strtoupper($data->updatedByName) !!} ({!! date(Option::fetchDateFormat()." ".Option::fetchTimeFormat(),strtotime($data->updated_at)) !!})</p>
					                    		@endif
						                      
						                  	</div>
						                </div>
				            		</div>
				        		</div>
				        	</div>

				        	<div class="panel panel-default">
				        		<div class="panel-body">
				            		<div class="row">
						                <div class="col-md-12 col-lg-12">
							                <div class="form-group @if($errors->has('courseEligibilityWidgetOneText'))has-error @endif">
												{!! Form::textarea("courseEligibilityWidgetOneText",CustomPages::getcontent("courseEligibilityWidgetOneText"),["class"=>"form-control","placeholder"=>"enter widget one text","rows"=>"4"]) !!}
												@if($errors->has("courseEligibilityWidgetOneText"))
													<span id="courseEligibilityWidgetOneText-error" class="help-block">{!! $errors->first("courseEligibilityWidgetOneText") !!}</span>
												@endif
												{!! HTML::decode(Form::label("courseEligibilityWidgetOneText","Widget One Text <span class='text-danger'>*</span>")) !!}
											</div>
						                </div>
				            		</div>
				        		</div>
				        	</div>

				        	<div class="panel panel-default">
				        		<div class="panel-body">
				            		<div class="row">
						                <div class="col-md-12 col-lg-12">
							                <div class="form-group @if($errors->has('courseEligibilityDuration'))has-error @endif">
												{!! Form::text("courseEligibilityDuration",CustomPages::getcontent("courseEligibilityDuration"),["class"=>"form-control","placeholder"=>"enter course duration","rows"=>"4"]) !!}
												@if($errors->has("courseEligibilityDuration"))
													<span id="courseEligibilityDuration-error" class="help-block">{!! $errors->first("courseEligibilityDuration") !!}</span>
												@endif
												{!! HTML::decode(Form::label("courseEligibilityDuration","Course Duration <span class='text-danger'>*</span>")) !!}
											</div>
						                </div>

						                <div class="col-md-12 col-lg-12">
							                <div class="form-group @if($errors->has('courseEligibilityTiming'))has-error @endif">
												{!! Form::text("courseEligibilityTiming",CustomPages::getcontent("courseEligibilityTiming"),["class"=>"form-control","placeholder"=>"enter course timing","rows"=>"4"]) !!}
												@if($errors->has("courseEligibilityTiming"))
													<span id="courseEligibilityTiming-error" class="help-block">{!! $errors->first("courseEligibilityTiming") !!}</span>
												@endif
												{!! HTML::decode(Form::label("courseEligibilityTiming","Course Timimg <span class='text-danger'>*</span>")) !!}
											</div>
						                </div>

						                <div class="col-md-12 col-lg-12">
							                <div class="form-group @if($errors->has('courseEligibilitySessionFrequency'))has-error @endif">
												{!! Form::text("courseEligibilitySessionFrequency",CustomPages::getcontent("courseEligibilitySessionFrequency"),["class"=>"form-control","placeholder"=>"enter session frequency","rows"=>"4"]) !!}
												@if($errors->has("courseEligibilitySessionFrequency"))
													<span id="courseEligibilitySessionFrequency-error" class="help-block">{!! $errors->first("courseEligibilitySessionFrequency") !!}</span>
												@endif
												{!! HTML::decode(Form::label("courseEligibilitySessionFrequency","Enter Session Frequency <span class='text-danger'>*</span>")) !!}
											</div>
						                </div>

						                <div class="col-md-12 col-lg-12">
							                <div class="form-group @if($errors->has('courseEligibilityEligibility'))has-error @endif">
												{!! Form::text("courseEligibilityEligibility",CustomPages::getcontent("courseEligibilityEligibility"),["class"=>"form-control","placeholder"=>"enter widget two title","rows"=>"4"]) !!}
												@if($errors->has("courseEligibilityEligibility"))
													<span id="courseEligibilityEligibility-error" class="help-block">{!! $errors->first("courseEligibilityEligibility") !!}</span>
												@endif
												{!! HTML::decode(Form::label("courseEligibilityEligibility","Course Eligibility <span class='text-danger'>*</span>")) !!}
											</div>
						                </div>
				            		</div>
				        		</div>
				        	</div>

				        	<div class="panel panel-default">
				        		<div class="panel-body">
				            		<div class="row">
				            			<div class="col-md-12 col-lg-12">
							                <div class="form-group @if($errors->has('courseEligibilityWidgetThreeTitle'))has-error @endif">
												{!! Form::text("courseEligibilityWidgetThreeTitle",CustomPages::getcontent("courseEligibilityWidgetThreeTitle"),["class"=>"form-control","placeholder"=>"enter widget three title","rows"=>"4"]) !!}
													@if($errors->has("courseEligibilityWidgetThreeTitle"))
													<span id="courseEligibilityWidgetThreeTitle-error" class="help-block">{!! $errors->first("courseEligibilityWidgetThreeTitle") !!}</span>
													@endif
												{!! HTML::decode(Form::label("courseEligibilityWidgetThreeTitle","Widget Three Title <span class='text-danger'>*</span>")) !!}
											</div>
						                </div>

						                <div class="col-md-12 col-lg-12">
							                <div class="form-group @if($errors->has('courseEligibilityWidgetThreeSubTitle'))has-error @endif">
												{!! Form::text("courseEligibilityWidgetThreeSubTitle",CustomPages::getcontent("courseEligibilityWidgetThreeSubTitle"),["class"=>"form-control","placeholder"=>"enter widget three sub  title","rows"=>"4"]) !!}
												@if($errors->has("courseEligibilityWidgetThreeSubTitle"))
													<span id="courseEligibilityWidgetThreeSubTitle-error" class="help-block">{!! $errors->first("courseEligibilityWidgetThreeSubTitle") !!}</span>
												@endif
												{!! HTML::decode(Form::label("courseEligibilityWidgetThreeSubTitle","Widget Three Sub Title <span class='text-danger'>*</span>")) !!}
											</div>
						                </div>

						                <div class="col-md-12 col-lg-12">
						                	<div class="form-group @if($errors->has('courseEligibilityWidgetThreeText'))has-error @endif">
											{!! HTML::decode(Form::label("courseEligibilityWidgetThreeText","Widget Three Text <span class='text-danger'>*</span>")) !!}
											{!! Form::textarea("courseEligibilityWidgetThreeText",CustomPages::getcontent("courseEligibilityWidgetThreeText"),["class"=>"form-control"]) !!}
												@if($errors->has("courseEligibilityWidgetThreeText"))
												<span id="courseEligibilityWidgetThreeText-error" class="help-block">{!! $errors->first("courseEligibilityWidgetThreeText") !!}</span>
												@endif
											</div>
						                </div>
				            		</div>
				        		</div>
				        	</div>
				        {!! Form::close() !!}
					</div><!--end .col -->
				</div><!--end .row -->
				<!-- END VERTICAL FORM -->
			</div>
		</section>
	</div><!--end #content-->
	<!-- END CONTENT -->
@stop

@section("script")
	{!! HTML::script('backend/js/bala.js') !!}
	{!! HTML::script('backend/ckeditor/ckeditor.js') !!}
	{!! HTML::script('backend/assets/js/libs/global/iframe-transport.js') !!}
	{!! HTML::script('backend/assets/js/libs/global/jquery-ui.js') !!}
	<script type="text/javascript">
      	CKEDITOR.replace('courseEligibilityWidgetOneText');
      	CKEDITOR.replace('courseEligibilityWidgetThreeText');
	</script>
@stop