<?php 
	use App\Models\CustomPages; 
	use App\Models\Option; 
?>
@extends("backend/master")
@section('maincontent')
	<!-- BEGIN CONTENT-->
	<div id="content">
		<section>
			<div class="section-header ">
				<ol class="breadcrumb">
					<li class="active">Home</li>
					<li class="active">Pages</li>
					<li class="active">{!! CustomPages::getcontent("courseOfferedPageTitle") !!}</li>
				</ol>
			</div>
			<div class="section-body">
				<!-- BEGIN VERTICAL FORM -->
				<div class="row">
					<div class="col-lg-12">
						<h1 class="text-primary">{!! CustomPages::getcontent("courseOfferedPageTitle") !!}</h1>
					</div><!--end .col -->
					
					<div class="clearfix"></div>
					
					@if(Session::has('success')) {!! HTML::display_success('success') !!} @endif

					<div class="col-lg-12 col-md-12">
						{!! Form::open(["url"=>"admin/pages/aboutus/post","class"=>"form","enctype"=>"multipart/form-data","files"=>true]) !!}
							<div class="panel panel-default">
				        		<div class="panel-body">
				            		<div class="row">
						                <div class="col-md-8 col-lg-8">
							                <div class="form-group @if($errors->has('courseOfferedPageTitle'))has-error @endif">
												{!! Form::text("courseOfferedPageTitle",CustomPages::getcontent("courseOfferedPageTitle"),["class"=>"form-control","placeholder"=>"enter title here"]) !!}
												@if($errors->has("courseOfferedPageTitle"))
													<span id="courseOfferedPageTitle-error" class="help-block">{!! $errors->first("courseOfferedPageTitle") !!}</span>
												@endif
												{!! HTML::decode(Form::label("courseOfferedPageTitle","Page Title <span class='text-danger'>*</span>")) !!}
											</div>
						                </div>

						                <div class="col-md-8 col-lg-8">
							                <div class="form-group @if($errors->has('courseOfferedSubTitle'))has-error @endif">
												{!! Form::text("courseOfferedSubTitle",CustomPages::getcontent("courseOfferedSubTitle"),["class"=>"form-control","placeholder"=>"enter title here"]) !!}
												@if($errors->has("courseOfferedSubTitle"))
													<span id="courseOfferedSubTitle-error" class="help-block">{!! $errors->first("courseOfferedSubTitle") !!}</span>
												@endif
												{!! HTML::decode(Form::label("courseOfferedSubTitle","Sub Title <span class='text-danger'>*</span>")) !!}
											</div>
						                </div>

						                <div class="col-md-4 col-lg-4 brd-left">
						                  	<div class="text-right">
						                    	{!! Form::submit('Save & Publish',['class'=>'btn ink-reaction btn-primary']) !!}
						                    	<?php
						                    		$data = CustomPages::where("fieldName", "courseOfferedPageTitle")->first();
						                    	?>
					                    		@if($data)
					                    			<p><b>Last Modified:</b>  {!! strtoupper($data->updatedByName) !!} ({!! date(Option::fetchDateFormat()." ".Option::fetchTimeFormat(),strtotime($data->updated_at)) !!})</p>
					                    		@endif
						                      
						                  	</div>
						                </div>
				            		</div>
				        		</div>
				        	</div>

				        	<div class="panel panel-default">
				        		<div class="panel-body">
				            		<div class="row">
				            			<div class="col-md-12 col-lg-12">
						                	<div class="form-group @if($errors->has('courseOfferedWidgetOneTitle'))has-error @endif">
											{!! HTML::decode(Form::label("courseOfferedWidgetOneTitle","Widget One Title <span class='text-danger'>*</span>")) !!}
											{!! Form::text("courseOfferedWidgetOneTitle",CustomPages::getcontent("courseOfferedWidgetOneTitle"),["class"=>"form-control"]) !!}
												@if($errors->has("courseOfferedWidgetOneTitle"))
													<span id="courseOfferedWidgetOneTitle-error" class="help-block">{!! $errors->first("courseOfferedWidgetOneTitle") !!}</span>
												@endif
											</div>
						                </div>

						                <div class="col-md-6 col-lg-6">
						                	<div class="form-group @if($errors->has('courseOfferedWidgetOneTextOne'))has-error @endif">
											{!! HTML::decode(Form::label("courseOfferedWidgetOneTextOne","Left Widget Text <span class='text-danger'>*</span>")) !!}
											{!! Form::textarea("courseOfferedWidgetOneTextOne",CustomPages::getcontent("courseOfferedWidgetOneTextOne"),["class"=>"form-control"]) !!}
												@if($errors->has("courseOfferedWidgetOneTextOne"))
												<span id="courseOfferedWidgetOneTextOne-error" class="help-block">{!! $errors->first("courseOfferedWidgetOneTextOne") !!}</span>
												@endif
											</div>
						                </div>

						                <div class="col-md-6 col-lg-6">
						                	<div class="form-group @if($errors->has('courseOfferedWidgetOneTextTwo'))has-error @endif">
											{!! HTML::decode(Form::label("courseOfferedWidgetOneTextTwo","Right Widget Text <span class='text-danger'>*</span>"),["id"=>"courseOfferedWidgetOneTextTwo"]) !!}
											{!! Form::textarea("courseOfferedWidgetOneTextTwo",CustomPages::getcontent("courseOfferedWidgetOneTextTwo"),["class"=>"form-control"]) !!}
												@if($errors->has("courseOfferedWidgetOneTextTwo"))
												<span id="courseOfferedWidgetOneTextTwo-error" class="help-block">{!! $errors->first("courseOfferedWidgetOneTextTwo") !!}</span>
												@endif
											</div>
						                </div>
				            		</div>
				        		</div>
				        	</div>

				        	<div class="panel panel-default">
				        		<div class="panel-body">
				            		<div class="row">
						                <div class="col-md-12 col-lg-12">
							                <div class="form-group @if($errors->has('courseOfferedWidgetTwoTitle'))has-error @endif">
												{!! Form::text("courseOfferedWidgetTwoTitle",CustomPages::getcontent("courseOfferedWidgetTwoTitle"),["class"=>"form-control","placeholder"=>"enter widget two title","rows"=>"4"]) !!}
													@if($errors->has("courseOfferedWidgetTwoTitle"))
													<span id="courseOfferedWidgetTwoTitle-error" class="help-block">{!! $errors->first("courseOfferedWidgetTwoTitle") !!}</span>
													@endif
												{!! HTML::decode(Form::label("courseOfferedWidgetTwoTitle","Widget Two Title <span class='text-danger'>*</span>")) !!}
											</div>
						                </div>

						                <div class="col-md-12 col-lg-12">
						                	<div class="form-group @if($errors->has('courseOfferedWidgetTwoDescription'))has-error @endif">
											{!! HTML::decode(Form::label("courseOfferedWidgetTwoDescription","Widget Two Text <span class='text-danger'>*</span>"),["id"=>"courseOfferedWidgetTwoDescription"]) !!}
											{!! Form::textarea("courseOfferedWidgetTwoDescription",CustomPages::getcontent("courseOfferedWidgetTwoDescription"),["class"=>"form-control"]) !!}
												@if($errors->has("courseOfferedWidgetTwoDescription"))
												<span id="courseOfferedWidgetTwoDescription-error" class="help-block">{!! $errors->first("courseOfferedWidgetTwoDescription") !!}</span>
												@endif
											</div>
						                </div>
				            		</div>
				        		</div>
				        	</div>

				        	<div class="panel panel-default">
				        		<div class="panel-body">
				            		<div class="row">
				            			<div class="col-md-12 col-lg-12">
				            				<div class="panel-group">
											    <div class="panel panel-default">
											      	<div class="panel-heading">
											        	<h4 class="panel-title">
											          	<a data-toggle="collapse" data-parent="#accordion" href="#collapse1">{!! CustomPages::getcontent("courseTitle1") == "" ? "Enter Details" : CustomPages::getcontent("courseTitle1") !!}</a>
											        	</h4>
											      	</div>

											      	<div id="collapse1" class="panel-collapse collapse">
											        	<div class="panel-body">
											        		<div class="form-group @if($errors->has('courseTitle1'))has-error @endif">
																{!! HTML::decode(Form::label("courseTitle1","Title <span class='text-danger'>*</span>"),["id"=>"courseTitle1"]) !!}
																{!! Form::text("courseTitle1",CustomPages::getcontent("courseTitle1"),["class"=>"form-control", "placeholder"=>"enter title"]) !!}
																@if($errors->has("courseTitle1"))
																	<span id="courseTitle1-error" class="help-block">{!! $errors->first("courseTitle1") !!}</span>
																@endif
															</div>

															<div class="form-group @if($errors->has('courseText1'))has-error @endif">
																{!! HTML::decode(Form::label("courseText1","Text <span class='text-danger'>*</span>"),["id"=>"courseText1"]) !!}
																{!! Form::textarea("courseText1",CustomPages::getcontent("courseText1"),["class"=>"form-control", "placeholder"=>"enter text", "rows"=>3, "cols"=>3]) !!}
																@if($errors->has("courseText1"))
																	<span id="courseText1-error" class="help-block">{!! $errors->first("courseText1") !!}</span>
																@endif
															</div>
													    </div>
											      	</div>
											    </div>

											    <div class="panel panel-default">
											      	<div class="panel-heading">
											        	<h4 class="panel-title">
											          	<a data-toggle="collapse" data-parent="#accordion" href="#collapse2">{!! CustomPages::getcontent("courseTitle2") == "" ? "Enter Details" : CustomPages::getcontent("courseTitle2") !!}</a>
											        	</h4>
											      	</div>

											      	<div id="collapse2" class="panel-collapse collapse">
											        	<div class="panel-body">
											        		<div class="form-group @if($errors->has('courseTitle2'))has-error @endif">
																{!! HTML::decode(Form::label("courseTitle2","Title <span class='text-danger'>*</span>"),["id"=>"courseTitle2"]) !!}
																{!! Form::text("courseTitle2",CustomPages::getcontent("courseTitle2"),["class"=>"form-control", "placeholder"=>"enter title"]) !!}
																@if($errors->has("courseTitle2"))
																	<span id="courseTitle2-error" class="help-block">{!! $errors->first("courseTitle2") !!}</span>
																@endif
															</div>

															<div class="form-group @if($errors->has('courseText2'))has-error @endif">
																{!! HTML::decode(Form::label("courseText2","Text <span class='text-danger'>*</span>"),["id"=>"courseText2"]) !!}
																{!! Form::textarea("courseText2",CustomPages::getcontent("courseText2"),["class"=>"form-control", "placeholder"=>"enter text", "rows"=>3, "cols"=>3]) !!}
																@if($errors->has("courseText2"))
																	<span id="courseText2-error" class="help-block">{!! $errors->first("courseText2") !!}</span>
																@endif
															</div>
													    </div>
											      	</div>
											    </div>

											    <div class="panel panel-default">
											      	<div class="panel-heading">
											        	<h4 class="panel-title">
											          	<a data-toggle="collapse" data-parent="#accordion" href="#collapse3">{!! CustomPages::getcontent("courseTitle3") == "" ? "Enter Details" : CustomPages::getcontent("courseTitle3") !!}</a>
											        	</h4>
											      	</div>

											      	<div id="collapse3" class="panel-collapse collapse">
											        	<div class="panel-body">
											        		<div class="form-group @if($errors->has('courseTitle3'))has-error @endif">
																{!! HTML::decode(Form::label("courseTitle3","Title <span class='text-danger'>*</span>"),["id"=>"courseTitle3"]) !!}
																{!! Form::text("courseTitle3",CustomPages::getcontent("courseTitle3"),["class"=>"form-control", "placeholder"=>"enter title"]) !!}
																@if($errors->has("courseTitle3"))
																	<span id="courseTitle3-error" class="help-block">{!! $errors->first("courseTitle3") !!}</span>
																@endif
															</div>

															<div class="form-group @if($errors->has('courseText3'))has-error @endif">
																{!! HTML::decode(Form::label("courseText3","Text <span class='text-danger'>*</span>"),["id"=>"courseText3"]) !!}
																{!! Form::textarea("courseText3",CustomPages::getcontent("courseText3"),["class"=>"form-control", "placeholder"=>"enter text", "rows"=>3, "cols"=>3]) !!}
																@if($errors->has("courseText3"))
																	<span id="courseText3-error" class="help-block">{!! $errors->first("courseText3") !!}</span>
																@endif
															</div>
													    </div>
											      	</div>
											    </div>

											    <div class="panel panel-default">
											      	<div class="panel-heading">
											        	<h4 class="panel-title">
											          	<a data-toggle="collapse" data-parent="#accordion" href="#collapse4">{!! CustomPages::getcontent("courseTitle4") == "" ? "Enter Details" : CustomPages::getcontent("courseTitle4") !!}</a>
											        	</h4>
											      	</div>

											      	<div id="collapse4" class="panel-collapse collapse">
											        	<div class="panel-body">
											        		<div class="form-group @if($errors->has('courseTitle4'))has-error @endif">
																{!! HTML::decode(Form::label("courseTitle4","Title <span class='text-danger'>*</span>"),["id"=>"courseTitle4"]) !!}
																{!! Form::text("courseTitle4",CustomPages::getcontent("courseTitle4"),["class"=>"form-control", "placeholder"=>"enter title"]) !!}
																@if($errors->has("courseTitle4"))
																	<span id="courseTitle4-error" class="help-block">{!! $errors->first("courseTitle4") !!}</span>
																@endif
															</div>

															<div class="form-group @if($errors->has('courseText4'))has-error @endif">
																{!! HTML::decode(Form::label("courseText4","Text <span class='text-danger'>*</span>"),["id"=>"courseText4"]) !!}
																{!! Form::textarea("courseText4",CustomPages::getcontent("courseText4"),["class"=>"form-control", "placeholder"=>"enter text", "rows"=>3, "cols"=>3]) !!}
																@if($errors->has("courseText4"))
																	<span id="courseText4-error" class="help-block">{!! $errors->first("courseText4") !!}</span>
																@endif
															</div>
													    </div>
											      	</div>
											    </div>

											    <div class="panel panel-default">
											      	<div class="panel-heading">
											        	<h4 class="panel-title">
											          	<a data-toggle="collapse" data-parent="#accordion" href="#collapse5">{!! CustomPages::getcontent("courseTitle5") == "" ? "Enter Details" : CustomPages::getcontent("courseTitle5") !!}</a>
											        	</h4>
											      	</div>

											      	<div id="collapse5" class="panel-collapse collapse">
											        	<div class="panel-body">
											        		<div class="form-group @if($errors->has('courseTitle5'))has-error @endif">
																{!! HTML::decode(Form::label("courseTitle5","Title <span class='text-danger'>*</span>"),["id"=>"courseTitle5"]) !!}
																{!! Form::text("courseTitle5",CustomPages::getcontent("courseTitle5"),["class"=>"form-control", "placeholder"=>"enter title"]) !!}
																@if($errors->has("courseTitle5"))
																	<span id="courseTitle5-error" class="help-block">{!! $errors->first("courseTitle5") !!}</span>
																@endif
															</div>

															<div class="form-group @if($errors->has('courseText5'))has-error @endif">
																{!! HTML::decode(Form::label("courseText5","Text <span class='text-danger'>*</span>"),["id"=>"courseText5"]) !!}
																{!! Form::textarea("courseText5",CustomPages::getcontent("courseText5"),["class"=>"form-control", "placeholder"=>"enter text", "rows"=>3, "cols"=>3]) !!}
																@if($errors->has("courseText5"))
																	<span id="courseText5-error" class="help-block">{!! $errors->first("courseText5") !!}</span>
																@endif
															</div>
													    </div>
											      	</div>
											    </div>

											    <div class="panel panel-default">
											      	<div class="panel-heading">
											        	<h4 class="panel-title">
											          	<a data-toggle="collapse" data-parent="#accordion" href="#collapse6">{!! CustomPages::getcontent("courseTitle6") == "" ? "Enter Details" : CustomPages::getcontent("courseTitle6") !!}</a>
											        	</h4>
											      	</div>

											      	<div id="collapse6" class="panel-collapse collapse">
											        	<div class="panel-body">
											        		<div class="form-group @if($errors->has('courseTitle6'))has-error @endif">
																{!! HTML::decode(Form::label("courseTitle6","Title <span class='text-danger'>*</span>"),["id"=>"courseTitle6"]) !!}
																{!! Form::text("courseTitle6",CustomPages::getcontent("courseTitle6"),["class"=>"form-control", "placeholder"=>"enter title"]) !!}
																@if($errors->has("courseTitle6"))
																	<span id="courseTitle6-error" class="help-block">{!! $errors->first("courseTitle6") !!}</span>
																@endif
															</div>

															<div class="form-group @if($errors->has('courseText6'))has-error @endif">
																{!! HTML::decode(Form::label("courseText6","Text <span class='text-danger'>*</span>"),["id"=>"courseText6"]) !!}
																{!! Form::textarea("courseText6",CustomPages::getcontent("courseText6"),["class"=>"form-control", "placeholder"=>"enter text", "rows"=>3, "cols"=>3]) !!}
																@if($errors->has("courseText6"))
																	<span id="courseText6-error" class="help-block">{!! $errors->first("courseText6") !!}</span>
																@endif
															</div>
													    </div>
											      	</div>
											    </div>

											    <div class="panel panel-default">
											      	<div class="panel-heading">
											        	<h4 class="panel-title">
											          	<a data-toggle="collapse" data-parent="#accordion" href="#collapse7">{!! CustomPages::getcontent("courseTitle7") == "" ? "Enter Details" : CustomPages::getcontent("courseTitle7") !!}</a>
											        	</h4>
											      	</div>

											      	<div id="collapse7" class="panel-collapse collapse">
											        	<div class="panel-body">
											        		<div class="form-group @if($errors->has('courseTitle7'))has-error @endif">
																{!! HTML::decode(Form::label("courseTitle7","Title <span class='text-danger'>*</span>"),["id"=>"courseTitle7"]) !!}
																{!! Form::text("courseTitle7",CustomPages::getcontent("courseTitle7"),["class"=>"form-control", "placeholder"=>"enter title"]) !!}
																@if($errors->has("courseTitle7"))
																	<span id="courseTitle7-error" class="help-block">{!! $errors->first("courseTitle7") !!}</span>
																@endif
															</div>

															<div class="form-group @if($errors->has('courseText7'))has-error @endif">
																{!! HTML::decode(Form::label("courseText7","Text <span class='text-danger'>*</span>"),["id"=>"courseText7"]) !!}
																{!! Form::textarea("courseText7",CustomPages::getcontent("courseText7"),["class"=>"form-control", "placeholder"=>"enter text", "rows"=>3, "cols"=>3]) !!}
																@if($errors->has("courseText7"))
																	<span id="courseText7-error" class="help-block">{!! $errors->first("courseText7") !!}</span>
																@endif
															</div>
													    </div>
											      	</div>
											    </div>

											    <div class="panel panel-default">
											      	<div class="panel-heading">
											        	<h4 class="panel-title">
											          	<a data-toggle="collapse" data-parent="#accordion" href="#collapse8">{!! CustomPages::getcontent("courseTitle8") == "" ? "Enter Details" : CustomPages::getcontent("courseTitle8") !!}</a>
											        	</h4>
											      	</div>

											      	<div id="collapse8" class="panel-collapse collapse">
											        	<div class="panel-body">
											        		<div class="form-group @if($errors->has('courseTitle8'))has-error @endif">
																{!! HTML::decode(Form::label("courseTitle8","Title <span class='text-danger'>*</span>"),["id"=>"courseTitle8"]) !!}
																{!! Form::text("courseTitle8",CustomPages::getcontent("courseTitle8"),["class"=>"form-control", "placeholder"=>"enter title"]) !!}
																@if($errors->has("courseTitle8"))
																	<span id="courseTitle8-error" class="help-block">{!! $errors->first("courseTitle8") !!}</span>
																@endif
															</div>

															<div class="form-group @if($errors->has('courseText8'))has-error @endif">
																{!! HTML::decode(Form::label("courseText8","Text <span class='text-danger'>*</span>"),["id"=>"courseText8"]) !!}
																{!! Form::textarea("courseText8",CustomPages::getcontent("courseText8"),["class"=>"form-control", "placeholder"=>"enter text", "rows"=>3, "cols"=>3]) !!}
																@if($errors->has("courseText8"))
																	<span id="courseText8-error" class="help-block">{!! $errors->first("courseText8") !!}</span>
																@endif
															</div>
													    </div>
											      	</div>
											    </div>

											    <div class="panel panel-default">
											      	<div class="panel-heading">
											        	<h4 class="panel-title">
											          	<a data-toggle="collapse" data-parent="#accordion" href="#collapse9">{!! CustomPages::getcontent("courseTitle9") == "" ? "Enter Details" : CustomPages::getcontent("courseTitle9") !!}</a>
											        	</h4>
											      	</div>

											      	<div id="collapse9" class="panel-collapse collapse">
											        	<div class="panel-body">
											        		<div class="form-group @if($errors->has('courseTitle9'))has-error @endif">
																{!! HTML::decode(Form::label("courseTitle9","Title <span class='text-danger'>*</span>"),["id"=>"courseTitle9"]) !!}
																{!! Form::text("courseTitle9",CustomPages::getcontent("courseTitle9"),["class"=>"form-control", "placeholder"=>"enter title"]) !!}
																@if($errors->has("courseTitle9"))
																	<span id="courseTitle9-error" class="help-block">{!! $errors->first("courseTitle9") !!}</span>
																@endif
															</div>

															<div class="form-group @if($errors->has('courseText9'))has-error @endif">
																{!! HTML::decode(Form::label("courseText9","Text <span class='text-danger'>*</span>"),["id"=>"courseText9"]) !!}
																{!! Form::textarea("courseText9",CustomPages::getcontent("courseText9"),["class"=>"form-control", "placeholder"=>"enter text", "rows"=>3, "cols"=>3]) !!}
																@if($errors->has("courseText9"))
																	<span id="courseText9-error" class="help-block">{!! $errors->first("courseText9") !!}</span>
																@endif
															</div>
													    </div>
											      	</div>
											    </div>

											    <div class="panel panel-default">
											      	<div class="panel-heading">
											        	<h4 class="panel-title">
											          	<a data-toggle="collapse" data-parent="#accordion" href="#collapse10">{!! CustomPages::getcontent("courseTitle10") == "" ? "Enter Details" : CustomPages::getcontent("courseTitle10") !!}</a>
											        	</h4>
											      	</div>

											      	<div id="collapse10" class="panel-collapse collapse">
											        	<div class="panel-body">
											        		<div class="form-group @if($errors->has('courseTitle10'))has-error @endif">
																{!! HTML::decode(Form::label("courseTitle10","Title <span class='text-danger'>*</span>"),["id"=>"courseTitle10"]) !!}
																{!! Form::text("courseTitle10",CustomPages::getcontent("courseTitle10"),["class"=>"form-control", "placeholder"=>"enter title"]) !!}
																@if($errors->has("courseTitle10"))
																	<span id="courseTitle10-error" class="help-block">{!! $errors->first("courseTitle10") !!}</span>
																@endif
															</div>

															<div class="form-group @if($errors->has('courseText10'))has-error @endif">
																{!! HTML::decode(Form::label("courseText10","Text <span class='text-danger'>*</span>"),["id"=>"courseText10"]) !!}
																{!! Form::textarea("courseText10",CustomPages::getcontent("courseText10"),["class"=>"form-control", "placeholder"=>"enter text", "rows"=>3, "cols"=>3]) !!}
																@if($errors->has("courseText10"))
																	<span id="courseText10-error" class="help-block">{!! $errors->first("courseText10") !!}</span>
																@endif
															</div>
													    </div>
											      	</div>
											    </div>
										  	</div>
										</div>
									</div>
								</div>
							</div>
				        {!! Form::close() !!}
					</div><!--end .col -->
				</div><!--end .row -->
				<!-- END VERTICAL FORM -->
			</div>
		</section>
	</div><!--end #content-->
	<!-- END CONTENT -->
@stop

@section("script")
	{!! HTML::script('backend/js/bala.js') !!}
	{!! HTML::script('backend/ckeditor/ckeditor.js') !!}
	{!! HTML::script('backend/assets/js/libs/global/iframe-transport.js') !!}
	{!! HTML::script('backend/assets/js/libs/global/jquery-ui.js') !!}
	<script type="text/javascript">
	    $(document).ready(function(){
	      	CKEDITOR.replace('courseOfferedWidgetOneTextOne');
	      	CKEDITOR.replace('courseOfferedWidgetOneTextTwo');
	      	CKEDITOR.replace('courseOfferedWidgetTwoDescription');
	      	CKEDITOR.replace('courseText9');
	    });
	</script>
@stop