<?php 
	use App\Models\User; 
?>
@extends("backend/master")
@section('styles')
	{!! HTML::style('backend/assets/css/jquery-ui.css') !!}
@stop

@section('maincontent')
	<!-- BEGIN CONTENT-->
	<div id="content">
		<section>
			<div class="section-header ">
				<ol class="breadcrumb">
					<li class="active">Home</li>
					<li class="active">Course Applied</li>
					<li>Modify Course Applied</li>
				</ol>
			</div>

			<div class="section-body">
				<!-- BEGIN VERTICAL FORM -->
				<div class="row">
					<div class="col-lg-12">
						<h1 class="text-primary">Modify Course Applied</h1>
					</div><!--end .col -->

					<div class="col-lg-2 col-md-4">
						<div class="section-header">
							{!! HTML::link("admin/courses/applied/get", "Manage Course Applied", ["class"=>"btn ink-reaction btn-block btn-primary"]) !!}
						</div>
					</div><!--end .col -->

					<div class="col-md-10">
						<div class="card">
							<div class="card-head style-primary">
								<header>Modify Course Applied</header>
							</div>

							@if(Session::has('success')) 
								{!! HTML::display_success('success') !!} 
							@endif

							@if(Session::has('error')) 
								{!! HTML::display_error('error') !!} 
							@endif

							<?php
								$id = Crypt::encrypt($course->id);
							?>

							<div class="card-body">
								{!! Form::open(["url"=>"admin/courses/applied/modify/post/".$id, "method"=>"post", "files"=>true, "enctype"=>"multipart/form-data", "id"=>"modifyCourseApplicationForm"]) !!}
			                        <div class="row">
			                            <div class="col-md-6 col-sm-6">
			                                {!! HTML::decode(Form::label("name", "Full Name <span class='req'>*</span>", ["class"=>""])) !!}
			                                {!! Form::text("name", $course->name, ["class"=>"form-control input-lg"]) !!}
			                                @if($errors->has("name"))
			                                    <span class="req">{!! $errors->first("name") !!}</span>
			                                @endif
			                            </div>

			                            <div class="col-md-6 col-sm-6">
			                                {!! HTML::decode(Form::label("father_name", "Father's/Husband's Name <span class='req'>*</span>", ["class"=>""])) !!}
			                                {!! Form::text("father_name", $course->father_name, ["class"=>"form-control input-lg"]) !!}
			                                @if($errors->has("father_name"))
			                                    <span class="req">{!! $errors->first("father_name") !!}</span>
			                                @endif
			                            </div>
			                        </div>

			                        <div class="row">
			                            <div class="col-md-6 col-sm-6">
			                                {!! HTML::decode(Form::label("address1", "Permanent Address <span class='req'>*</span>", ["class"=>""])) !!}
			                                {!! Form::textarea("address1", $course->address1, ["class"=>"form-control input-lg", "rows"=>4]) !!}
			                                @if($errors->has("address1"))
			                                    <span class="req">{!! $errors->first("address1") !!}</span>
			                                @endif
			                            </div>

			                            <div class="col-md-6 col-sm-6">
			                                {!! HTML::decode(Form::label("address2", "Address for Correspondence <span class='req'>*</span>", ["class"=>""])) !!}
			                                {!! Form::textarea("address2", $course->address2, ["class"=>"form-control input-lg", "rows"=>4]) !!}
			                                @if($errors->has("address2"))
			                                    <span class="req">{!! $errors->first("address2") !!}</span>
			                                @endif
			                            </div>
			                        </div>

			                        <div class="row">
			                            <div class="col-md-6 col-sm-6">
			                                {!! HTML::decode(Form::label("dob", "Date of Birth <span class='req'>*</span>", ["class"=>""])) !!}
			                                {!! Form::date("dob", $course->dob, ["class"=>"form-control input-lg"]) !!}
			                                @if($errors->has("dob"))
			                                    <span class="req">{!! $errors->first("dob") !!}</span>
			                                @endif
			                            </div>

			                            <div class="col-md-6 col-sm-6">
			                                <label></label>
			                                {!! HTML::decode(Form::label("phone", "Phone Number <span class='req'></span>", ["class"=>""])) !!}
			                                {!! Form::text("phone", $course->phone, ["class"=>"form-control input-lg"]) !!}
			                                @if($errors->has("phone"))
			                                    <span class="req">{!! $errors->first("phone") !!}</span>
			                                @endif
			                            </div>
			                        </div>

			                        <div class="row">
			                            <div class="col-md-6 col-sm-6">
			                                {!! HTML::decode(Form::label("mobile", "Mobile Number <span class='req'></span>", ["class"=>""])) !!}
			                                {!! Form::text("mobile", $course->mobile, ["class"=>"form-control input-lg"]) !!}
			                                @if($errors->has("mobile"))
			                                    <span class="req">{!! $errors->first("mobile") !!}</span>
			                                @endif
			                            </div>

			                            <div class="col-md-6 col-sm-6">
			                                {!! HTML::decode(Form::label("emailid", "Email ID <span class='req'></span>", ["class"=>""])) !!}
			                                {!! Form::email("emailid", $course->emailid, ["class"=>"form-control input-lg"]) !!}
			                                @if($errors->has("emailid"))
			                                    <span class="req">{!! $errors->first("emailid") !!}</span>
			                                @endif
			                            </div>
			                        </div>

		                        	<hr class="fw">

			                        <div class="row">
			                            <div class="col-md-12">
			                                <h4 class="margin-5"><b>Educational Qualification</b> <span class="req">*</span></h4>
			                                <table class="table table-bordered edu-qua">
			                                    <thead>
			                                        <tr>
			                                            <th><b>Year</b></th>
			                                            <th><b>School/College</b></th>
			                                            <th><b>University</b></th>
			                                            <th><b>Degree</b></th>
			                                            <th><b>Marks / Class</b></th>
			                                        </tr>
			                                    </thead>
			                                    <tbody>
			                                    	<?php
														$educations = json_decode($course->education);
														$display = "";
														$i = 0;
														if(count($educations) == 1){
															$display = "none";
														}
			                                    	?>
			                                    	@foreach($educations as $education)
				                                        <tr class="educationCount" id="educationCount{!! $i + 1 !!}">
				                                            <td>{!! Form::text("year".$i, $education->year, ["class"=>"form-control input-lg", "id"=>"year".$i]) !!}</td>
				                                            <td>{!! Form::text("school".$i, $education->school, ["class"=>"form-control input-lg", "id"=>"school".$i]) !!}</td>
				                                            <td>{!! Form::text("university".$i, $education->university, ["class"=>"form-control input-lg", "id"=>"university".$i]) !!}</td>
				                                            <td>{!! Form::text("degree".$i, $education->degree, ["class"=>"form-control input-lg", "id"=>"degree".$i]) !!}</td>
				                                            <td>{!! Form::text("mark".$i, $education->mark, ["class"=>"form-control input-lg", "id"=>"mark".$i]) !!}</td>
				                                        </tr>
				                                        <?php $i++; ?>
			                                        @endforeach

													{!! Form::hidden("educationLength", $i, ["id"=>"educationLength"]) !!}

			                                        <tr>
			                                            <td colspan="5">
			                                                <button type="button" class="btn btn-primary btn-sm" id="addNewEducationRecord" value="Add New Record">Add New Record &nbsp;<i class="fa fa-plus-circle"></i></button>
			                                                <button type="button" style="display:{!! $display !!}" class="btn btn-danger btn-sm" id="removeNewEducationRecord">Remove Previous Record &nbsp;<i class="fa fa-minus-circle"></i></button>
			                                            </td>
			                                        </tr>
			                                    </tbody>
			                                </table>

			                                <hr class="fw">

			                                <h4 class="margin-5"><b> Work Experience</b> <span class="req">*</span></h4>
			                                <table class="table table-bordered edu-qua">
			                                    <thead>
			                                        <tr>
			                                            <th><b>Period</b></th>
			                                            <th><b>Organisation</b></th>
			                                            <th><b>Designation</b></th>
			                                            <th><b>Nature of Work</b></th>
			                                        </tr>
			                                    </thead>

			                                    <tbody>
			                                    	<?php
														$experiences = json_decode($course->workexp);
														$display = "";
														$i = 0;
														if(count($experiences) == 1){
															$display = "none";
														}
			                                    	?>
			                                    	@foreach($experiences as $experience)
				                                        <tr class="experienceCount" id="experienceCount{!! $i + 1 !!}">
				                                            <td>{!! Form::text("period".$i, $experience->period, ["class"=>"form-control input-lg", "id"=>"period".$i]) !!}</td>
				                                            <td>{!! Form::text("organisation".$i, $experience->organisation, ["class"=>"form-control input-lg", "id"=>"organisation".$i]) !!}</td>
				                                            <td>{!! Form::text("designation".$i, $experience->designation, ["class"=>"form-control input-lg", "id"=>"designation".$i]) !!}</td>
				                                            <td>{!! Form::text("work".$i, $experience->work, ["class"=>"form-control input-lg", "id"=>"work".$i]) !!}</td>
				                                        </tr>
				                                        <?php $i++; ?>
			                                        @endforeach

			                                        {!! Form::hidden("experienceLength", $i, ["id"=>"experienceLength"]) !!}

			                                        <tr>
			                                            <td colspan="4">
			                                                <button class="btn btn-primary btn-sm" id="addNewExperienceRecord" value="Add New Record" type="button">Add New Record &nbsp;<i class="fa fa-plus-circle"></i></button>
			                                                <button style="display:{!! $display !!}" class="btn btn-danger btn-sm" id="removeNewExperienceRecord" type="button">Remove Previous Record &nbsp;<i class="fa fa-minus-circle"></i></button>
			                                            </td>
			                                        </tr>
			                                    </tbody>
			                                </table>
			                            </div>
			                        </div>

			                        <div class="row">
			                            <div class="col-md-6 col-sm-6">
			                                {!! HTML::decode(Form::label("photo", "Upload Photo <span class='req'></span>", ["class"=>""])) !!}
			                                {!! Form::file("photo", ["class"=>"", "id"=>"photo"]) !!}
			                                @if($errors->has("photo"))
			                                    <span class="req">{!! $errors->first("photo") !!}</span>
			                                @endif
			                            </div>

			                            <div class="col-md-6 col-sm-6">
			                                {!! HTML::image($course->photo, $course->name, ["width"=>100, "height"=>100]) !!}
			                            </div>
			                        </div>

		                        	<div class="spacer-20"></div>

			                        <div class="row">
			                            <div class="col-md-12">
			                                {!! HTML::decode(Form::label("comment", 'Please answer in less than 100 words "Why I want to join this course?" <span class="req">*</span>', ["class"=>""])) !!}
			                                {!! Form::textarea("comment", $course->comment, ["class"=>"form-control input-lg", "rows"=>6, "id"=>"comment"]) !!}
			                                @if($errors->has("comment"))
			                                    <span class="req">{!! $errors->first("comment") !!}</span>
			                                @endif
			                                
			                                <div class="row">
			                                    <div class="col-md-4 col-sm-4">
			                                    	<div class="radio radio-styled">
				                                        <label>
				                                            {!! Form::radio("paymentType", "offline", $course->paymentType == 'offline' ? true : false, ["class"=>"option-input radio", "id"=>"paymentType"]) !!}
				                                            Off-Line Payment
				                                        </label>
				                                    </div>
			                                    </div>

			                                    <div class="col-md-4 col-sm-4">
			                                    	<div class="radio radio-styled">
				                                        <label>
				                                            {!! Form::radio("paymentType", "online", $course->paymentType == 'online' ? true : false, ["class"=>"option-input radio", "id"=>"paymentType"]) !!}
				                                            On-Line Payment
				                                        </label>
				                                    </div>
			                                    </div>
			                                </div><!--end row-->

			                                <div class="clearfix"></div>

			                                <div class="checkbox checkbox-styled">
				                                <label>
				                                    {!! Form::checkbox("termsAndConditions", "agreed", true, ["class"=>"", "id"=>"termsAndConditions"]) !!}
				                                    I agree to the <a href="">Terms and Conditions</a> of Advertisement club Madras
				                                </label>
				                            </div>

			                                <br>

			                                <div class="spacer-40"></div>

			                                <div class="clearfix">
			                                    {!! Form::submit("Submit", ["class"=>"btn btn-primary btn-lg", "id"=>"clickModifyAppliedCourse"]) !!}
			                                </div>
			                            </div>
			                        </div>
		                    	{!! Form::close() !!}
							</div><!--end card-body-->
						</div><!--end col-md-10-->
					</div>
				</div>
			</div>
		</section>
	</div>
@stop


@section('script')
	<script>
        $(document).on("click", "#addNewEducationRecord", function(){
            var length = $(".educationCount").length;
            var row = parseInt(length) + parseInt(1);

            //Append Code
            var req_code = '';
            req_code += '<tr class="educationCount" id="educationCount'+row+'">';
            req_code += '<td><input class="form-control input-lg" id="year'+length+'" name="year'+length+'" value="" type="text"></td>';
            req_code += '<td><input class="form-control input-lg" id="school'+length+'" name="school'+length+'" value="" type="text"></td>';
            req_code += '<td><input class="form-control input-lg" id="university'+length+'" name="university'+length+'" value="" type="text"></td>';
            req_code += '<td><input class="form-control input-lg" id="degree'+length+'" name="degree'+length+'" value="" type="text"></td>';
            req_code += '<td><input class="form-control input-lg" id="mark'+length+'" name="mark'+length+'" value="" type="text"></td>';
            req_code += '</tr>';
            $(req_code).insertAfter("#educationCount"+length);

            $("#educationLength").val(row);

            if(length >= 1){
                $("#removeNewEducationRecord").show();
            }
        });

        $(document).on("click", "#removeNewEducationRecord", function(){
            var length = $(".educationCount").length;
            if(length != 1){
                $("#educationCount"+length).remove();
            }

            if(length == 2){
                $("#removeNewEducationRecord").hide();
            }

            $("#educationLength").val(parseInt(length) - parseInt(1));
        });

        $(document).on("click", "#addNewExperienceRecord", function(){
            var length = $(".experienceCount").length;
            var row = parseInt(length) + parseInt(1);

            //Append Code
            var req_code = '';
            req_code += '<tr class="experienceCount" id="experienceCount'+row+'">';
            req_code += '<td><input class="form-control input-lg" id="period'+length+'" name="period'+length+'" value="" type="text"></td>';
            req_code += '<td><input class="form-control input-lg" id="organisation'+length+'" name="organisation'+length+'" value="" type="text"></td>';
            req_code += '<td><input class="form-control input-lg" id="designation'+length+'" name="designation'+length+'" value="" type="text"></td>';
            req_code += '<td><input class="form-control input-lg" id="work'+length+'" name="work'+length+'" value="" type="text"></td>';
            req_code += '</tr>';
            $(req_code).insertAfter("#experienceCount"+length);

            $("#experienceLength").val(row);

            if(length >= 1){
                $("#removeNewExperienceRecord").show();
            }
        });

        $(document).on("click", "#removeNewExperienceRecord", function(){
            var length = $(".experienceCount").length;
            if(length > 1){
                $("#experienceCount"+length).remove();
            }

            if(length == 2){
                $("#removeNewExperienceRecord").hide();
            }

            $("#experienceLength").val(parseInt(length) - parseInt(1));
        });

		$(document).on("click", "#clickModifyAppliedCourse", function(){
			if(!$("#termsAndConditions").is(':checked')){
                swal("Agree", "Please agree to our terms and conditions", "info");
                return false;
            }

            if(!$("input[name='paymentType']").is(':checked')){
                swal("Please Select", "Please select payment type", "info");
                return false;
            }

            var error = "no";
            $("form :input").each(function(){
                var fieldid = $(this).attr('id');
                var fieldvalue = $(this).val();
                if(fieldid != "addNewEducationRecord" && fieldid != "removeNewEducationRecord" && fieldid != "addNewExperienceRecord" && fieldid != "removeNewExperienceRecord" && fieldid != "clickModifyAppliedCourse" && fieldid != "photo" && fieldid != "paymentType" && fieldid != "paymentType"){
                	if(fieldvalue == '' || fieldvalue == null){
	                   $('#'+fieldid).after("<div class='validation_msg'>Don't leave this field empty.</div>");
	                   $('html,body').animate({ scrollTop: $('#'+fieldid).offset().top }, 500);
	                   error = "yes";
	                   return false;
	                }
                }

                if(fieldid == 'phone' || fieldid == 'mobile'){
                   var mob_num = $('#'+fieldid).val();
                    var filter = /^[0-9-+ ]+$/ ;
                    if (!filter.test(mob_num)) {
                        $('#'+fieldid).after("<div class='mobileno_msg'>Please enter valid "+fieldid+" number.</div>");
                        $('html,body').animate({ scrollTop: $('#'+fieldid).offset().top }, 500);
                        error = "mobile";
                        return false;
                    }
                }
            });
            
            if(error == "yes"){
                setTimeout(function(){  $(".validation_msg").hide(); }, 3000);
                return false;
            }
            
            if(error ==  "mobile"){
                setTimeout(function(){  $(".mobileno_msg").hide(); }, 5000);
                return false;
            }
		});
  	</script>
@stop