<?php 
	use App\Models\User; 
	use App\Models\Taxes; 
?>
@extends("backend/master")
@section('maincontent')
	<!-- BEGIN CONTENT-->
	<div id="content">
		<section>
			<div class="section-header ">
				<ol class="breadcrumb">
					<li class="active">Home</li>
					<li class="active">Downloads</li>
					<li class="active">Add New Download</li>
				</ol>
			</div>
			<div class="section-body">
				<!-- BEGIN VERTICAL FORM -->
				<div class="row">
					<div class="col-lg-12">
						<h1 class="text-primary">Add New Download</h1>
					</div><!--end .col -->
					<div class="col-lg-3 col-md-4">
						
						<div class="section-header">
							{!! HTML::link("admin/downloads","Manage Downloads",["class"=>"btn ink-reaction btn-block btn-primary"]) !!}
						</div>
					</div><!--end .col -->
					<div class="col-md-9">
						{!! Form::open(["url"=>"admin/downloads/add","class"=>"form","enctype"=>"multipart/form-data","files"=>true]) !!}
							<div class="card">
								<div class="card-head style-primary">
									<header>Create Download</header>
								</div>
								@if(Session::has('success')) {!! HTML::display_success('success') !!} @endif
								<div class="card-body">
									<div class="form-group @if($errors->has('downloadProducts'))has-error @endif">
										{!! Form::select("downloadProducts",$products,"",["class"=>"form-control","id"=>"downloadProducts","placeholder"=>"Select Product"]) !!}
										@if($errors->has("downloadProducts"))
											<span id="downloadProducts-error" class="help-block">{!! $errors->first("downloadProducts") !!}</span>
										@endif
										{!! HTML::decode(Form::label("downloadProducts","Products<span class='text-danger'>*</span>")) !!}
									</div>

									<div class="form-group @if($errors->has('uploadBrochure'))has-error @endif">
										{!! Form::file("uploadBrochure",["class"=>"form-control"]) !!}
											@if($errors->has("uploadBrochure"))
												<span id="uploadBrochure-error" class="help-block">{!! $errors->first("uploadBrochure") !!}</span>
											@endif
										{!! HTML::decode(Form::label("uploadBrochure","Upload Brochure <span class='text-danger'></span>")) !!}
									</div>
									
									<div class="form-group @if($errors->has('uploadCertification'))has-error @endif">
										{!! Form::file("uploadCertification",["class"=>"form-control"]) !!}
											@if($errors->has("uploadCertification"))
												<span id="uploadCertification-error" class="help-block">{!! $errors->first("uploadCertification") !!}</span>
											@endif
										{!! HTML::decode(Form::label("uploadCertification","Upload Certification <span class='text-danger'>*</span>")) !!}
									</div>

									<div class="form-group @if($errors->has('uploadPoster'))has-error @endif">
										{!! Form::file("uploadPoster",["class"=>"form-control"]) !!}
											@if($errors->has("uploadPoster"))
												<span id="uploadPoster-error" class="help-block">{!! $errors->first("uploadPoster") !!}</span>
											@endif
										{!! HTML::decode(Form::label("uploadPoster","Upload Poster <span class='text-danger'></span>")) !!}
									</div>
								</div><!--end .card-body -->

								<div class="card-actionbar">
									<div class="card-actionbar-row">
										<button type="submit" class="btn ink-reaction btn-primary-dark">Add Download</button>
									</div>
								</div>

							</div><!--end .card -->
						{!! Form::close() !!}
					</div><!--end .col -->
				</div><!--end .row -->
				<!-- END VERTICAL FORM -->
			</div>
		</section>
	</div><!--end #content-->
	<!-- END CONTENT -->
@stop

@section("script")
	{!! HTML::script('backend/js/bala.js') !!}
@stop