@extends("backend/master")
@section('maincontent')
	<!-- BEGIN CONTENT-->
	<div id="content">
		<section>
			<div class="section-header ">
				<ol class="breadcrumb">
					<li class="active">Home</li>
					<li class="active">Event Categories</li>
					<li class="active">Add New Event Category</li>
				</ol>
			</div>

			<div class="section-body">
				<!-- BEGIN VERTICAL FORM -->
				<div class="row">
					<div class="col-lg-12">
						<h1 class="text-primary">Add New Event Category</h1>
					</div><!--end .col -->

					<div class="col-lg-3 col-md-4">
						<div class="section-header">
							{!! HTML::link("admin/events/categories/get","Manage Events Categories",["class"=>"btn ink-reaction btn-block btn-primary"]) !!}
						</div>
					</div><!--end .col -->

					<div class="col-md-9">
						{!! Form::open(["url"=>"admin/events/categories/add/post", "class"=>"form", "files"=>true]) !!}
							<div class="card">
								<div class="card-head style-primary">
									<header>Create Event Category</header>
								</div>

								@if(Session::has('success')) {!! HTML::display_success('success') !!} @endif

								<div class="card-body">
									<div class="form-group @if($errors->has('eventCategoryTitle'))has-error @endif">
										{!! Form::text("eventCategoryTitle","",["class"=>"form-control"]) !!}
											@if($errors->has("eventCategoryTitle"))
												<span id="eventCategoryTitle-error" class="help-block">{!! $errors->first("eventCategoryTitle") !!}</span>
											@endif
										{!! HTML::decode(Form::label("eventCategoryTitle","Title <span class='text-danger'>*</span>")) !!}
									</div>

									<div class="form-group @if($errors->has('eventCategoryDescription'))has-error @endif">
										{!! HTML::decode(Form::label("eventCategoryDescription","Description <span class='text-danger'>*</span>")) !!}
										{!! Form::textarea("eventCategoryDescription","",["class"=>"form-control"]) !!}
										@if($errors->has("eventCategoryDescription"))
											<span id="eventCategoryDescription-error" class="help-block">{!! $errors->first("eventCategoryDescription") !!}</span>
										@endif
									</div>
								</div><!--end .card-body -->

								<div class="card-actionbar">
									<div class="card-actionbar-row">
										<button type="submit" class="btn ink-reaction btn-primary-dark">Add Event Category</button>
									</div>
								</div>
							</div><!--end .card -->
						{!! Form::close() !!}
					</div><!--end .col -->
				</div><!--end .row -->
				<!-- END VERTICAL FORM -->
			</div>
		</section>
	</div><!--end #content-->
	<!-- END CONTENT -->
@stop

@section("script")
	{!! HTML::script('backend/ckeditor/ckeditor.js') !!}
	<script type="text/javascript">
	    $(document).ready(function(){
	      	CKEDITOR.replace('eventCategoryDescription');
	    });
	</script>
@stop