	<?php
		use App\Models\Customfieldmeta;
	?>
	<ul id="Reg_sortable">
		@foreach($custom_fields as $fields)
			<li data-id="{{encrypt($fields->id)}}">
			@if($fields->field_type == 'plain_text' || $fields->field_type == 'datepicker' || $fields->field_type == 'dateandtime' || $fields->field_type == 'phonenumber' || $fields->field_type == 'numbers' || $fields->field_type == 'amount' || $fields->field_type == 'email')
				<div class="form-group">
					<input type="text" class="form-control @if($fields->field_type == 'datepicker') R_custom_fields_date @endif @if($fields->field_type == 'dateandtime') R_custom_fields_datetime @endif" id="{{$fields->field_slug}}" name="{{$fields->field_slug}}" value="{{$fields->field_value}}">
					<label>{{$fields->label_name}} @if($fields->is_required == 'yes') <span class='text-danger'>*</span> @endif</label>
				</div>
			@endif

			@if($fields->field_type == 'text_area')
				<div class="form-group">
					<textarea class="form-control"></textarea>
					<label>{{$fields->label_name}} @if($fields->is_required == 'yes') <span class='text-danger'>*</span> @endif</label>
				</div>
			@endif

			@if($fields->field_type == 'checkbox' || $fields->field_type == 'radio')
				<div class="form-group">
					<?php
						$metadata = Customfieldmeta::where('custom_field_id',$fields->id)->get();
					?>
					@foreach($metadata as $m)
						{{$m->field_value}}<input type="{{$fields->field_type}}" name="">
					@endforeach
					<label>{{$fields->label_name}} @if($fields->is_required == 'yes') <span class='text-danger'>*</span> @endif</label>
				</div>
			@endif

			@if($fields->field_type == 'dropdown')
				<?php
					$metadata = Customfieldmeta::where('custom_field_id',$fields->id)->get();
				?>
				<div class="form-group">
					<select class="form-control">
						@foreach($metadata as $m)
							<option>{{$m->field_value}}</option>
						@endforeach
					</select>
					<label>{{$fields->label_name}} @if($fields->is_required == 'yes') <span class='text-danger'>*</span> @endif</label>
				</div>
			@endif

			@if($fields->field_type == 'single_file_upload')
				<div class="form-group">
					<input type="file" class="form-control" name="{{$fields->field_slug}}" id="{{$fields->field_slug}}">
					<label>{{$fields->label_name}} @if($fields->is_required == 'yes') <span class='text-danger'>*</span> @endif</label>
				</div>
				@if($fields->field_value != '')
					<div class="form-group">
						<a href="{{asset($fields->field_value)}}" target="_blank" style="color: green;">{{$fields->extra_field}} <i class="fa fa-file"></i></a>
						<a href="javascript:;" class="removeCustomFieldFile" data-field="single" data-id="{{encrypt($fields->id)}}" style="color: red;"><i class="fa fa-trash"></i></a>
						<label>Preview</label>
					</div>
				@endif
			@endif

			@if($fields->field_type == 'multiple_file_upload')
				<div class="form-group">
					<input type="file" class="form-control" name="{{$fields->field_slug}}[]" id="{{$fields->field_slug}}" multiple="">
					<label>{{$fields->label_name}} @if($fields->is_required == 'yes') <span class='text-danger'>*</span> @endif</label>
				</div>
				<?php
					$metadata = Customfieldmeta::where('custom_field_id',$fields->id)->get();
				?>
				@if(count($metadata) != 0)
					<div class="form-group">
						<label>Preview</label>
						
						<ul>
							@foreach($metadata as $meta)
								<li>
									<a href="{{asset($meta->field_value)}}" target="_blank" style="color: green;">{{$meta->extra_field}} <i class="fa fa-file"></i></a>
									<a href="javascript:;" class="removeCustomFieldFile" data-field="multiple" data-id="{{encrypt($meta->id)}}" style="color: red;"><i class="fa fa-trash"></i></a>
								</li>
							@endforeach
						</ul>
					</div>
				@endif
			@endif
			<a href="javascript:;" class="R_removeCustomField" data-id="{{encrypt($fields->id)}}" style="color:red;"><i class="fa fa-trash"></i> Remove Field</a>
			</li>
		@endforeach
	</ul>
	@if(count($custom_fields) == 0)
		<b>No fields found</b>
	@else
	@endif