<?php 

	use App\Models\User; 

	use App\Models\Option;

	use App\Models\EventCategories;

?>

@extends("backend/master")

@section('styles')

	{!! HTML::style('backend/assets/css/theme-default/libs/DataTables/jquery.dataTables.css') !!}

	{!! HTML::style('backend/assets/css/theme-default/libs/DataTables/extensions/dataTables.colVis.css') !!}

	{!! HTML::style('backend/assets/css/theme-default/libs/DataTables/extensions/dataTables.tableTools.css') !!}

@stop



@section('maincontent')

	<!-- BEGIN CONTENT-->

	<div id="content">

		<section class="style-default-bright">

			<div class="section-header ">

				<ol class="breadcrumb">

					<li class="active">Home</li>

					<li class="active">Events</li>

				</ol>

			</div>



			<div class="section-header">

				<div class="row">

					<div class="col-lg-6">

						<h2 class="text-primary">Events</h2>

					</div>



					<div class="col-lg-6">

						{!! HTML::link("admin/events/add/get", "Add New Events", ["class"=>"btn ink-reaction pull-right btn-primary"]) !!}

					</div>

				</div>

			</div>



			<div class="section-body">

				<div class="row">

					<div class="col-lg-12">

						<div class="table-responsive">

							<table id="myTable" class="table table-striped table-hover">

								<thead>

									<tr>

										<th>#</th>

										<th>Title</th>

										<th>Category</th>

										<th>Created By</th>

										<th>Created On</th>

										<th class="sort-numeric">Status</th>

										<th class="sort-alpha">Actions</th>

									</tr>

								</thead>



								<tbody>

									<?php $i = 1; ?>

									@foreach($events as $event)

										<?php

											$id = Crypt::encrypt($event->id);

										?>

										<tr class="gradeX">

											<td>{!! $i !!}</td>

											<td>{!! $event->eventTitle !!}</td>

											<td>{!! EventCategories::getcategoryname($event->eventCategoryID) !!}</td>

											<td>{!! ucwords($event->createdByName) !!}</td>

											<td>{!! date(Option::fetchDateFormat()." ".Option::fetchTimeFormat(),strtotime($event->created_at)) !!}</td>

											<?php

												$event->status == "active" ? $class = "success" : $class = "danger";

											?>

											<td><button type="button" class="btn ink-reaction btn-xs btn-{!! $class !!} eventsStatus" data-id="{!! $id !!}">{!! ucfirst($event->status) !!}</button></td>

											<td>

												<a href="{!! URL::to('admin/events/modify/get/'.$event->eventSlug.'/'.$id) !!}" class="btn btn-icon-toggle" data-toggle="tooltip" data-placement="top" data-original-title="Modify Events" data-id="{!! $id !!}"><i class="fa fa-pencil"></i>

												</a>

												<button type="button" class="btn btn-icon-toggle eventsDelete" data-toggle="tooltip" data-placement="top" data-original-title="Delete row" data-id="{!! $id !!}"><i class="fa fa-trash-o"></i></button>

											</td>

										</tr>

										<?php $i++; ?>

									@endforeach

								</tbody>

							</table>

						</div><!--end .table-responsive -->

					</div><!--end .col -->

				</div><!--end .row -->

				<!-- END DATATABLE 1 -->

			</div><!--end .section-body -->

		</section>

	</div><!--end #content-->

	<!-- END CONTENT -->

@stop



@section('script')

	{!! HTML::script('backend/assets/js/libs/DataTables/jquery.dataTables.min.js') !!}

	{!! HTML::script('backend/assets/js/libs/DataTables/extensions/ColVis/js/dataTables.colVis.min.js') !!}

	{!! HTML::script('backend/assets/js/libs/DataTables/extensions/TableTools/js/dataTables.tableTools.min.js') !!}

	{!! HTML::script('backend/assets/js/core/demo/DemoTableDynamic.js') !!}

	<script>

		$(document).ready(function(){

	    	$('#myTable').DataTable();

		});



		$(document).on("click", ".eventsStatus", function(){

			var clicked = $(this);

			var id = clicked.attr("data-id");

			$("#processingIcon").remove();

			swal({

		        title: "Are you sure?",

		        text: "Do you really want to change this event status?",

		        type: "warning",

		        showCancelButton: true,

		        confirmButtonColor: "#EE2C47",

		        confirmButtonText: "Yes",

		        cancelButtonText: "No",

		        closeOnConfirm: true,

		        closeOnCancel: true

		    },

		    function(isConfirm){

		    	if(!isConfirm){

		    		return false;

		    	}



		        clicked.after('<span id="processingIcon" style="color:#399bff"><i class="fa fa-circle-o-notch fa-spin"></i></span>');



				$.ajax({

					type: "POST",

					url:  "/admin/events/status/post",

					headers: { 'X-CSRF-TOKEN': $('meta[name="_token"]').attr('content'), },

					data: {id:id},

					dataType: "json",

					success: function(data){

						console.log(data);

						var colour = "";

						if(data.status == "success"){

							data.current == "Inactive" ? colour = "btn-danger" : colour = "btn-success";

							clicked.text(data.current);

							clicked.removeClass("btn-success btn-danger").addClass(colour);

							$("#processingIcon").remove();

							swal("Changed!", "This event's status changed to "+data.current, "success");

							success_msg(data.msg);

						}

						return false;

					},

					error: function(e){

						console.log(e.responseText);

						return false;

					}

				});/* end of ajax */

			});/* end of confirm function */

			return false;

		});/* end of click function */



		$(document).on("click", ".eventsDelete", function(){

			var clicked = $(this);

			var id = clicked.attr("data-id");

			$("#processingIcon").remove();

			swal({

	            title: "Are you sure?",

	            text: "Do you really want to delete this event?",

	            type: "warning",

	            showCancelButton: true,

	            confirmButtonColor: "#EE2C47",

	            confirmButtonText: "Yes",

	            cancelButtonText: "No",

	            closeOnConfirm: true,

	            closeOnCancel: true

        	},

	        function(isConfirm){

	        	if(!isConfirm){

	        		return false;

	        	}

            	clicked.after('<span id="processingIcon" style="color:#399bff"><i class="fa fa-circle-o-notch fa-spin"></i></span>');



				$.ajax({

					type: "POST",

					url:  "/admin/events/delete/post",

					headers: { 'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content'), },

					data: {id:id},

					dataType: "json",

					success: function(data){

						console.log(data);

						var colour="";

						if(data.status == "success"){

							clicked.closest("tr").hide();

							success_msg(data.msg);

							$("#processingIcon").remove();

							swal("Deleted!!!", "This event deleted successfully!!!", "success");

						}

						return false;

					},

					error: function(e){

						console.log(e.responseText);

						swal("Error", "Error processing your request", "error");

						return false;

					}

				});/* end of ajax */

			});/* end of confirm function */

			return false;

		});/* end of click function */

	</script>

@stop