<?php 
	use App\Models\User; 
	use App\Models\Option; 
?>
@extends("backend/master")
@section('styles')
{!!HTML::style('backend/assets/css/theme-default/libs/DataTables/jquery.dataTables.css')!!}
{!!HTML::style('backend/assets/css/theme-default/libs/DataTables/extensions/dataTables.colVis.css')!!}
{!!HTML::style('backend/assets/css/theme-default/libs/DataTables/extensions/dataTables.tableTools.css')!!}
@stop
@section('maincontent')
	<!-- BEGIN CONTENT-->
	<div id="content">
		<section class="style-default-bright">
			<div class="section-header ">
				<ol class="breadcrumb">
					<li class="active">Home</li>
					<li class="active">FAQs</li>
				</ol>
			</div>
			<div class="section-header">
				<div class="row">
					<div class="col-lg-6">
						<h2 class="text-primary">FAQs</h2>
					</div>
					<div class="col-lg-6">
						{!! HTML::link("admin/pages/faq/add/get","Add New FAQ",["class"=>"btn ink-reaction pull-right btn-primary"]) !!}
					</div>
				</div>
			</div>

			<div class="section-body">
				<div class="row">
					<div class="col-lg-12">
						<div class="table-responsive">
							<table id="myTable" class="table table-striped table-hover">
								<thead>
									<tr>
										<th>#</th>
										<th>Question</th>
										<th>Last Modified</th>
										<th class="sort-numeric">Status</th>
										<th class="sort-alpha">Actions</th>
									</tr>
								</thead>
								<tbody>
									<?php $i = 1; ?>
									@foreach($FAQs as $FAQ)
										<?php
											$FAQ->status == "active" ? $class = "success" : $class = "danger";
											$lastModified = $FAQ->FAQUpdatorName != "" ? ucfirst($FAQ->FAQUpdatorName)." (".date(Option::fetchDateFormat()." ".Option::fetchTimeFormat(),strtotime($FAQ->updated_at)).")" : "";
										?>
										<tr class="gradeX">
											<td>{!! $i !!}</td>
											<td>{!! $FAQ->FAQQuestion !!}</td>
											<td>{!! $lastModified !!}</td>
											<td><button type="button" class="btn ink-reaction btn-xs btn-{!! $class !!} FAQStatus" data-id="{!! $FAQ->id !!}">{!! ucfirst($FAQ->status) !!}</button></td>
											<td>
												<a href="{!! URL::to('admin/pages/faq/modify/get/'.$FAQ->id) !!}">
												<button type="button" class="btn btn-icon-toggle" data-toggle="tooltip" data-placement="top" data-original-title="Edit row"><i class="fa fa-pencil"></i></button>
												</a>
												<button type="button" class="btn btn-icon-toggle FAQDelete" data-toggle="tooltip" data-placement="top" data-original-title="Delete row" data-id="{!! $FAQ->id !!}"><i class="fa fa-trash-o"></i></button>
											</td>
										</tr>
									<?php $i++; ?>
									@endforeach
								</tbody>
							</table>
						</div><!--end .table-responsive -->
					</div><!--end .col -->
				</div><!--end .row -->
				<!-- END DATATABLE 1 -->

			</div><!--end .section-body -->
		</section>
	</div><!--end #content-->
	<!-- END CONTENT -->
@stop

@section('script')
	{!! HTML::script('backend/assets/js/libs/DataTables/jquery.dataTables.min.js') !!}
	{!! HTML::script('backend/assets/js/libs/DataTables/extensions/ColVis/js/dataTables.colVis.min.js') !!}
	{!! HTML::script('backend/assets/js/libs/DataTables/extensions/TableTools/js/dataTables.tableTools.min.js') !!}
	{!! HTML::script('backend/assets/js/core/demo/DemoTableDynamic.js') !!}
	{!! HTML::script('backend/js/bala.js') !!}
	<script type="text/javascript">
	$(document).ready(function()
	{
    	$('#myTable').DataTable();
	});
	</script>
@stop