<?php 
	use App\Models\User; 
	use App\Models\Taxes; 
?>
@extends("backend/master")
@section('maincontent')
	<!-- BEGIN CONTENT-->
	<div id="content">
		<section>
			<div class="section-header ">
				<ol class="breadcrumb">
					<li class="active">Home</li>
					<li class="active">FAQs</li>
					<li class="active">Add New FAQ</li>
				</ol>
			</div>
			<div class="section-body">
				<!-- BEGIN VERTICAL FORM -->
				<div class="row">
					<div class="col-lg-12">
						<h1 class="text-primary">Add New FAQ</h1>
					</div><!--end .col -->
					<div class="col-lg-3 col-md-4">
						
						<div class="section-header">
							{!! HTML::link("admin/pages/faq/get","Manage FAQs",["class"=>"btn ink-reaction btn-block btn-primary"]) !!}
						</div>
					</div><!--end .col -->
					<div class="col-md-9">
						{!! Form::open(["url"=>"admin/pages/faq/add/post","class"=>"form","enctype"=>"multipart/form-data","files"=>true]) !!}
							<div class="card">
								<div class="card-head style-primary">
									<header>Create FAQ</header>
								</div>
								@if(Session::has('success')) {!! HTML::display_success('success') !!} @endif
								<div class="card-body">
									<div class="form-group @if($errors->has('FAQQuestion'))has-error @endif">
										{!! Form::text("FAQQuestion","",["class"=>"form-control"]) !!}
											@if($errors->has("FAQQuestion"))
												<span id="FAQQuestion-error" class="help-block">{!! $errors->first("FAQQuestion") !!}</span>
											@endif
										{!! HTML::decode(Form::label("FAQQuestion","Question <span class='text-danger'>*</span>")) !!}
									</div>
									
									<div class="form-group @if($errors->has('FAQAnswer'))has-error @endif">
									{!! HTML::decode(Form::label("FAQAnswer","Answer <span class='text-danger'>*</span>")) !!}
									{!! Form::textarea("FAQAnswer","",["class"=>"form-control"]) !!}
										@if($errors->has("FAQAnswer"))
											<span id="FAQAnswer-error" class="help-block">{!! $errors->first("FAQAnswer") !!}</span>
										@endif
									</div>

									<div class="form-group @if($errors->has('FAQProducts'))has-error @endif">
										{!! Form::select("FAQProducts[]",$products,"",["class"=>"form-control","id"=>"FAQProducts","multiple"]) !!}
										@if($errors->has("FAQProducts"))
											<span id="FAQProducts-error" class="help-block">{!! $errors->first("FAQProducts") !!}</span>
										@endif
										{!! HTML::decode(Form::label("FAQProducts","Products<span class='text-danger'>*</span>")) !!}
									</div>
								</div><!--end .card-body -->

								<div class="card-actionbar">
									<div class="card-actionbar-row">
										<button type="submit" class="btn ink-reaction btn-primary-dark">Add FAQ</button>
									</div>
								</div>

							</div><!--end .card -->
						{!! Form::close() !!}
					</div><!--end .col -->
				</div><!--end .row -->
				<!-- END VERTICAL FORM -->
			</div>
		</section>
	</div><!--end #content-->
	<!-- END CONTENT -->
@stop

@section("script")
	{!! HTML::script('backend/js/bala.js') !!}
	{!! HTML::script('backend/ckeditor/ckeditor.js') !!}
	<script type="text/javascript">
	    $(document).ready(function() 
	    {
	      CKEDITOR.replace('FAQAnswer');
	    });
	</script>
@stop