@extends("backend/master")
@section('maincontent')
	<!-- BEGIN CONTENT-->
	<div id="content">
		<section>
			<div class="section-header ">
				<ol class="breadcrumb">
					<li class="active">Home</li>
					<li class="active">Gallery Categories</li>
					<li class="active">Add New Gallery Category</li>
				</ol>
			</div>

			<div class="section-body">
				<!-- BEGIN VERTICAL FORM -->
				<div class="row">
					<div class="col-lg-12">
						<h1 class="text-primary">Add New Gallery Category</h1>
					</div><!--end .col -->

					<div class="col-lg-3 col-md-4">
						<div class="section-header">
							{!! HTML::link("admin/gallery/categories/get","Manage Gallery Categories",["class"=>"btn ink-reaction btn-block btn-primary"]) !!}
						</div>
					</div><!--end .col -->

					<div class="col-md-9">
						{!! Form::open(["url"=>"admin/gallery/categories/add/post", "class"=>"form", "files"=>true]) !!}
							<div class="card">
								<div class="card-head style-primary">
									<header>Create Gallery Category</header>
								</div>

								@if(Session::has('success')) {!! HTML::display_success('success') !!} @endif

								<div class="card-body">
									<div class="form-group @if($errors->has('galleryCategoryTitle'))has-error @endif">
										{!! Form::text("galleryCategoryTitle","",["class"=>"form-control"]) !!}
											@if($errors->has("galleryCategoryTitle"))
												<span id="galleryCategoryTitle-error" class="help-block">{!! $errors->first("galleryCategoryTitle") !!}</span>
											@endif
										{!! HTML::decode(Form::label("galleryCategoryTitle","Title <span class='text-danger'>*</span>")) !!}
									</div>
								</div><!--end .card-body -->

								<div class="card-actionbar">
									<div class="card-actionbar-row">
										<button type="submit" class="btn ink-reaction btn-primary-dark">Add Gallery Category</button>
									</div>
								</div>
							</div><!--end .card -->
						{!! Form::close() !!}
					</div><!--end .col -->
				</div><!--end .row -->
				<!-- END VERTICAL FORM -->
			</div>
		</section>
	</div><!--end #content-->
	<!-- END CONTENT -->
@stop

@section("script")
	
@stop