<?php
	use App\Models\GalleryCategories;
	use App\Models\Upload;
?>
@extends("backend/master")
@section('styles')
	{!! HTML::style('backend/assets/css/jquery-ui.css') !!}
@stop
@section('maincontent')
	<!-- BEGIN CONTENT-->
	<div id="content">
		<section>
			<div class="section-header ">
				<ol class="breadcrumb">
					<li class="active">Home</li>
					<li class="active">Gallery</li>
					<li class="active">Modify Gallery</li>
				</ol>
			</div>

			<div class="section-body">
				{!! Form::open(["url"=>"admin/gallery/modify/".$gallery->gallerySlug."/".Crypt::encrypt($gallery->id), "class"=>"form", "files"=>true]) !!}
					<!-- BEGIN VERTICAL FORM -->
					<div class="row">
						<div class="col-lg-12">
							<h1 class="text-primary">Modify Gallery</h1>
						</div><!--end .col -->

						<div class="col-md-9">
							<div class="card">
								<div class="card-head style-primary">
									<header>Modify Gallery</header>
								</div>

								@if(Session::has('success')) {!! HTML::display_success('success') !!} @endif

								<div class="card-body">
									<div class="form-group @if($errors->has('galleryTitle'))has-error @endif">
										{!! Form::text("galleryTitle",$gallery->galleryTitle,["class"=>"form-control", "id"=>"galleryTitle"]) !!}
											@if($errors->has("galleryTitle"))
												<span id="galleryTitle-error" class="help-block">{!! $errors->first("galleryTitle") !!}</span>
											@endif
										{!! HTML::decode(Form::label("galleryTitle", "Title <span class='text-danger'>*</span>")) !!}
									</div>

									<div class="form-group @if($errors->has('galleryDate'))has-error @endif">
										{!! Form::text("galleryDate",$gallery->galleryDate,["class"=>"form-control", "id"=>"galleryDate"]) !!}
										{!! HTML::decode(Form::label("galleryDate", "Date")) !!}
									</div>

									<div class="form-group @if($errors->has('galleryHostedBy'))has-error @endif">
										{!! Form::text("galleryHostedBy",$gallery->galleryHostedBy,["class"=>"form-control", "id"=>"galleryHostedBy"]) !!}
										{!! HTML::decode(Form::label("galleryHostedBy", "Hosted By")) !!}
									</div>

									<div class="form-group @if($errors->has('venue'))has-error @endif">
										{!! Form::text("venue",$gallery->hostDesignation,["class"=>"form-control", "id"=>"venue"]) !!}
										{!! HTML::decode(Form::label("venue", "Venue")) !!}
									</div>

									<div class="form-group @if($errors->has('hostCompanyName'))has-error @endif">
										{!! Form::text("hostCompanyName",$gallery->hostCompanyName,["class"=>"form-control", "id"=>"hostCompanyName"]) !!}
										{!! HTML::decode(Form::label("hostCompanyName", "Company <span class='text-danger'></span>")) !!}
									</div>

									<div class="form-group @if($errors->has('descriptionTitle'))has-error @endif">
										{!! Form::text("descriptionTitle",$gallery->descriptionTitle,["class"=>"form-control", "id"=>"descriptionTitle"]) !!}
										{!! HTML::decode(Form::label("descriptionTitle", "Description Title <span class='text-danger'></span>")) !!}
									</div>

									<div class="form-group @if($errors->has('description'))has-error @endif">
										{!! Form::textarea("description",$gallery->description,["class"=>"form-control", "id"=>"description"]) !!}
											@if($errors->has("description"))
												<span id="description-error" class="help-block">{!! $errors->first("description") !!}</span>
											@endif
										{!! HTML::decode(Form::label("description", "Description")) !!}
									</div>
								</div><!--end .card-body -->
							</div><!--end .card -->

							<div class="card">
								<div class="card-head">
									<header>Gallery Images</header>
								</div><!--end .card-head -->

								<div class="card-body">
									<div class="row">
										<div class="col-md-12">
											<ul class="product_images_container" id="pro_galleryimgbox">
												<?php
												 	$galimg = Upload::where('productid', $gallery->id)->where('type', 'gallery')->get();
												 ?>
												@foreach($galimg as $gal)
													<li>
														<button class="btn ink-reaction btn-icon-toggle btn-primary removeimg" data-id="{!! Crypt::encrypt($gal->id) !!}" type="button"><i class="fa fa-close"></i></button>
														<img src="{!! $gal->path !!}">
														<input type="hidden" name="pro_galleryimage[]" value="{!! $gal->path !!}">
														<input type="hidden" name="pro_gallerythumbimage[]" value="{!! $gal->thumbnail !!}">
														<input type="hidden" name="pro_gallerythumb1image[]" value="{!! $gal->thumbnail1 !!}">
													</li>
												@endforeach	
											</ul>
											<a href="javascript:;" id="pro_gallerybtn" class="btn btn-block ink-reaction btn-default">Upload Gallery Images</a>
											<div class="">Recommended Gallery image size 1024px x 768px</div>
											<div class="progress progress-striped active" id="pro_galleryprogressbox" style="display:none;">
												<div class="progress-bar progress-bar-warning" id="pro_galleryprogress"></div>
											</div>
											<input type="file" multiple="" id="pro_galleryfile" style="display:none;">
										</div>
									</div>
								</div>
							</div><!--end .card -->
						</div><!--end .col -->

						<div class="col-md-3">
							<div class="card">
								<div class="card-head style-primary">
									<header>Manage</header>
								</div><!--end .card-head -->

								<div class="publishActions">
									<div class="card-actionbar">
										<div class="card-actionbar-row">
											{!! HTML::link("admin/gallery/get","Manage Gallery",["class"=>"btn ink-reaction btn-block btn-primary"]) !!}
										</div>
									</div>
								</div>
							</div><!--end .card -->

							<div class="card">
								<div class="card-head">
									<header>Categories</header>
								</div><!--end .card-head -->

								<div class="card-body small-padding height-8 productCategories">
									<ul data-sortable="true" class="list">
										<?php 
											$categories = GalleryCategories::where('status', 'active')->get(); 
										?>
										@foreach($categories as $category)
											<?php
												$checked = "";
												if($category->id == $gallery->galleryCategoryID){
													$checked = "checked='checked'";
												}
											?>
											<li class="tile">
												<div class="radio radio-styled">
													<label>
														<input type="radio" name="galleryCategory" value="{!! $category->id !!}" class="galleryCategories" {!! $checked !!}>
														<span>{!! $category->categoryName !!}</span>
													</label>
												</div>
											</li>
										@endforeach<!-- 1-->			
									</ul>
								</div>
							</div><!--end .card -->

							<div class="card">
								<div class="card-head">
									<header>Gallery Featured Image</header>
								</div><!--end .card-head -->

								<div class="card-body">
									<div class="row">
										<div class="col-md-6" id="pro_featureimgbox">
											<?php
											 	$feaimg = Upload::where('productid',$gallery->id)->where('type','feature')->first();
											 	if($feaimg){ 
											 		$furl = $feaimg->path; 
											 		$fturl = $feaimg->thumbnail; 
											 	} else{ 
											 		$furl = ''; 
											 		$fturl = ''; 
											 	}
											?>

											@if($feaimg)
												<img src="{!! $feaimg->path !!}" class="featuredImage img-responsive">
											@endif
										</div>

										<div class="col-md-6">
											<a href="javascript:;" id="pro_featurebtn" class="btn btn-block ink-reaction btn-default">Set Featured Image</a>
											<div>Recommended Size 600px x 400px</div>
											<br>
											<div class="progress progress-striped active" id="pro_featureprogressbox" style="display:none;">
												<div class="progress-bar progress-bar-warning" id="pro_featureprogress"></div>
											</div>
											<input type="file" id="pro_featurefile" style="display:none;">
											<input type="hidden" name="pro_featureimage" id="pro_featureimage">
											<input type="hidden" name="pro_featurethumbimage" id="pro_featurethumbimage">
										</div>
									</div>
								</div>
							</div><!--end .card -->


							

							<div class="card">
								<div class="card-head">
									<header>Publish</header>
								</div><!--end .card-head -->

								<div class="publishActions">
									<div class="card-actionbar">
										<div class="card-actionbar-row">
											<!-- <button class="btn ink-reaction btn-primary">Preview</button> -->
											<button type="submit" id="publishGallery" class="btn ink-reaction btn-primary-dark">Update Gallery</button>
										</div>
									</div>
								</div>
							</div><!--end .card -->
						</div>
					</div><!--end .row -->
					<!-- END VERTICAL FORM -->
				{!! Form::close() !!}
			</div>
		</section>
	</div><!--end #content-->
	<!-- END CONTENT -->
@stop

@section("script")
	{!! HTML::script('backend/assets/js/libs/global/iframe-transport.js') !!}
	{!! HTML::script('backend/assets/js/libs/global/jquery-ui.js') !!}
	{!! HTML::script('backend/assets/js/libs/global/fileupload.js') !!}
	{!! HTML::script('backend/ckeditor/ckeditor.js') !!}
	{!! HTML::script('backend/assets/js/jquery-ui.js') !!}
	<script type="text/javascript">
		$(document).ready(function(){
			CKEDITOR.replace('description');
			$("#galleryDate").datepicker({
		      	changeMonth: false,
		      	dateFormat:'yy-mm-dd',
		      	numberOfMonths: 1
		    });
		});
		$('#pro_featurebtn').on('click', function(){
			$('#pro_featurefile').trigger('click'); 
		});
		$('#pro_gallerybtn').on('click', function(){ $('#pro_galleryfile').trigger('click'); });
		'use strict';       
		$('#pro_featurefile').fileupload({
		    url: '/imageuploadwiththumbnail',
		    headers: { 'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content'), },
		    dataType: 'json',
		    formData: { path:'' },
		    done: function (e, data) {
		        var baseurl = document.location.origin;
		        var src = baseurl+'/'+data.result.files[0].url;
		        var thumbsrc = baseurl+'/'+data.result.files[0].thumbnailUrl;
		        $('#pro_featureimgbox').html('').html('<img src="'+src+'" class="featuredImage img-responsive">'); 
		        $('#pro_featureimage').val(src);
		        $('#pro_featurethumbimage').val(thumbsrc);
		        // console.log(src);
		    },
		    progressall: function (e, data) {
		        $('#pro_featureprogressbox').show();
		        var progress = parseInt(data.loaded / data.total * 100, 10);
		        $('#pro_featureprogress').css(
		            'width',
		            progress + '%'
		        ).text(progress+'%');
		        if(progress == 100){ closeprogress();  }
		    },error: function(e){
		      console.log(e.responseText);
		    }
		}).prop('disabled', !$.support.fileInput)
		.parent().addClass($.support.fileInput ? undefined : 'disabled');

		$('#pro_galleryfile').fileupload({
		    url: '/imageuploadwiththumbnail',
		    headers: { 'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content'), },
		    dataType: 'json',
		    formData: { path:'' },
		    done: function (e, data) {
		    	console.log(data);
		        var baseurl = document.location.origin;
		        var src = baseurl+'/'+data.result.files[0].url;
		        var thumbsrc = baseurl+'/'+data.result.files[0].thumbnailUrl;
		         var thumb1src = baseurl+'/'+data.result.files[0].thumbnail1Url;
		         console.log(data);
		         console.log('imgae uplaod');
		         console.log(thumb1src);
		        $('#pro_galleryimgbox').append('<li><button class="btn ink-reaction btn-icon-toggle btn-primary removeimg" type="button"><i class="fa fa-close"></i></button><img src="'+src+'"><input type="hidden" name="pro_galleryimage[]" value="'+src+'"><input type="hidden" name="pro_gallerythumbimage[]" value="'+thumbsrc+'"><input type="hidden" name="pro_gallerythumb1image[]" value="'+thumb1src+'"></li>'); 
		        $('#hiddenimgbox').append('');
		        console.log(src);
		    },
		    progressall: function (e, data) {
		        $('#pro_galleryprogressbox').show();
		        var progress = parseInt(data.loaded / data.total * 100, 10);
		        $('#pro_galleryprogress').css(
		            'width',
		            progress + '%'
		        ).text(progress+'%');
		        if(progress == 100){ closeprogress();  }
		    },error: function(e){
		      console.log(e.responseText);
		    }
		}).prop('disabled', !$.support.fileInput)
		.parent().addClass($.support.fileInput ? undefined : 'disabled');

		function closeprogress(){
			setTimeout(function(){ $('.progress').next().css('width','0%').text(''); $('.progress').hide(); }, 1000);
		}

		$(document).on("click", "#publishGallery", function(){
			var title = $("#galleryTitle").val();

			if(title == ""){
				swal("Required", "Please fill all the fields", "warning");
				return false;
			}

			if(!$("input[name='galleryCategory']").is(':checked')){
                swal("Please Select", "Please select gallery category", "info");
                return false;
            }
		});

		$(document).on('click', '.removeimg', function(){
			var current = $(this) ;
			var ID = current.attr("data-id");
			
			$.ajax({
				type: "POST",
				url: "/admin/gallery/modify/delete/image",
				headers: { 'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content'), },
				data: {ID:ID},
				dataType: "json",
				success: function(data){
					current.parent().remove();
					return false;
				},
				error: function(e){
					console.log(e.responseText);
					return false;
				}
			});/* end of ajax */ 
		});
	</script>
@stop