<?php 
	use App\Models\User; 
	use App\Models\Option; 
?>
@extends("backend/master")

@section('styles')
@section('styles')
	{!! HTML::style('backend/assets/css/theme-default/libs/DataTables/jquery.dataTables.css') !!}
	{!! HTML::style('backend/assets/css/theme-default/libs/DataTables/extensions/dataTables.colVis.css') !!}
	{!! HTML::style('backend/assets/css/theme-default/libs/DataTables/extensions/dataTables.tableTools.css') !!}
	{!! HTML::style('backend/assets/css/jquery-ui.css') !!}
@stop

@section('maincontent')
	<!-- BEGIN CONTENT-->
	<div id="content">
		<section class="style-default-bright">
			<div class="section-header ">
				<ol class="breadcrumb">
					<li class="active">Home</li>
					<li>Job Opportunities</li>
				</ol>
			</div>

			<div id="exclUploadDiv">
		      	<div class="card">
		        	<div class="card-body">
		          		<div class="row">
		            		{!! Form::open(["id"=>"registrationForm"]) !!}

		            			<div class="col-lg-3">
		              				{!! Form::text("dateFrom","",["class"=>"form-control","id"=>"dateFrom","placeholder"=>"From Date"]) !!}
					              	@if($errors->has("dateFrom"))
										<span id="dateFrom-error" class="help-block">{!! $errors->first("dateFrom") !!}</span>
									@endif
		            			</div>

		            			<div class="col-lg-3">
		              				{!! Form::text("dateTo","",["class"=>"form-control","id"=>"dateTo","placeholder"=>"To Date"]) !!}
					              	@if($errors->has("dateTo"))
										<span id="dateTo-error" class="help-block">{!! $errors->first("dateTo") !!}</span>
									@endif
		            			</div>

		            			<div class="clearfix"></div>	
		            			<br>
		            			
					            <div class="col-lg-2">
					                <input type="button" class="btn ink-reaction btn-success" value="Search" id="searchJob">
					                <input type="reset" class="btn ink-reaction btn-danger" value="Reset">
					            </div>
		            		{!! Form::close() !!}
		          		</div>
		        	</div>
		      	</div>
		  	</div>

		  	<div class="clearfix"></div>

  			@if(Session::has('success')) {!! HTML::display_success('success') !!} @endif

  			<div class="processLoadingDiv" style='display:none'>
		        <div class="spinner">
				  <div class="bounce1"></div>
				  <div class="bounce2"></div>
				  <div class="bounce3"></div>
				</div>
		        <p class="text-center">Processing.... Please wait...</p>
		    </div>

			<section id="jobOpportunitiesTable" style="display:none;">

				<div class="section-header">
					<div class="row">
						<div class="col-lg-6">
							<h2 class="text-primary">Job Opportunities</h2>
						</div>
					</div>
				</div>

				<div class="section-body">
					<div class="row">
						<div class="col-lg-12">
							<div class="table-responsive">
								<table id="myTable" class="table table-striped table-hover">
									<thead>
										<tr>
											<th>#</th>
											<th>Email</th>
											<th>Job Title</th>
											<th>Location</th>
											<th>Job Type</th>
											<th>Application Email/URL</th>
											<th>Company Name</th>
										</tr>
									</thead>

									<tbody>
										
									</tbody>
								</table>
							</div><!--end .table-responsive -->
						</div><!--end .col -->
					</div><!--end .row -->
					<!-- END DATATABLE 1 -->
				</div><!--end .section-body -->
			</section>
		</section>
	</div><!--end #content-->
	<!-- END CONTENT -->
@stop

@section('script')
  	{!! HTML::script('backend/assets/js/jquery-ui.js') !!}
  	{!! HTML::script('backend/assets/js/libs/DataTables/jquery.dataTables.min.js') !!}
	{!! HTML::script('backend/assets/js/libs/DataTables/extensions/ColVis/js/dataTables.colVis.min.js') !!}
	{!! HTML::script('backend/assets/js/libs/DataTables/extensions/TableTools/js/dataTables.tableTools.min.js') !!}
	<script>
		$('#myTable').DataTable();
		$(document).ready(function(){
	    	$("#dateFrom").datepicker({
		      	changeMonth: false,
		      	dateFormat:'yy-mm-dd',
		      	numberOfMonths: 1,
		      	onClose: function( selectedDate ){
		        	$("#dateTo").datepicker( "option", "minDate", selectedDate );
		      	}
		    });

		    $( "#dateTo" ).datepicker({
		      	dateFormat:'yy-mm-dd',
		      	changeMonth: false,
		      	numberOfMonths: 1,
		      	onClose: function( selectedDate ){
		        	$( "#dateFrom" ).datepicker( "option", "maxDate", selectedDate );
		      	}
		    });
		});/* end of ready function */


		//payment reports
		$(document).on("click","#searchJob",function(){
	    	var clicked = $(this);
	    	$("#jobOpportunitiesTable").slideUp();
	        clicked.after('<span id="processingIcon" style="color:#399bff"><i class="fa fa-circle-o-notch fa-spin"></i></span>');
	  		var form = $('#registrationForm').serialize();
	  		console.log(form);
	        $.ajax({
	        	headers: { 'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content'), },
	            type: 'POST',
	            url: '/admin/job-opportunities/post',
	            data: form,
	            dataType: 'json',
	            success:function(data){
	              	console.log(data);
	          		if(data.status == 'success' && data.count > 0){
							var oTable = $('#myTable').dataTable();
	              		oTable.fnClearTable();
						$.each(data.result,function(key,value){
							oTable.fnAddData([data.result[key]['sno'],data.result[key]['email'],data.result[key]['job_title'],data.result[key]['location'],data.result[key]['job_type'],data.result[key]['application_email'],data.result[key]['company_name']]);
						});
						$("#jobOpportunitiesTable").slideDown();
					}else{
						swal("Empty!", data.msg , "warning");
					}
					$("#processingIcon").remove();
	            },
	            error:function(e){
	              console.log(e.responseText);
	              $("#processingIcon").remove();
	              swal("Error!", "Error processing your request, please try later", "error");
	              return false;
	            }
	        });/* end of ajax */
			return false;
	    });
	</script>
@stop