<?php 
	use App\Models\User; 
	use App\Models\Option; 
	use App\Models\TrackingReports; 
?>
@extends("backend/master")
@section('styles')
	{!! HTML::style('backend/assets/css/theme-default/libs/DataTables/jquery.dataTables.css') !!}
	{!! HTML::style('backend/assets/css/theme-default/libs/DataTables/extensions/dataTables.colVis.css') !!}
	{!! HTML::style('backend/assets/css/theme-default/libs/DataTables/extensions/dataTables.tableTools.css') !!}
	<link rel="stylesheet" href="//code.jquery.com/ui/1.11.4/themes/smoothness/jquery-ui.css">
@stop
@section('maincontent')
	<!-- BEGIN CONTENT-->
	<div id="content">
		<section class="style-default-bright">
			<div class="section-header ">
				<ol class="breadcrumb">
					<li class="active">Home</li>
					<li class="active">System Logs</li>
				</ol>
			</div>

			<div id="exclUploadDiv">
		      	<div class="card">
		        	<div class="card-body">
		          		<div class="row">
		            		{{ Form::open(["id"=>"formSystemLog"]) }}
		            			<div class="col-lg-3">
		              				{!! Form::text("dateFrom","",["class"=>"form-control","id"=>"dateFrom","placeholder"=>"From Date"]) !!}
					              	@if($errors->has("dateFrom"))
										<span id="dateFrom-error" class="help-block">{!! $errors->first("dateFrom") !!}</span>
									@endif
		            			</div>

		            			<div class="col-lg-3">
		              				{!! Form::text("dateTo","",["class"=>"form-control","id"=>"dateTo","placeholder"=>"To Date"]) !!}
					              	@if($errors->has("dateTo"))
										<span id="dateTo-error" class="help-block">{!! $errors->first("dateTo") !!}</span>
									@endif
		            			</div>

		            			<div class="col-lg-3">
		              				{!! Form::select("logType",["login"=>"Login","product"=>"Product","payment"=>"Payment"],"",["class"=>"form-control","id"=>"logType","placeholder"=>"Select Log Type"]) !!}
					              	@if($errors->has("logType"))
										<span id="logType-error" class="help-block">{!! $errors->first("logType") !!}</span>
									@endif
		            			</div>

		            			<div class="col-lg-3">
		              				{!! Form::select("process",["add"=>"Add","modify"=>"Modify","status"=>"Status","delete"=>"Delete"],"",["class"=>"form-control","id"=>"process","placeholder"=>"Select Log Type"]) !!}
					              	@if($errors->has("process"))
										<span id="process-error" class="help-block">{!! $errors->first("process") !!}</span>
									@endif
		            			</div>

		            			<div class="clearfix"></div>	
		            			<br>
					            <div class="col-lg-2">
					                <input type="submit" class="btn ink-reaction pull-left btn-primary" id="searchSystemLogs">
					            </div>
		            		{{ Form::close() }}
		          		</div>
		        	</div>
		      	</div>
		  	</div>
  			<div class="clearfix"></div>

  			@if(Session::has('success')) {!! HTML::display_success('success') !!} @endif

			<div class="section-body" id="systemLogTable" style="display: none;">
				<div class="row">
					<div class="col-lg-12">
						<div class="table-responsive">
							<table id="myTable" class="table table-striped table-hover">
								<thead>
									<tr>
										<th>#</th>
										<th>User Name</th>
										<th>Log Type</th>
										<th>Process</th>
										<th>Date</th>
										<th class="sort-numeric">Activity</th>
									</tr>
								</thead>
								<tbody class="systemLogBody">
								</tbody>
							</table>
						</div><!--end .table-responsive -->
					</div><!--end .col -->
				</div><!--end .row -->
				<!-- END DATATABLE 1 -->

			</div><!--end .section-body -->
		</section>
	</div><!--end #content-->
	<!-- END CONTENT -->
@stop

@section('script')
	{!! HTML::script('backend/assets/js/libs/DataTables/jquery.dataTables.min.js') !!}
	{!! HTML::script('backend/assets/js/libs/DataTables/extensions/ColVis/js/dataTables.colVis.min.js') !!}
	{!! HTML::script('backend/assets/js/libs/DataTables/extensions/TableTools/js/dataTables.tableTools.min.js') !!}
	{!! HTML::script('backend/assets/js/core/demo/DemoTableDynamic.js') !!}
	{!! HTML::script('backend/js/bala.js') !!}
	{!! HTML::script('backend/assets/js/jquery-ui.js') !!}
	<script type="text/javascript">
		$(document).ready(function()
		{
	    	$('#myTable').DataTable();
	    	$("#dateFrom").datepicker({
		      changeMonth: false,
		      dateFormat:'dd-M-yy',
		      numberOfMonths: 1,
		      onClose: function( selectedDate ) 
		      {
		        $("#dateTo").datepicker( "option", "minDate", selectedDate );
		      }
		    });

		    $( "#dateTo" ).datepicker({
		      dateFormat:'dd-M-yy',
		      changeMonth: false,
		      numberOfMonths: 1,
		      onClose: function( selectedDate ) 
		      {
		        $( "#dateFrom" ).datepicker( "option", "maxDate", selectedDate );
		      }
		    });
		});
	</script>
@stop