<!DOCTYPE html>

<!--[if IE 8]> <html lang="en" class="ie8 no-js"> <![endif]-->

<!--[if IE 9]> <html lang="en" class="ie9 no-js"> <![endif]-->

<!--[if !IE]><!-->

<html lang="en" class="no-js">

<!--<![endif]-->

<!-- BEGIN HEAD -->

<head>

<meta charset="utf-8"/>

<?php

	use App\Models\Option;

	use App\Models\Upload;

?>

<title>{!! Option::siteTitle() !!}</title>

<link rel="icon" href="{!! Upload::getimageurl(Option::getvalue('header_favicon')) !!}" type="image/png" sizes="16x16">

<meta http-equiv="X-UA-Compatible" content="IE=edge">

<meta content="width=device-width, initial-scale=1" name="viewport"/>

<meta content="" name="description"/>

<meta content="" name="author"/>

<meta name="csrf-token" content="{!! csrf_token() !!}" />




<!-- BEGIN GLOBAL MANDATORY STYLES -->

<link href='https://fonts.googleapis.com/css?family=Open+Sans:400,600,700,800' rel='stylesheet' type='text/css'>

{!! HTML::style('backend/assets/css/theme-default/bootstrap.css') !!}

{!! HTML::style('backend/assets/css/theme-default/materialadmin.css') !!}

{!! HTML::style('backend/assets/css/theme-default/font-awesome.min.css') !!}

{!! HTML::style('backend/assets/css/theme-default/material-design-iconic-font.min.css') !!}

{!! HTML::style('backend/assets/css/theme-default/libs/rickshaw/rickshaw.css') !!}

{!! HTML::style('backend/assets/css/theme-default/libs/select2/select2.css') !!}

{!! HTML::style('backend/assets/css/theme-default/libs/multi-select/multi-select.css') !!} 

{!! HTML::style('backend/assets/css/theme-default/libs/bootstrap-tagsinput/bootstrap-tagsinput.css?1424887862') !!}

{!! HTML::style('backend/assets/css/theme-default/libs/toastr/toastr.css') !!}

{!! HTML::style('backend/assets/css/theme-default/libs/bootstrap-datepicker/datepicker3.css?1424887858') !!}

{!! HTML::style('backend/assets/css/jquery.minicolors.css') !!} 

{!! HTML::style('backend/sweetalert/sweetalert.css') !!} 

@yield("styles")

</head>

<!-- END HEAD -->



<body class="menubar-hoverable header-fixed menubar-pin menubar-first">



<!-- BEGIN HEADER-->

<header id="header" >

	<div class="headerbar">

		<!-- Brand and toggle get grouped for better mobile display -->

		<div class="headerbar-left">

			<ul class="header-nav header-nav-options">

				<li class="header-nav-brand" >

					<div class="brand-holder">

						<a href="{!! URL::to('admin') !!}">

							<span class="text-lg text-bold text-primary">{!! Option::portalName() !!} ADMIN</span>

						</a>

					</div>

				</li>

				<li>

					<a class="btn btn-icon-toggle menubar-toggle" data-toggle="menubar" href="javascript:void(0);">

						<i class="fa fa-bars"></i>

					</a>

				</li>

			</ul>

		</div>

		<!-- Collect the nav links, forms, and other content for toggling -->

		<div class="headerbar-right">

			<ul class="header-nav header-nav-profile">

				<li>

					<a href="{!! URL::to('/') !!}" target="_blank">Visit Website</a>

				</li>

				<li>

					&nbsp;

				</li>

				<li class="dropdown">

					<a href="javascript:void(0);" class="dropdown-toggle ink-reaction" data-toggle="dropdown">

						<span class="profile-info">

							{!! Auth::User()->userName !!}

							<small>Administrator</small>

						</span>

					</a>

					<ul class="dropdown-menu animation-dock">

						<li><a href="{!! URL::to('admin/users/modify/'.Auth::user()->id) !!}">Profile</a></li>

						<li><a href="{!! URL::to('admin/users/change/password') !!}">Change Password</a></li>

						<li class="divider"></li>

						<li><a href="{!! URL::to('admin/logout') !!}"><i class="fa fa-fw fa-power-off text-danger"></i> Logout</a></li>

					</ul><!--end .dropdown-menu -->

				</li><!--end .dropdown -->

			</ul><!--end .header-nav-profile -->

		</div><!--end #header-navbar-collapse -->

	</div>

</header>

<!-- END HEADER-->



		<!-- BEGIN BASE-->

		<div id="base">



			<!-- BEGIN OFFCANVAS LEFT -->

			<div class="offcanvas">

			</div><!--end .offcanvas-->

			<!-- END OFFCANVAS LEFT -->



			@yield('maincontent')



			@include('backend.sidebar')



			

		<!-- END BASE -->



{!! HTML::script('backend/assets/js/libs/jquery/jquery-1.11.2.min.js') !!}

{!! HTML::script('backend/assets/js/libs/jquery/jquery-migrate-1.2.1.min.js') !!}



<!-- IMPORTANT! Load jquery-ui.min.js before bootstrap.min.js to fix bootstrap tooltip conflict with jquery ui tooltip -->

{!! HTML::script('backend/assets/js/libs/bootstrap/bootstrap.min.js') !!}

{!! HTML::script('backend/assets/js/libs/spin.js/spin.min.js') !!}

{!! HTML::script('backend/assets/js/libs/autosize/jquery.autosize.min.js') !!}

{!! HTML::script('backend/assets/js/libs/moment/moment.min.js') !!}

{!! HTML::script('backend/assets/js/libs/flot/jquery.flot.min.js') !!}

{!! HTML::script('backend/assets/js/libs/flot/jquery.flot.time.min.js') !!}

{!! HTML::script('backend/assets/js/libs/flot/jquery.flot.resize.min.js') !!}

{!! HTML::script('backend/assets/js/libs/flot/jquery.flot.orderBars.js') !!}

{!! HTML::script('backend/assets/js/libs/flot/jquery.flot.pie.js') !!}

{!! HTML::script('backend/assets/js/libs/flot/curvedLines.js') !!}

{!! HTML::script('backend/assets/js/libs/jquery-knob/jquery.knob.min.js') !!}

{!! HTML::script('backend/assets/js/libs/sparkline/jquery.sparkline.min.js') !!}

{!! HTML::script('backend/assets/js/libs/nanoscroller/jquery.nanoscroller.min.js') !!}

{!! HTML::script('backend/assets/js/libs/d3/d3.min.js') !!}

{!! HTML::script('backend/assets/js/libs/d3/d3.v3.js') !!}

{!! HTML::script('backend/assets/js/libs/rickshaw/rickshaw.min.js') !!}

{!! HTML::script('backend/assets/js/core/source/App.js') !!}

{!! HTML::script('backend/assets/js/libs/select2/select2.min.js') !!}

{!! HTML::script('backend/assets/js/libs/multi-select/jquery.multi-select.js') !!} 

{!! HTML::script('backend/assets/js/libs/bootstrap-tagsinput/bootstrap-tagsinput.min.js') !!} 



<!-- BEGIN PAGE LEVEL SCRIPTS -->

{!! HTML::script('backend/assets/js/core/source/AppNavigation.js') !!}

{!! HTML::script('backend/assets/js/core/source/AppOffcanvas.js') !!}

{!! HTML::script('backend/assets/js/core/source/AppCard.js') !!}

{!! HTML::script('backend/assets/js/core/source/AppForm.js') !!}

{!! HTML::script('backend/assets/js/core/source/AppNavSearch.js') !!}

{!! HTML::script('backend/assets/js/core/source/AppVendor.js') !!}

{!! HTML::script('backend/assets/js/core/demo/Demo.js') !!}

{!! HTML::script('backend/assets/js/libs/toastr/toastr.js') !!} 

{!! HTML::script('backend/sweetalert/sweetalert.min.js') !!} 



<script type="text/javascript">

	function info_msg(msg){

		toastr.options = {

		  "closeButton": false,

		  "debug": false,

		  "newestOnTop": false,

		  "progressBar": false,

		  "positionClass": "toast-bottom-right",

		  "preventDuplicates": false,

		  "onclick": null,

		  "showDuration": "300",

		  "hideDuration": "50",

		  "timeOut": "3000",

		  "extendedTimeOut": "100",

		  "showEasing": "swing",

		  "hideEasing": "linear",

		  "showMethod": "fadeIn",

		  "hideMethod": "fadeOut"

		}

		toastr.info(msg);

	}



	function error_msg(msg){

		toastr.options = {

		  "closeButton": false,

		  "debug": false,

		  "newestOnTop": false,

		  "progressBar": false,

		  "positionClass": "toast-bottom-right",

		  "preventDuplicates": false,

		  "onclick": null,

		  "showDuration": "300",

		  "hideDuration": "50",

		  "timeOut": "3000",

		  "extendedTimeOut": "100",

		  "showEasing": "swing",

		  "hideEasing": "linear",

		  "showMethod": "fadeIn",

		  "hideMethod": "fadeOut"

		}

		toastr.error(msg);

	}



	function success_msg(msg){

		toastr.options = {

		  "closeButton": false,

		  "debug": false,

		  "newestOnTop": false,

		  "progressBar": false,

		  "positionClass": "toast-bottom-right",

		  "preventDuplicates": false,

		  "onclick": null,

		  "showDuration": "300",

		  "hideDuration": "100",

		  "timeOut": "5000",

		  "extendedTimeOut": "100",

		  "showEasing": "swing",

		  "hideEasing": "linear",

		  "showMethod": "fadeIn",

		  "hideMethod": "fadeOut"

		}

		toastr.success(msg);

	}

	

</script>

<!-- END PAGE LEVEL SCRIPTS -->

@yield("script")

</body>

<!-- END BODY -->

</html>